# tests/test_irc.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist
from gozerbot.plugins import plugins
from gozerbot.thr import start_new_thread
from gozerbot.config import config
import unittest, time

plugins.reload('gozerplugs.plugs', 'irc')

class test_irc(unittest.TestCase):

    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.userhosts['test2'] = 'test2@test2'
    b.channels['#test'] = {}
    b.channels['#test2'] = {}
    start_new_thread(b.connect, ('bottest', 'localhost'))
    time.sleep(2)

    def test_partextra(self):
        self.b.fakein(':gozer!~gozer@localhost PART #test2 :gozer')
        self.assert_('#test2' not in self.b.channels)

    def test_pong(self):
        self.b.fakein('PONG')
        self.assertEqual(self.b.pongcheck, 1)

    def test_join(self):
        result = self.b.test('join')
        self.assert_(stringinlist('<channel>', result))

    def test_join2(self):
        result = self.b.test('join #test3', 10)
        self.assert_(stringinlist('joined channel #test3', result))
         
    def test_delchan(self):
        result = self.b.test('delchan')
        self.assert_(stringinlist('<channel>', result))

    def test_delchan2(self):
        result = self.b.test('delchan #blabla')
        self.assert_(stringinlist('no channel', result))

    def test_delchan3(self):
        result = self.b.test('delchan #test2')
        self.assert_(stringinlist('deleted', result))

    def test_part(self):
        result = self.b.test('part #test')
        self.assert_(stringinlist('left channel #test', result))

    def test_channels(self):
        self.b.test('join #test')
        result = self.b.test('channels')
        self.assert_(stringinlist('#test', result))

    def test_cycle(self):
        self.b.test('join #test')
        result = self.b.test('cycle')
        self.assert_('#test' in self.b.state['joinedchannels'])

    def test_nick(self):
        result = self.b.test('nick')
        self.assert_(stringinlist('<nickname>', result))

    def test_nick2(self):
        result = self.b.test('nick dodo', 10)
        self.b.test('nick test', 10)
        self.assert_(stringinlist('nick changed', result))

    def test_sendraw(self):
        result = self.b.test('sendraw PRIVMSG #dunkbots :yo!')
        self.assert_(1)

    def test_nicks(self):
        self.b.test('join #test')
        result = self.b.test('nicks')
        self.assert_(stringinlist('test', result))

    def test_silent(self):
        result = self.b.test('silent')
        self.assert_(stringinlist('silent mode', result))

    def test_loud(self):
        result = self.b.test('loud')
        self.assert_(stringinlist('loud mode', result))

    def test_reconnect(self):
        result = self.b.test('reconnect')
        self.b.connectok.wait()
        self.assert_(1)

    def test_channelmode(self):
        self.b.test('join #test')
        result = self.b.test('channelmode')
        self.assert_(stringinlist('channel mode', result))

    def test_action(self):
        result = self.b.test('action #test mekker')
        self.assert_(1)

    def test_action2(self):
        result = self.b.test('action')
        self.assert_(stringinlist('<channel>', result))

    def test_action3(self):
        result = self.b.test('action #test')
        self.assert_(stringinlist('<channel>', result))

    def test_say(self):
        result = self.b.test('say #test mekker')
        self.assert_(1)

    def test_say2(self):
        result = self.b.test('say')
        self.assert_(stringinlist('<channel>', result))

    def test_say3(self):
        result = self.b.test('say #test')
        self.assert_(stringinlist('<channel>', result))

    def test_server(self):
        result = self.b.test('server')
        self.assert_(stringinlist('localhost', result))

    def test_voice(self):
        result = self.b.test('voice')
        self.assert_(stringinlist('<nickname>', result))

    def test_voice(self):
        result = self.b.test('voice test')
        self.assert_(1)
