# gozerplugs/plugs/simplelog.py
#
#

""" log irc channels to [hour:min] <nick> txt format """

__copyright__ = 'this file is in the public domain'

from gozerbot.commands import cmnds
from gozerbot.callbacks import callbacks
from gozerbot.persistconfig import PersistConfig
from gozerbot.generic import hourmin, rlog
from gozerbot.monitor import outmonitor
from gozerbot.plughelp import plughelp
from gozerbot.examples import examples
from gozerbot.ircevent import Ircevent
from gozerbot.fleet import fleet
import time

plughelp.add('simplelog', 'log irc channels to [hour:min] <nick> txt format')

cfg = PersistConfig()
cfg.define('channels', [])

logfiles = {}

def init():
    callbacks.add('ALL', simplelogcb, presimplelogcb)
    outmonitor.add('simplelog', simplelogcb, presimplelogcb)
    return 1

def shutdown():
    for file in logfiles.values():
        file.close()
    return 1

def timestr():
    return time.strftime("%Y-%m-%d %H:%M:%S")

def write(channel, txt):
    f = channel[1:] + '.' + time.strftime("%Y%m%d") + '.slog'
    try:
        logfiles[f].write(txt)
        logfiles[f].flush()
    except KeyError:
        try:
            logfiles[f] = open('logs/' + f, 'a')
            logfiles[f].write(txt)
            logfiles[f].flush()
        except Exception, ex:
            rlog(10, 'simplelog', str(ex))
    except Exception, ex:
        rlog(10, 'simplelog', str(ex))

def log(bot, ievent):
    chan = ievent.channel
    if ievent.cmnd == 'PRIVMSG':
        if ievent.txt.startswith('\001ACTION'):
            txt = ievent.txt[7:-1].strip()
            write(chan, '%s | * %s %s\n' % (timestr(), ievent.nick, txt))
        else:
            write(chan, '%s | <%s> %s\n' % (timestr(), ievent.nick, \
ievent.origtxt))
    elif ievent.cmnd == 'MODE':
        write(chan, '%s | %s sets mode: %s\n' % (timestr(), ievent.nick, \
' '.join(ievent.arguments[1:])))
    elif ievent.cmnd == 'JOIN':
        write(chan, '%s | %s (%s) has joined\n' % (timestr(), ievent.nick, \
ievent.userhost))
    elif ievent.cmnd == 'PART':
        write(chan, '%s | %s (%s) has left\n' % (timestr(), ievent.nick, \
ievent.userhost))
    elif ievent.cmnd == 'QUIT':
        if not bot.userchannels.has_key(ievent.nick):
            return
        for c in bot.userchannels[ievent.nick]:
            if c in cfg.get('channels') and c in bot.state['joinedchannels']:
                write(c, '%s | %s (%s) has \
quit: %s\n' % (timestr(), ievent.nick, ievent.userhost, ievent.txt))

def presimplelogcb(bot, ievent):
    if (bot.name, ievent.channel) in cfg.get('channels') or \
ievent.cmnd == 'QUIT':
        return 1

def simplelogcb(bot, ievent):
    log(bot, ievent)

def handle_simplelogon(bot, ievent):
    if bot.jabber:
        ievent.reply("simplelog only works on IRC")
        return
    chan = ievent.channel
    if chan not in cfg.get('channels'):
        cfg.get('channels').append((bot.name, chan))
        cfg.save()
        ievent.reply('simplelog enabled on (%s,%s)' % (bot.name, chan))
    else:
        ievent.reply('simplelog already enabled on (%s,%s)' % (bot.name, \
chan))
cmnds.add('simplelog-on', handle_simplelogon, 'OPER')
examples.add('simplelog-on', 'enable simplelog on <channel> or the channel \
the commands is given in', '1) simplelog-on 2) simplelog-on #dunkbots')

def handle_simplelogoff(bot, ievent):
    try:
        cfg.get('channels').remove((bot.name, ievent.channel))
        cfg.save()
    except ValueError:
        ievent.reply('simplelog is not enabled in (%s,%s)' % (bot.name, \
ievent.channel))
        return
    ievent.reply('simplelog disabled on (%s,%s)' % (bot.name, ievent.channel))

cmnds.add('simplelog-off', handle_simplelogoff, 'OPER')
examples.add('simplelog-off', 'disable simplelog on <channel> or the channel \
the commands is given in', '1) simplelog-off 2) simplelog-off #dunkbots')
