<?php

class divListFai extends MultiSelectWindow
{
  /* Current base */
  var $selectedBase       = "";
  var $selectedBranch     = "main";
  var $AvailableBranches  = array();
  var $departments        = array();

  /* Regex */
  var $Regex              = "*";
  var $ShowProfiles;
  var $ShowTemplates;
  var $ShowScripts;
  var $ShowHooks;
  var $ShowVariables;
  var $ShowPackages;
  var $ShowPartitions;

  /* Subsearch checkbox */
  var $SubSearch;

  var $parent             ;
  var $ui                 ;

  var $SaveAdditionalVars = array("selectedBranch");

  function divListFai ($config,$parent)
  {
    MultiSelectWindow::MultiSelectWindow($config,"Fai");
    
    $this->parent       = $parent;
    $this->ui           = get_userinfo();

    /* Set default base */
    if(!isset($_SESSION['CurrentMainBase'])){
      $_SESSION['CurrentMainBase'] = $this->config->current['BASE'];
    }
    $this->selectedBase = $_SESSION['CurrentMainBase'];

    /* Set list strings */
    $this->SetTitle(_("List of FAI classes"));
    $this->SetSummary(_("This table displays all FAI classes in the selected tree."));

    /* Result page will look like a headpage */
    $this->SetHeadpageMode();
    $this->SetInformation(_("This menu allows you to create, delete and edit FAI classes."));

    $this->EnableAplhabet   (true);
  
    /* Disable buttonsm */
    $this->EnableCloseButton(false);
    $this->EnableSaveButton (false);

    /* set Page header */
    $this->AddHeader(array("string" => "&nbsp;",                "attach" => "style='text-align:center;width:20px;'"));
    $this->AddHeader(array("string" => _("Name of FAI class"),  "attach" => "style=''"));
    $this->AddHeader(array("string" => _("Class type"),         "attach" => "style='width:200px;'"));
    $this->AddHeader(array("string" => _("Actions"),            "attach" => "style='width:80px;border-right:0px;text-align:right;'"));

    $this->AddCheckBox("ShowProfiles"   , _("Display FAI profile objects")    ,_("Show profiles")     ,true);
    $this->AddCheckBox("ShowTemplates"  , _("Display FAI template objects")   ,_("Show templates")    ,true);
    $this->AddCheckBox("ShowScripts"    , _("Display FAI scripts")            ,_("Show scripts")      ,true);
    $this->AddCheckBox("ShowHooks"      , _("Display FAI hooks")              ,_("Show hooks")        ,true);
    $this->AddCheckBox("ShowVariables"  , _("Display FAI variables")          ,_("Show variables")    ,true);
    $this->AddCheckBox("ShowPackages"   , _("Display FAI packages")           ,_("Show packages")     ,true);
    $this->AddCheckBox("ShowPartitions" , _("Display FAI partitions")         ,_("Show partitions")   ,true);

    /* Add SubSearch checkbox */
    //$this->AddCheckBox(SEPERATOR);
    //$this->AddCheckBox("SubSearch",  _("Select to search within subtrees"), _("Ignore subtrees"), false);

    /*                  Name                 ,Text                              ,Default  , Connect with alphabet  */
    $this->AddRegex   ("Regex",     _("Display users matching"),"*" , true);
  }

  function AddUserBoxToFilter($position){
    $str = "";
    if($position  == 2){
      $smarty = get_smarty();
      $smarty->assign("selectedBranch",$this->selectedBranch);
      $smarty->assign("branchimage","images/branch.png");
      $smarty->assign("branches",$this->AvailableBranches);
      $str = $smarty->fetch(get_template_path('branch_selector.tpl', TRUE));
    }
    return($str);
  }

  function GenHeader()
  {
    /* Prepare departments,
       which are shown in the listbox on top of the listbox
     */
    $options= "";
    foreach ($this->config->idepartments as $key => $value){
      if ($this->selectedBase == $key){
        $options.= "<option selected='selected' value='$key'>$value</option>";
      } else {
        $options.= "<option value='$key'>$value</option>";
      }
    }




    /* Get copy & paste icon */
    if($this->parent->CopyPasteHandler){
      $Copy_Paste = $this->parent->CopyPasteHandler->generatePasteIcon();
    }else{
      $Copy_Paste ="";
    }

    /* Create listhead, it will be shown on top of the divlist.
     * It provides general navigation and object creation
     */
    $listhead =
      "<div style='background:#F0F0F9;padding:5px;'>&nbsp;".

      "<input class='center' type='image' src='images/list_root.png' align='middle'
      title='"._("Go to root department")."' name='dep_root' alt='".      _("Root")."'>&nbsp;".

      "<input class='center' type='image' src='images/list_up.png' align='middle'
      title='"._("Go up one department")."' name='dep_back' alt='"._("Up"). "'>&nbsp;".

      "<input class='center' type='image' src='images/list_home.png' align='middle'
      title='"._("Go to users home department")."' name='dep_home' alt='"._("Home")."'>&nbsp;".

      " <input class='center' type='image' src='images/list_reload.png' align='middle' title='"._("Reload list")."' name='submit_department' alt='".
_("Submit")."'>&nbsp;".

      "<img class='center' src=\"images/list_seperator.png\" alt=\"\" align=\"middle\" height=\"16\" width=\"1\">&nbsp;".

      " <input class='center' type='image' src='images/fai_new_profile.png' align='middle'
      title='"._("New profile")."' name='Create_profile' alt='"._("P")."'>&nbsp;".

      "<img class='center' src=\"images/list_seperator.png\" alt=\"\" align=\"middle\" height=\"16\" width=\"1\">&nbsp;".

      " <input class='center' type='image' src='images/fai_new_partitionTable.png' align='middle'
      title='"._("New partition table")."' name='Create_partition' alt='"._("PT")."'>&nbsp;".

      " <input class='center' type='image' src='images/fai_new_script.png' align='middle'
      title='"._("New scripts")."' name='Create_script' alt='"._("S")."'>&nbsp;".

      " <input class='center' type='image' src='images/fai_new_hook.png' align='middle'
      title='"._("New hooks")."' name='Create_hook' alt='"._("H")."'>&nbsp;".

      " <input class='center' type='image' src='images/fai_new_variable.png' align='middle'
      title='"._("New variables")."' name='Create_variable' alt='"._("V")."'>&nbsp;".

      " <input class='center' type='image' src='images/fai_new_template.png' align='middle'
      title='"._("New templates")."' name='Create_template' alt='"._("T")."'>&nbsp;".

      " <input class='center' type='image' src='images/fai_new_packages.png' align='middle'
      title='"._("New package list")."' name='Create_package' alt='"._("PK")."'>&nbsp;".

      $Copy_Paste.

      " <img class='center' src='images/list_seperator.png' align='middle' alt='' height='16' width='1'>&nbsp;".

      _("Base")."&nbsp;<select name='CurrentMainBase' onChange='mainform.submit()' class='center'>$options</select>".
      " <input class='center' type='image' src='images/list_submit.png' align='middle' title='"._("Submit department")."' name='submit_department' alt='".  _("Submit")."'>&nbsp;".

      "</div>";

    $this->SetListHeader($listhead);
  }

  /* so some basic settings */
  function execute()
  {
    $this->ClearElementsList();
    $this->GenHeader();
  }

  function setEntries($list)
  {
    /********************
      Variable init
     ********************/

     $objects = array(
           "FAIpartitionTable"  => array("IMG"=> "images/fai_partitionTable.png", "NAME"=>"Partition table","KZL"=> "PT", "VAR"=>"ShowPartitions"),
           "FAIpackageList"     => array("IMG"=> "images/fai_packages.png",       "NAME"=>"Package list" ,  "KZL"=> "PL", "VAR"=>"ShowPackages"),
           "FAIscript"          => array("IMG"=> "images/fai_script.png",         "NAME"=>"Scripts" ,       "KZL"=> "S",  "VAR"=>"ShowScripts"),
           "FAIvariable"        => array("IMG"=> "images/fai_variable.png",       "NAME"=>"Variables" ,     "KZL"=> "V",  "VAR"=>"ShowVariables"),
           "FAIhook"            => array("IMG"=> "images/fai_hook.png",           "NAME"=>"Hooks",          "KZL"=> "H",  "VAR"=>"ShowHooks"),
           "FAIprofile"         => array("IMG"=> "images/fai_profile.png",        "NAME"=>"Profile" ,       "KZL"=> "P",  "VAR"=>"ShowProfiles"),
           "FAItemplate"        => array("IMG"=> "images/fai_template.png",       "NAME"=>"Templates" ,     "KZL"=> "T",  "VAR"=>"ShowTemplates"));

    $editlink ="<a href='?plug=".$_GET['plug']."&amp;edit_entry=%KEY%' title='%TITLE%'>%NAME%</a>";

    /********************
      Attach objects
     ********************/

     foreach($list as $key => $value){
       $info     = "";
       $img      = "";
       $type     = $value['type'];
       $abort    =false;

       if(isset($objects[$type])){
         $img   = "<img class='center' src='".$objects[$type]['IMG']."' title='".$objects[$type]['NAME']."' alt='".$objects[$type]['KZL']."'>";
         $info  = $objects[$type]['NAME'];
         $var   = $objects[$type]['VAR'];
       }else{
         $img   = "<img class='center' src='images/empty.png' alt=''>";
         $info  = "";
         $var   = "";
       }

       if((isset($value['description']))&&(!empty($value['description']))){
         $desc= " [".$value['description']."]";
       }else{
         $desc= "";
       }

       /* Create action icons */
       $action ="";
       if($this->parent->CopyPasteHandler){
         if($value['FAIstate'] != "freeze"){
           $action .= "<input class='center' type='image'
             src='images/editcut.png' alt='"._("cut")."' name='cut_%KEY%' title='"._("Cut this entry")."'>&nbsp;";
         }
         $action.= "<input class='center' type='image'
           src='images/editcopy.png' alt='"._("copy")."' name='copy_%KEY%' title='"._("Copy this entry")."'>&nbsp;";
       }

       if($value['FAIstate'] == "freeze"){
         $action .= "<input class='center' type='image' src='images/edit.png'  alt='"._("edit")."'
           name='entry_edit_%KEY%' title='"._("Edit class")."'>";
         $edi = $editlink;
         $acti = $action;
       }else{
         $action .= "<input class='center' type='image' src='images/edit.png'  alt='"._("edit")."'
           name='entry_edit_%KEY%' title='"._("Edit class")."'>";
         $action .= "<input class='center' type='image' src='images/edittrash.png' alt='"._("delete")."'
           name='entry_delete_%KEY%' title='"._("Delete class")."'>";
         $acti = $action;
         $edi = $editlink;
       }



       $field1 = array("string" => $img , "attach" => "style='text-align:center;width:20px;'");
       $field2 = array("string" => preg_replace(array("/%KEY%/","/%NAME%/","/%TITLE%/"),array($key,$value['cn'].$desc,preg_replace('/ /', '&nbsp;', @LDAP::fix($value['dn']))),$edi) , "attach" => "style=''");
       $field3 = array("string" => $info, "attach" => "style='width:200px;'");
       $field4 = array("string" => preg_replace("/%KEY%/",$key,$acti) , "attach" => "style='width:80px;border-right:0px;text-align:right;'");
       $this->AddElement(array($field1,$field2,$field3,$field4));
    }
  }

  function Save()
  {
    MultiSelectWindow::Save();  
  }

  function save_object()
  {
    /* Save automatic created POSTs like regex, checkboxes */
    MultiSelectWindow::save_object(); 
    $_SESSION['faifilter']['branch'] = $this->selectedBranch; 
  }
}
// vim:tabstop=2:expandtab:shiftwidth=2:filetype=php:syntax:ruler:
?>
