//  This may look like C code, but it is really -*- C++ -*-

//  ------------------------------------------------------------------
//  The Goldware Library
//  Copyright (C) 1990-1999 Odinn Sorensen
//  Copyright (C) 1999-2000 Alexander S. Aganichev
//  ------------------------------------------------------------------
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this program; if not, write to the Free
//  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
//  MA 02111-1307, USA
//  ------------------------------------------------------------------
//  $Id: gxareas.cpp,v 1.1.1.1 2000/02/25 10:12:53 asa Exp $
//  ------------------------------------------------------------------
//  Read areas from an AREAS.BBS file (any type!)
//  ------------------------------------------------------------------

#include <cstdlib>
#include <cstring>
#include <gedacfg.h>


//  ------------------------------------------------------------------
//  Read one or more AREAS.BBS files

void gareafile::ReadAreasBBS(char* tag) {

  AreaCfg aa;
  int echos;
  char origin[80], options[80];
  char* ptr;
  char* echoid=NULL;
  char* path=NULL;
  char* desc=NULL;
  
  *origin = NUL;
  strcpy(options, tag);
  ptr = strtok(tag, " \t");

  // Read each AREAS.BBS
  while(ptr) {
    if(*ptr != '-') {
      GetAreasBBS(ptr, origin, options);
      echos = echolist.Echos();
      for(int n=0; n<echos; n++) {
        echolist.GetEcho(n, &echoid, &path, &desc);
        aa.reset();
        aa.type = GMB_ECHO;
        aa.attr = attribsecho;
        aa.board = atoi(path);
        if(aa.board and (aa.board < 201))
          aa.msgbase = GMB_HUDSON;
        else if((aa.board > 200) and (aa.board < 501))
          aa.msgbase = GMB_GOLDBASE;
        else if(*path == '$') {
          aa.msgbase = GMB_SQUISH;
          adjustpath(path+1);
          aa.setpath(path+1);
        }
        else if(*path == '!') {
          aa.msgbase = GMB_JAM;
          adjustpath(path+1);
          aa.setpath(path+1);
        }
        else {
          aa.msgbase = fidomsgtype;
          adjustpath(path);
          aa.setpath(path);
        }
        aa.setdesc(desc);
        aa.setechoid(echoid);
        aa.setorigin(origin);
        AddNewArea(aa);
      }
    }
    ptr = strtok(NULL, " \t");
  }     
}


//  ------------------------------------------------------------------
