
// OCR engine (c) Joerg Schulenburg
// first engine: rule based
/*
This is a Optical-Character-Recognition program
Copyright (C) 2000  Joerg Schulenburg

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 Joerg.Schulenburg@physik.uni-magdeburg.de

 >>>  DO NOT EDIT THIS FILE IF YOU NOT REALLY KNOW WHAT YOU ARE DOING! <<<
  
  I have invested lot of time, to write this part of the program.
  This engine should recognize chars allways right or return UNKNOWN.
  If you change something, test all other example files too, 
  to be sure that all things work better.   (JoergS)


todo:
  - use only one box!?, may be bits have usefull infos
  - divide this file, suggestion: classify chars:
      high=ABCDEFGHIJKLMNOPQRSTUVWXYZbdfhklt, low=acegijmnopqrsuvwxyz
      or
      often_used=etianmsurwdkgo     rarely_used=hvjcflpqxyz.,:
      or
      every char (large overhead)

  general feature extraction:
   - white holes at middle, upper, lower position (cost much time)
   - test lines and triangles insteat of rectangles
   
   char is removed, wchar_t is used  (better code)

*/

#include <stdlib.h>
#include <stdio.h>
// #include "pgm2asc.h"
#include "ocr0.h"
#include "ocr1.h"
#include "amiga.h"
#include "pnm.h"
#include "gocr.h"

#define MM	{ fprintf(stderr," mark %d\n",__LINE__); }
#define MX      { out_x(box1); out_b(b,0,0,dx,dy,cs); MM; }


/* extern "C"{ */

static int only_numbers=0;
int set_only_numbers(int n){ only_numbers=n; return 0; }

// test for umlauts, if ret>0 and m==1 box1 is changed
// m>0   modify box1->dots
// m==2  modify box1->y0
int testumlaut(struct box *box1, int cs, int m, wchar_t *modifier){
   // pix p=*(box1->p);
   int  r,y,x,x0,x1,y0,y1,dx,dy,m1,m2,m3,
        xl,xr,yu,yl;  // left, right, upper and lower border of dots
   wchar_t mod='\0';	/* (TeX-) modifier ~"'` for compose() */
   r=0;
   x0=box1->x0; x1=box1->x1; dx=x1-x0+1;
   y0=box1->y0; y1=box1->y1; dy=y1-y0+1;
   m1=box1->m1; m2=box1->m2; m3=box1->m3;
   xl=x0; xr=x1; yu=yl=y0;
   if( dy < 5  ||   4*y0 > 3*m2+m3 ) return 0;  // no low chars: .,-=
   /* modifier in box included? */
   if( 2*y1 > m1+m2 ){
    /* modifier in box included? */
    for(y=y0;2*y<y0+y1;y++)if( get_bw(xl,xr,y,y,box1->p,cs,1)==0 ) break;
    if( 2*y<y0+y1 ){ /* yes => extract */
      yl=y;
      while( get_bw(xl,xr,y,y,box1->p,cs,1)==0 && 2*y<=y0+y1) y++;
      if( m&2 ) box1->y0=y;	/* snip */
    } 
    else { /* not included => look at upper end */
      if( 2*y0 <= m1+m2 ){  /* upper case char */
        y=m1-3*(m2-m1)/4; if(y<0) y=0;
        while( get_bw(xl-2,xr+2,y,y,box1->p,cs,1)==1 && y<y0) y++;
        while( get_bw(xl  ,xr  ,y,y,box1->p,cs,1)==0 && y<y0) y++;
        if( y<y0 )
        if( get_bw(xl,xr,y,y0,box1->p,cs,1)==1 ){
          yu=y;
          while( get_bw(xl,xr,y,y,box1->p,cs,1)==1 && y<y0) y++;
          yl=y;
        }
      } else {		    /* lower case char */
        if( get_bw(xl+2+dx/8,xr,m1+1,yl-2,box1->p,cs,1)==1 ){
          y=yu=m1+1;
          while( get_bw(xl,xr,y,y,box1->p,cs,1)==1 && y<y0) y++;
          yl=y;
        }
      }
    }
   }
   if( yu>=yl ) { if(m) box1->dots=0; return 0; } /* nothing found */

   if ( yl-1>yu ) {  // tall box ij"a"o"u
//     x=box1->y0;box1->y0=m1; out_x(box1); box1->y0=x;
//     fprintf(stderr,"\ntestumlaut y0=%d m1=%d m2=%d",y0,m1,m2);
//     fprintf(stderr," yu=%d yl=%d xl=%d xr=%d m1=%d m2=%d",yu,yl,xl,xr,m1,m2);
     {
       if(    get_bw(xl-1,xl-1,yu,yl-1,box1->p,cs,1)==1 ) // neighbour overlap?
       while( get_bw(xl  ,xl  ,yu,yl-1,box1->p,cs,1)==1 && 2*xl<x0+x1) xl++;

       x=xl;y=yu;
       if( get_bw(xl,x1+1,yu,yl-1,box1->p,cs,1)==0 ) r=0; // neighbour overlap?
       else
       if( get_bw(xl  ,xl  ,yu,yl-1,box1->p,cs,1)==0
        || get_bw(xl-1,xl-1,yu,yl-1,box1->p,cs,1)==0 ) // be sure there are gap to neighbours
       if( get_bw(xr  ,xr  ,yu,yl-1,box1->p,cs,1)==0
        || get_bw(xr+1,xr+1,yu,yl-1,box1->p,cs,1)==0 )
       { 
         r=1;
         if( xr-xl>2 && num_obj(xl,xr,yu,yl-1,box1->p,cs)>=2 ){ // not best!!!
           // may be the following lines are not quite ok
           while( get_bw(xl,xr,yl,yl,box1->p,cs,1)==0 && 2*yl<y0+y1) yl++;
           r=2; 
	   mod = DIAERESIS;
         }
         if( m&2 ) box1->y0=yl;
/*         if( m&2 ) box1->y0= ( (r==1) ? yu : yl ); */
         // out_x(box1);
       }
       if(r==0){ // divided fr != fi
         while( get_bw(x0,x1,yu,yu,box1->p,cs,1)==0 && 2*yu<y0+y1) yu++;
         if(m)box1->y0=yu;
       }
       if( r==1 ){ yl--;
         if( loop(box1->p,xl,yu,xr-xl,cs,0,RI)
           > loop(box1->p,xl,yl,xr-xl,cs,0,RI)+dx/8
          && loop(box1->p,xr,yu,xr-xl,cs,0,LE)
           < loop(box1->p,xr,yl,xr-xl,cs,0,LE)-dx/8 ) 
	   mod = ACUTE_ACCENT;

         if( loop(box1->p,xl,yu,xr-xl,cs,0,RI)
           < loop(box1->p,xl,yl,xr-xl,cs,0,RI)-dx/8
          && loop(box1->p,xr,yu,xr-xl,cs,0,LE)
           > loop(box1->p,xr,yl,xr-xl,cs,0,LE)+dx/8 )
	   mod = GRAVE_ACCENT;

         if( loop(box1->p,xl,yu,xr-xl,cs,0,RI)
           > loop(box1->p,xl,yl,xr-xl,cs,0,RI)-dx/8
          && loop(box1->p,xr,yu,xr-xl,cs,0,LE)
           > loop(box1->p,xr,yl,xr-xl,cs,0,LE)-dx/8
         && num_cross(xl,xr,yu,yu,box1->p,cs) == 1 
         && num_cross(xl,xr,yl,yl,box1->p,cs) == 2 ) 
	   mod = CIRCUMFLEX_ACCENT;
         
        if( xr-xl>3 && yl-yu>1 )
         if( loop(box1->p,xl,yu,xr-xl,cs,0,RI)
           > loop(box1->p,xl,yl,xr-xl,cs,0,RI)
          && loop(box1->p,xr,yu,xr-xl,cs,0,LE)
           < loop(box1->p,xr,yl,xr-xl,cs,0,LE)
         && num_cross(xl,xr,yu,yu,box1->p,cs) == 2 
         && num_cross(xl,xr,yl,yl,box1->p,cs) == 2 ) 
	   mod = TILDE;

        if( xr-xl>2 && yl-yu>2 )
        if( num_hole(xl,xr,yu,yl,box1->p,cs) == 1 )
	   mod = RING_ABOVE;

       }
     }
     if(m) box1->dots=r; // set to 0 also possible after division
   }
//   printf(" modifier=%c",mod);
   if( modifier ) *modifier=mod;	/* set modifier */
   return r;
}

/* ----------------------- part1 -------------------------------- */
wchar_t ocr0p1(struct box *box1, pix  *b, int cs);
/* ----------------------- part2 -------------------------------- */
wchar_t ocr0p2(struct box *box1, pix  *b, int cs);

// OCR engine ;)
wchar_t ocr0(struct box *box1, pix  *b, int cs){
   // pix  p=*(box1->p);
   int	i,j,d,x,y,x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
       rx,ry,r1,r2,i1,i2,i3,i4,i5,i6;	/* tmp-vars */
   int xa,xb,	/* used for store significant points of char */
       ya;
   int dots=box1->dots;
   // ad,ac will be used in future
   wchar_t bc = UNKNOWN;			// bestletter
   wchar_t ac = UNKNOWN;			// alternative char (2nd best)
   wchar_t um = SPACE;				// modifier '"
   int hchar;		// char is higher than 'e'
   int gchar;		// char has ink lower than m3

   // --- test thin lines - ---------------------------------
   for( ; 2*dy<box1->m3-box1->m2 && dx>=2*dy && dx>4; ){     // max 3x3 (small font)
      if( get_bw(x0+dx/10,x1-dx/10,y0+dy/2,y0+dy/2,box1->p,cs,2)==2 ) break;
      if( dots ) return '=';
      return '-';
   }
   // --- test thin lines = ---------------------------------
   for( ; dy>2 && dx>4; ){     // max 3x3 (small font)
      if( get_bw(x0+dx/10,x1-dx/10,y0     ,y0     ,box1->p,cs,2)==2 ) break;
      if( get_bw(x0      ,x1      ,y0+dy/2,y0+dy/2,box1->p,cs,1)==1 ) break;
      if( get_bw(x0+dx/10,x1-dx/10,y1     ,y1     ,box1->p,cs,2)==2 ) break;
      return '=';
   }
   // --- test dots : ---------------------------------
   if( 2*y0>box1->m2+box1->m1 )	// ~i
   if(  y1<=box1->m3 )      	// ~:
   for( ; dy>5 && dx>3 && dy>=2*dx; ){     // max 3x3 (small font)
      for( i=0,y=y0;y<y0+dy/8+1;y++)
        if(get_line(x0+dx/4,y,x1,y,box1->p,cs,100)>40) i++; else i--;
      if( i<=0 ) break;
      for( i=0,y=dy/4;y<dy-dy/2;y++)
        if( get_bw(0,dx-1,y,y,b,cs,1)==0 ) i++; else i--;
      if( i<=0 ) break;
      return ':';
   }
   // --- test dots ; ---------------------------------
   if( 2*y0>box1->m2+box1->m1 )	// ~i
   if( 4*y1>3*box1->m3+box1->m2 )      	// ~:
   for( ; dy>5 && dx>2 && dy>2*dx; ){     // max 3x3 (small font)
      // better would it be to detect round pixelcluster on top
      for( i=0,y=y0;y<y0+dy/8+1;y++)
        if(get_line(x0+dx/4,y,x1,y,box1->p,cs,100)>40) i++; else i--;
      if( i<=0 ) break;
      for( i=0,y=dy/4;y<dy-dy/2;y++)
        if( get_bw(0,dx-1,y,y,b,cs,1)==0 ) i++; else i--;
      if( i<=0 ) break;
      return ';';
   }
   // --- first test small dots . ---------------------------------
   if( 3*dy<box1->m4-box1->m1 && abs(dx-dy)<(dx+dy)/4+2
    && 3*y1>=(2*box1->m3+  box1->m2)	// dot near baseline?
    && 5*y0>=(3*box1->m3+2*box1->m2) ){ // Jul00
     d=0; r1=600;r2=1400;
     for(x=x0;x<=x1;x++)for(y=y0;y<=y1;y++){ /* circle equation */
       rx=1000*(2*x-(x0+x1))/dx;	// normiert auf 1000
       ry=1000*(2*y-(y0+y1))/dy;
       if( rx*rx + ry*ry < r1*r1 ) if( pixel(box1->p,x,y)>=cs ){ d++;x=x1+1;y=y1+1; }
       if( rx*rx + ry*ry > r2*r2 ) if( pixel(box1->p,x,y)< cs ){ d++;x=x1+1;y=y1+1; }
     }
     if(d==0) return '.';
   }
   // --- first test small dots , ---------------------------------
   if( 2*dy<box1->m4-box1->m1 && dx<dy
    && 2*y0>box1->m2+box1->m3 ){
      if(dots==1) return ';';
      return ',';
   }
   // --- first test small dots ' ---------------------------------
   if( 2*dy<box1->m4-box1->m1 && dx<dy
    && 2*y0<  box1->m1+box1->m2
    && 3*y1<2*box1->m2+box1->m3 ){
      return '\'';
   }
//   if( dots==1 ){ um='\''; }
#if 1
   if( dots==0 ){ // i-dots ??? (if dots==0 is wrong)
      y=box1->m1;
      for(;y<y0+dy/2;y++)if( get_bw(x0+dx/4,x1,y,y,box1->p,cs,1)==1) break;
      { i1=y;
        if( y<y0+dy/4 )
        for(;y<y0+dy/2;y++)if( get_bw(x0,x1,y,y,box1->p,cs,1)==0) break;
        if( y<y0+dy/2 && 5*(y-i1+1)>box1->m2-box1->m1){ dots=1;
	  um = ACUTE_ACCENT; 

          if( get_bw((x0+x1)/2,(x0+x1)/2,box1->m1,box1->m2-1,box1->p,cs,1)==0)
          if( get_bw( x0      , x0      ,box1->m1,box1->m2-1,box1->p,cs,1)==0)
          if( get_bw( x0      ,(x0+x1)/2,box1->m1,box1->m2-1,box1->p,cs,1)==1)
          if( get_bw((x0+x1)/2,    x1   ,box1->m1,box1->m2-1,box1->p,cs,1)==1)
          { dots=2; 
   	    um = DIAERESIS; 
	  }
        }
      }
   }
#endif
   if( /* um==ACUTE_ACCENT || */ um==DIAERESIS){
      for(y=y1;y>y0;y--)
      if( get_bw(x0,x1,y,y,box1->p,cs,1)==0) { y0=y; dy=y1-y0+1; break; } // scan "a "o "u
   }
   // --- hchar --- gchar -------------------------
   hchar=0;if( 2*y0<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
   gchar=0;if( 2*y1>=2*box1->m3+(box1->m4-box1->m3) ) gchar=1;
   // if the char is slightly moved down correction can be done
   if ( y0<box1->m2 && y1>box1->m3 && 2*y1<box1->m3+box1->m4) // moved
   if( 2*(y0-(y1-box1->m3))<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
 

   // --- test numbers 0..9 --- separated for faster compilation
   if( only_numbers ) return ocr0n(box1,b,cs);

   bc=ocr1(box1,b,cs);
   if(bc!=UNKNOWN)
     return bc; // for fast compilable tests

   // --- part1 --- separated for faster compilation
   if(bc==UNKNOWN)
        bc=ocr0p1(box1,b,cs);

   // --- part2 --- separated for faster compilation
   if(bc==UNKNOWN)
     bc=ocr0p2(box1,b,cs);

   // --- test numbers 0..9 --- seperated for faster compilation
   if(bc==UNKNOWN)
     bc = ocr0n(box1,b,cs);

   // --- test \it g ---------------------------------------------------
   for(d=100;dx>2 && dy>4;){     // dx>1 dy>2*dx 
      // out_x(box1);printf(" 1 x0 y0 %d %d\n",x0,y0);
      if( num_cross(x0+dx/2,x0+dx/2,y0,y1,box1->p,cs) != 3 // pre select
       && num_cross(x0+dx/4,x1-dx/4,y0,y1,box1->p,cs) != 3 ) break;
      for( x=0,i=y=y0+dy/2;y<=y1-dy/4;y++){	// suche kerbe
	j=loop(box1->p,x0,y,dx,cs,0,RI); 
        if( j>x ) { x=j; i=y; }
      }
      if( x<4*dx/8 ) break;
      if( num_cross(x0+dx/2,x1,i,y1,box1->p,cs) != 1 ) break;
      if( num_hole(x0,x1,y0,i+1,box1->p,cs)!=1 ) break;
      if( num_hole(x0,x1,i-1,y1,box1->p,cs)!=0 ) break;
      if( loop(box1->p,x0,y1  ,dy,cs,0,RI)>dx/3 &&
          loop(box1->p,x0,y1-1,dy,cs,0,RI)>dx/3) break; // no q
      for( x=0,i=y=y0+dy/3;y<=y1-dy/3;y++){	// suche kerbe
	j=loop(box1->p,x1,y,dx,cs,0,LE); 
        if( j>x ) { x=j; i=y; }
      } if( x>dx/2 ) break;		// no g
      i1=loop(b,dx-1,dy/8     ,dx,cs,0,LE); if(i1>dx/2) break;
      i3=loop(b,dx-1,dy-1-dy/8,dx,cs,0,LE);
      i2=loop(b,dx-1,dy/2     ,dx,cs,0,LE); if(i1+i3-2*i2<0) break; // konvex 
      i1=loop(b,dx-1,dy/4     ,dx,cs,0,LE); if(i1>dx/2) break;
      i3=loop(b,dx-1,dy-1-dy/8,dx,cs,0,LE);
      for(y=dy/4;y<dy-1-dy/4;y++){
        i2=loop(b,dx-1,y,dx,cs,0,LE);
        if(i1+i3-2*i2<-1-dx/16) break;  // konvex from right ~g ~3
      } if(y<dy-1-dy/4) break;
      x=loop(b,dx  -1,6*dy/8,dx,cs,0,LE); if(x>1) x--; // robust
      y=loop(b,dx-x-1,  dy-1,dy,cs,0,UP);
      if(y<dy/8) break; // ~q (serif!)
      if(  gchar  && !hchar) return 'g';	// italic g
      break;
   }
   // --- test beta,\3,sz,"s ---------------------------------------------
   if(bc==UNKNOWN && hchar)
   for(d=100;dx>3 && dy>6;){     // min 4x7
      /*         this part is provisorium, should be changed!
	     a-\
             |  d
	    b| /
             | \
            -c /
       */
      if( num_cross(x0 ,x1 ,y0+dy/4  ,y0+dy/4  ,box1->p,cs) != 2
       && num_cross(x0 ,x1 ,y0+dy/4+1,y0+dy/4+1,box1->p,cs) != 2 ) break;
      for(i=1+dy/16,y=y0+dy/8;y<y1-dy/4 && i>0;y++){
        if( y<y1-6*dy/16 ){ if( num_cross(x0 ,x1 ,y,y,box1->p,cs) != 2 ) i--;}
        else              { if( num_cross(x0 ,x1 ,y,y,box1->p,cs) <  2 ) i--;}
        if( get_bw(x0,x0+dx/2,y,y,box1->p,cs,1) == 0 ) i--;
        if( y<y1-5*dy/16 ) 
        if( get_bw(x1-dx/2,x1,y,y,box1->p,cs,1) == 0 ) i--;
      } if( i<=0 ) break;
      // out_x(box1);

      for(y=y0+dy/3;y<y1-dy/3;y++)
        if( get_bw(x1-dx/8,x1,y,y,box1->p,cs,1) == 0 ) break;
      if( y>=y1-dy/3 ) break;

      for(y=y0+dy/5;y<y0+dy/3;y++)
        if( get_bw(x1-dx/6,x1,y,y,box1->p,cs,1) == 1 ) break;
      if( y>=y0+dy/3 ) break;

      for(y=y0+dy/2;y<y1;y++)
        if( get_bw(x1-dx/6,x1,y,y,box1->p,cs,1) == 1 ) break;
      if( y>=y1 ) break;

      for(x=x0+dx/4;x<x1-dx/4;x++)
        if( num_cross(x,x,y0,y1,box1->p,cs) == 3 ) break;
      if( x>=x1-dx/4 ) break;

      i=loop(b,dx/2,dy-1,dy,cs,0,UP)+dy/64; 	// Jul00
      for(x=dx/5;x<dx/2;x++)
        if( loop(b,x,dy-1,dy,cs,0,UP) > i ) break; 
      if( x==dx/2 ) break;

      x=x0+loop(b,0,dy/4,dx,cs,0,RI);
      for(;x<x1-dx/3;x++)
        if( get_bw(x,x,y0,y0+dy/4,box1->p,cs,1) == 0 ) break;
      if( x<x1-dx/3 ) break;

      if( !gchar )
      if( num_hole( x0, x1, y0, y1,box1->p,cs) != 0 ) break;

      bc=LATIN_SMALL_LETTER_SHARP_S;
      break;
   }
   // --- test ()<> ------------------------------------------------
   if(bc==UNKNOWN)
//   if(!dots)
   for(d=100;dx>3 && dy>4;){     // min 3x4
#if 1
      for(i=y=0;y<dy;y++){
        if( num_cross(0,dx-1,y,y,b,cs) != 1 ) i++;
        if( loop(b,   0,y,dx,cs,0,RI)
          + loop(b,dx-1,y,dx,cs,0,LE)<3*dx/8 ) break;
      }
      if( y<dy ) break;
      if ( i>2 || (i>0 && dy<16)) break;
#endif
      /* look for the extrema => r1..r2 */
      for(i=dx,r1=r2=y=dy/2-dy/8;y<=dy/2+dy/8;y++){
        j=loop(b,   0,y,dx,cs,0,RI); if(j==i) r2=y; if(j<i){ r2=r1=y; i=j; } 
        j=loop(b,dx-1,y,dx,cs,0,LE); if(j==i) r2=y; if(j<i){ r2=r1=y; i=j; } 
      } y=(r1+r2)/2;
      i1=loop(b,dx-1,     dy/16,dx,cs,0,LE);
      i2=loop(b,dx-1,y         ,dx,cs,0,LE);
      i3=loop(b,dx-1,dy-1-dy/16,dx,cs,0,LE);
      i4=loop(b,   0,dy/16     ,dx,cs,0,RI);
      i5=loop(b,   0,y         ,dx,cs,0,RI);
      i6=loop(b,   0,dy-1-dy/16,dx,cs,0,RI);
      if(dx>dy){
        if(i2==0 && 3*i5>dx && i4<=dx/8 && i6<=dx/8) return '>';
        if(i5==0 && 3*i2>dx && i1<=dx/8 && i3<=dx/8) return '<';
      }
      if( i5==0     && i1<=dx/8   && i3<=dx/8
       && i2>=dx/2  && i4>=3*dx/4 && i6>=3*dx/4
       && 2*loop(b,   0,  dy/4-dy/16,dx,cs,0,RI)+1+dx/16>=i4+i5
       && 2*loop(b,   0,3*dy/4+dy/16,dx,cs,0,RI)+1+dx/16>=i6+i5  ) return '<';
      if( i2==0     && i4<=dx/8   && i6<=dx/8
       && i5>=dx/2  && i1>=3*dx/4 && i3>=3*dx/4
       && 2*loop(b,dx-1,  dy/4-dy/16,dx,cs,0,LE)+1+dx/16>=i1+i2
       && 2*loop(b,dx-1,3*dy/4+dy/16,dx,cs,0,LE)+1+dx/16>=i3+i2  ) return '>';

      i1=loop(b,dx-1,dy/16,dx,cs,0,LE);
      i2=loop(b,dx-1,dy/2 ,dx,cs,0,LE);
      i3=loop(b,dx-1,dy-1 ,dx,cs,0,LE);
      i4=loop(b,   0,0   ,dx,cs,0,RI);
      i5=loop(b,   0,dy/2,dx,cs,0,RI);
      i6=loop(b,   0,dy-1,dx,cs,0,RI);
      i=(box1->m4+box1->m3)/2-box1->m2;
      //  
      //  out_x(box1);printf("() %d %d %d %d %d %d %d\n",i,i1,i2,i3,i4,i5,i6);
      if(2*i2<i1+i3 && 2*i5>i4+i6 && 2*dx<dy && dy>=i) return ')';
      if(2*i2>i1+i3 && 2*i5<i4+i6 && 2*dx<dy && dy>=i){
        for(x=y=0;y<dy/4;y++){
          i=loop(b,0,y,dx,cs,0,RI);if( i>x ) x=i;
        }
        for(y=0;y<dy/4;y++){
          i=loop(b,0,y+dy/8,dx,cs,0,RI);if( i<x ) break;
        }
        if( y==dy/4 ) break; // ~l (left upper side must be convex) Jul00
        return '(';
      }

      // ~lI      
      for(i=i4,y=0;y<dy;y++){
        x=loop(b,0   ,y,dx,cs,0,RI);if(abs(x-i)>dx/6+1 ) break; i=x;
      } if( y<dy ) break;
      for(i=i1,y=0;y<dy;y++){
        x=loop(b,dx-1,y,dx,cs,0,LE);if(abs(x-i)>dx/6+1 ) break; i=x;
      } if( y<dy ) break;

      if(i1<=dx/10 && i2>dx/3 && i5>dx/3 && i6<=dx/10) return '/';
      if(i4<=dx/10 && i2>dx/3 && i5>dx/3 && i3<=dx/10) return '\\';
      break;
   }
   //  --------- test [] --------------------------------
   if(bc==UNKNOWN)
   for(d=100;dx>3 && dy>4 && dy>2*dx;){ // only for accurate font at the moment
      if( get_bw(x0,x1,y0  ,y0  ,box1->p,cs,2) == 2 
       && get_bw(x0,x1,y0+1,y0+1,box1->p,cs,2) == 2 ) break;
      if( get_bw(x0,x1,y1  ,y1  ,box1->p,cs,2) == 2
       && get_bw(x0,x1,y1-1,y1-1,box1->p,cs,2) == 2 ) break;
      if( get_bw(x0     ,x0,y0     ,y1     ,box1->p,cs,2) == 0
       || get_bw(x0+1 ,x0+1,y0     ,y1     ,box1->p,cs,2) == 0 )
      if( get_bw(x0+dx/2,x1,y0+dy/4,y1-dy/4,box1->p,cs,1) == 0 ) return '[';
      if( get_bw(x1     ,x1,y0     ,y1     ,box1->p,cs,2) == 0
       || get_bw(x1-1 ,x1-1,y0     ,y1     ,box1->p,cs,2) == 0 )
      if( get_bw(x0,x1-dx/2,y0+dy/4,y1-dy/4,box1->p,cs,1) == 0 ) return ']';
      break;
   }
   // --- test + ------------------------------------------------
   if(bc==UNKNOWN)
   for(d=100;dx>4 && dy>4;){     // min 5x5
      xa=(dx+1)/3-1; ya=(dy+1)/3-1;
      xb=(dx+1)/4;
      if( get_bw(x0,x0+xa,y0,y0+ya,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0,x0+xa,y1-ya,y1,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-xb,x1,y0,y0+ya,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-xa,x1,y1-ya,y1,box1->p,cs,1) == 1 ) break;
      for(i=0,y=y0+ya;y<=y1-ya;y++){ // horizontal line
        if( get_bw(x0+dx/9,x1-dx/9,y,y,box1->p,cs,2) == 0 ) { i=y; break; }
      }
      if( !i ) break;
      return '+';
   }
   // --- test $ ------------------------------------------------
   if(bc==UNKNOWN)
   for(d=100;dx>3 && dy>5;){     // min 3x4
      if( num_hole(x0,x1,y0,y1,box1->p,cs)!=2 ) break;
      
      if( get_bw(x0,x0+dx/5,y0      ,y0+dy/18,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0,x0+dx/9,y1-dy/23,y1      ,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-dx/9,x1,y0      ,y0+dy/18,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-dx/5,x1,y1-dy/23,y1      ,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0,x0+dx/3,y0+dy/3 ,y0+dy/2 ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3,x1,y1-dy/2 ,y1-dy/3 ,box1->p,cs,1) != 1 ) break;
      i1=x0+loop(box1->p,x0,y0,dx,cs,0,RI); if( i1<x0+dx/3 || i1>x1-dx/5 ) break;
      i2=x0+loop(box1->p,x0,y1,dx,cs,0,RI); if( i2<x0+dx/5 || i2>i1      ) break;
      for(i=1,y=y0;y<=y1 && i;y++) // vertikaler strich?
        if( get_bw(i2,i1+2,y,y,box1->p,cs,1) != 1 ) i=0;
      if( !i ) break;
      return '$';
   }
   // --- test & ------------------------------------------------
   if(bc==UNKNOWN && hchar)
   for(d=100;dx>5 && dy>6;){
      if( get_bw(x1-dx/9,x1,y0,y0+dy/4,box1->p,cs,1) == 1 ) break; // g
      i1=loop(b,0,dy/8   ,dx,cs,0,RI); if(i1>dx/2) break;
      i3=loop(b,0,dy-dy/4,dx,cs,0,RI); if(i3>i1) break;
      for( i2=0, y=dy/4; y<dy/2; y++ ){
        i =loop(b,0,y,dx,cs,0,RI); if( i>i2 ) i2=i;
      } if(2*i2-i1-i3<1) break;
      if( num_hole(x0,x1     ,y0,y1,box1->p,cs)!=2 ) break;
      if( num_hole(x0,x1-dx/4,y0,y1,box1->p,cs)!=2 ) break;
      if( num_cross(dx-1,dx-1,dy/4,dy-1,b,cs) < 1 ) break;
      for( x=dx-1; x>=dx/2; x-- ){
        if( num_cross(x,x,dy/4,dy-1,b,cs) > 1 ) break;
      } if( x<=3*dx/4 ) break; 
      return '&';
   }
   // --- test \it & like \epsilon\tau ------------------------------
   if(bc==UNKNOWN)
   for(d=100;dx>7 && dy>7;){
      if( num_cross(0,dx-1,  dy/4,  dy/4,b,cs) != 3 ) break;
      if( num_cross(0,dx-1,  dy/2,  dy/2,b,cs) != 4 ) break;
      if( num_cross(dx/2,dx-1,dy/2, dy/2,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,3*dy/4,3*dy/4,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,  dy-1,  dy-1,b,cs) != 1 ) break;
      if( num_cross(     0,     0,0,dy-1,b,cs) != 1 ) break;
      if( num_cross(  dx/3,  dx/3,0,dy-1,b,cs) != 4 ) break;
      if( num_cross(13*dx/16,13*dx/16,0,dy/8,b,cs) != 0 ) break;
      if( num_cross(4*dx/8,4*dx/8,dy-dy/4,dy-1,b,cs) != 1 ) break;
      if( num_cross(3*dx/8,3*dx/8,dy-dy/4,dy-1,b,cs) != 1 ) break;
      if( num_cross(5*dx/8,5*dx/8,dy-dy/4,dy-1,b,cs) != 1 ) break;
      if( num_hole(x0   ,(x0+x1)/2,y0,     y1,box1->p,cs) != 1 ) break;
      if( num_hole(x0+dx/8,x1-dx/4,y0,y1-dy/4,box1->p,cs) != 1 ) break;
      return '&';
   }
   // --- test ? ---------------------------------------------------
   if(bc==UNKNOWN)
   for(d=100;dx>3 && dy>5;){     // min 3x4
      if(bc!=UNKNOWN)
      	return bc;
      // out_b(box1->p,x0,y0,dx,dy,cs);
      for(y=y0;y<y1;y++)	// new y1
      if( get_bw(x0, x1, y, y,box1->p,cs,1) != 1 ) break; // lower end upper point
      if( y==y1 || 2*y<y0+y1 ) break;
      y--; i=y-y0+1;	// new dy
      if( num_cross(x0 , x1 , y0 , y0+dy/2 , box1->p,cs) < 2 ) break;
      if( num_hole( x0, x1, y0, y1, box1->p,cs) > 0 ) break;

      for(y=dy/2;y<dy;y++)
      if( get_bw(0,dx-1,y,y,b,cs,1) == 0 ) break;
      if( y==dy ) break;
      for(      ;y<dy;y++)
      if( get_bw(0,dx-1,y,y,b,cs,1) == 1 ) break;
      if( y==dy ) break;
      if( get_bw(7*dx/8,dx-1,y,dy-1,b,cs,1) == 1 ) break; // broken thin 2

      bc='?';
      return bc;
   }
   // --- test !| ---------------------------------------------------
   if(bc==UNKNOWN && hchar)
   for(d=100; dy>4 && dy>2*dx;){     // min 3x4
	// measure thickness
 
     for( i1=0,y=y0;y<=y1;y++){
       i=num_cross(x0,x1,y,y,box1->p,cs); if(i>1) break;
       if(i==0 && i1==0) i1=y;
     } if(y<=y1 || i1==0 || i1<y0+dy/2)break;

     return '!'; 
   }
   // --- test * five egdes (jagges? beames?) what is the right english word? ----
   if(bc==UNKNOWN)
   for(d=100;dx>4 && dy>4;){
      x=dx/2;y=(6*dy+8)/16; // center point 6/8=6/2^3 rounded 
      i=get_line2(x,y,x   ,0,b,cs,100); if(i<95) break; // black upwarts beam
      i=get_line2(0,y,dx-1,y,b,cs,100); if(i<95) break; // horizontal line
//      out_b(b,0,0,dx-1,dy-1,cs);printf(" %d",(5*dx+4)/8);
      i=get_line2(x,y,(5*dx+4)/8,dy-1,b,cs,100); if(i<95) break; // straight down
      i=get_line2(x,y,(2*dx+4)/8,dy-1,b,cs,100); if(i<95) break; // straight up
      i=get_line2(     x,dy-dy/8,x,dy-1,b,cs,101); if(i<95) break; // lower gap
      i=get_line2(     dx/4,dy/4,   0,0,b,cs,101); if(i<95) break; // upper left gap
      i=get_line2(dx-1-dx/4,dy/4,dx-1,0,b,cs,101); if(i<95) break; // upper right gap
      if( num_cross(0,dx-1,dy-1,dy-1,b,cs) != 2
       && num_cross(0,dx-1,dy-2,dy-2,b,cs) != 2 ) break;
      return '*';
   }
   // --- test @ - a popular char should be detectable! added in version v0.2.4a5
   if(bc==UNKNOWN)
   for(d=100;dx>7 && dy>7;){
      x=6*dx/16;
      y=dy/2;
      if( num_cross(0,dx-1,y,y,b,cs) != 4 ) break;
      if( num_cross(x,x,0,dy-1,b,cs) != 4 ) break;
      if( num_cross(0,   x,y,y,b,cs) != 2 ) break;
      if( num_cross(x,dx-1,y,y,b,cs) != 2 ) break;
      if( num_cross(x,x,0,   y,b,cs) != 2 ) break;
      if( num_cross(x,x,y,dy-1,b,cs) != 2 ) break;
      if( num_hole(x0,x1,y0,y1,box1->p,cs) != 1 ) break;
      if( num_hole(x0+dx/8,x1-3*dx/16,y0+dy/8,y1-dy/8,box1->p,cs) != 1 ) break;
      return '@';
   }
   // --- test paragraph v0.2.6
   if(bc==UNKNOWN && hchar)
   for(d=100;dx>4 && dy>15;){
      if( get_bw(     0,dx/2,3*dy/4,3*dy/4,b,cs,1) == 1 ) break;
      if( get_bw(3*dx/4,dx-1,3*dy/4,3*dy/4,b,cs,1) == 0 ) break;
      if( get_bw(     0,dx/4,  dy/4,  dy/4,b,cs,1) == 0 ) break;
      if( get_bw(  dx/2,dx-1,  dy/4,  dy/4,b,cs,1) == 1 ) break;
      if( get_bw(dx/2,dx/2,        0, dy/4,b,cs,1) == 0 ) break;
      if( get_bw(dx/2,dx/2,dy-1-dy/4, dy-1,b,cs,1) == 0 ) break;
      if( num_cross(dx/2,dx/2,0,dy-1,b,cs) != 4 ) break;
      if( num_cross(x0,x1,y0+dy/2,y0+dy/2,box1->p,cs) != 2 ) break;
      if( num_hole( x0,x1,y0+dy/4,y1-dy/4,box1->p,cs) != 1 ) break;
      return SECTION_SIGN;	// paragraph=0xA7=167 
   }
   if(box1->ac==UNKNOWN) box1->ac=ac;
   return bc;
}

/* ----------------------- part1 -------------------------------- */
wchar_t ocr0p1(struct box *box1, pix  *b, int cs){
   // pix  p=*(box1->p);
   int	i,j,d,x,y,x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
       i0,i1,i2,i3,i4,j1,t1;	/* tmp-vars */
   int xa,xb,xc,xd,xe,xf,	/* used for store significant points of char */
       ya,yb,yc,yd,ye,yf;
   wchar_t bc= UNKNOWN;				// bestletter
   wchar_t ac= UNKNOWN;				// alternative char (2nd best)
   int dots=box1->dots;
   // ad,ac will be used in future
   int  ad=0;				// propability 0..100

   int hchar;		// char is higher than 'e'
   int gchar;		// char has ink lower than m3
   // --- hchar --- gchar -------------------------
   hchar=0;if( 2*y0<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
   gchar=0;if( 2*y1>=2*box1->m3+(box1->m4-box1->m3) ) gchar=1;
   // if the char is slightly moved down correction can be done
   if ( y0<box1->m2 && y1>box1->m3 && 2*y1<box1->m3+box1->m4) // moved
   if( 2*(y0-(y1-box1->m3))<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
 
   // --- most frequent letter 'e' first!!!
   // --- test e ---------------------------------------------------
   for(d=100;dx>2 && dy>4;){     // min 3x4
      if( loop(box1->p,x0,y0+dy/2,x1-x0,cs,0,RI)>dx/3 ) break; // rough test
      if( loop(box1->p,x0+dx/2,y0,y1-y0,cs,0,DO)>dy/3 ) break;
      if( loop(box1->p,x0+dx/2,y1,y1-y0,cs,0,UP)>dy/3 ) break;
      i=loop(box1->p,x0,y0+dy/2,x1-x0,cs,0,RI); if( i>dx/2 ) break;
      j=loop(box1->p,x0,y0     ,x1-x0,cs,0,RI); if( j<i    ) break;
      j=loop(box1->p,x0,y1     ,x1-x0,cs,0,RI); if( j<i    ) break;
      i=loop(box1->p,x0+dx/2,y0,y1-y0,cs,0,DO); if( i>dx/2 ) break;
      j=loop(box1->p,x1-dx/3,y0,y1-y0,cs,0,DO); if( j<i ) i=j;
      j=loop(box1->p,x0     ,y0,y1-y0,cs,0,DO); if( j<i    ) break;
      j=loop(box1->p,x1     ,y0,y1-y0,cs,0,DO); if( j<i    ) break;
      i=loop(box1->p,x0+dx/2,y1,y1-y0,cs,0,UP); if( i>dx/2 ) break;
      j=loop(box1->p,x0     ,y1,y1-y0,cs,0,UP); if( j<i    ) break;
      j=loop(box1->p,x1     ,y1,y1-y0,cs,0,UP); if( j<i    ) break;
      //  out_x(box1);
      for(y=1;y<dy/2;y++) if( num_cross(x0,x1,y0+y,y0+y,box1->p,cs) == 2 ) break;
      if( y==dy/2 ) break;  // v0.2.5 ~ bad_t
      for(i=0,j=x0+dx/4;j<=x1-dx/4 && i<=dx/4;j++)
        if( num_cross(j,j,y0,y1,box1->p,cs) == 3 ) i++;
      if( i<dx/4-1 || i==0 ) break;  // v0.2.4a3 more strong! ~g
      // look for horizontal white line (right gap) => set x,y
      for(x=0,y=i=y0+dy/3;i<y1-dy/6;i++){
        j=loop(box1->p,x1,i,y1-y0,cs,0,LE);
        if(j>=x) { x=j;y=i; }
      }
      if (x<dx/2) break;
      for(i=1,j=x0+dx/6;j<x1-dx/6 && i;j++)
        if( num_cross(j,j,y0,y,box1->p,cs) > 1 ) i=0;
      if( i ) break;
      if( num_cross(x0,x1,y,y,box1->p,cs) != 1 ) break; // ausser bei weit geschwungenem e
      if( num_hole(x0, x1, y0 , y  ,box1->p,cs) <  1 ){
        if( hchar ) break; // ~ \it t
        // look if thinn font (may be h-line is broken) Mai00
        for(j=0,i=x0+dx/8;i<x1-1;i++)
        if( get_bw(i,i,y0+dy/4,y,box1->p,cs,1) == 1 ) j++;
        if(j<2*dx/4) break;
      }
      if( num_hole(x0, x1, y+1, y1 ,box1->p,cs) != 0 ) break;
      // suche Horizontalen Teiler
      for(x=0,y=i=y0;i<y1;i++){
        j=loop(box1->p,x0,i,x1-x0,cs,0,RI);
        if(j>=x) { x=j;y=i; }
      }
      if (y>y0+dy/6 && y<y1-dy/8) break;

      if( num_cross(x0+dx/2,x1,y1-dy/4,y1,box1->p,cs) == 0 ) break; // ~p
      if( hchar ){  // broken B ?
        x = loop(box1->p,x0,y0+dy/2,dx,cs,0,RI);
        if( loop(box1->p,x0,y0+dy/4,dx,cs,0,RI)<=x ) break;
        if( loop(box1->p,x0,y1-dy/4,dx,cs,0,RI)<=x ) break;
      }

      return 'e';
   }
   // --- test f like t ---------------------------------------------------
   if( (!dots) )  // Bold-face is gchar
   for(d=100;dx>2 && dy>box1->m3-box1->m2+1 && dy>5;){     // sometimes no hchar! 
      for(x=0,j=y=2+(3*dy+8)/32;y<4*dy/8;y++){ // upper cross line
        i=loop(b,0,y,dx,cs,0,RI); if( y>dy/4 && i>5*dx/8 ) break;
        i=loop(b,i,y,dx,cs,1,RI); if( i>x ) { x=i;j=y; }
        if( y<3*dy/4 && y>dy/4
         && num_cross(0,dx-1,y  ,y  ,b,cs) != 1
         && num_cross(0,dx-1,y+1,y+1,b,cs) != 1  // against noise
          ) break;
      } if( y<4*dy/8 ) break; y=j;// if( y>dy/2 || y<dy/8 ) break;
       
//          out_x(box1); MM;
      i=loop(b,0,dy/2,dx,cs,0,RI);
      i=loop(b,i,dy/2,dx,cs,1,RI); // thickness
      if( x<2*i ) break;

      if( loop(b,dx-1,dy/2,dx,cs,0,LE)<dx/2 )
      if( loop(b,dx-1,dy/2,dx,cs,0,LE)-1
        <=loop(b,dx-1, y  ,dx,cs,0,LE) ) break; // ~1

      if( loop(b,0,dy/2,dx,cs,0,RI)-1
         >loop(b,0,   1,dx,cs,0,RI) ) break; // ~X

      i=y;j=1;
      if( num_cross(0,dx-1,0,0,b,cs)==1 && hchar) //~r
      if( num_cross(0,dx-1,dy-1,dy-1,b,cs)!=1
       && num_cross(0,dx-1,dy-2,dy-2,b,cs)!=1 ) break; // ~* etc.
      for(y=1;j && y<i;   y++)  // no @@ pattern
       if( num_cross(0,dx-1,y  ,y  ,b,cs) ==2 ) j=0;
      for(y=1;j && y<i;   y++)  // no @@ pattern
      for(x=0;j && x<dx  ;x++){ //    ..
        if(  pixel(b,x  ,y  )>=cs && pixel(b,x+1,y  )>=cs
          && pixel(b,x  ,y-1)< cs && pixel(b,x+1,y-1)< cs ) { j=0;break; }
      }  if(j) break;

      if( num_hole (x0  , x1  , y0, y1,box1->p,cs) != 0 ) break; // ~e 
      // out_b(box1->p,x0,y0,dx,dy,cs); printf(" out_t xyi %d %d %d %d\n",x,y,i,j);
      for(i1=i2=dx,y=7*dy/8;y<dy;y++){
         x=loop(b,0   ,y,dx,cs,0,RI);if(x<i1)i1=x;
         x=loop(b,dx-1,y,dx,cs,0,LE);if(x<i2)i2=x;
      } if(i1>i2) break; // ~t ~e
      if( loop(b,0,3*dy/4,dx,cs,0,RI)<i1 ) break;

      bc='f';  // d*=100;d/=128 // not 100% !
      if(hchar) return 'f';
      break;
   }
   // --- test E ---------------------------------------------------
   for(d=100;dx>2 && dy>4 ;){     // min 3x4
      // holes right open?
      for( i=1,y=y0; y<y0+dy/4 && i; y++ ) // long black line
        if( get_bw(x0+dx/3,x1-dx/6,y,y,box1->p,cs,2) == 0 ) i=0;
      if( i ) break;
      for( i=1,y=y1; y>y1-dy/4 && i; y-- ) // long black line
        if( get_bw(x0+dx/6,x1-dx/4,y,y,box1->p,cs,2) == 0 ) i=0;
      if( i ) break;
      for( i=1,y=y0+dy/3; y<y1-dy/3 && i; y++ ){ // black line
        j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        j=loop(box1->p,x0+j,y,dx,cs,1,RI); if( j>dx/3 ) i=0;
      } if( i ) break;
      x=x1-dx/3; y=y0;		// von oben durchbohren!
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,DO,ST); if( y>y0+dy/4 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,DO); if( y>y0+dy/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,DO); if( x<=x1 || y>y0+dy/2 ) break;
      x=x1-dx/3; y=y1;		// von unten durchbohren!
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,UP,ST); if( y<y1-dy/4 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,UP); if( y<y0-dy/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,UP); if( x<=x1 || y<y0+dy/2 ) break;
      x=x1-dx/3; y=y0;		// von oben durchbohren!
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,DO,ST); if( y>y0+dy/4 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,DO); if( y>y0+dy/3 ) break;
      y+=dy/15;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST); if( x<=x0 ) break;
      x+=dx/15+1;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,DO,ST); if( y>y1-dy/3 ) break;
      if( num_hole(x0, x1, y0 , y1  ,box1->p,cs) > 0 ) break;
      i=loop(box1->p,x0,y0+dy/4,dx,cs,0,RI); if(i>dx/2) break;
      j=loop(box1->p,x0,y0+dy/2,dx,cs,0,RI); if(j<i-dx/4 || j>i+dx/8) break; i=j;
      j=loop(box1->p,x0,y1-dy/4,dx,cs,0,RI); if(j<i-dx/4 || j>i+dx/8) break;
      for( x=dx,y=y0+dy/6; y<y1-dy/9; y++ ) // left border straight
      { i=loop(box1->p,x0,y,dx,cs,0,RI); if( i>x+dx/9 ) break;
        if(i<x) x=i;
      } if( y<y1-dy/9 ) break;	// t
      if(dy>3*dx)  // ~[
      if( get_bw(x0+dx/2,x0+dx/2,y0+dy/4,y1-dy/4,box1->p,cs,1) == 0 ) break;

     return 'E';
   }
   // --- test w ~{\it w}-------
   for(d=100;dx>4 && dy>3;){     // dy<=dx
      //   xa      xe
      //    \  xc  /  <=ya  connected xa-xb-xc-xd-xe
      //     xb  xd   <=yb
      // get two lowest points  i3,i4,ya
      // out_x(box1);
      // ~ul ~uf
      // out_x(box1);
      for(y=dy/8;y<  dy/2;y++) if( num_cross(0,dx-1,y,y,b,cs)< 2 ) break;
      if(y<dy/2) break;
      for(y=dy-1-dy/16;y>3*dy/4;y--) if( num_cross(0,dx-1,y,y,b,cs)==2 ) break;
      if(y==3*dy/4) break; yb=y;
      t1=loop(b,0 ,dy/4,dx,cs,0,RI);
      t1=loop(b,t1,dy/4,dx,cs,1,RI); // thickness of line?
      for(i=j=0 ;y>  dy/4;y--) if( num_cross(0,dx-1,y,y,b,cs)==4 ) i++;
                          else if( num_cross(0,dx-1,y,y,b,cs)>=3 ) j++;
      if(i+5<dy/4 && 7*t1<dy) break;  // only for large letters
      if(i+j==0) break;
//    out_x(box1);
      if( num_cross(0,dx-1,    1,    1,b,cs)< 2
       && num_cross(0,dx-1,dy/16,dy/16,b,cs)< 2 ) break;
      x =loop(b,0     ,yb,dx,cs,0,RI);
      xb=loop(b,x     ,yb,dx,cs,1,RI);xb=x+xb/2;     if(xb>dx/2) break;
      x =loop(b,dx-1  ,yb,dx,cs,0,LE);
      xd=loop(b,dx-1-x,yb,dx,cs,1,LE);xd=dx-1-x-xd/2;if(xd<3*dx/8) break;
      for(y=0,xc=x=xb+1;x<xd;x++)if((i=loop(b,x,dy-1,dy,cs,0,UP))>y){xc=x;y=i;}
      if(!y) break; ya=dy-1-y; // flat
      y=loop(b,xc,ya,dy,cs,1,UP);if(y)y--;
      if( num_cross(0 ,xc  ,ya-y  ,ya-y  ,b,cs)!= 2 
       && num_cross(0 ,xc  ,ya-y/2,ya-y/2,b,cs)!= 2 ) break;
      if( num_cross(xc,dx-1,ya-y  ,ya-y  ,b,cs)!= 2 
       && num_cross(xc,dx-1,ya-y/2,ya-y/2,b,cs)!= 2 ) break;
//      out_x(box1);
      ya-=y/2;
      x =loop(b,0     ,1 ,dx,cs,0,RI);
      xa=loop(b,x     ,1 ,dx,cs,1,RI);
      if( x+xa>xb ){ // may be, here is a small but thick letter
         // later add some proofs
         xa=x+xa/4; 
      } else {
         xa=x+xa/2;
      }
      x =loop(b,dx-1  ,1 ,dx,cs,0,LE);
      xe=loop(b,dx-1-x,1 ,dx,cs,1,LE);xe=dx-1-x-xe/2;
      
//     printf(" %d %d %d %d %d %d %d %d %d %d\n",xa,1,xb,yb,xc,ya,xd,yb,xe,1);
      if( get_line2(xa   ,   1,xb,  yb,b,cs,100)<95 
       && get_line2(xa+dx/32,1,xb,  yb,b,cs,100)<95 ) break;
      if( get_line2(xb,yb-1,xc,ya      ,b,cs,100)<95
       && get_line2(xb,yb-1,xc,ya+dy/32,b,cs,100)<95
       && get_line2(xb,yb-1,xc,ya+dy/16,b,cs,100)<95 ) break;
      if( get_line2(xc,  ya,xd,  yb,b,cs,100)<95 
       && get_line2(xc+1,ya,xd,  yb,b,cs,100)<95 ) break;
      if( get_line2(xd,yb,xe      , 1,b,cs,100)<95 
       && get_line2(xd,yb,xe+dx/20, 1,b,cs,100)<95 ) break;
      // if( num_hole(0,dx-1,0,dy-1,b,cs) != 0 ) break;
      // ~ur
      for(i=0,y=3*dy/4;y<dy;y++){
        x=loop(b,dx-1,y,dx,cs,0,LE); if( x>i ) i=x; if( x<i-2 ) break;
      } if( y<dy ) break;
//    printf("Ok\n");
      if( hchar ) return 'W';
      return 'w';
   }
   // --- test ~w {\it w} -------
   // italic
   for(d=100;dx>4 && dy>3;){     // dy<=dx
      // ~ul ~uf
      for(y=dy/8;y<dy/2;y++) if( num_cross(0,dx-1,y,y,b,cs)<2 ) break;
      if(y<dy/2) break;
      if( num_cross(0,dx-1,dy/2,dy/2,b,cs)!=3 ) break;
      for(i=0,y=0;y<dy;y++)if( num_cross(0,dx-1,y,y,b,cs)==3 ) i++; else i--;
      if(i<=0) break;  // three legs
      // out_x(box1);
      yb=dy/2;
      x =loop(b,0     ,yb,dx,cs,0,RI);
      x+=loop(b,x     ,yb,dx,cs,1,RI);  if(x>dx/2) break;
      xb=loop(b,x     ,yb,dx,cs,0,RI);xb=x+xb/2;  if(xb>dx/2) break;
      x =loop(b,dx-1  ,yb,dx,cs,0,LE);
      x+=loop(b,dx-1-x,yb,dx,cs,1,LE);
      xd=loop(b,dx-1-x,yb,dx,cs,0,LE);xd=dx-1-x-xd/2;if(xd<3*dx/8) break;
      if( num_cross(xb,xd,yb,yb  ,b,cs)!= 1 ) break;
      if( num_cross(xb,xb,yb,dy-1,b,cs)!= 1 ) break;
      if( num_cross(xd,xd,yb,dy-1,b,cs)!= 1 ) break;
      if( num_cross(xb,xb, 0,yb  ,b,cs)!= 0 ) break;
      if( num_cross(xd,xd, 0,yb  ,b,cs)!= 0 ) break;
      if( num_hole(0,dx-1,0,dy-1,b,cs) != 0 ) break; 
      // ~ur
      for(i=0,y=3*dy/4;y<dy;y++){
        x=loop(b,dx-1,y,dx,cs,0,LE); if( x>i ) i=x; if( x<i-2 ) break;
      } if( y<dy ) break;
      if( hchar ) return 'W';
      return 'w';
   }
   // --- test A ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      // first selection (grobes Sieb)
      if( get_bw(dx/2,dx/2,dy-1-dy/8,dy-1,b,cs,1) == 1 ) break; // ~B
      if( get_bw(0   ,dx/8,0        ,dy/8,b,cs,1) == 1 ) break; // ~R
      if( num_cross(0,dx-1,     1  ,     1  ,b,cs)!=1	// 600dpi
       && num_cross(0,dx-1,  dy/8  ,  dy/8  ,b,cs)!=1
       && num_cross(0,dx-1,  dy/16 ,  dy/16 ,b,cs)!=1
       && num_cross(0,dx-1,  dy/8+1,  dy/8+1,b,cs)!=1 ) break;
      if( num_cross(0,dx-1,7*dy/8  ,7*dy/8  ,b,cs)!=2
       && num_cross(0,dx-1,7*dy/8-1,7*dy/8-1,b,cs)!=2 ) break;
      for(y=dy/8;y<dy/2;y++) if( num_cross(0,dx-1,y,y,b,cs) > 1 ) break;
      if( y==dy/2 ) break; i1=y;
      
      x =loop(b,0,i1,dx,cs,0,RI); if(x>3*dx/4) break;
      x+=loop(b,x,i1,dx,cs,1,RI); if(x>3*dx/4) break; i2=x;
      x+=loop(b,x,i1,dx,cs,0,RI); if(x<3*dx/8) break; i2=(x+i2)/2;
      // hole (i2,i1)
      y+=loop(b,i2,y,dy,cs,0,DO); if(y>3*dy/4) break;
      
      if( num_hole ( x0, x1, y0, y1-dy/4 ,box1->p,cs) != 1 ) break;
      // out_x(box1);
      i3=0;i4=0;
      for(x=dx/4;x<3*dx/4;x++){
       i4=num_cross(i2,x,y      ,dy-1,b,cs);if(i4<1 || i4>2)
       i4=num_cross(i2,x,y+dy/16,dy-1,b,cs);if(i4<1 || i4>2) break;
       if(i4==1) i3=x;
      } if(i4<1 || i4>2 || i3==0) break;

      if( get_bw(dx-1-dx/4, dx-1, dy-1-dy/4, dy-1, b,cs,1) != 1 ) break;
      /* dy/4 changed to dy/6 because of screenfonts */
      if( get_bw(   0     , dx/8,        0 , dy/6, b,cs,1) == 1 ) break;
      if( get_bw(dx-1-dx/8, dx-1,        0 , dy/6, b,cs,1) == 1 ) break;

      i1=loop(b,dx-1,     dy/4,dx,cs,0,LE);
      i2=loop(b,dx-1,     dy/2,dx,cs,0,LE);
      i3=loop(b,dx-1,dy-1-dy/4,dx,cs,0,LE);
      if( 2*i2+dx/4<i1+i3 || 2*i2-dx/8>i1+i3 ) break;

      i1=loop(b,0   ,     dy/4,dx,cs,0,RI);	// linke senkr. linie
      i2=loop(b,0   ,     dy/2,dx,cs,0,RI);
      i3=loop(b,0   ,dy-1-dy/4,dx,cs,0,RI);
      if( 2*i2+dx/4<i1+i3 || 2*i2-dx/8>i1+i3 || i1<i3) break;

      // lower ends could be round on thick fonts
      for(i3=dx,y=dy/4;y<7*dy/8;y++){ // increasing width
        i1=loop(b,   0, y,dx,cs,0,RI);
        i2=loop(b,dx-1, y,dx,cs,0,LE);
        if(i1+i2>i3+dx/16) break; if( i1+12<i3 ) i3=i1+i2;
      } if(y<7*dy/8) break;
      
      bc='A';
      return bc;
   }
   // --- test a ---------------------------------------------------
   for(d=100;dx>2 && dy>4;){     // min 3x4
      if( get_bw(x0     , x0+dx/2, y1-dy/3, y1-dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3, x1     , y0+dy/3, y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3, x1     , y0+dy/4, y0+dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2, y1-dy/2, y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2, y0     , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/3, x1-dx/3, y0     , y0     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/4, x1-dx/2, y1     , y1     ,box1->p,cs,1) != 1 )
      if( get_bw(x0+dx/4, x1-dx/3, y1-1   , y1-1   ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0     , y0+dy/2, y1     ,box1->p,cs,1) != 1 )
      if( get_bw(x0+dx/8, x0+dx/8, y0+dy/2, y1     ,box1->p,cs,1) != 1 ) break;
      if( loop(b,3*dx/8,0,dy,cs,0,DO) > 3*dy/16 ) break; // ~d

      if( num_cross(0,dx-1,dy/4  ,dy/4  , b,cs) >2 )  // ~glued am != an
      if( num_cross(0,dx-1,dy/4+1,dy/4+1, b,cs) >2 ) break;

      for(i=dx/8+1,x=dx/4;x<=dx-1-dx/4 && i;x++){
        if( num_cross(x,x,0,b->y-1, b,cs) == 3 ) i--;
      } if( i ) break;

      i1=loop(b,0,  dy/8,dx,cs,0,RI);
      i3=loop(b,0,3*dy/4,dx,cs,0,RI);
      for(y=dy/8+1;y<3*dy/4;y++){
        i2=loop(b,0,y,dx,cs,0,RI);if(2*i2>i1+i3+1) break;
      } if(y==3*dy/4) break; // ~6
      // ~ s (small thick s), look for vertikal line piece
      for(x=3*dx/4;x<dx;x++)
      if( loop(b,x,dy/4,dy/2,cs,1,DO)>dy/4 ) break; 
      if( x==dx ) break;

      if( num_hole (x0     , x1     , y0+dy/3, y1 ,box1->p,cs) != 1 ) break;
      // if( num_hole (x0     , x1     , y0     , y1 ,box1->p,cs) != 1 ) break;
      if( num_hole (x0     , x1     , y0, y1-dy/3 ,box1->p,cs) != 0 ){
        i =loop(b,0,dy/4,dx,cs,0,RI);
        i =loop(b,i,dy/4,dx,cs,1,RI);
        if(i<dx/4+1) break;        // fat a
        i =loop(b,0,dy/4,dx,cs,0,RI);
        i+=loop(b,i,dy/4,dx,cs,1,RI);
        for(y=dy/4;y<dy/2;y++)
        if( num_cross(0,dx-1,y,y, b,cs) !=2 ) break;
        x =loop(b,0,y-1,dx,cs,0,RI);
        x+=loop(b,x,y-1,dx,cs,1,RI);
        if(x>i) break;        // ~ 8
      }
      
      if(hchar && gchar) { if(ac==UNKNOWN) ac='a'; break; } // ~Q
      if ( hchar || gchar ) break;
      bc='a';
      break;
   }
   // --- test hand written a ---------------------------------------------------
   if((!hchar) && (!gchar))
   for(d=100;dx>3 && dy>4;){     // min 3x4
      if( get_bw(x0      , x0+dx/2,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/2 , x1     ,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y1-dy/2 , y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0      , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/3 , x0+dx/3,y0      , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0+dy/2 , y1-dy/3,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0      , x0     ,y1      , y1     ,box1->p,cs,1) == 1 ) break;

      if( num_cross(x0+dx/2,x0+dx/2,y0      , y1     ,box1->p,cs)  != 2 ) break;
      if( num_cross(x0+dx/3,x1-dx/3,y0      , y0     ,box1->p,cs)  != 1 ) // AND
      if( num_cross(x0+dx/3,x1-dx/3,y0+1    , y0+1   ,box1->p,cs)  != 1 ) break;
      if( num_cross(x0,x1,y1      , y1     ,box1->p,cs)  != 2 )
      if( num_cross(x0,x1,y1-1    , y1-1   ,box1->p,cs)  != 2 ) break;
      if( num_cross(x0,x1,y0+dy/2 , y0+dy/2,box1->p,cs)  != 2 
       || num_cross(x0,x1,y0+dy/4 , y0+dy/4,box1->p,cs)  != 2 ) break; // Jun00

      if( num_cross(x0     ,x0     ,y0+dy/3 , y1-dy/4,box1->p,cs)  != 1 )
      if( num_cross(x0+1   ,x0+1   ,y0+dy/3 , y1-dy/4,box1->p,cs)  != 1 ) break;
      if( num_hole(x0,x1-2,y0     ,y1     ,box1->p,cs) != 1 )
      if( num_hole(x0,x1  ,y0     ,y1     ,box1->p,cs) != 1 ) break;
      if( num_hole(x0,x1  ,y0+dy/4,y1-1   ,box1->p,cs) != 0 ) break;
      if( num_hole(x0,x1  ,y0     ,y1-dy/5,box1->p,cs) != 0 ) break; // Q

      if( loop(b,0   ,0   ,x1-x0,cs,0,RI)<=
          loop(b,0   ,2   ,x1-x0,cs,0,RI)  ) break;

      if( loop(b,dx-1,dy-1,x1-x0,cs,0,LE)>  dx/4 
       && loop(b,dx-1,dy-2,x1-x0,cs,0,LE)> (dx+4)/8 ) break;

      x=loop(b,dx-1,dy-1-dy/2,dx,cs,0,LE);	// should be minimum
      for( y=dy-1-dy/2;y<dy;y++ ){
        i=loop(b,dx-1,y,x1-x0,cs,0,LE);
        if( i<x ) break; x=i;
      }
      if( y>=dy ) break;

      bc='a';			// schreib-a (alpha)
      break;
   }
   // --- test c,C ---------------------------------------------------
   if(!gchar)
   for(d=100;dx>2 && dy>2;){     // min 3x4
      if( get_bw(x0     , x0+dx/3,y0+dy/2, y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2,y1-dy/3, y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2,y0     , y0+dy/3,box1->p,cs,1) != 1 ) break;
      for(y=y0+dy/4;y<y0+3*dy/4;y++)
        if( get_bw(x0+dx/2,x1,y,y,box1->p,cs,1) == 0 ) break;
      if( y==y0+3*dy/4 ) break; i1=y;   // upper end of right gap
      for(y=i1;y<y1-dy/8;y++)
        if( get_bw(x0+dx/2,x1,y,y,box1->p,cs,1) == 1 ) break;
      if( y-i1<dy/6 ) break; i2=y-1;   // lower end of right gap
      for(y=i1,i2=0,x=x0+dx/2;x<x0+6*dx/8;x++){
        i=y-1+loop(box1->p,x0+dx/2,i1,dy,cs,0,DO);
        if( i>i2 ) { i2=i; }
      } if(i2<y0+5*dy/8) break; // lowest 
      i3=y+1-loop(box1->p,x0+dx/2,i1,dy,cs,0,UP); if(i3>y0+  dy/4) break; // highest
      if( num_cross(x0+dx/2,x1,i2,y0,box1->p,cs) < 1 ) break; // ~L
      if( num_cross(x0+dx/2,x1,i3,y1,box1->p,cs) < 1 ) break; // ~r
      
      i=1;
      for(x=dx/2;x<dx-1 && i;x++)  // look for  @@ (instead +1 use +delta?) 
      for(y=dy/2;y<dy-1 && i;y++){ //           .@
        if( pixel(b,x  ,y  )>=cs
        &&  pixel(b,x+1,y  )< cs
        &&  pixel(b,x+1,y-1)< cs
        &&  pixel(b,x  ,y-1)< cs ) { i=0;break; }
      }
      // out_b(b,0,0,dx,dy,cs); printf(" ok? %d\n",i);
      if(!i) break;		// ~G

      i=loop(b,0,dy/2,dx,cs,0,RI);
      for(y=0;y<dy;y++)if( loop(b,0,y,dx,cs,0,RI)<i-1-dx/32 ) break;
      if( y<dy ) break; // ~r
      // out_x(box1);
      for(i1=0,i2=dx,y=dy/2;y>=dy/4;y--){
        x =loop(b,0,y,dx,cs,0,RI);
        x+=loop(b,x,y,dx,cs,1,RI); if(x>i1) i1=x;
        i =loop(b,x,y,dx,cs,0,RI); if(i<i2) i2=i;
        if( i1<x-dx/32 && i>i2+dx/32 ) break; // unusual for c, more a bad e?
      } if( y>=dy/4 ) break;
      
      if( !hchar ){ // test for e where the middle line is partly removed
        x=     loop(b,0,dy/2,dx,cs,0,RI);
        x=x   +loop(b,x,dy/2,dx,cs,1,RI);
        y=dy/2-loop(b,x,dy/2,dy,cs,0,UP)-1;
        i=x   +loop(b,x,y,dx,cs,1,RI);
        i=i   +loop(b,i,y,dx,cs,0,RI);
        if( num_cross(x  ,x  ,1,dy/2,b,cs) > 1
         || num_cross(x+1,x+1,1,dy/2,b,cs) > 1 )
        if( num_cross(i-1,i-1,1,dy/2,b,cs) > 1
         || num_cross(i  ,i  ,1,dy/2,b,cs) > 1 ) break; // ~bad e
      }
      if( dy>16 && dy>3*dx && hchar ){	// ~[
        x= loop(b,0,     dy/16,dx,cs,0,RI);
        x=+loop(b,0,dy-1-dy/16,dx,cs,0,RI);
        i= loop(b,0,     dy/2 ,dx,cs,0,RI)*2;
        if( i>=x )
        if( num_cross(0,dx-1,dy/4,dy/4,b,cs) < 2 ) break;
       
      }
      if( get_bw(x0,x0,y0  ,y1  ,box1->p,cs,2) != 2
       && get_bw(x0,x1,y0  ,y0  ,box1->p,cs,2) != 2
       && get_bw(x0,x1,y1  ,y1  ,box1->p,cs,2) != 2
       && get_bw(x1,x1,y0+1,y1-1,box1->p,cs,1) != 1 ) break; /* ~[ */

      x =loop(b,   0,dy/2,dx,cs,0,RI);
      i =loop(b,dx-1,dy/2,dx,cs,0,LE);
      if( (i<dx/2 || i<3) && hchar && dy>7 )
      if( loop(b,   0,7*dy/8,dx,cs,0,RI) > x+dx/8
       && loop(b,   0,  dy/8,dx,cs,0,RI) > x+dx/8
       && loop(b,dx-1,dy-1-dy/ 8,dx,cs,0,LE)
        > loop(b,dx-1,dy-1-dy/16,dx,cs,0,LE)
       && loop(b,dx-1,     dy/ 8,dx,cs,0,LE)
        > loop(b,dx-1,     dy/16,dx,cs,0,LE) ) break; // ~(

      bc='c'; if( hchar ) bc='C';
      return bc;
   }
   // --- test uU ---------------------------------------------------
   //  in Mitte so breit wie oben (bei V kontinuierlich schmaler)
   for(d=100;dx>2 && dy>3;){     // min 3x4
      for(y=y0+dy/8;y<y1-dy/4;y++)
        if( num_cross(x0,x1,y,y,box1->p,cs) < 2 ) break;
      if( y<y1-dy/4 ) break;
      if( get_bw(dx/2,dx/2,dy/2,dy-1,b,cs,1)==0 ) break;
      if( get_bw(dx/2,dx-1,dy/2,dy/2,b,cs,1)==0 ) break;
      for(i=0,x=3*dx/8;x<dx-dx/4;x++){
        y=loop(b,x,0,dy,cs,0,DO); if(y>i)i=y; if(y<i && i>1) break;
      } if( i<dy/4 ) break; x--;
      if( get_bw(0,x   ,i-1,i-1,b,cs,1)==0 ) break;
      if( get_bw(x,dx-1,i-1,i-1,b,cs,1)==0 ) break;

      for(i=dy/16+1,y=dy/8;y<dy-dy/4 && i;y++){	// 12%+1 Fehler
        j=num_cross(0,dx/2,y,y,b,cs);
        if( y<dy/2 && num_cross(dx/2,dx-1,y,y,b,cs)>1 ) i--; // ~{\it v}
        if( y<dy/2 && (j<1 && j>2) ) i--;
        if( y>dy/2 && j!=1 ) i--;
      } if( !i ) break;
      for(i=dy/16+1,y=dy/8;y<dy-dy/4 && i;y++){	// 12%+1 Fehler
        j=num_cross(dx-dx/2,dx-1,y,y,b,cs);
        if( y>dy/2 && (j<1 && j>2) ) i--;
        if( y<dy/2 && j!=1 ) i--;
      } if( !i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x, y0,    y0+dy/3,box1->p,cs,1) != 1 ) i=0;
      } if( i ) break;
      for(i=dx/4+1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x,y0+dy/3,y1-dy/3,box1->p,cs,3) != 2 ) i--;
      } if( !i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x,y1-dy/3,     y1,box1->p,cs,3) == 2 ) i=0;
      } if( !i ) break;
      if( num_cross(0      ,dx/2,   dy/4,   dy/4,b,cs)==2
       && num_cross(dx-dx/2,dx-1,dy-dy/4,dy-dy/4,b,cs)==1 ) break; // ~{\it v}

      i=loop(b,0,dy-1-dy/16,dx,cs,0,RI);
      j=loop(b,0,dy-1-dy/8 ,dx,cs,0,RI);
      if( i<j ) break; // ~ll v0.2.4a3
      if(dy>15)
      if( loop(b,dx-1,dy/16,dx,cs,0,LE)
        > loop(b,dx-1,dy/8 ,dx,cs,0,LE)+1+dx/32 ) break; // ~bad 0 (thinn)

      bc='u';

      if(dots==0) if( hchar ){ bc='U'; }
      break;
   }
   // --- test \mu ---------------------------------------------------
   //  in Mitte so breit wie oben (bei V kontinuierlich schmaler)
   if( gchar && !hchar )
   for(d=100;dx>2 && dy>4;){     // min 3x4
      for(y=y0+dy/8;y<box1->m3-dy/4;y++)
        if( num_cross(x0,x1,y,y,box1->p,cs) < 2 ) break;
// out_x(box1);MM;
      if( y<box1->m3-dy/4 ) break;
      if( get_bw(dx/2,dx/2,3*dy/8,7*dy/8,b,cs,1)==0 ) break;
      if( get_bw(dx/2,dx-1,3*dy/8,7*dy/8,b,cs,1)==0 ) break;
      for(y=dy/2;y<dy;y++){
        x=loop(b,dx-1,y,dx,cs,0,LE); if(8*x>5*dx) break;
      } if( y>=dy || 2*y>box1->m3+box1->m4) break; i2=y;
      for(i=0,x=2*dx/8;x<dx-1-dx/4;x++){
        y=loop(b,x,0,dy,cs,0,DO); if(y>i)i=y; if(y<i && i>1) break;
      } if( i<dy/4 ) break; x--;
      if( get_bw(0,x   ,i-1,i-1,b,cs,1)==0 ) break;
      if( get_bw(x,dx-1,i-1,i-1,b,cs,1)==0 ) break;
      for(i=dy/16+1,y=dy/8;y<dy-(box1->m4-box1->m3)-dy/4 && i;y++){	// 12%+1 Fehler
        j=num_cross(0,dx/2,y,y,b,cs);
        if( y<dy/2 && num_cross(dx/2,dx-1,y,y,b,cs)>1 ) i--; // ~{\it v}
        if( y<dy/2 && (j<1 && j>2) ) i--;
        if( y>dy/2 && j!=1 ) i--;
      } if( !i ) break;
      for(i=dy/16+1,y=dy/8;y<dy-(box1->m4-box1->m3)-dy/4 && i;y++){	// 12%+1 Fehler
        j=num_cross(dx-dx/2,dx-1,y,y,b,cs);
        if( y>dy/2 && (j<1 && j>2) ) i--;
        if( y<dy/2 && j!=1 ) i--;
      } if( !i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x, y0,    y0+dy/4,box1->p,cs,1) != 1 ) i=0;
      } if( i ) break;
      for(i=dx/4+1,x=x0+dx/3;x<=x1-dx/3 && i;x++){
        if( get_bw( x, x,y0+dy/4,y1-dy/2,box1->p,cs,3) != 2 ) i--;
      } if( !i ) break;
      if( num_cross(0      ,dx/2,   dy/4,   dy/4,b,cs)!=1 ) break;
      if( num_cross(dx-dx/2,dx-1,dy-dy/2,dy-dy/2,b,cs)!=1 ) break;
      if( get_bw( dx/4,dx-1,dy-2-3*dy/16,dy-1,b,cs,1) == 1 ) break;
      if( num_cross(0      ,dx/4,dy-1,dy-1,b,cs)!=1 ) break;
      // bc = compose('m', 'g'); /* um='g' for greek ??? */
      bc = MICRO_SIGN;

      break;
   }
   // --- test v -------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( get_bw(x0     , x0+dx/2,y0+dy/2, y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/2, x1     ,y0+dy/2, y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2,y1-dy/2, y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2,y0     , y0+dy/3,box1->p,cs,1) == 1 ) // it v?
      if( get_bw(x0+dx/2+1,x0+dx/2+1,y0  , y0+dy/3,box1->p,cs,1) == 1 ) break;

      // UVW
      if(((num_cross(     0,dx/2+1,dy/ 8,dy/ 8,b,cs)!=1)
       && (num_cross(     0,dx/2+1,dy/16,dy/16,b,cs)!=1) // it v
       && (num_cross(dx/2+1,dx  -1,dy/ 8,dy/ 8,b,cs)!=1)) /* () added on Sep00 */  
      || ((num_cross(   0,dx-1,dy-1-dy/8,dy-1-dy/8,b,cs)> 1) 
       && (num_cross(   0,dx-1,dy-1     ,dy-1     ,b,cs)> 1)) ) break;
      // UV
      if( get_bw(0        ,dx/8,dy-1-dy/6,dy-1,b,cs,1)==1 ) break;
      if( get_bw(dx-1-dx/8,dx-1,dy-1-dy/6,dy-1,b,cs,1)==1 ) break;
      if( loop(b,0   ,dy/6     ,dx,cs,0,RI)
        >=loop(b,0   ,dy-1-dy/3,dx,cs,0,RI) ) break;
      if( loop(b,0   ,dy-1-dy/3,dx,cs,0,RI)
        >=loop(b,0   ,dy-1-dy/8,dx,cs,0,RI)
       && loop(b,dx-1,dy-1-dy/3,dx,cs,0,LE)
        >=loop(b,dx-1,dy-1-dy/8,dx,cs,0,LE) ) break;
      if( loop(b,dx-1,dy/6     ,dx,cs,0,LE)
        >=loop(b,dx-1,dy-1-dy/3,dx,cs,0,LE) ) break;
      x=loop(b,0,dy-1,dx,cs,0,RI); // 3*x>dx changed to 2*x>dx May2001 JS
      x=loop(b,x,dy-1,dx,cs,1,RI); if ( dx>14 && 2*x>dx ) break; // U
      if( num_cross(0      ,dx/2,   dy/4,   dy/4,b,cs)==2
       && num_cross(dx-dx/2,dx-1,dy-dy/4,dy-dy/4,b,cs)==2 ) break; // ~{\it u}
      
#if 0
      // measure thickness of lower v 
      i=loop(b,   0,dy-1-dy/16,dx,cs,0,RI)
       +loop(b,dx-1,dy-1-dy/16,dx,cs,0,LE);
      j=loop(b,   0,dy-1-dy/4 ,dx,cs,0,RI)
       +loop(b,dx-1,dy-1-dy/4 ,dx,cs,0,LE);
      if( box1->m1 && hchar && dy>15 && j>=i-dx/32 ) break;	// ~Y
#endif
      /* V has serifs only on upper site! Y also on bottom, check it. Okt00 */
      i=loop(b,  0,   0,dx,cs,0,RI);
      i=loop(b,  i,   0,dx,cs,1,RI); i1=i; // thickness	
      i=loop(b,  0,   1,dx,cs,0,RI);
      i=loop(b,  i,   1,dx,cs,1,RI); if(i>i1) i1=i; // thiggest
      i=loop(b,  0,dy/4,dx,cs,0,RI);
      i=loop(b,  i,dy/4,dx,cs,1,RI); i2=i;
      i=loop(b,  0,dy  ,dx,cs,0,RI);
      i=loop(b,  i,dy  ,dx,cs,1,RI); i3=i; // thickness	
      i=loop(b,  0,dy-1,dx,cs,0,RI);
      i=loop(b,  i,dy-1,dx,cs,1,RI); if(i>i3) i3=i; // thiggest
      if( y0 < box1->m2 )
      if( i1-i2 > dx/32+2 
       && i3-i2 > dx/32+2 ) break; // ~serif_Y 
      
      if( y0 < box1->m2 )
      if( i1-i2 < dx/32+2 ) 	/* no serif detected */
      if( num_cross(0,dx-1,dy-1-dy/4,dy-1-dy/4,b,cs)==1 ){
        i=loop(b,   0,dy/4,dx,cs,0,RI);
        i=loop(b,   i,dy/4,dx,cs,1,RI); // thickness	
        j=loop(b,   0,dy-1-dy/4 ,dx,cs,0,RI);
        j=loop(b,   j,dy-1-dy/4 ,dx,cs,1,RI);
        if ( j<=i+1 ) break; // ~Y
      }
      bc='v';
      if( hchar ) bc='V';
      break;
   }
   // --- test r -------
   for(d=100;dy>4 && dx>2;){     // dy>dx
      if( dots || hchar || gchar || 2*dy<box1->m3-box1->m1) break;

      if( loop(b,dx-1,dy/2,dx,cs,0,LE)<=dx/8+2 ) break; // ~v Jun00


      i=dy-(dy+20)/32;	// ignore dust on the ground

      for( y=4*dy/8; y<i; y++ ){  // center down v-line
        if( y<dy-2*dy/8 && num_cross(0,dx-1,y,y,b,cs) !=1 ) break;
        i1= loop(b,0   ,y,dx,cs,0,RI); if(i1>3*dx/8) break;
        i2= loop(b,dx-1,y,dx,cs,0,LE); if(i1>i2) break;
        if( (i1+(dx-i2-1))/2 >= 4*dx/8 ) break; // mass middle should be left
      }
      if (y<i) break;

      for( x=4*dx/8; x<dx; x++ ){  // right upper h-line
        if( get_bw(x,x,0,dy/4,b,cs,1) !=1 ) break; }
      if (x<dx) break;

      if( loop(b,dx-1,dy-1-dy/4,dx,cs,0,LE)>5*dx/8          // not a C
      && get_bw(dx-1-dx/8,dx-1,dy-1-dy/4,dy-1,b,cs,1) ==1 ) break;

      if( loop(b,0,dy/4,dx,cs,0,RI)>3*dx/8          // not a I
      && get_bw(0,dx/8,0,dy/4,b,cs,1) ==1 ) break;
      if( num_hole(x0, x1, y0 , y1 ,box1->p,cs) != 0 ) break; // not \sc P
      if( num_cross(0,dx-1,dy/2,  dy/2  ,b,cs)!=1
       && num_cross(0,dx-1,dy/2+1,dy/2+1,b,cs)!=1 ) break; // ~n 024a3

      // itallic t is sometimes not high enough, look for v-like shape
      for(y=3*dy/4;y<dy-1;y++)
      if( num_cross(0,dx-1,y,        y        ,b,cs)==2
       && num_cross(0,dx-1,y+1+dy/32,y+1+dy/32,b,cs)==2 ) break; // ~t
      if(y<dy-1) break;

      if((!hchar) && (!gchar))return 'r';
      bc='r'; break; // not 100% sure!
   }
   // --- test R ---------------------------------------------------
   if(!gchar)
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( num_cross(x0,x1,y1-dy/8,y1-dy/8, box1->p,cs) < 2 ) break; // ~P
      for(i=1,y=y0+dy/8;y<=y1-dy/8 && i;y++){  // left v-line
        if( get_bw(x0     , x0+dx/2,y, y,box1->p,cs,1) != 1 ) i=0;
      } if( !i ) break;
      for(i=1,x=x0+3*dx/8;x<=x1-dx/4 && i;x++){  // upper h-line
        if( get_bw( x, x, y0,    y0+dy/4,box1->p,cs,1) != 1 ) i=0;
      } if( !i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){  // lower h-gap
        if( get_bw( x, x,y1-dy/4,y1     ,box1->p,cs,1) == 0 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/8 && i;x++){  // vert crossed 2 ???
        if( num_cross(x,x,y0,y1, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+3*dy/8 && i;y++){  // upper 2 vert lines
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0+dy/3;y<=y1-dy/3 && i;y++){ // midle h line
        if( num_cross(x0,x1,y,y, box1->p,cs) == 1 ) i=0;
      } if( i ) break;
      for(i=1,y=y1-dy/4;y<=y1 && i;y++){   // lower 2 vert lies
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( get_bw(x1-dx/3,x1,y0,y0+dy/4,box1->p,cs,1) != 1 ) break; // pixel ru
      x=loop(b,dx-1,     dy/4,dx,cs,0,LE); if(x>dx/2) break; i=x; // ru
      x=loop(b,dx-1,     dy/2,dx,cs,0,LE); if(x<=i  ) break; i=x; // rc
      x=loop(b,dx-1,   5*dy/8,dx,cs,0,LE); if(x>i  ) i=x;
      x=loop(b,dx-1,   6*dy/8,dx,cs,0,LE); if(x>i  ) i=x;
      x=loop(b,dx-1,dy-1-dy/8,dx,cs,0,LE); if(x>=i  ) break;      // rd
      if( num_hole(x0, x1, y0 , y1-dy/3 ,box1->p,cs) != 1 ) break;
      i1=loop(b,0,     dy/4,dx,cs,0,RI); // straight
      i2=loop(b,0,     dy/2,dx,cs,0,RI);
      i3=loop(b,0,dy-1-dy/4,dx,cs,0,RI); if( abs(i1+i3-2*i2)>1+dx/16 ) break;
      bc='R'; break;
   }
   // --- test m -------
   if(!gchar && !hchar)
   for(d=100;dx>4 && dy>3;){
      y=dy/2;
      if( num_cross(0,dx-1,y  ,y  ,b,cs) != 3
       && num_cross(0,dx-1,y+1,y+1,b,cs) != 3 ) break; // m ru rn
      x =loop(b,0,y,dx  ,cs,0,RI); if(x>  dx/4) break; // search 1st v-line
      x+=loop(b,x,y,dx-x,cs,1,RI); if(x>  dx/2) break; i1=x; // first gap
      x+=loop(b,x,y,dx-x,cs,0,RI); if(x>3*dx/4) break; i2=x; // 2nd v-line
      x+=loop(b,x,y,dx-x,cs,1,RI); if(x>6*dx/8) break; i3=x; // 2nd gap
      x+=loop(b,x,y,dx-x,cs,0,RI); if(x<5*dx/8) break; i4=x; // 3th v-line
      if( abs((i2-i1)-(i4-i3)) > 2+((i2-i1)+(i4-i3))/16 ) break; // same gap width? rn
      // the same game for the lower part =>l1 l2 l3 l4 ???
      i =loop(b,0,5*dy/8,dx,cs,0,RI);
      i =loop(b,i,5*dy/8,dx,cs,1,RI);
      x =loop(b,0,dy-dy/32-1,dx,cs,0,RI);
      x =loop(b,x,dy-dy/32-1,dx,cs,1,RI);
      if( x > i+1 ) i=1; else i=0; /* looks like serif m, Okt00 */
      for(x=i1;x<i2;x++) if( loop(b,x,dy-1-i,dy,cs,0,UP)>dy/4 ) break;
      if(x==i2) break; // no gap detected
      for(x=i3;x<i4;x++) if( loop(b,x,dy-1-i,dy,cs,0,UP)>dy/4 ) break;
      if(x==i4) break; // no gap detected
      for(x=i1;x<i3;x++) if( loop(b,x,dy-2,dy,cs,1,UP)>dy/4 ) break;
      if(x==i3) break; // no middle line detected
      for(x=i1;x<i4;x++) if( loop(b,x,0,dy,cs,0,DO)>=dy/2 ) break;
      if(x<i4) break; // gap detected
      // glued rn as m ??? hmm seems a ballance act
      if(i2-i1>i4-i3+dx/16){
       for(y=0,x=(i1+i2)/2;x<i2;x++){
         i=loop(b,x,0,dy,cs,0,DO); 
         i=loop(b,x,i,dy,cs,1,DO); // measure thickness
         if( i>y ) y=i; if( 2*i<y ) break;
       }
       if(x <i2) break; // unusual property for m (see n)
      }

      if(ad<90) { ac='m';ad=90;  // {\it m}
         if( loop(b,1,  dy/4,dx,cs,0,RI)
            >loop(b,0,7*dy/8,dx,cs,0,RI) ) return 'm'; 
      }
      for(x=i1;x<i4;x++) if( loop(b,x,0,dy,cs,0,DO)>=dy/4 ) break;
      if(x<i4) break; // gap detected

      return 'm';

   }
   // --- test M -------
   if((!gchar)/* && hchar */)  // SMALL CAPS FONT ???
   for(d=100;dx>4 && dy>3;){	// dy<=dx nicht perfekt! besser mittleres
				// min-suchen fuer m
      if( num_cross(0,dx-1,  dy/2,  dy/2,b,cs)<3
       && num_cross(0,dx-1,  dy/4,  dy/4,b,cs)<3
       && num_cross(0,dx-1,5*dy/8,5*dy/8,b,cs)<3
       && num_cross(0,dx-1,3*dy/4,3*dy/4,b,cs)<3 ) break;
      if( num_cross(0,dx-1,  dy/4,  dy/4,b,cs)<2 ) break;
      if( num_cross(0,dx-1,3*dy/4,3*dy/4,b,cs)<2 ) break;
      
      x = loop(b,dx-1  ,dy-1,dx,cs,0,LE); // ~ melted kl
      x = loop(b,dx-1-x,dy-1,dx,cs,1,LE); if( x>dx/2 ) break;
      // out_x(box1);MM;

      if( loop(b,   0,7*dy/16,dx,cs,0,RI)
        + loop(b,dx-1,7*dy/16,dx,cs,0,LE) > dx/2 ) break; // ~K


      if( dy>8 /* following lines should be extend to range check */ 
       && loop(b,  dx/4,dy-1,      dy,cs,0,UP)<dy/4
       && loop(b,3*dx/8,dy-1,      dy,cs,0,UP)<dy/4 )
      if( loop(b,   0,dy-1-dy/ 8,dx,cs,0,RI)
        < loop(b,   0,dy-1-dy/16,dx,cs,0,RI)-dx/32 ) break; // ~it_u
      if( num_cross(0,dx-1,  dy/2,  dy/2,b,cs)==2
       && num_cross(0,dx-1,  dy/4,  dy/4,b,cs)> 2 
       && num_cross(0,dx-1,3*dy/4,3*dy/4,b,cs)> 2 ) break; // ~it_u
      if( num_cross(0   ,dx-1,3*dy/4,3*dy/4,b,cs)==2
       && num_cross(dx/2,dx/2,3*dy/4,  dy-1,b,cs)> 0 ) break; // ~it_v


      if( loop(b,3*dx/4,   0,dy,cs,0,DO)
        > loop(b,2*dx/4,   0,dy,cs,0,DO)
       && loop(b,3*dx/4,dy-1,dy,cs,0,UP)
        < loop(b,2*dx/4,dy-1,dy,cs,0,UP) ) break; // ~N 
      if( loop(b,3*dx/4,     dy/8,dy,cs,0,DO)
        > loop(b,2*dx/4,     dy/8,dy,cs,0,DO)
       && loop(b,3*dx/4,dy-1-dy/8,dy,cs,0,UP)
        < loop(b,2*dx/4,dy-1-dy/8,dy,cs,0,UP) ) break; // ~serif_N 

      // i0 is lower end of upper serifen (widest gap? )
      i0=0;
       
      if( num_cross(0,dx-1,dy/2,dy/2,b,cs)!=4 ){ // Is it a N ?
        if( num_cross(0,dx-1,dy/2,dy/2,b,cs)==3 ){
          for(y=dy/2+1;y<dy;y++){
            if( num_cross(0,dx-1,y,y,b,cs)<3 ) break;
          }
          if( num_cross(0,dx-1,y,y,b,cs)==2 ){
            x =loop(b,dx-1  ,y-1,dx,cs,0,LE);
            x+=loop(b,dx-1-x,y-1,dx,cs,1,LE);
            x+=loop(b,dx-1-x,y-1,dx,cs,0,LE);
            if( loop(b,dx-x,y-1,dy,cs,0,UP)>dy/4 ) break; // ~N
          }
        }
      }

      // MNWK
      for(i2=0,i1=x=dx/2;x<dx-dx/4;x++){ // lowest pixel
        y=loop(b,x,0,dy,cs,0,DO); if(y>i2) {i2=y;i1=x;} else break; }
      i3=i2+loop(b,i1,i2,dy-i2,cs,1,DO);
      if(i2<dy/4) break;	// rm

      t1=loop(b,0 ,3*dy/4,dx,cs,0,RI);
      t1=loop(b,t1,3*dy/4,dx,cs,1,RI); // thickness of line?
      if( 7*(t1+1)<dx )
      if( num_cross(i1,dx-1,i2-1,i2-1,b,cs)!=2
       || num_cross(0 ,i1  ,i2-1,i2-1,b,cs)!=2 ) break;  // too hard ???
      if( num_hole(x0, x1, y0 , y1 ,box1->p,cs) != 0 ) break;  // small A

      // ~u_n-pair
      if( num_cross(0,dx-1,0,0,b,cs)!=2
       && num_cross(0,dx-1,1,1,b,cs)!=2
       && num_cross(0,dx-1,2,2,b,cs)!=2 ) break;

      // ~nn v0.2.4a3 
      if( num_cross(0,dx-1,  dy/4,  dy/4,b,cs)==4
       && num_cross(0,dx-1,3*dy/4,3*dy/4,b,cs)==4 ){
        i1 =loop(b, 0,  dy/4,dx,cs,0,RI);
        i1+=loop(b,i1,  dy/4,dx,cs,1,RI);
        i1+=loop(b,i1,  dy/4,dx,cs,0,RI);
        i2 =loop(b, 0,3*dy/4,dx,cs,0,RI);
        i2+=loop(b,i2,3*dy/4,dx,cs,1,RI);
        i2+=loop(b,i2,3*dy/4,dx,cs,0,RI);
        if( i1>=i2 ) break; // no good M
        i1+=loop(b,i1,  dy/4,dx,cs,1,RI);
        i2+=loop(b,i2,3*dy/4,dx,cs,1,RI);
        if( i1>=i2 ) break; // no good M
        i1+=loop(b,i1,  dy/4,dx,cs,0,RI);
        i2+=loop(b,i2,3*dy/4,dx,cs,0,RI);
        if( i1<=i2 ) break; // no good M
      }
      return 'M';
   }
   // --- test n ---------------------------------------------------
   // glued rm is very similar to glued nn -> thickness of h-line should grow
   if(/*(!hchar) && */ (!gchar) && 2*y0>=box1->m1+box1->m2)
   for(d=100;dx>2 && dy>3;){     // min 3x4
      y=7*dy/8;
      if( num_cross(   0,dx/2,y  ,y  ,b,cs) != 1
       && num_cross(   0,dx/2,y-1,y-1,b,cs) != 1
       && num_cross(dx/2,dx-1,y  ,y  ,b,cs) <  1 ) break; // n rr
      // ~thick_w
      y=loop(b,dx-1-dx/4,0,dy,cs,0,DO); if(y>dy/2) break;
      if(y>1)if( get_bw(dx-1-dx/4,dx-1,0,y-2,b,cs,1) == 1 ) break;

      y=3*dy/4;
      if( num_cross(0,dx-1,y  ,y  ,b,cs) == 1 ) break; // ~p
      y=dy/2;
      if( num_cross(0,dx-1,y  ,y  ,b,cs) != 2
       && num_cross(0,dx-1,y+1,y+1,b,cs) != 2 ) break; // n rr
      
      // out_x(box1);printf(" n1\n");
      x =loop(b,0,y,dx  ,cs,0,RI); if(x>  dx/4) break; // search 1st v-line
      x+=loop(b,x,y,dx-x,cs,1,RI); if(x>  dx/2) break; i1=x; // 1st gap
      x+=loop(b,x,y,dx-x,cs,0,RI); if(x<  dx/2) break; i2=x; // 2nd v-line
      x+=loop(b,x,y,dx-x,cs,1,RI); if(x<3*dx/4) break; i3=x; // 2nd gap

      i=dy/4; y=13*dy/16;
      if( num_cross(dx/2,dx-1,y,y,b,cs)==2 ) i=3*dy/8; // \it n
      // the same game for the lower part =>l1 l2 l3 l4 ???
      for(x=i1;x<i2;x++) if( loop(b,x,   0,dy,cs,0,DO)>=i ) break;
      if(x <i2) break; // gap detected

      for(x=i1;x<i2;x++) if( loop(b,x,dy-1,dy,cs,0,UP) >dy/4 ) break;
      if(x==i2) break; // no gap detected (glued serifs ??? )

      // glued rm as nn ???
      for(y=0,x=(i1+i2)/2;x<i2;x++){
         i=loop(b,x,0,dy,cs,0,DO); 
         i=loop(b,x,i,dy,cs,1,DO); // measure thickness
         if( i>y ) y=i; if( i<y/2 ) break;
      }
      if(x <i2) break; // unusual property for n

      i= loop(b,dx-1  ,dy/2,dx,cs,0,LE); if(i>5)
      if( get_bw(dx-1-i/2,dx-1-i/2,0,dy/2,b,cs,1) == 1 ) break; // ~rr
      i+=loop(b,dx-1-i,dy/2,dx,cs,1,LE);
      if( get_bw(dx-1-i  ,dx-1-i  ,0,dy/2,b,cs,1) == 0 ) break; // ~rv

      if( get_bw(dx/2,dx/2,dy/4,dy/4,b,cs,1) == 0
       && get_bw(dx/2,dx/2,dy-2,dy-2,b,cs,1) == 0
       && get_bw(dx/2,dx/2,dy/4,dy-2,b,cs,1) == 1 ) break; // ~P

      // glued ri ???
      if( dots>0 && box1->m1 )
      if( get_bw((x1+x0)/2,x1,box1->m1,y0-1,box1->p,cs,1) == 1 )
      if( num_cross( 0,dx-1,0  ,0  ,b,cs) >2
       || num_cross( 0,dx-1,1  ,1  ,b,cs) >2 ) break;

      return 'n';
   }
   // --- test N ------- +hchar -gchar
   if(/* hchar && */ !gchar)  // \sc N
   for(d=100;dx>4 && dy>3;){
      if( num_cross(0,dx-1,   0,   0,b,cs) != 2 
       && num_cross(0,dx-1,   1,   1,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,b,cs) != 2 
       && num_cross(0,dx-1,dy-2,dy-2,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,dy/2,dy/2,b,cs) <  2 ) break;
      if( loop(b,0   ,dy/2,dx,cs,0,RI)
         +loop(b,dx-1,dy/2,dx,cs,0,LE)>dx/2 ) break; // ~K
      for(i=0,y=3*dy/8;y<dy-1-3*dy/8;y++) // robust! Dec00
      if( num_cross(0,dx-1,y,y,b,cs) == 3 ) i++; else i--;
      if( i<=0 ) break;
      // out_x(box1);
      // go around lower left serif
      for( i1=i3=0,y=1;y<dy/2;y++ ){	// suche erstes ^ (i1,i3)
        x =loop(b,0,y,dx,cs,0,RI);
        x+=loop(b,x,y,dx,cs,1,RI); if( x>3*dx/4 ){ y=dy/2;break; }
        if( get_bw(x  ,x  ,y,dy-1-dy/4,b,cs,1) == 0
         || get_bw(x+1,x+1,y,dy-1-dy/4,b,cs,1) == 0 ) break;
      } if( y>=dy/2 ) break;
      i1=x0+x;i3=y0+y;

      for( i4=0,i2=x=x0+dx/2;x< x1-dx/5;x++ ){ // suche zweites v (i2,i4)
        i=loop(box1->p,x,y0+dy/8+1,dy,cs,0,DO); if( i>i4 ) { i4=i;i2=x; }
      } i4=y0+dy/8+1+i4-1; if( i4<y0+dy/4 ) break;

      if( num_cross(i1,x1,i3,i3,box1->p,cs) != 2 ) break;
      if( num_cross(x0,i1,i3,i3,box1->p,cs) != 1 ) break;
      if( num_cross(i2,x1,i4,i4,box1->p,cs) != 1 ) break;
      if( num_cross(x0,i2,i4,i4,box1->p,cs) != 2 ) break;
      // out_x(box1);

      for( i=x=0,y=i3; y<y1-dy/4; y++ ){	// hl-duo
        i =loop(box1->p,x0  ,y,dx,cs,0,RI);
        i+=loop(box1->p,x0+i,y,dx,cs,1,RI);	// 1st line
        i =loop(box1->p,x0+i,y,dx,cs,0,RI);	// growing gap?
        if( i+1+dx/16<x ) break; if(i>x) x=i; // one pixel tolerance
      } if( i+1+dx/16<x ) break;

      // ~ ru first gap should grow significant
      x =loop(b,   0,7*dy/8,dx,cs,0,RI);
      x+=loop(b,   x,7*dy/8,dx,cs,1,RI);
      x+=loop(b,   x,7*dy/8,dx,cs,0,RI);
      i =loop(b,dx-1,7*dy/8,dx,cs,0,LE);
      if( x<5*(dx-i)/8 ) break; // Mai00

      if( !hchar )	// outer v-lines should be vertikal ~glued_rv
      if( abs( loop(b,0   ,  dy/4,dx,cs,0,RI)
              +loop(b,dx-1,  dy/4,dx,cs,0,LE)
              -loop(b,0   ,3*dy/4,dx,cs,0,RI)
              -loop(b,dx-1,3*dy/4,dx,cs,0,LE) ) > 1+dx/32 ) break;

      return 'N';
   }
   // --- test h ---------------------------------------------------
   if(hchar && (!gchar))  
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( get_bw(0        ,dx/2,dy/8     ,dy/8     ,b,cs,1) != 1 ) break;
      if( get_bw(0        ,dx/2,dy/2     ,dy/2     ,b,cs,1) != 1 ) break;
      if( get_bw(dx/2     ,dx-1,dy-1-dy/3,dy-1-dy/3,b,cs,1) != 1 ) break;
      if( get_bw(dx/2     ,dx/2,dy/5     ,dy-1-dy/3,b,cs,1) != 1 ) break;
      if( get_bw(dx-1-dx/3,dx-1,0        ,dy/5     ,b,cs,1) == 1 ) break;
      for( x=x0+dx/3;x<x1-dx/3;x++)
      if( get_bw(x, x,y1-dy/3, y1,     box1->p,cs,1) == 0 ) break;
      if( x>=x1-dx/3 ) break;
      for(i=dy/4,y=y0+dy/3;y<=y1 && i;y++){
        if( num_cross(x0,x1     ,y,y, box1->p,cs) == 2 ) i--;
      } if( i ) break;
      for(i=dy/4,y=y0;y<=y0+dy/2 && i;y++){
        if( num_cross(x0,x0+dx/2,y,y, box1->p,cs) == 1 ) i--;
      } if( i ) break;
      if( num_hole(x0, x1, y0      , y1      ,box1->p,cs)  > 0 ) // could happen
      if( num_hole(x0, x1, y0+dy/3 , y1-dy/3 ,box1->p,cs) != 1 ) break; // mini
      if( loop(b,dx-1,dy/3,dx,cs,0,LE)+dx/8
        < loop(b,dx-1,dy/2,dx,cs,0,LE)
       && loop(b,dx-1,dy-2,dx,cs,0,LE)+dx/8
        < loop(b,dx-1,dy/2,dx,cs,0,LE)      ) break; // ~k Okt00
      bc='h'; break;
   }
   // --- test H ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( num_cross(0,dx-1,dy/4  ,dy/4  ,b,cs) != 2
       && num_cross(0,dx-1,dy/4-1,dy/4-1,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,3*dy/4  ,3*dy/4  ,b,cs) != 2
       && num_cross(0,dx-1,3*dy/4+1,3*dy/4+1,b,cs) != 2 ) break;
      if( loop(b,0   ,dy/8,dx,cs,0,RI)
        + loop(b,dx-1,dy/8,dx,cs,0,LE)>dx/2 ) break; // ~A
      for( j1=0,i=1,y=y0+dy/10; y<y1-dy/10 && i; y++ ) // 2 vertikal lines
      { j=loop(box1->p,x0  ,y,dx,cs,0,RI)
         +loop(box1->p,x1  ,y,dx,cs,0,LE); if( j>dx/2 ) i=0; if(j>j1)j1=j; } 
      if( !i ) break;
      for( i=1,y=dy/4; y<dy-1-dy/4 && i; y++ ) // max - min width
      { j=loop(b,0   ,y,dx,cs,0,RI)
         +loop(b,dx-1,y,dx,cs,0,LE); if( j1-j>dx/5 ) i=0; } 
      if( !i ) break;   // ~K Jul00
      for( i=0,ya=y=y0+dy/3; y<y1-dy/3; y++ ) // horizontal line
      { j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        j=loop(box1->p,x0+j,y,dx,cs,1,RI); if( j>i ) { i=j; ya=y; } } 
      if( i<=dx/2 ) break; ya-=y0;
      if( num_cross(0,dx-1,ya  ,ya  ,b,cs) != 1
       && num_cross(0,dx-1,ya+1,ya+1,b,cs) != 1 ) break; /* Dec00 */
      for( y=ya; y<dy-dy/4; y++ ) // ~M Dec00
      if( num_cross(0,dx-1,y  ,y  ,b,cs) > 2
       && num_cross(0,dx-1,y+1,y+1,b,cs) > 2 ) break;
      if ( y<dy-dy/4 ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y0     ,y0+dy/4,box1->p,cs,1) == 0 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y1-dy/4,y1     ,box1->p,cs,1) == 0 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( num_cross(x,x,y0+dy/8,y1-dy/8, box1->p,cs) == 1 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+dy/4 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y1-dy/4;y<=y1 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( get_bw(x1-dx/8, x1     , y0, y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/8, y1-dy/8, y1,box1->p,cs,1) != 1 ) break;
      i1=loop(b,dx-1,     dy/4,dx,cs,0,LE); if(i1>dx/2) break;
      i2=loop(b,dx-1,     dy/2,dx,cs,0,LE); if(i2<i1-dx/4 || i2>i1+dx/8) break;
      i3=loop(b,dx-1,dy-1-dy/4,dx,cs,0,LE); if(i3<i2-dx/4 || i3>i2+dx/8) break;
      if(abs(i1+i3-2*i2)>dx/16+1) break;
      if( num_hole(x0,x1,y0,y1,box1->p,cs) != 0 ) break;
      return 'H';
   }
   // --- test k ---------------------------------------------------
   for(;dx>2 && dy>3;){     // min 3x4
      if( num_cross(0,  dx-1,0,0,b,cs) != 1
       && num_cross(0,  dx-1,1,1,b,cs) != 1 ) break;
      if( num_cross(0,3*dx/4,  dy/8 ,  dy/8 ,b,cs) != 1
       || num_cross(0,3*dx/4,3*dy/16,3*dy/16,b,cs) != 1 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,b,cs) != 2
       && num_cross(0,dx-1,dy-2,dy-2,b,cs) != 2 ) break;
//      out_x(box1);printf(" k:");
      i1=loop(b,0,dy/2-dy/4,dx,cs,0,RI);
      i2=loop(b,0,dy/2     ,dx,cs,0,RI);if(i2>dx/2) break;
      i3=loop(b,0,dy/2+dy/4,dx,cs,0,RI);
      if(abs(i1+i3-2*i2)>dx/16+1 || i1<i3-1) break; // v-line on left side?
      if( 2*y0>(box1->m1+box1->m2) ) break;
      if( get_bw(x0     , x0+dx/4, y0     , y0+dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x1,      y1-dy/3, y1     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/4, x1,      y0  , y0+3*dy/16,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-dx/4, x1,      y0+dy/4, y1-dy/4,box1->p,cs,1) != 1 ) break; //~1
      if( get_bw(x1-dx/4, x1,      y1-dy/8, y1     ,box1->p,cs,1) != 1 ) break;
      if( num_hole(x0     , x1     , y0+dy/4, y1   ,box1->p,cs  ) != 0 ) break;
      for(y=y0+1;y<y0+dy/2;y++)		// luecke ???
        if( get_bw(x0,x1,y,y,box1->p,cs,1) == 0 ) break;
      if( y<y0+dy/2 ) break;
      for(i=1,x=x0;x<=x0+dx/2 && i;x++) 
        if(get_line(x,y0     ,x ,y1,box1->p,cs,100)>50) i=0;
      if( i ) break;				// no vertikal line!
      for(i=1,y=y0+dy/3;y<=y1-dy/3 && i;y++) 
        if( get_line(x0+dx/4,y,x1     ,y1,box1->p,cs,100)>60 
         || get_line(x0+dx/2,y,x1-dx/6,y1,box1->p,cs,100)>60 ) i=0;
      if( i ) break;			// no falling line!?
      for(i=1,y=dy/2;y<dy-dy/4 && i;y++) 
        if(get_line(dx-1-dx/4,y,dx-1,y ,b,cs,100)<13) i=0;
      if( i ) break;				// no white range
      for(y=y0+dy/3;y<y1;y++) if( num_cross(x0,x1,y,y,box1->p,cs)==2 ) break;
      if( y==y1 ) break;
      if( num_hole(x0,x1,y0,y1,box1->p,cs)>0 ) break; // ~A kommt vor!
      bc='k'; break;
   }
   // --- test K ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // updated 29 Mar 2000 perfect???
      for(y=dy/8;y<dy-dy/8;y++) if( !get_bw(0,dx/2,y,y,b,cs,1) ) break;
      if( y<dy-dy/8 ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x, y0,    y0+dy/4,box1->p,cs,3) == 2 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y1-dy/4,y1     ,box1->p,cs,3) == 2 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/3;x<=x1-dx/8 && i;x++){
        if( num_cross(x,x,y0,y1, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+dy/4 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( dx<10 ){
        for(i=1,y=y0+dy/3;y<=y1-dy/3 && i;y++){
          if( num_cross(x0,x1,y,y, box1->p,cs) == 1 ) i=0;
        } if( i ) break;
      }
      for(i=1,y=y1-dy/4;y<=y1 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( get_bw(x1-dx/3,x1,y0,y0+dy/8,box1->p,cs,1) != 1 ) break; // ~k
      i=loop(box1->p,x1,y0+dy/4,x1-x0+1,cs,0,LE); if(i>dx/2) break;
      j=loop(box1->p,x1,y0+  dy/2,x1-x0+1,cs,0,LE);
      x=loop(box1->p,x1,y0+3*dy/8,x1-x0+1,cs,0,LE); if(x>j) j=x;
      if(j<=i  ) break; i=j;
// out_x(box1);MM;
      j=loop(box1->p,x1,y1-dy/4,x1-x0+1,cs,0,LE); if(j>=i  ) break;
      // out_x(box1); // detailed analysis
      //
      //  a   d   <= that are main points of K
      //  |  /
      //  b/e
      //  |  \ 
      //  c   f
      ya=   dy/4;xa=loop(b,0,ya,dx,cs,0,RI);xa+=loop(b,xa,ya,dx,cs,1,RI)/2;
      yc=dy-dy/4;xc=loop(b,0,yc,dx,cs,0,RI);xc+=loop(b,xc,yc,dx,cs,1,RI)/2;
      for(yb=yd=ye=yf=xe=y=i=0,xf=xd=xb=dx;y<dy/4;y++){ // range 0..1/4
        x =loop(b,dx-1,     y,dx,cs,0,LE); if(x<xd){ xd=x;yd=     y; }
        x =loop(b,dx-1,dy-1-y,dx,cs,0,LE); if(x<xf){ xf=x;yf=dy-1-y; }
        x =loop(b,dx-1,dy/2+y,dx,cs,0,LE); if(x>xe){ xe=x;ye=dy/2+y; }
        x =loop(b,dx-1,dy/2-y,dx,cs,0,LE); if(x>xe){ xe=x;ye=dy/2-y; }
#if 0  // removed v0.2.4a2
        x =loop(b,0   ,dy/2+y,dx,cs,0,RI); // middle left border
        x+=loop(b,x   ,dy/2+y,dx,cs,1,RI); // test 2nd cross
        x+=loop(b,x   ,dy/2+y,dx,cs,0,RI); if(x<xb){ xb=x;yb=dy/2+y; }
#endif
        x =loop(b,0   ,dy/2-y,dx,cs,0,RI);
        x+=loop(b,x   ,dy/2-y,dx,cs,1,RI); // test 2nd cross
        x+=loop(b,x   ,dy/2-y,dx,cs,0,RI); if(x<xb){ xb=x;yb=dy/2-y; }
      }
      xd=dx-1-xd;xe=dx-1-xe;xf=dx-1-xf;
//      printf(" xa=%d xb=%d xc=%d xd=%d xe=%d\n",xa,xb,xc,xd,xe);
      xb+=loop(b,xb,yb,dx,cs,1,RI)/4; // detect center of line
      xe-=loop(b,xe,ye,dx,cs,1,LE)/4;
      xd-=loop(b,xd,yd,dx,cs,1,LE)/4;
      xf-=loop(b,xf,yf,dx,cs,1,LE)/4;
      if(xe>5*dx/8 || xb>5*dx/8) break; // ~{\it n}
      //printf(" a=%d %d b=%d %d c=%d %d d=%d %d e=%d %d f=%d %d",
      //  xa,ya,xb,yb,xc,yc,xd,yd,xe,ye,xf,yf);
      if( get_line2(xb,yb,xd,yd,b,cs,100)<95 ) break;
      if( get_line2(xe,ye,xf,yf,b,cs,100)<95 ) break;
      if( get_line2(xa,ya,xc,yc,b,cs,100)<95 ) break;
      xe+=loop(b,xe,ye,dx,cs,1,RI); if( xe>=xf ) break; // ~{\it n}
      // printf(" ok xe=%d",xe);
      bc='K'; break;
   }
   if(box1->ac == UNKNOWN)
     box1->ac=ac;
   return bc;
}

/* ----------------------- part2 -------------------------------- */
wchar_t ocr0p2(struct box *box1, pix  *b, int cs){
   // pix  p=*(box1->p);
   int	i,j,d,x,y,x0=box1->x0,x1=box1->x1,y0=box1->y0,y1=box1->y1;
   int  dx=x1-x0+1,dy=y1-y0+1,	/* size */
       i1,i2,i3,i4,i5,j1;	/* tmp-vars */
   int xa,xb,xc,xd,	/* used for store significant points of char */
       ya,yb,yc,yd,ye,yf;
   wchar_t bc=UNKNOWN;			      // bestletter
   wchar_t ac=UNKNOWN;			      // alternative char (2nd best)
   int dots=box1->dots;
   // ad,ac will be used in future
   int  ad=0;				// propability 0..100
   int hchar;		// char is higher than 'e'
   int gchar;		// char has ink lower than m3
   // --- hchar --- gchar -------------------------
   hchar=0;if( 2*y0<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
   gchar=0;if( 2*y1>=2*box1->m3+(box1->m4-box1->m3) ) gchar=1;
   // if the char is slightly moved down correction can be done
   if ( y0<box1->m2 && y1>box1->m3 && 2*y1<box1->m3+box1->m4) // moved
   if( 2*(y0-(y1-box1->m3))<=2*box1->m2-(box1->m2-box1->m1) ) hchar=1;
 
   // --- test B ---------------------------------------------------
   if(dx>20 || (!gchar)) // either all details are visible
                         //    or we need the height
   for(d=100;dx>2 && dy>4;){     // min 3x4
      for(i=1,y=y0;y<y1-dy/2 && i;y++)
      if( get_bw(x0,x0+dx/2, y      , y      ,box1->p,cs,1) != 1 ) i=0;
      if( !i ) break;
      for(i=1,y=y1-dy/2;y<y1 && i;y++)
      if( get_bw(x0,x0+dx/3, y      , y      ,box1->p,cs,1) != 1 ) i=0;
      if( !i ) break;
      if( get_bw(x1,x1     , y0     , y0     ,box1->p,cs,1) == 1 ) break;
      if( num_cross(x0+dx/2, x0+dx/2,y0,y1  ,box1->p,cs) != 3 )
      if( num_cross(x1-dx/3, x1-dx/3,y0,y1  ,box1->p,cs) != 3 ) break;
      if( num_cross(0,dx-1,3*dy/4  ,3*dy/4  ,b,cs) != 2 )
      if( num_cross(0,dx-1,3*dy/4+1,3*dy/4+1,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,  dy/4  ,  dy/4  ,b,cs) != 2 )
      if( num_cross(0,dx-1,  dy/4-1,  dy/4-1,b,cs) != 2 ) break;
      for( y=dy/4;y<3*dy/4;y++ ) if( num_cross(0,dx-1,y,y,b,cs)==1 ) break;
      if( y==3*dy/4 ) break;

      if( loop(box1->p,x0,y0+ y  ,dx,cs,0,RI)
        > loop(box1->p,x0,y0+dy/4,dx,cs,0,RI)+dx/32 )
      if( get_bw(x0,x0,y0,y0,box1->p,cs,1) == 0 )
      if( get_bw(x0,x0,y1,y1,box1->p,cs,1) == 0 ) break;  // ~8

      i1=loop(box1->p,x0,y0+dy/4,dx,cs,0,RI);
      i2=loop(box1->p,x0,y0+dy/2,dx,cs,0,RI);
      i3=loop(box1->p,x0,y1-dy/4,dx,cs,0,RI);
      if(dy>16 && i3<i2 && i1+i3<2*i2){
        if( loop(box1->p,x0,y0+ 1  ,dx,cs,0,RI)
         >= loop(box1->p,x0,y0+ 3  ,dx,cs,0,RI)+dx/32 )
        if( loop(box1->p,x0,y0+ 0  ,dx,cs,0,RI)
          > loop(box1->p,x0,y0+ 3  ,dx,cs,0,RI)+dx/32 )
        if( loop(box1->p,x0,y1- 0  ,dx,cs,0,RI)
          > loop(box1->p,x0,y1- 3  ,dx,cs,0,RI)+dx/32 )
        if( loop(box1->p,x0,y1- 1  ,dx,cs,0,RI)
          > loop(box1->p,x0,y1- 3  ,dx,cs,0,RI)+dx/32 ) break; // ~8 Aug00
      }

      if( num_hole(0,dx-1,0  ,y+1 ,b,cs) != 1 ) break;
      if( num_hole(0,dx-1,y-1,dy-1,b,cs) != 1 ) break;
      // out_x(box1);

      for( x=dx,y=dy/6; y<dy-dy/8; y++ ) // left border straight
      { i=loop(box1->p,x0,y0+y,dx,cs,0,RI); if( i>x+dx/9 ) break;
        if(i<x) x=i;
      } if( y<dy-dy/8 ) break;	// ~8 bad_a

      for( x=dx,y=1;y<dy/4;y++ ) // right border straight
      { i=loop(b,dx-1,dy-y,dx,cs,0,LE);
        if( i<x ) x=i; else if( i>x )break;
      } if( y<dy/4 ) break;	// ~ff (serifen?)

      if ( loop(b,0,  dy/8,dx,cs,0,RI)
          +loop(b,0,7*dy/8,dx,cs,0,RI)
        >2*loop(b,0,  dy/2,dx,cs,0,RI)+1 ) break; // not konvex!

      if(!hchar){  // ~ fat_a
        x =loop(b,0,dy/4,dx,cs,0,RI);
        if(loop(b,0,dy/2,dx,cs,0,RI)>x) break;
      }

      if ( hchar || (dx>10 && dy>10) ) bc='B';	// hchar or good_quality
      else if( ac==UNKNOWN ) ac='B';
      break;
   }
   // --- test b ---------------------------------------------------
   for(d=100;dx>3 && dy>4;){     // min 3x4
      for(y=y0;y<y1;y++)
      if( get_bw(x0       , x0+dx/2, y      , y      ,box1->p,cs,1) != 1 ) break;
      if(y<y1-dy/32-1) break;
      if( get_bw(x0+  dx/2, x0+dx/2, y1-dy/3, y1     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-  dx/2, x1     , y1-dy/3, y1-dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-  dx/3, x1     , y0     , y0+dy/5,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-4*dx/9, x1     , y0+dy/5, y0+dy/5,box1->p,cs,1) == 1 ) break;
      if( num_cross(x0,x1,y0+dy/4  ,y0+dy/4  ,box1->p,cs) > 1 ) // &
      if( num_cross(x0,x1,y0+dy/4-1,y0+dy/4-1,box1->p,cs) > 1 )
      if( dy<16 ||
          num_cross(x0,x1,y0+dy/5  ,y0+dy/5  ,box1->p,cs) > 1 ) break; // fat b
      for(i=j=0,y=dy/2;y<dy-dy/8;y++)
      if( num_cross(0,dx-1,y,y,b,cs) == 2 ) i++; else j++;
      if( i<2*j ) break; // v024a4
      if( num_hole( x0, x1 , y0+dy/4, y1,box1->p,cs) != 1 ) break;
      i=loop(b,dx-1,dy-1     ,dx,cs,0,LE);
      j=loop(b,dx-1,dy-1-dy/8,dx,cs,0,LE); if(j>i) break;
      return 'b';
   }
   // --- test D ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if(dots) break;
      if( get_bw(x0     ,x0+dx/3,y0+dy/2,y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3,x1     ,y0+dy/2,y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1     ,x1     ,y0     ,y0+dy/8,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1-dx/2,x1     ,y0+dy/4,y0+dy/4,box1->p,cs,1) != 1 ) break;
      if( num_cross(x0+dx/2,x0+dx/2,y0     ,y1     ,box1->p,cs) != 2 )
      if( num_cross(x1-dx/3,x1-dx/3,y0     ,y1     ,box1->p,cs) != 2 ) break;
      if( num_cross(x0     ,x1     ,y0+dy/3,y0+dy/3,box1->p,cs) != 2 ) break;
      if( num_cross(x0     ,x1     ,y1-dy/3,y1-dy/3,box1->p,cs) != 2 ) break;
      if( num_hole (x0     ,x1     ,y0     ,y1     ,box1->p,cs) != 1 ) break;
      // test ob linke Kante gerade
      for(x=0,y=b->y-1-dy/8;y>=dy/5;y--){ // rechts abfallende Kante/Knick?
        i=loop(b,0,y,x1-x0,cs,0,RI);
        if( i+2+dx/16<=x ) break;
        if( i>x ) x=i;
      }
      if (y>=dy/5 ) break; 
      // test ob rechte Kante abfallend
      for(x=dx,y=0;y<dy/3;y++){ // rechts abfallende Kante/Knick?
        i=loop(b,b->x-1,y,x1-x0,cs,0,LE);
        if( i>x+dx/16 ) break;
        if( i<x ) x=i;
      }
      if (y<dy/3 ) break; 
      // test ob rechte Kante ansteigend
      for(x=dx,y=b->y-1;y>2*dy/3;y--){ // rechts abfallende Kante/Knick?
        i=loop(b,b->x-1,y,x1-x0,cs,0,LE);
        if( i>x+dx/16 ) break;
        if( i<x ) x=i;
      }
      if (y>2*dy/3 ) break; 
      if( loop(b,dx-1,dy-1      ,dx,cs,0,LE) <=
          loop(b,dx-1,dy-2-dy/16,dx,cs,0,LE)   ) break;  // P

      y=loop(b,dx/2,dy-1,dy,cs,0,UP)-1; if( y > dy/16 ) dy-=dy/16;
      if(y>=0 && get_bw(dx/2,dx-1,dy-1-y,dy-1-y,b,cs,1)==1) break; // ~A

      ya=loop(b,      0,dy-1,dy,cs,0,UP);
      yb=loop(b,dx/16+1,dy-1,dy,cs,0,UP);
      if( ya<dy/2 && ya>dy/16 && ya>yb ) break; // ~O

      bc='D'; break;
   }
   // --- test d ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( get_bw(x0     , x0+dx/2, y1-dy/6, y1-dy/9,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/2, y1-dy/3, y1-dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x1     , y1-dy/3, y1-dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/4, x1     , y0+dy/8, y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2, x0+dx/2, y1-dy/4, y1     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/3, y0     , y0+dy/5,box1->p,cs,1) == 1 ) break;
      if( get_bw(x0     , x0+dx/4, y1-dy/8, y1     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2-1,x0+dx/2,y1-dy/8, y1     ,box1->p,cs,1) != 1 ) break; // ~"A
      if( loop(b,b->x-1,  b->y/4,x1-x0,cs,0,LE) >
          loop(b,b->x-1,3*b->y/4,x1-x0,cs,0,LE)+1 ) break;
      for(i=dx/8+1,x=0;x<dx && i;x++){
        if( num_cross(x ,x   ,0  ,dy-1, b,cs) == 2 ) i--;
      } if( i ) break;
      for(i=dy/6+1,y=dy/4;y<dy && i;y++){
        if( num_cross(0 ,dx-1,y  ,y   , b,cs) == 2 ) i--;
        if( num_cross(0 ,dx-1,y  ,y   , b,cs) >  2 ) i++; // ~al
      } if( i ) break;
      for(i=dy/8+1,y=0;y<dy/2 && i;y++){
        if( num_cross(0   ,dx-1,y ,y  , b,cs) == 1 )
        if( num_cross(dx/2,dx-1,y ,y  , b,cs) == 1 ) i--;
      } if( i ) break;
      if( num_hole(x0 , x1 , y0+dy/4 , y1 ,box1->p,cs) !=1 ) break;
      bc='d'; break;
   }
   // --- test F ---------------------------------------------------
   for(d=100;dx>2 && dy>4;){     // dx>1 dy>2*dx 

      if( get_bw(x0+dx/2,x0+dx/2,y0,y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0,x0+dx/4,y1-dy/4,y1-dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0,x0+dx/2,y0+dy/4,y0+dy/4,box1->p,cs,1) != 1 ) break;
      j=loop(b,dx-1,7*dy/8,dx,cs,0,LE); if(j<3 || j<dx/2) break; // ~f Jun00
      for( i=1,y=y0; y<y0+dy/4 && i; y++ ){ // long black line
        j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        j=loop(box1->p,x0+j,y,dx,cs,1,RI); if( j>dx/2 ) i=0; } 
      if( i ) break;
      x=loop(box1->p,0,dy-1-dy/4,dx,cs,0,RI);
      x=loop(box1->p,x,dy-1-dy/4,dx,cs,1,RI); // strichdicke
      for( i=1,y=dy/3; y<dy-1-dy/3 && i; y++ ) // black line
      { j=loop(b,0,y,dx,cs,0,RI);
        j=loop(b,j,y,dx,cs,1,RI); if( j>dx/3 && j>2*x) i=0; } 
      if( i ) break;
      for( i=1,y=dy/8; y<dy-1-dy/2 && i; y++ ) // white line
        if( get_bw(dx-1-dx/3,dx-1-dx/5,y,y,b,cs,1) == 0 ) i=0;
      if( i ) break;
      for(i=1,y=1;y<=dy/2 && i;y++)
      if( get_bw(0,dx/2,y,y,b,cs,1) != 1 ) i=0;
      if( !i ) break;
      for(i=1,y=dy/2;y<dy && i;y++)
      if( get_bw(0,dx/3,y,y,b,cs,1) != 1 ) i=0;
      if( !i ) break;
      if( get_bw(dx-1-dx/3,dx-1,dy-1     ,dy-1,b,cs,1) == 1 ) break;
      if( get_bw(dx-1-dx/4,dx-1,dy-1-dy/4,dy-1,b,cs,1) == 1 ) break;
      if( get_bw(dx-1     ,dx-1,0        ,dy/3,b,cs,1) != 1 ) break;
      if( loop(b,0,  b->y/4,dx,cs,0,RI) <
          loop(b,0,3*b->y/4,dx,cs,0,RI)-1 ) break;
      if( num_hole(x0 , x1 , y0 , y1 ,box1->p,cs) >0 ) break;
      for(i=0,x=dx/4;x<dx-1;x++)
      if( num_cross(x,x,0,dy-2,b,cs) == 2 ) i++;
      if ( i<1 ) break; // 0.2.4a4

      if(dy<20) /* special case of small fi, not very elegant */
      if( get_bw(   1,   1,1,1,b,cs,1) == 1
       && get_bw(   0,   0,2,2,b,cs,1) == 1
       && get_bw(dx-2,dx-1,0,0,b,cs,1) == 0
       && get_bw(   0,   1,0,0,b,cs,1) == 0
       && get_bw(   0,   0,0,1,b,cs,1) == 0 ) break;

      bc='F';break;
   }
   // --- test L ---------------------------------------------------
   for(d=100;dx>2 && dy>4;){     // min 3x4
      i=loop(b,dx-1,dy/2,dx,cs,0,LE); if(i<3 && dy>8) break;
      for( i=i1=0,y=y1-dy/4;y<=y1;y++){ 	// querstrich
        j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        j=loop(box1->p,x0+j,y,dx,cs,1,RI); if( j>i ){ i=j;i1=y; }
      } if( i<3*dx/4 ) break; i1=i;
      i=loop(box1->p,x0  ,y0+dy/2,dx,cs,0,RI); if( i>dx/2   ) break; // strichdicke
      i=loop(box1->p,x0+i,y0+dy/2,dx,cs,1,RI); if( i>dx/4+2 ) break;
      for( y=y0;y<=y1-dy/4 && i;y++){ 	// laengsstrich
        j=loop(box1->p,x0  ,y,dx,cs,0,RI); if( j>dx/2 ) i=0;
        x=loop(box1->p,x0+j,y,dx,cs,1,RI); if( (x>i+1 && y>y0+dy/4) || x>3*i1/4 ) i=0;
      } if( !i ) break;
      if( num_cross(0, dx-1-dx/8, dy-1-dy/2, dy-1-dy/2,b,cs) != 1 ) break;
      if( num_cross(0, dx-1     , dy/3     ,      dy/3,b,cs) != 1 ) break;
      if( num_cross(0, dx-1     , dy/8     ,      dy/8,b,cs) != 1 ) break;
      x=0;y=dy-1-dy/4;
      turmite(b,&x,&y,0,dx-1,0,dy-1,cs,RI,ST); if( x>dx/4 ) break;
      turmite(b,&x,&y,0,dx-1,0,dy-1,cs,ST,RI); if( x>dx/2 ) break;
      i=100;
      // if(!hchar)i=i*80/100;
      if( gchar)i=i*80/100;
      if( i>ad  ){ ad=i;ac='L'; }
      if( i<100 ) break;
      bc='L'; break;
   }
   // --- test l ---------------------------------------------------
   //  'l' see ocr1.c
   // --- test o,O ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( get_bw(x0      , x0+dx/2,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
//      out_b(b,0,0,dx,dy,cs);
      if( get_bw(x1-dx/2 , x1     ,y0+dy/2 , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y1-dy/2 , y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0      , y0+dy/2,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2 , x0+dx/2,y0+dy/3 , y1-dy/3,box1->p,cs,1) != 0 ) break;

      if( num_cross(x0+dx/2,x0+dx/2,y0      , y1     ,box1->p,cs)  != 2 ) break;
      if( num_cross(x0+dx/3,x1-dx/3,y0      , y0     ,box1->p,cs)  != 1 ) // AND
      if( num_cross(x0+dx/3,x1-dx/3,y0+1    , y0+1   ,box1->p,cs)  != 1 ) break;
      if( num_cross(x0+dx/3,x1-dx/3,y1      , y1     ,box1->p,cs)  != 1 ) // against "rauschen"
      if( num_cross(x0+dx/3,x1-dx/3,y1-1    , y1-1   ,box1->p,cs)  != 1 ) break;
      if( num_cross(x0     ,x0     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x0+1   ,x0+1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      if( num_cross(x1     ,x1     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x1-1   ,x1-1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      if( num_hole(x0,x1,y0,y1,box1->p,cs) != 1 ) break;
      
      if( loop(b,0   ,0   ,x1-x0,cs,0,RI)<=
          loop(b,0   ,2   ,x1-x0,cs,0,RI)  ) break;

      x=loop(b,dx-1,dy-1-dy/3,x1-x0,cs,0,LE);	// should be minimum
      for( y=dy-1-dy/3;y<dy;y++ ){
        i=loop(b,dx-1,y,x1-x0,cs,0,LE);
        if( i<x ) break; x=i;
      }
      if( y<dy ) break;

      // ~D
      if(     loop(b,0,     dy/16,dx,cs,0,RI)
         +    loop(b,0,dy-1-dy/16,dx,cs,0,RI)
         <= 2*loop(b,0,     dy/2 ,dx,cs,0,RI)+dx/8 ) break; // not konvex
      if(   loop(b,0   , 1+dy/16,dx,cs,0,RI) + dx/4
         <= loop(b,dx-1, 1+dy/16,dx,cs,0,LE) ) break; // Dec00

      if( loop(b,dx-1,     dy/16,dx,cs,0,LE)>dx/8 )
      if( loop(b,0   ,     dy/16,dx,cs,0,RI)<dx/16 ) break;
      if( loop(b,dx-1,dy-1-dy/16,dx,cs,0,LE)>dx/8 )
      if( loop(b,0   ,dy-1-dy/16,dx,cs,0,RI)<dx/16 ) break;
      if( get_bw(x1-dx/32,x1,y0,y0+dy/32,box1->p,cs,1) == 0
       && get_bw(x1-dx/32,x1,y1-dy/32,y1,box1->p,cs,1) == 0
//     && ( get_bw(x0,x0+dx/32,y0,y0+dy/32,box1->p,cs,1) == 1
       && ( get_bw(0,dx/32,0,dy/32,b,cs,1) == 1
         || get_bw(x0,x0+dx/32,y1-dy/32,y1,box1->p,cs,1) == 1 ) ) break; // ~D

       // italic a
      for(i=0,y=6*dy/8;y<dy;y++)
      if( num_cross(0,dx-1,y,y,b,cs) > 2 ) i++; else i--; if(i>0) break; // ~'a' \it a
      if( hchar && 2*y0<box1->m1+box1->m2 ) i=1; else i=0;
      bc='o';  
      if( i ){ bc='O'; }
      break;
   }
   // --- test pP ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( get_bw(0   , dx/2,3*dy/4,3*dy/4,b,cs,1) != 1 ) break;
      if( get_bw(0   , dx/2,  dy/2,  dy/2,b,cs,1) <  1 ) break;
      if( get_bw(dx/4, dx-1,  dy/4,  dy/4,b,cs,1) != 1 ) break;
      if( num_cross(x0+dx/2  ,x0+dx/2  , y0, y1-3*dy/16,box1->p,cs) != 2 )
      if( num_cross(x0+dx/2+1,x0+dx/2+1, y0, y1-3*dy/16,box1->p,cs) != 2 ) break;
      if( num_cross(0,dx-1,7*dy/8  ,7*dy/8  ,b,cs) != 1 )
      if( num_cross(0,dx-1,7*dy/8-1,7*dy/8-1,b,cs) != 1 ) break;
      if( num_cross(0,dx-1,  dy/4  ,  dy/4  ,b,cs) != 2 )
      if( num_cross(0,dx-1,  dy/4-1,  dy/4-1,b,cs) != 3 ) // \it p with nice kurve
      if( num_cross(0,dx-1,  dy/4+1,  dy/4+1,b,cs) != 2 )
      if( num_cross(0,dx-1,  dy/4+1,  dy/4+1,b,cs) != 2 ) break;
      i1=   loop(b, 0,3*dy/8,dx,cs,0,RI);
      i2=i1+loop(b,i1,3*dy/8,dx,cs,1,RI); // upper x-position of v line
      i3=   loop(b, 0,7*dy/8,dx,cs,0,RI);
      i4=i3+loop(b,i3,7*dy/8,dx,cs,1,RI); // lower x-position of v line
      // out_x(box1);printf(" p:");
      for ( y=dy/8; y<7*dy/8; y++ ){
        x=i2+  (8*y-3*dy)*(i4-i2)/(4*dy); // right limit of line
        i=  loop(b,0,y,dx,cs,0,RI); if(i>x+dx/16) break;
      } if ( y<7*dy/8 ) break;
      for ( x=0,j=y=dy/3; y<7*dy/8; y++ ){ // suche unterkante
        i=loop(b,dx-1,y,dx,cs,0,LE);
        if ( i>x ) { x=i; j=y; } if(x>dx/2) break;
      } if ( x<dx/2 || x>=dx) break;
      if( get_bw(3*dx/4,dx-1, y      , dy-1,b,cs,1) == 1 ) break;
      if( hchar && gchar) break; // ~ \ss

      if( ac==UNKNOWN ) { if( hchar && !gchar ) ac='P'; else ac='p'; }
      if( num_hole (x0 ,x1 , y0, y1-dy/5,box1->p,cs) != 1 ) break;
      if( num_hole (x0 ,x1 , y0, y1     ,box1->p,cs) != 1 ) break;

      bc='p'; if( hchar && !gchar ) bc='P';
      break;
   }
   // --- test Q ---------------------------------------------------
   if(bc==UNKNOWN)
   if(/* hchar && */ y1>box1->m3) // ~q
   for(d=100;dx>2 && dy>4;){     // min 3x4
      if( get_bw(x0     ,x0+dx/3,y0+dy/3,y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/3,x1     ,y0+dy/3,y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y1-dy/3,y1,     box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y0     ,y0+dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y0+dy/3,y1-dy/2,box1->p,cs,1) == 1 ) break;
      if( get_bw(x1     ,x1     ,y0     ,y0     ,box1->p,cs,1) == 1 ) break; //alpha
      if( num_cross(x0+dx/2,x0+dx/2,y0      , y1     ,box1->p,cs)  <  2 ) break;
      if( num_cross(x0+dx/5,x1-dx/5,y0      , y0     ,box1->p,cs)  != 1 ) // AND
      if( num_cross(x0+dx/5,x1-dx/5,y0+1    , y0+1   ,box1->p,cs)  != 1 ) break;
      if( num_cross(x0     ,x0     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x0+1   ,x0+1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      if(    get_bw(x1     ,x1     ,y1-dy/8 , y1     ,box1->p,cs,1) == 0 )
      if( num_cross(x1     ,x1     ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 )
      if( num_cross(x1-1   ,x1-1   ,y0+dy/3 , y1-dy/3,box1->p,cs)  != 1 ) break;
      i=num_hole(x0,x1,y0,y1,box1->p,cs);
      if(!i) break;
      if( i!=1 && (i!=2 || num_hole(x0,x1,y0+dy/2,y1,box1->p,cs)!=1) ) break;
      x=x1;y=y1;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST); if( x<x1-dx/2 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,LE); if( x<x1-dx/2 ) break;
      if( loop(b,0   ,0   ,dx,cs,0,RI)
        < loop(b,0   ,2   ,dx,cs,0,RI)       ) break;
      if( loop(b,0   ,dy/8+2,dx,cs,0,RI)
         +loop(b,dx-1,dy/8+2,dx,cs,0,LE) > 5*dx/8 ) break; // ~4 Okt00

      x=  loop(b,dx-1,3*dy/8,dy,cs,0,LE); if( x>dx/4 ) break;
      if( loop(b,dx-1-x,0   ,dy,cs,0,DO)
       <= loop(b,dx-2-x,0   ,dy,cs,0,DO)       ) break;	// 4

      if( loop(b,dx-1,dy/3,dx,cs,0,LE)> dx/4 ) break;
      if( get_bw(x0+dx/4,x0+dx/4,y1-dy/16,y1,box1->p,cs,1) == 0 
       && get_bw(x0     ,x0+dx/4,y1-dy/16,y1,box1->p,cs,1) == 1 ) break; // ~R Jul00

      // ~o look at the lower right side for falling line
      for(x=0,y=dy/2;y<dy;y++){
        i=loop(b,dx-1,y,dx,cs,0,LE);if(i>x){ x=i; }
        if( i<x-dx/16 ) break;	// falling line detected
      }
      if( y==dy ) break; // no falling line => no Q
      if( bc!=UNKNOWN ){ if(ac==UNKNOWN) ac='Q'; break; }
      return 'Q';
   }
   // --- test q ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      for ( x=0,j=y=y0+dy/3; y<y1-dy/6; y++ ){ // suche unterkante
        i=loop(box1->p,x0,y,dx,cs,0,RI);
        if ( i>x ) { x=i; j=y; }
      } if ( x<dx/2 || x>=dx) break;
      if( loop(box1->p,x0,j,dy,cs,0,UP)<2 ) break; // 4 
      if( get_bw(x1-dx/3, x1     , y0+dy/3, y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/3, y0+dy/3, y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/4, y1-dy/5, y1-dy/9,box1->p,cs,1) == 1 ) break;
      if( num_cross(x0+dx/2,x0+dx/2, y0, j      ,box1->p,cs) != 2 ) break;
      if( num_hole (x0     ,x1     , y0, y1     ,box1->p,cs) != 1 ) break;
      if( num_hole (x0     ,x1     , y0, j      ,box1->p,cs) != 1 ) break;
      // ~\it g
      if( loop(b,0,dy-1-dy/4,dx,cs,0,RI)>5*dx/8
       && get_bw(dx/4,dx/4,dy-1-dy/4,dy-1,b,cs,1)==1 ) break; // ~\it g
      
      if((!gchar) && hchar){ if( ac==UNKNOWN ) ac='q'; break; } // ~4
      bc='q';
      break;
   }
   // --- test ij ---------------------------------------------------
   if(bc==UNKNOWN)
   if(dots==1) // what about \it neighbouring ij
   for(d=100;dy>4 && dx>1;){     // min 3x4
      ya=y0;
      if( dots!=1 ) break;
      if( box1->m2 && 2*y0>=box1->m2+box1->m1 ) ya=box1->m1;

//      out_x(box1);
      for(y=ya;2*y<ya+y1;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) == 1 ) break;
      if(2*y>=ya+y1) break;		// hmm only gap
      ya=y;
      if( box1->m2 && ya>box1->m2+2 ) break;
      for(   ;2*y<y1+ya;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) != 1 ) break;
      if(2*y>=ya+y1) break;		// hmm no gap
      for(   ;2*y<y1+ya;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) == 1 ) break;
      if(2*y>=ya+y1) break;		// hmm very large gap
      yb=y;
      if( loop(b,dx-1,y+(y1-ya+1)/32,dx,cs,0,LE)>dx/2 ) break; // unusual (right part of ouml)

      // printf(" num_cross dy/2=%d %d\n",dy/2, num_cross(0,dx-1,dy/2,dy/2,b,cs));
      // printf(" dots=%d\n",dots); out_x(box1);
      // \sl ~f. !
      for(y=(ya+y1)/2;y<=y1;y++) if( get_bw(x0,x1,y,y,box1->p,cs,1) != 1 ) break;
      if(y<=y1) break;

      y=(y1-yb+1)/2+yb-y0;  /* only one vertical line, italic i is more an tall S */
      if( num_cross(0,dx-1,y,y,b,cs) != 1 ) break;
      for(;y<=y1-y0;y++){ if( num_cross(0,dx-1,y,y,b,cs) != 1 ) break; } yc=y;
      for(;y<=y1-y0;y++){ if( num_cross(0,dx-1,y,y,b,cs) != 2 ) break; } yd=y;
      if( yd<3*(y1-yb+1)/4+yb-y0 ) break;
      y=(y1-yb+1)/2+yb-y0;
      for(;y>0;y--){ if( num_cross(0,dx-1,y,y,b,cs) != 1 ) break; } ye=y;
      for(;y>0;y--){ if( num_cross(0,dx-1,y,y,b,cs) != 2 ) break; } yf=y;
      if( yf>(y1-yb+1)/4+yb-y0 ) break;
      if(yd>yc+2){
        xa=loop(b,   0,yc-1,dx,cs,0,RI);
        xb=loop(b,dx-1,yc-1,dx,cs,0,LE);
        if(
            xb-loop(b,dx-1,yc,dx,cs,0,LE) /* Dec00 */
          > xa-loop(b,   0,yc,dx,cs,0,RI) ){ 
          y= loop(b,dx-xb,yc-1,dy,cs,0,DO);
          if(y>0){
            i=loop(b,dx-xb-1,yc-1+y-1,dy,cs,0,DO);
            if( i>0 ) y+=i-1;
          }
          if( yc-1+y < yd-1 ) break;
        } else { 
          y= loop(b,11*xa/16,yc-1,dy,cs,0,DO);
          if( yc-1+y < yd-2 ) break;
        }
      }
      if(yf<ye-2){
        x=loop(b,0  ,ye+1,dx,cs,0,RI);
        y=loop(b,x-1,ye+1,dy,cs,0,UP);
        i=loop(b,x  ,ye+2-y,dy,cs,0,UP);
        if( i>0 ) y+=i-1;
        if( ye+1-y > yf+1 ) break;
      }

      if( gchar )  // i is more often than j, be sure that realy correct Mai00
      if( loop(b,   0,2*dy/4,dx,cs,0,RI)
         -loop(b,dx-1,2*dy/4,dx,cs,0,LE)>dx/8 ) return 'j';
      // could be a broken + or similar thing?
      if( 3 * ya > box1->m1 + 2*box1->m2 ){ 
	if( ac==UNKNOWN ) 
	  ac='i'; 
	break; 
      }

      return 'i';
   }
   // --- test I ---------------------------------------------------
   if(!gchar) //  ~serif I  Mar2000 ??? 
   for(d=100;dy>4 && dy>dx && 5*dy>4*(box1->m3-box1->m2);){     // min 3x4
      if( dots==1 ) break;

      x =loop(b,0,  dy/2,dx,cs,0,RI);	// konvex? divided Q
      if(loop(b,0,7*dy/8,dx,cs,0,RI) > x+dx/8) break;
      for( y=dy/16;y<dy-1-dy/16;y++ )
      if( num_cross(0, dx-1, y       , y       ,b,cs) != 1 )
      if( num_cross(0, dx-1, y+dy/16 , y+dy/16 ,b,cs) != 1 ) break;
      if( y<dy-1-dy/16 ) break;
      x =loop(b,0,  dy/2,dx,cs,0,RI);
      i5=loop(b,x,  dy/2,dx,cs,1,RI); // center width
      for(y=dy/4;y<3*dy/4;y++ ){ // same width ?
        x =loop(b,0,  y,dx,cs,0,RI);
        x =loop(b,x,  y,dx,cs,1,RI); // width
        if( abs(x-i5)>1+dx/8 ) break;
      } if( y<3*dy/4 ) break;
      // out_x(box1);

      // upper max width
      for(i2=i1=0,y=0;y<dy/4;y++ ){
        x =loop(b,0,  y,dx,cs,0,RI);
        x =loop(b,x,  y,dx,cs,1,RI); if(x>i1){ i1=x;i2=y; }
      }
      for(i4=i3=0,y=3*dy/4;y<dy;y++ ){
        x =loop(b,0,  y,dx,cs,0,RI);
        x =loop(b,x,  y,dx,cs,1,RI); if(x>i3){ i3=x;i4=y; }
      }
      if( abs(i3-i1)>1+dx/8 ) break;  // if i3>>i5 more sure!
      if( i1>i5 ){ // look for edges else *80%
      } 
      if(i1+1<i5 && !hchar) break; // Jun00

      // calculate upper and lower mass center
      x =loop(b,0,     dy/8,dx,cs,0,RI); i1=x;
      x+=loop(b,x,     dy/8,dx,cs,1,RI); i1=(i1+x-1)/2;

      x =loop(b,0,dy-1-dy/8,dx,cs,0,RI); i2=x;
      x+=loop(b,x,dy-1-dy/8,dx,cs,1,RI); i2=(i2+x-1)/2;
      x =loop(b,0,dy-2-dy/8,dx,cs,0,RI); i=x;
      x+=loop(b,x,dy-2-dy/8,dx,cs,1,RI); i=(i+x-1)/2; if( i>i2 ) i2=i;

      // out_x(box1);
      // printf(" get_line(%d,%d) %d\n",i1,i2,
      //    get_line2(i1,dy/8,i2,dy-1-dy/8,b,cs,100));
      if( get_line2(i1,dy/8,i2,dy-1-dy/8,b,cs,100)<95 ) break;
      x =(i1-i2+4)/8; i1+=x; i2-=x;

      // upper and lower width
      x =loop(b,i1,   0,dx,cs,1,LE); i=x; i3=0;
      x =loop(b,i1,   1,dx,cs,1,LE); if(x>i)i=x;
      x =loop(b,i1,   0,dx,cs,1,RI); j=x;
      x =loop(b,i1,   1,dx,cs,1,RI); if(x>j)j=x; if(abs(i-j)>1+dx/8)i3|=1;
      x =loop(b,i2,dy-1,dx,cs,1,LE); j=x;
      x =loop(b,i2,dy-2,dx,cs,1,LE); if(x>j)j=x; if(abs(i-j)>1+dx/8)i3|=1;
      x =loop(b,i2,dy-1,dx,cs,1,RI); j=x;
      x =loop(b,i2,dy-2,dx,cs,1,RI); if(x>j)j=x; if(abs(i-j)>1+dx/8)i3|=1;
      if(i3) break;

      if(dy>15)  // v024a4
      if( loop(b,dx-1,dy/16 ,dx,cs,0,LE)
        > loop(b,dx-1,dy/4  ,dx,cs,0,LE)+1+dx/32 ) break; // ~bad ) (thinn)

      for(i=0,y=dy/16;y<15*dy/16 && i<2;y++)
      if( num_cross(0,dx-1,y,y,b,cs) != 1 ) i++;
      if( i>1 ) break;

      if(!hchar){	// right part (bow) of h is never a l
        if( get_bw(dx/4,dx/4,   0,dy/4,b,cs,1) == 1
         && get_bw(dx/4,dx/4,dy/2,dy-1,b,cs,1) == 0 ) break;
        if( loop(b,   0,dy/4,dx,cs,0,RI)> dx/4
         && loop(b,dx-1,dy/4,dx,cs,0,LE)<=dx/4
         && loop(b,   1,   0,dy,cs,0,DO)<=dy/4 ) break; // ~z
      }

      if( get_bw(x1,x1,y0  ,y1  ,box1->p,cs,2) != 2
       && get_bw(x0,x1,y0  ,y0  ,box1->p,cs,2) != 2
       && get_bw(x0,x1,y1  ,y1  ,box1->p,cs,2) != 2
       && get_bw(x0,x0,y0+1,y1-1,box1->p,cs,1) != 1 ) break; /* ~] */

      x =loop(b,   0,dy/2,dx,cs,0,RI);	// konvex/konkav? ~()
      i =loop(b,dx-1,dy/2,dx,cs,0,LE);
      if( loop(b,   0,7*dy/8,dx,cs,0,RI) > x+dx/8
       && loop(b,   0,  dy/8,dx,cs,0,RI) > x+dx/8
       && loop(b,dx-1,7*dy/8,dx,cs,0,LE) < i-dx/8
       && loop(b,dx-1,  dy/8,dx,cs,0,LE) < i-dx/8 ) break; // ~(
      if( loop(b,   0,7*dy/8,dx,cs,0,RI) < x-dx/8
       && loop(b,   0,  dy/8,dx,cs,0,RI) < x-dx/8
       && loop(b,dx-1,7*dy/8,dx,cs,0,LE) > i+dx/8
       && loop(b,dx-1,  dy/8,dx,cs,0,LE) > i+dx/8 ) break; // ~)
                                 
      
      if(i1+1<i5 && !hchar){ 
	if(60>ad || ac==UNKNOWN) 
	  ac='I'; 
	break; 
      } // ~ slanted I

      // out_b(b,0,0,dx,dy,cs); printf(" i12 %d %d %d\n",i1,i2,i3);
      return 'I';
   }
   // --- test J --------------------------------------------------- 28Jun00
   for(d=100;dy>4 && dy>=dx && dx>2;){     // min 3x4
      if( get_bw(x0+dx/4,x0+dx/4,y1-dy/4,y1,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y0+dy/4,y0+dy/4,box1->p,cs,1) == 0
       && get_bw(x0+dx/2,x0+dx/2,y1-dy/4,y1-dy/4,box1->p,cs,1) == 0
       && get_bw(x0+dx/2,x0+dx/2,y0+dy/4,y1-dy/4,box1->p,cs,1) == 1 ) break; // ~d
      if( get_bw(dx/2,dx/2,   0,dy/8,b,cs,1) == 0
       && get_bw(dx/2,dx/2,dy/8,dy/2,b,cs,1) == 1
       && num_hole(x0,x1,y0+dy/8,y1,box1->p,cs) > 0 ) break; // ~d Jul00
      if( loop(b,0   ,3*dy/8,dx,cs,0,RI)
        <=loop(b,dx-1,3*dy/8,dx,cs,0,LE)+dx/6 ) break;
      if( loop(b,0   ,  dy/6,dx,cs,0,RI)
        <=loop(b,dx-1,  dy/6,dx,cs,0,LE)+dx/6 ) break;
      if( loop(b,dx/5,5*dy/8,dx,cs,0,RI)+dx/5
        <=loop(b,dx-1,5*dy/8,dx,cs,0,LE)      ) break;
      // out_x(box1);
      // test ob rechte Kante gerade
      for(x=0,y=dy/32;y<dy;y++){ // rechts abfallende Kante/Knick?
        i=loop(b,dx-1,y,dx,cs,0,LE);
        if( i+1<x ) break;
        if( i>x ) x=i;
      } if (y<dy ) break; 

      if( get_bw(x0     ,x0+dx/4,y0+dy/8,5*dy/8,box1->p,cs,1) == 1 ) break;
      if( get_bw(dx-1   ,dx-1   ,dy-1   ,dy-1  ,b,cs,1) == 1 ) break;
      if( get_bw(x0     ,x0+dx/2,y1-dy/5,y1    ,box1->p,cs,1) != 1 ) break;
      if( dots==1 ) return 'j';
      if( dots!=0 ) break;
      if(dy>3*dx){
       if( get_bw(0,dx-1,dy-1,dy-1,b,cs,2) == 0
        || get_bw(0,dx-1,dy-2,dy-2,b,cs,2) == 0 ) break; // ~]
       if( get_bw(0,   0,   0,   1,b,cs,1) == 1
        && loop(b,dx-1,dy-1,dx,cs,0,LE) < 2 ) break;  // ~]
      }

      if( loop(b,dx-1,dy-1,dx,cs,0,LE) > 3*dx/4  // ~)
       && loop(b,dx-1,0   ,dx,cs,0,LE)
        > loop(b,dx-1,dy/4,dx,cs,0,LE) ) break; // ~)

      return 'J';
   }
   // --- test T ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // dx>1 dy>2*dx 
      for( i=1,y=y0;y<y0+dy/6 && i;y++)		// oberer Balken?
      if( get_bw(x0+dx/4,x1-dx/8,y,y,box1->p,cs,2) == 0 ) i=0;
      if( i ) break;
      if( get_bw(        0,dx/3,        0,     dy/8,b,cs,1) != 1 ) break;
      if( get_bw(        0,dx/8,     dy/2,dy-1-dy/8,b,cs,1) == 1 ) break;
      if( get_bw(        0,dx/4,     dy/2,dy-1-dy/4,b,cs,1) == 1 ) break;
      if( get_bw(dx-1-dx/4,dx-1,     dy/2,dy-1-dy/4,b,cs,1) == 1 ) break;
      // top max width x
      for( x=0,y=0;y<dy/4;y++){		// oberer Balken?
        i=loop(b,0,y,dx,cs,0,RI);
        i=loop(b,i,y,dx,cs,1,RI);if(i>x) x=i; // max. width
      } if( x<=dx/2 ) break;
      // center width
      for( y=dy/4;y<3*dy/4;y++){		// oberer Balken?
        i=dx/4+loop(b,dx/4,y,dx,cs,0,RI);if(i==dx/4) break; // ~r
        i=     loop(b,   i,y,dx,cs,1,RI);if(2*i>x) break;
      } if( y<3*dy/4 ) break;
      // down width
      for( y=3*dy/4;y<dy;y++){
        i=     loop(b,dx/4,y,dx,cs,0,RI);
        i=     loop(b,   i,y,dx,cs,1,RI);if(4*i>3*x) break; //~I
      } if( y<dy ) break;

      i =dx/2+loop(b,dx/2,dy/4,dx,cs,0,RI);if(i>3*dx/4) break; // ~7
      i+=     loop(b,i   ,dy/4,dx,cs,1,RI);if(i>3*dx/4) break;

      if( num_cross(0,dx-1,  dy-1,  dy-1,b,cs) != 1
       && num_cross(0,dx-1,  dy-2,  dy-2,b,cs) != 1 ) break;
      if( num_cross(0,dx-1,2*dy/3,2*dy/3,b,cs) != 1
       && num_cross(0,dx-1,2*dy/3,2*dy/3,b,cs) != 1 ) break;
//      out_b(box1->p,x0,y0,dx,dy,cs);
      return 'T';
   }
   // --- test t ---------------------------------------------------
   if((!gchar) && (!dots))
   for(d=100;dx>2 && dy>box1->m3-box1->m2+1;){     // sometimes no hchar! 
      for(x=0,j=y=1+3*dy/16;y<4*dy/8;y++){ // upper cross line
        i=loop(b,0,y,dx,cs,0,RI); if( y>dy/4 && i>dx/2 ) break;
        i=loop(b,i,y,dx,cs,1,RI); if( i>x ) { x=i;j=y; }
        if( y<11*dy/16
         && num_cross(0,dx-1,y  ,y  ,b,cs) != 1
         && num_cross(0,dx-1,y+1,y+1,b,cs) != 1  // against noise
          ) break;
      } if( y<4*dy/8 ) break; yb=j;// if( yb>dy/2 || yb<dy/8 ) break;

      i=loop(b,dx-1,0,dx,cs,0,LE);
      for(y=0;y<dy/4;y++){ // upper cross line
        if( num_cross(0,dx-1,y  ,y  ,b,cs) == 2
         && num_cross(0,dx-1,y+1,y+1,b,cs) == 2 ) break;
        j=loop(b,dx-1,y,dx,cs,0,LE); if(j-i>1) break; i=j;
      } if( y<dy/4 ) break;

      i=loop(b,dx-1,yb,dx,cs,0,LE);
      for(y=dy/8;y<yb;y++) // upper cross line
      if( loop(b,dx-1,y,dx,cs,0,LE)>i ) break;
      if( y==yb ) break;

      i=loop(b,0,dy/2,dx,cs,0,RI);
      i=loop(b,i,dy/2,dx,cs,1,RI); // thickness
      if( 2*x<3*i ) break;

      if( loop(b,dx-1,dy/2,dx,cs,0,LE)-1
        <=loop(b,dx-1, yb ,dx,cs,0,LE) ) break; // ~1

      j=1;
      for(y=1;j && y<yb;  y++)  // no @@ pattern
      for(x=0;j && x<dx-2;x++){ //    ..
        if(  pixel(b,x  ,y  )>=cs && pixel(b,x+1,y  )>=cs
          && pixel(b,x  ,y-1)< cs && pixel(b,x+1,y-1)< cs ) { j=0;break; }
      } if(!j) break;
      if( num_cross(0,dx-1,dy-2,dy-2,b,cs) == 2
       && num_cross(0,dx-1,dy-1,dy-1,b,cs) == 2 ) break; // ~* (5er)

      // out_b(box1->p,x0,y0,dx,dy,cs); printf(" out_t xyi %d %d %d %d\n",x,y,i,j);
      return 't';
   }
   // --- test sS near 5 ---------------------------------------------------
   if(!gchar)
   for(d=100;dx>2 && dy>4;){     // min 3x4
      if( num_cross(  dx/2,  dx/2,0,dy-1,b,cs)!=3
       && num_cross(5*dx/8,3*dx/8,0,dy-1,b,cs)!=3 ) break;
      if( num_cross(0,dx-1,dy/2  ,dy/2  ,b,cs)!=1
       && num_cross(0,dx-1,dy/2-1,dy/2-1,b,cs)!=1 ) break;
      // get the upper and lower hole koords
      y=dy/4;
      x  =loop(b,0,y,dx,cs,0,RI); if(x>3*dx/8) break; /* slanted too */
      x +=loop(b,x,y,dx,cs,1,RI); if(x>  dx/2) break;
      i1 =loop(b,x,y,dx,cs,0,RI); i1=(i1+2*x)/2; // upper center x
      y=11*dy/16;
      x  =loop(b,dx-1  ,y,dx,cs,0,LE); if(x>dx/4) break;
      x +=loop(b,dx-1-x,y,dx,cs,1,LE); if(x>dx/2) break;
      i2 =loop(b,dx-1-x,y,dx,cs,0,LE); i2=dx-1-(i2+2*x)/2; // upper center x
//      out_x(box1);
      for( y=dy/4;y<dy/2;y++ )  // Mai00 ~3
      if( get_bw(0,i1,y,y,b,cs,1) != 1 ) break;
      if( y<dy/2 ) break;

      y=dy/2-loop(b,dx-1,dy/2,dy/2,cs,1,UP);
//      if( !joined(b,i1,dy/4,dx-1,y,cs) ){
        // break;  // sometimes thick small fonts have no gap
//      }
      for(y=dy/4;y<dy/2;y++){
        x=loop(b,dx-1,y,dx,cs,0,LE);if(x>dx/8) break;
      }
      if(y==dy/2) break;  // Mai00

      y=dy/2+loop(b,0,dy/2,dy/2,cs,1,DO);
      if( !joined(b,0,y,i2,11*dy/16,cs) ) break;

      if( num_hole( x0, x1, y0+dy/4, y1, box1->p,cs) > 0 ) break;

      // sS5 \sl z  left upper v-bow ?

      i1=loop(b,0,  dy/16,dx,cs,0,RI);
      i2=loop(b,0,4*dy/16,dx,cs,0,RI);
      i3=loop(b,0,7*dy/16,dx,cs,0,RI);
      if( 2*i2+dx/32 >= i1+i3 ) break;
      // out_b(b,0,0,dx,dy,cs);
      
      for(y=7*dy/16;y<5*dy/8;y++){
        if( num_cross( 0,dx-1,y  ,y  ,b,cs)==2 )
        if( num_cross( 0,dx-1,y+1,y+1,b,cs)==1 )
        if( num_cross( 0,dx/4,y,y,b,cs)==1 ) break; // ~5
      } if(y<5*dy/8) break; // v0.2.4a5
      if (  loop(b, dx-1,dy-2-dy/32,dx,cs,0,LE) 
          > loop(b,    0,   1+dy/32,dx,cs,0,RI) + dx/4 ) break; // ~5 Dec00

      if( hchar ){ // S but 5 is very similar! check it
        y =loop(b,dx/2,0,dy,cs,0,DO);
        y+=loop(b,dx/2,y,dy,cs,1,DO) + dy/32;
        if( get_bw(dx/2,dx-1,y,y,b,cs,1) == 1 ) return 'S'; // be more sure
        if(ad<90){ ad=90;ac='S'; }
      } else { return 's'; }
//    printf(" no");
      break;
   }
   // --- test g ---------------------------------------------------
   /* some g's have crotchet at upper right end, so hchar can be set */
   if(gchar && 4*y0>=(3*box1->m1+box1->m2) )  // ~italic g
   for(d=100;dx>2 && dy>4;){     // min 3x5
      if( get_bw(x0+dx/2, x0+dx/2, y1-dy/2, y1,box1->p,cs,1) != 1 ) break;
      if( get_bw(x1-dx/4, x1     , y1-dy/4, y1,box1->p,cs,1) != 1 ) break; // ~p
      if( get_bw(x0+dx/2, x0+dx/2, y0, y0+dy/2,box1->p,cs,1) != 1 ) break;

      if( num_cross(x0+dx/2, x0+dx/2, y0, y1, box1->p,cs) < 3 )
      if( num_cross(x1-dx/2, x1-dx/2, y0, y1, box1->p,cs) < 3 ) break;
      if( num_hole ( x0, x1, y0, y0+5*dy/8, box1->p,cs) != 1 ) break;
      for(y=dy/4;y<dy;y++) if( num_cross(0,dx-1,y,y,b,cs)==2 ) break;
      if( y==dy ) break; // ~q
      if( get_bw(0,dx/2,7*dy/8,7*dy/8,b,cs,1) != 1 ) break; // ~q
      bc='g';
      break;
   }
   // --- test rundes G ---------------------------------------------
   if(!gchar)
   for(d=100;dx>3 && dy>4;){     // min 3x4
      if( get_bw(x0     ,x0+dx/2,y0+dy/3,y0+dy/3,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x1-dx/4,y0     ,y0+dy/4,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0+dx/2,x0+dx/2,y1-dy/4,y1     ,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     ,x0+dx/2,y1-dy/3,y1-dy/3,box1->p,cs,1) != 1 ) break; // ~S
      for( y=y0+dy/4;y<y1-dy/3;y++ ) 
      if( get_bw(x1-dx/2,x1,y,y,box1->p,cs,1) == 0 ) break;
      if( y==y1-dy/3 ) break;
      if( num_cross(x0+dx/2  , x0+dx/2  , y0, y, box1->p,cs) != 1
       || num_cross(x0+dx/2+1, x0+dx/2+1, y0, y, box1->p,cs) != 1 ) break; // ~e

      x=x0; y=y1;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,UP,ST);	// left bow?
      if( y<y0+dy/4 ) break;	// filter W

      x=x1; y=y1-dy/3;		// upper right offen bow
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST);
      if( x<x1-3*dx/8 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,LE);
      if( x<x0+dx/2 ){	// not sure, try again (not best)
        x=x1; y=y1-dy/4;
        turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST);
        turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,LE);
        if( x<x0+dx/2 ) break;
      }
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,UP);	// upper end right midle
      if( x<=x1     ) break;
      if( y<y0+3*dy/8 ) break;
      if( y>y1-dy/4 ) break;

//      out_x(box1); MM;
      x=x1-dx/3;y=y1;     // follow C-bow, filter S
      turmite(box1->p,&x,&y,x0,x1,y0+dy/4,y1,cs,LE,UP); // w=LE b=UP
      if( x>x0+dx/4+1 ) break; x++;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,UP);
      if( y>=y0 ) break;      

      if( num_hole(x0,x1,y0,y1,box1->p,cs) > 0 ) break;
      if( dx>4 && dy>6){		// no (<{[
        for(i=1,y=0;i && y<dy/3;y++)
        if( num_cross(0,dx-1,y,y,b,cs) == 2 ) i=0;
        if( i ) break;
      }
      for(i=1,y=dy/2;i && y<dy;y++)
      if( num_cross(0,dx-1,y,y,b,cs) == 2 ) i=0;
      if( i ) break;
      for(i=0,y=3*dy/4;y<dy;y++){
        x=loop(b,0,y,dx,cs,0,RI);	// Kante abfallend <=> Z
        if( x<i-dx/20 ) break;
        if( x>i ) i=x;
      } if( y<dy ) break;

      for(i=0,i1=y=dy/8+2;y<dy-2-dy/8;y++){ // look for horizontal line
        x=loop(b,dx-1  ,y,dx/4,cs,0,LE);
        x=loop(b,dx-1-x,y,dx/2,cs,1,LE); if(x>i){ i=x;i1=y; }
      } if( i1<dy/4 || i1>3*dy/4 ) break; // around the middle ?

      i=1;
      for(x=dx/2;x<dx-1 && i;x++)  // look for  @@ (instead +1 use +delta?) 
      for(y=dy/2;y<dy-1 && i;y++){ //           .@
        if( pixel(b,x  ,y  )>=cs
        &&  pixel(b,x+1,y  )< cs
        &&  pixel(b,x+1,y-1)< cs
        &&  pixel(b,x  ,y-1)< cs ) { i=0;break; }
      }
      if(i) break;		// ~C

      bc='G'; break;
   }
   // --- test xX ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( num_cross(x0,x1,y0+dy/8,y0+dy/8, box1->p,cs) < 2 ) break;
      if( num_cross(x0,x1,y1-dy/8,y1-dy/8, box1->p,cs) < 2 ) break;
      for(i=1,y=y0+dy/8;y<=y1-dy/8 && i;y++){
        if( get_bw(x0     , x1-dx/4,y, y,box1->p,cs,1) != 1 ) i=0;
      } if( !i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x, y0,    y0+dy/4,box1->p,cs,1) != 1 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y1-dy/4,y1     ,box1->p,cs,1) != 1 ) i=0;
      } if( i ) break;
      for(i=1,x=x0;x<=x0+dx/3 && i;x++){
        if( num_cross(x,x,y0,y1, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,x=x1-dx/3;x<=x1 && i;x++){
        if( num_cross(x,x,y0,y1, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+dy/3 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y0+dy/3;y<=y1-dy/3 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 1 ) i=0;
      } if( i ) break;
      for(i=1,y=y1-dy/3;y<=y1 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( get_bw(x1-dx/4, x1     , y0, y0+dy/6,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/4, y1-dy/6, y1,box1->p,cs,1) != 1 ) break;
      i=loop(box1->p,x1,y0+dy/6,x1-x0+1,cs,0,LE); if(i>dx/2) break;
      j=loop(box1->p,x1,y1-dy/2,x1-x0+1,cs,0,LE); if(j<=i  ) break; i=j;
      j=loop(box1->p,x1,y1-dy/6,x1-x0+1,cs,0,LE); if(j>=i  ) break;
      i=loop(box1->p,x0,y0+dy/6,x1-x0+1,cs,0,RI); if(i>dx/2) break;
      j=loop(box1->p,x0,y0+dy/2,x1-x0+1,cs,0,RI); if(j<=i  ) break; i=j;
      j=loop(box1->p,x0,y1-dy/6,x1-x0+1,cs,0,RI); if(j>=i  ) break;
      for(i=1,x=dx-1-dx/4;x<dx && i;x++){
        if( num_cross(x,x,dy/8,dy/2,b,cs) == 2 ) i=0;
      } if( !i ) break; // ~ glued be (b divided)
      if( dx>dy )	/* Jan00 */
      if( num_cross(dx/4,dx/8,0,dy-1,b,cs) > 2
       && num_cross(dx/4,dx/4,0,dy-1,b,cs) > 2 )
      if( loop(b,0,dy/4,dx,cs,0,RI)<dx/8 ) break; // ~glued_sc
      bc='x'; if(hchar) bc='X';
      break;
   }
   // --- test \it x ---------------------------------------------------
   for(d=100;dx>4 && dy>4;){     // min 3x4
      if( get_bw(x0,x0+dx/4,y0+dy/2,y0+dy/2,box1->p,cs,1) != 0 ) break;
      if( get_bw(x1-dx/4,x1,y0+dy/2,y0+dy/2,box1->p,cs,1) != 0 ) break;
      if( num_cross(x0+dx/4,x1-dx/4,y0+dy/2,y0+dy/2, box1->p,cs) != 1 ) break;
      if( num_cross(x0,x1,y0+dy/4,y0+dy/4, box1->p,cs) != 3 
       && num_cross(x0,x1,y0+dy/8,y0+dy/8, box1->p,cs) <  3 ) break;
      if( num_cross(x0,x1,y1-dy/4,y1-dy/4, box1->p,cs) != 3
       && num_cross(x0,x1,y1-dy/8,y1-dy/8, box1->p,cs) <  3 ) break;
      if( gchar || hchar ){ if(ac==UNKNOWN) ac='x'; break; }
      bc='x';
      break;
   }
   // --- test italic yY --------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( num_cross(0,dx-1,dy/8,dy/8,b,cs) < 2 
       && num_cross(0,dx-1,   1,   1,b,cs) < 2 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,b,cs) != 1 
       && num_cross(0,dx-1,dy-2,dy-2,b,cs) != 1 ) break;
      if( num_cross(dx-1,dx-1,0,dy-1,b,cs) != 1 
       && num_cross(dx-1,dx-1,0,dy-1,b,cs) != 1 ) break;
      if( num_cross(dx/2,dx/2,dy/4,dy-1,b,cs) != 2 
       && num_cross(dx/2,dx/2,dy/4,dy-1,b,cs) != 2 ) break;
      for(yc=y=0,xc=x=dx/4;x<dx-dx/4;x++){  // search deepest point
        i=loop(b,x,0,dy,cs,0,DO); if(i>y){ yc=y=i;xc=x; }
      } if( y>12*dy/16 || y<3*dy/8 ) break;
      ya=dy/8; xa=xc-loop(b,xc,ya,dx,cs,0,LE); if(xa<  0) break;
      yb=dy/8; xb=xc+loop(b,xc,yb,dx,cs,0,RI); if(xb>=dx) break;
      // out_x(box1);
      // /a   b
      //  |  |
      //   -c/
      // \e-d
      for(y=dy/8;y<yc-dy/8;y++){
       if( num_cross(xc,dx-1,y,y,b,cs) != 1 ) break;
       if( num_cross(0 ,xc  ,y,y,b,cs) <  1 ) break;
      } if(y<yc-dy/8) break;
      yd=dy-1-dy/8;xd=dx-1-loop(b,dx-1,yd,dx,cs,0,LE); if(xd>6*dx/8) break;
      // printf(" abcd=%d %d %d %d %d %d %d %d -",xa,ya,xb,yb,xc,yc,xd,yd);
      if( get_line2(xb,yb,xd,yd,b,cs,100)<95 ) break;
      // if( get_line2(xc,yc,xd,yd,b,cs,100)<95 ) break;
      // printf("ok");
      if(gchar && !hchar) return 'y'; 
      if(hchar && !gchar) return 'Y';
      bc='y'; // SMALL-CAPS ???
      break;
   }
   // --- test yY ---------------------------------------------------
   for(d=100;dx>2 && dy>3;){     // min 3x4
      if( get_bw(x0,x0+3*dx/8,y0+dy/8,y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( num_cross(0,dx-1,dy/8,dy/8,b,cs) != 2 
       && num_cross(0,dx-1,   1,   1,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,dy-1,dy-1,b,cs) != 1 
       && num_cross(0,dx-1,dy-2,dy-2,b,cs) != 1 ) break;
      if( num_cross(dx-1,dx-1,0,dy-1,b,cs) != 1 
       && num_cross(dx-1,dx-1,0,dy-1,b,cs) != 1 ) break;
      if( loop(b,dx-1,dy-1-dy/8,dx,cs,0,LE)+dx/8+1  // Jul00
        < loop(b,   0,dy-1-dy/8,dx,cs,0,RI) ) break;
      for(y=0,x=dx/4;x<dx-dx/4;x++){  // search deepest point
        i=loop(b,x,0,dy,cs,0,DO); if(i>y) y=i;
      } if( y>10*dy/16 || y<2*dy/8 ) break;
//      out_x(box1);
      //
      // a   b
      //  \ /
      //   c
      //  ed
      for(xc=xb=xa=dx,yc=yb=ya=y=0;y<dy/4;y++){
        x =loop(b,   0  ,       y,dx,cs,0,RI); if(x<xa){ xa=x;ya=y; }
        x =loop(b,dx-1  ,       y,dx,cs,0,LE); if(x<xb){ xb=x;yb=y; }
      }
      if(yb>dy/8) break;
      for(xc=dx,yc=y=dy/4;y<3*dy/4;y++){
        if( num_cross(0,dx-1,y,y,b,cs) < 2 ) break;
        x =loop(b,dx-1  ,y,dx,cs,0,LE);
        x+=loop(b,dx-1-x,y,dx,cs,1,LE);
        x =loop(b,dx-1-x,y,dx,cs,0,LE); if(x<=xc){ xc=x;yc=y; }
      }
      xa+=    loop(b,xa  ,ya,dx,cs,1,RI)/2;
      xb=dx-1-loop(b,dx-1,yb,dx,cs,1,LE)/2;
      x =     loop(b,dx-1  ,yc,dx,cs,0,LE);
      x+=     loop(b,dx-1-x,yc,dx,cs,1,LE);
      xc=dx-1-x-loop(b,dx-1-x,yc,dx,cs,0,LE)/4; yc++; yc+=dy/16;
      yd=dy-1-dy/8;xd=dx-1-loop(b,dx-1,yd,dx,cs,0,LE); if(xd>6*dx/8) break;
// printf(" abcd=%d %d %d %d %d %d %d %d -\n",xa,ya,xb,yb,xc,yc,xd,yd);
      if( get_line2(xa,ya,xc  ,yc,b,cs,100)<95
       && get_line2(xa,ya,xc-1,yc,b,cs,100)<95 ) break;
      if( get_line2(xb,yb,xc  ,yc,b,cs,100)<95
       && get_line2(xb,yb,xc-1,yc,b,cs,100)<95 ) break;
      if( get_line2(xc,yc,xd,yd,b,cs,100)<95 ) break;

      // decission between vV and Y is sometimes very difficult
      // hope that the following code is the ultimate solution
      if( yc>=5*dy/8 && !gchar)
      if( get_line2(xa,ya,xd  ,yd,b,cs,100)>95 )
      if( get_line2(xb,yb,xd  ,yd,b,cs,100)>95 )
      break; // ~V
      xa=loop(b,0,   1,dx,cs,0,RI);
      xb=loop(b,0,dy/2,dx,cs,0,RI);
      xc=loop(b,0,dy-1,dx,cs,0,RI);
      if( 2*xb<=xa+xc+1 ) break; // ~V

      if(gchar && !hchar) return 'y'; 
      if(y0<box1->m2-(box1->m2-box1->m1)/4 && !gchar) return 'Y';
      bc='y'; // SMALL-CAPS ???
      break;
   }
   // --- test z -------
   for(d=100;dx>3 && dy>3;){     // dy>dx
      if( get_bw(0        ,dx/8,dy/2,dy/2,b,cs,1) == 1 ) break;
      if( get_bw(dx-1-dx/8,dx-1,dy/2,dy/2,b,cs,1) == 1 ) break;
      if( get_bw(0        ,dx/4,0   ,dy/4,b,cs,1) != 1 ) break;
      if( get_bw(dx-1-dx/4,dx-1,0   ,dy/4,b,cs,1) != 1 ) break;
      if( get_bw(0        ,dx/4,dy-1-dy/4,dy-1,b,cs,1) != 1 ) break;
      if( get_bw(dx-1-dx/4,dx-1,dy-1-dy/4,dy-1,b,cs,1) != 1 ) break;
      if( get_bw(dx/3,dx-1-dx/3,     dy/2,dy/2,b,cs,1) != 1 ) break;
      if( dx<5 && num_cross(1   ,   1,0,dy-1,b,cs) != 2 ) break;
      if( dx>8 && num_cross(dx/2,dx/2,0,dy-1,b,cs) != 3 ) break;
      if(  num_cross(0   ,dx-1,dy/2+1,dy/2-1,b,cs) != 1 ) break;
//    out_x(box1);fprintf(stderr," z:");
      for( i=1,x=0;x<=dx/2 && i;x++ ){
        if( get_bw(x0+dx/3+x,x0+dx/3+x,y0     ,y0+dy/5,box1->p,cs,1) == 0 ) i=0;
        if( get_bw(x0+dx/8+x,x0+dx/8+x,y1-dy/5,y1     ,box1->p,cs,1) == 0 ) i=0;
      } if( !i ) break;
      // --- line from left down to right up 0003
      for(y=dy/8;y<dy-dy/8;y++){ x=dx-1-dx*y/dy;  // straight line ? 
        if( get_bw(x-dx/8,x+dx/8,y,y,b,cs,1)!=1 ) break; // pixel around ?
      } if(y<dy-dy/8) break;
      if(  loop(b,b->x-1,dy/16,dx,cs,0,LE)
         > loop(b,b->x-1,dy/ 8,dx,cs,0,LE)+(dx+16)/32 ) break; // ~2
      x=x0,y=y1;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,UP,ST); if( y<y1-dy/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,UP);	//
      if( x<x0+dx/2 || y>y0 ) break;		// upper right edge?
      // --- vertikal line at right end
      x=x1,y=y0+dy/4;	// horizontal line can be very thick on tt-font
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,LE,ST); if( x<x1-  dx/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,LE); if( x<x1-5*dx/8 ) break;
      // --- vertikal line at left end
      x=x0,y=y1-dy/4;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,RI,ST); if( x>x0+  dx/3 ) break;
      turmite(box1->p,&x,&y,x0,x1,y0,y1,cs,ST,RI); if( x>x0+5*dx/8 ) break;

      // test ob rechte Kante ansteigend
      for(x=dx,y=b->y-1-dy/2;y>=dy/4;y--){ // rechts abfallende Kante/Knick?
        i=loop(b,b->x-1,y,x1-x0,cs,0,LE);
        if( i-2>=x ) break; if( i<x ) x=i;
      } if (y>=dy/4 ) break; 

      if( num_hole (x0  , x1  , y0, y1,box1->p,cs) != 0 ) break; 

      if( loop(b,dx-1,  dy/ 8,dx,cs,0,LE)
        > loop(b,dx-1,5*dy/16,dx,cs,0,LE) ) break; /* ~2 */

      bc='z';
      if( hchar ) bc='Z';
      break;
   }
   // --- test ff ---------------------------------------------------
   if( bc==UNKNOWN )
   for(d=100;dx>4 && dy>6;){     // Dec00 body copied from H
      if( num_cross(0,dx-1,  dy/4 ,  dy/4 ,b,cs) != 2
       && num_cross(0,dx-1,3*dy/16,3*dy/16,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,3*dy/4  ,3*dy/4  ,b,cs) != 2
       && num_cross(0,dx-1,3*dy/4+1,3*dy/4+1,b,cs) != 2 ) break;
      if( loop(b,0   ,dy/8,dx,cs,0,RI)
        + loop(b,dx-1,dy/8,dx,cs,0,LE)>dx/2 ) break; // ~A
      for( j1=0,i=1,y=y0+dy/10; y<y1-dy/10 && i; y++ ) // 2 vertikal lines
      { j=loop(box1->p,x0  ,y,dx,cs,0,RI)
         +loop(box1->p,x1  ,y,dx,cs,0,LE);
        if( j>10*dx/16 ) i=0; if ( j>j1 ) j1=j; } 
      if( !i ) break;
      for( x=dx/4; x<dx/2; x++ ){  // lower gap
        y=loop(b,x  ,dy-1,dy,cs,0,UP);
        if ( y > 3*dy/8 ) break;
        if ( 10*y > dy ){	/* italic */
          i=loop(b,x  ,dy-y,dx,cs,0,RI);
          if( i>1 && y+loop(b,x+i-1,dy-y,dy,cs,0,UP)>3*dy/8 ) break;
        }
      } if( x>=dx/2 ) break;
      x=loop(box1->p,x0  ,y1-dy/8,dx,cs,0,RI)
       +loop(box1->p,x1  ,y1-dy/8,dx,cs,0,LE);
      for( i=1,y=dy/4; y<dy-1-dy/4 && i; y++ ) // max - min width
      { j=loop(b,0   ,y,dx,cs,0,RI)
         +loop(b,dx-1,y,dx,cs,0,LE); if( j-x>dx/5 ) i=0; } 
      if( !i ) break;   // ~K Jul00
      for( i=0,ya=y=y0+dy/4; y<y1-dy/3; y++ ) // horizontal line
      { j=loop(box1->p,x0  ,y,dx,cs,0,RI);
        j=loop(box1->p,x0+j,y,dx,cs,1,RI); if( j>i ) { i=j; ya=y; } } 
      if( i<=dx/2 ) break; ya-=y0;
      if( num_cross(0,dx-1,ya  ,ya  ,b,cs) != 1
       && num_cross(0,dx-1,ya+1,ya+1,b,cs) != 1 ) break; /* Dec00 */
      for( y=ya; y<dy-dy/4; y++ ) // ~M Dec00
      if( num_cross(0,dx-1,y  ,y  ,b,cs) > 2
       && num_cross(0,dx-1,y+1,y+1,b,cs) > 2 ) break;
      if ( y<dy-dy/4 ) break;
      for(i=1,x=x0+dx/2;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y0     ,y0+dy/4,box1->p,cs,1) == 0 ) i=0;
      } if( !i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( get_bw( x, x,y1-dy/4,y1     ,box1->p,cs,1) == 0 ) i=0;
      } if( i ) break;
      for(i=1,x=x0+dx/4;x<=x1-dx/4 && i;x++){
        if( num_cross(x,x,y0+dy/8,y1-dy/8, box1->p,cs) == 1 ) i=0;
      } if( i ) break;
      for(i=1,y=y0;y<=y0+dy/4 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      for(i=1,y=y1-dy/4;y<=y1 && i;y++){
        if( num_cross(x0,x1,y,y, box1->p,cs) == 2 ) i=0;
      } if( i ) break;
      if( get_bw(x1-dx/8, x1     , y0, y0+dy/8,box1->p,cs,1) != 1 ) break;
      if( get_bw(x0     , x0+dx/8, y1-dy/8, y1,box1->p,cs,1) != 1 ) break;
      i1=loop(b,dx-1,     dy/4,dx,cs,0,LE); if(i1>dx/2) break;
      i2=loop(b,dx-1,     dy/2,dx,cs,0,LE); if(i2<i1-dx/4 || i2>i1+dx/8) break;
      i3=loop(b,dx-1,dy-1-dy/4,dx,cs,0,LE); if(i3<i2-dx/4 || i3>i2+dx/8) break;
      if(abs(i1+i3-2*i2)>dx/16+1) break;
      if( num_hole(x0,x1,y0+dy/4,y1,box1->p,cs) != 0 ) break;
      return LATIN_SMALL_LIGATURE_FF;
   }
   // --- test ae  ---------------------------------------------------
   if( bc==UNKNOWN )
   for(d=100;dx>4 && dy>6;){     // provisorium
      if( num_cross(    0,dx-1,3*dy/16,3*dy/16,b,cs) != 3
       && num_cross(dx/10,dx-1,3*dy/16,3*dy/16,b,cs) != 3 ) break;
// out_x(box1);MM;       
      if( num_cross(0,dx-1,3*dy/ 4,3*dy/ 4,b,cs) <  2 ) break;
      if( num_cross(0,dx-1,      0,   dy-1,b,cs) <  3 ) break;
      if( num_cross(dx-1,0,      0,   dy-1,b,cs) <  3 ) break;
      if( num_cross(0,dx-1,  dy/16,  dy/16,b,cs) <  2 ) break;
      if( num_cross(0,dx-1,dy-1-dy/16,dy-1-dy/16,b,cs) <  2 ) break;
      for( x=0,i2=y=dy/4; y<3*dy/4; y++ ){
        j=loop(b,0,y,dx,cs,0,RI); if(j>x) { i2=y; x=j; }
      } if( x<dx/4 || x>3*dx/4 ) break;
      for( x=0,i4=y=dy/4; y<3*dy/4; y++ ){
        j=loop(b,dx-1,y,dx,cs,0,LE); if(j>x) { i4=y; x=j; }
      } if( x<dx/4 || x>3*dx/4 ) break;
      for( x=0,i4=y=dy/8; y<3*dy/4; y++ ){
        j=loop(b,dx-1  ,y,dx,cs,0,LE);
        j=loop(b,dx-1-j,y,dx,cs,1,LE);
        if(j>x) { i4=y; x=j; }
      } if( x<dx/4 ) break;
      if( num_hole(x0,x0+3*dx/4,y0+dy/4,y1,box1->p,cs) != 1 ) break;
      if( num_hole(x0+dx/2-1,x1,y0,y1-dy/4,box1->p,cs) != 1 ) break;
      return LATIN_SMALL_LETTER_AE;

   }
   // --- test AE  ---------------------------------------------------
   if( bc==UNKNOWN )
   for(d=100;dx>5 && dy>6;){     // provisorium
      if( num_cross(0,dx-1,3*dy/16,3*dy/16,b,cs) <  2 ) break;
      if( num_cross(0,dx-1,3*dy/ 4,3*dy/ 4,b,cs) <  2 ) break;
      if( num_cross(0,dx-1,      0,   dy-1,b,cs) <  3 ) break;
      if( num_cross(0,dx-1,  dy/16,  dy/16,b,cs) != 1 
       && num_cross(0,dx-1,  dy/32,  dy/32,b,cs) != 1
       && num_cross(0,dx-1,      0,      0,b,cs) != 1 ) break;
      for( x=dx,i1=i3=0,i2=y=dy/4; y<3*dy/4; y++ ){
        j=loop(b,     0,y,dx,cs,0,RI); if(j>x) break; x=j;
        j=loop(b,     j,y,dx,cs,1,RI); if(j>i1) { i1=j; i2=y; }
        j=loop(b,dx-1  ,y,dx,cs,0,LE);
        j=loop(b,dx-1-j,y,dx,cs,1,LE); if(j>i3) { i3=j; i4=y; }
      } if( y<3*dy/4 || i1<dx/4-1 || i3<dx/4-1) break;
      for( i1=i3=0,y=0; y<dy/8; y++ ){
        j=loop(b,dx-1  ,     y,dx,cs,0,LE);
        j=loop(b,dx-1-j,     y,dx,cs,1,LE); if(j>i1) { i1=j; }
        j=loop(b,dx-1  ,dy-1-y,dx,cs,0,LE);
        j=loop(b,dx-1-j,dy-1-y,dx,cs,1,LE); if(j>i3) { i3=j; }
      } if( i1<=dx/4 || i3<=dx/4 ) break;
      if( num_hole(x0,x0+3*dx/4,y0,y1-dy/4,box1->p,cs) != 1 ) break;
      if( num_hole(x0,       x1,y0,y1     ,box1->p,cs) != 1 ) break;
      return LATIN_CAPITAL_LETTER_AE;

   }
   // --- test /o O_WITH_STROKE -----------------------------------------
   if( bc==UNKNOWN )
   for(d=100;dx>4 && dy>4;){     // provisorium
      if( num_cross(   0,dx-1,dy/2,dy/2,b,cs) != 3 ) break;
      if( num_cross(dx/2,dx/2,   0,dy-1,b,cs) != 3 ) break;
// out_x(box1);MM;
      if( num_cross(   0,dx-1,   0,   0,b,cs) > 2 ) break;
      if( num_cross(dx/4,dx-1,   0,   0,b,cs) > 2 ) break;
      if( num_cross(   0,dx-1,dy-1,dy-1,b,cs) > 2 ) break;
      if( num_cross( 0,3*dx/4,dy-1,dy-1,b,cs) > 2 ) break;
      if( num_cross(   0,   0,   0,dy-1,b,cs) > 2 ) break;
      if( num_cross(dx-1,dx-1,   0,dy-1,b,cs) > 2 ) break;
      if( num_cross(   0,   0,dy/4,dy-1,b,cs) > 2 ) break;
      if( num_cross(dx-1,dx-1, 0,3*dy/4,b,cs) > 2 ) break;
      i1 =loop(b,dx-1   ,   0,dx,cs,0,LE); if( i1>dx/8 ) break;
      i1+=loop(b,dx-1-i1,   0,dx,cs,1,LE); if( i1>dx/4 ) break; i1=dx-1-i1;
      i2 =loop(b,      0,dy-1,dx,cs,0,RI); if( i2>dx/8 ) break;
      for(y=1;y<dy-1;y++){
        x=i1+y*(i2-i1)/dy-dx/8; if(x<0)x=0;
        j=loop(b,x,y,dx,cs,0,RI); if( j>3*dx/16 ) break;
      } if( y<dy-1 ) break;
      if( num_cross(       0 ,dx/4,dy/2,dy/2,b,cs) != 1 ) break;
      if( num_cross(dx-1-dx/4,dx-1,dy/2,dy/2,b,cs) != 1 ) break;
      if( num_cross(dx/4,dx-1-dx/4,dy/2,dy/2,b,cs) != 1 ) break;
      if( num_hole(x0,x1,y0,y1,box1->p,cs) != 2 ) break;

      if ( hchar )
      if ( 2*y0<box1->m1+box1->m2 ) return LATIN_CAPITAL_LETTER_O_WITH_STROKE;
      return LATIN_SMALL_LETTER_O_WITH_STROKE;

   }
   // --- test /c C_WITH_STROKE -----------------------------------------
   if( bc==UNKNOWN )
   for(d=100;dx>4 && dy>4;){     // provisorium
      if( num_cross(     0,dx-1,dy/2,dy/2,b,cs) != 2 ) break;
      if( num_cross(0,dx-1-dx/4,dy/2,dy/2,b,cs) != 2 ) break;
      if( num_cross(dx/2,dx/2,   0,dy-1,b,cs) != 3 ) break;
      if( num_cross(   0,dx-1,   0,   0,b,cs) > 2 ) break;
      if( num_cross(dx/4,dx-1,   0,   0,b,cs) > 2 ) break;
      if( num_cross(   0,dx-1,dy-1,dy-1,b,cs) > 2 ) break;
      if( num_cross( 0,3*dx/4,dy-1,dy-1,b,cs) > 2 ) break;
      if( num_cross(   0,   0,   0,dy-1,b,cs) > 2 ) break;
      if( num_cross(dx-1,dx-1,   0,dy-1,b,cs) > 3 ) break;
      if( num_cross(   0,   0,dy/4,dy-1,b,cs) > 2 ) break;
      if( num_cross(dx-1,dx-1, 0,3*dy/4,b,cs) > 3 ) break;
// out_x(box1);MM;       
      i1 =loop(b,dx-1   ,   0,dx,cs,0,LE); if( i1>dx/4 ) break;
      i1+=loop(b,dx-1-i1,   0,dx,cs,1,LE); if( i1>dx/4 ) break; i1=dx-1-i1;
      i2 =loop(b,      0,dy-1,dx,cs,0,RI); if( i2>dx/4 ) break;
      for(y=0;y<dy;y++){
        x=i1+y*(i2-i1)/dy;
        j=loop(b,x,y,dx,cs,0,RI); if( j>dx/8 ) break;
      } if( y<dy ) break;
      if( num_cross(       0 ,dx/4,dy/2,dy/2,b,cs) != 1 ) break;
      if( num_cross(dx-1-dx/4,dx-1,dy/2,dy/2,b,cs) != 0 ) break;
      if( num_cross(dx/4,dx-1-dx/4,dy/2,dy/2,b,cs) != 1 ) break;
      if( num_hole(x0,x1,y0,y1,box1->p,cs) != 1 ) break;

//      if ( hchar ) return compose('C','/');
//      return compose('c','/');
      return CENT_SIGN;

   }
   // --- test LETTER_C_WITH_CEDILLA  ---------------------------------------------------
   if( bc==UNKNOWN )
   if( gchar )
   for(d=100;dx>3 && dy>6;){     // provisorium
      if( num_cross(0,dx-1,3*dy/16,3*dy/16,b,cs) > 2 ) break;
      if( num_cross(0,dx-1,      0,   dy-1,b,cs) < 2 ) break;
      if( num_cross(0,dx-1,  dy/16,  dy/16,b,cs) > 2 ) break;
// out_x(box1);MM;
      for( x=dx,i2=y=dy/4; y<3*dy/4; y++ ){
        j=loop(b,0,y,dx,cs,0,RI); if(j<x) { i2=y; x=j; }
      } if( x>0 ) break; i1=x;
      for( x=0,i4=y=dy/4; y<5*dy/8; y++ ){
        j=loop(b,dx-1,y,dx,cs,0,LE); if(j>x) { i4=y; x=j; }
      } if( x<dx/2 ) break; i3=x;
      j =loop(b,dx/2,0,dy,cs,0,DO);
      j+=loop(b,dx/2,j,dy,cs,1,DO); if(j>dy/4) break;
      j =loop(b,dx/2,j,dy,cs,0,DO); if(j<dy/2) break;
      j =loop(b,dx-1    ,dy-1-dy/8,dx,cs,0,LE); if(j<dx/4 || 4*j>3*dx) break;
      j =loop(b,dx-1-j/2,dy-1-dy/8,dy,cs,0,UP); if(j>dy/2) break; // ~()
      if( num_hole(x0,x1,y0,y1,box1->p,cs) != 0 ) break;
      if( hchar ) return LATIN_CAPITAL_LETTER_C_WITH_CEDILLA;
      return LATIN_SMALL_LETTER_C_WITH_CEDILLA;

   }
   // --- test #  ---------------------------------------------------
   if( bc==UNKNOWN )
   if( ! gchar )
   for(d=100;dx>4 && dy>4;){     // provisorium
      if( num_cross(0,dx-1,     dy/8,     dy/8,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,dy-1-dy/8,dy-1-dy/8,b,cs) != 2 ) break;
      if( num_cross(0,dx-1,     dy/2,     dy/2,b,cs) != 2 ) break;
      if( num_cross(0,dx/2,     dy/2,     dy/2,b,cs) != 1 ) break;
      j=loop(b,   0,dy/8,dx,cs,0,RI); if(j<dx/8) break;
      j=loop(b,   0,dy/2,dx,cs,0,RI); if(j<dx/8 || j>=dx/2) break;
      j=loop(b,dx-1,dy/2,dx,cs,0,LE); if(j<dx/8 || j>=dx/2) break;
      j=loop(b,dx-1,dy-1,dx,cs,0,LE); if(j<dx/8) break;
      for( i1=i3=0,y=dy/4; y<dy/2; y++ ){
        j=loop(b,0,y,dx,cs,0,RI); if(j>3*dx/4) { i1=0; break; }
        j=loop(b,j,y,dx,cs,1,RI); if(j>i1) { i1=j; }
        j=loop(b,0,y,dx,cs,0,RI); if(j>3*dx/4) { i1=0; break; }
        j=loop(b,j,y,dx,cs,1,RI); if(j>i3) { i3=j; }
      } if( i1<dx-dx/8 || i3<dx-dx/8 ) break;
      if( num_hole(x0,x1,y0,y1,box1->p,cs) != 1 ) break;
      return '#';
   }
   // --- test %  ---------------------------------------------------
   if( bc==UNKNOWN )
   if( ! gchar )
   for(d=100;dx>7 && dy>7;){     // provisorium
      if( num_cross(x0,x1     ,y0+dy/4,y0+dy/4,box1->p,cs) != 3 ) break;
      if( num_cross(x0,x1+dx/4,y1-dy/4,y1-dy/4,box1->p,cs) != 3 ) break;
      if( num_cross(0,dx-1,        0,     dy-1,b,cs) != 5
       && num_cross(x0,x1+dx/4,   y0, y1,box1->p,cs) != 5 ) break;
      if( num_hole(x0     ,x1     ,y0,y1-dy/4,box1->p,cs) != 1 ) break;
      if( num_hole(x0+dx/4,x1+dx/4,y0+dy/4,y1,box1->p,cs) != 1 ) break;
      if( num_hole(x0     ,x1+dx/4,y0,y1     ,box1->p,cs) != 2 ) break;
      return '%';
   }
   if(box1->ac==UNKNOWN) box1->ac=ac;
   return bc;
}

