# system:     "Makefile template for Eiffel compilations"
# author:     "Eric Bezault <ericb@gobosoft.com>"
# copyright:  "Copyright (c) 2000, Eric Bezault and others"
# license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
# date:       "$Date: 2001/04/29 08:38:38 $"
# revision:   "$Revision: 1.4 $"


# SmallEiffel
SE_COMPILER=compile
SE_CLEAN=clean
SE_CFLAGS=-boost -no_split -no_style_warning -no_gc ${SE_PCFLAGS}
SE_DEBUG_CFLAGS=-all_check -no_split -no_style_warning -no_gc ${SE_PCFLAGS}

# ISE Eiffel
ISE_ECOMPILER=es4
ISE_FINISH_FREEZING=finish_freezing
ISE_CFLAGS=-batch -finalize
ISE_CODEGEN=F_code
ISE_FFLAGS=${ISE_PFFLAGS}
ISE_DEBUG_CFLAGS=-batch
ISE_DEBUG_CODEGEN=W_code
ISE_DEBUG_FFLAGS=${ISE_PFFLAGS}

# Halstenbach
HACT_COMPILER=ibcomp
HACT_FISH=fish
HACT_CFLAGS=-executable -finalize -new -stop
HACT_CODEGEN=F_code
HACT_FFLAGS=
HACT_DEBUG_CFLAGS=-executable -new -stop
HACT_DEBUG_CODEGEN=W_code
HACT_DEBUG_FFLAGS=

# Visual Eiffel
VE_COMPILER=vec
VE_CFLAGS=-no
VE_DEBUG_CFLAGS=-no

# Miscellaneous
TARGET_EXE=${TARGET}${EXE}
BIN_DIR=.


all: help

depend: ise.dep hact.dep

help:
	@${ECHO} 'make [ se[-debug] | ise[-debug] | hact[-debug] | ve[-debug] ]'


# SmallEiffel

se:
	${MAKE} compile-se
	${MAKE} install-se 'BIN_DIR=${BIN_DIR}'
	${MAKE} clean-se

se-debug:
	${MAKE} compile-se-debug
	${MAKE} install-se-debug 'BIN_DIR=${BIN_DIR}'
	${MAKE} clean-se-debug

compile-se: loadpath.se
	${SE_COMPILER} ${SE_CFLAGS} -o ${TARGET} ${ROOT_CLASS} ${CREATION_ROUTINE}

compile-se-debug: loadpath.se
	${SE_COMPILER} ${SE_DEBUG_CFLAGS} -o ${TARGET} ${ROOT_CLASS} ${CREATION_ROUTINE}

loadpath.se: ${ROOT_DIR}/loadpath.se
	${CP} ${ROOT_DIR}/loadpath.se loadpath.se

install-se:
	-${CP} -f ${TARGET_EXE} ${BIN_DIR}

install-se-debug:
	-${CP} -f ${TARGET_EXE} ${BIN_DIR}

clean-se:
	${SE_CLEAN} ${ROOT_CLASS}

clean-se-debug:
	${SE_CLEAN} ${ROOT_CLASS}


# ISE Eiffel

ise:
	${MAKE} compile-ise
	${MAKE} install-ise 'BIN_DIR=${BIN_DIR}'
	${MAKE} clean-ise

ise-debug:
	${MAKE} compile-ise-debug
	${MAKE} install-ise-debug 'BIN_DIR=${BIN_DIR}'
	${MAKE} clean-ise-debug

compile-ise: ise.ace
	${ISE_ECOMPILER} ${ISE_CFLAGS} -ace ise.ace
	${MAKE} ise_finish_freezing 'MAKEFLAGS='

# Problem with ${MAKEFLAGS} when compiling under
# Windows: 'nmake' (called by 'finish_freezing')
# does not recognize option --unix.
ise_finish_freezing:
	cd EIFGEN/${ISE_CODEGEN} ; ${ISE_FINISH_FREEZING} ${ISE_FFLAGS}

compile-ise-debug: ise-debug.ace
	${ISE_ECOMPILER} ${ISE_DEBUG_CFLAGS} -ace ise-debug.ace
	${MAKE} ise_finish_freezing_debug 'MAKEFLAGS='

# Problem with ${MAKEFLAGS} when compiling under
# Windows: 'nmake' (called by 'finish_freezing')
# does not recognize option --unix.
ise_finish_freezing_debug:
	cd EIFGEN/${ISE_DEBUG_CODEGEN} ; ${ISE_FINISH_FREEZING} ${ISE_DEBUG_FFLAGS}

include ise.dep

ise.ace: ${ROOT_DIR}/ise.tpl
	${ECHO} '-- *** GENERATED BY '\''make ise.ace'\'' *** --' > ise.ace
	${GEPP} ${ROOT_DIR}/ise.tpl >> ise.ace

ise-debug.ace: ${ROOT_DIR}/ise.tpl
	${ECHO} '-- *** GENERATED BY '\''make ise-debug.ace'\'' *** --' > ise-debug.ace
	${GEPP} -DASSERTION ${ROOT_DIR}/ise.tpl >> ise-debug.ace

ise.dep: ${ROOT_DIR}/ise.tpl
	${ECHO} -n 'ise.ace:' > ise.dep
	${GEPP} -M ${ROOT_DIR}/ise.tpl >> ise.dep

install-ise:
	-${CP} -f EIFGEN/${ISE_CODEGEN}/${TARGET_EXE} ${BIN_DIR}
	-${CP} -f EIFGEN/${ISE_CODEGEN}/${TARGET}.melted ${BIN_DIR}

install-ise-debug:
	-${CP} -f EIFGEN/${ISE_DEBUG_CODEGEN}/${TARGET_EXE} ${BIN_DIR}
	-${CP} -f EIFGEN/${ISE_DEBUG_CODEGEN}/${TARGET}.melted ${BIN_DIR}

clean-ise:
	-${RM} -rf EIFGEN
	-${RM} -f ${TARGET}.eif ${TARGET}.epr

clean-ise-debug:
	-${RM} -rf EIFGEN
	-${RM} -f ${TARGET}.eif ${TARGET}.epr


# Halstenbach

hact:
	${MAKE} compile-hact
	${MAKE} install-hact 'BIN_DIR=${BIN_DIR}'
	${MAKE} clean-hact

hact-debug:
	${MAKE} compile-hact-debug
	${MAKE} install-hact-debug 'BIN_DIR=${BIN_DIR}'
	${MAKE} clean-hact-debug

compile-hact: hact.ace
	${HACT_COMPILER} ${HACT_CFLAGS} -ace hact.ace -project ${TARGET}.eif
	${MAKE} hact_fish 'MAKEFLAGS='

# Problem with ${MAKEFLAGS} when compiling under
# Windows: 'nmake' (called by 'fish') does not
# recognize option --unix.
hact_fish:
	cd ${TARGET}_gen/${HACT_CODEGEN} ; ${HACT_FISH} ${HACT_FFLAGS}

compile-hact-debug: hact-debug.ace
	${HACT_COMPILER} ${HACT_DEBUG_CFLAGS} -ace hact-debug.ace -project ${TARGET}.eif
	${MAKE} hact_fish_debug 'MAKEFLAGS='

# Problem with ${MAKEFLAGS} when compiling under
# Windows: 'nmake' (called by 'fish') does not
# recognize option --unix.
hact_fish_debug:
	cd ${TARGET}_gen/${HACT_DEBUG_CODEGEN} ; ${HACT_FISH} ${HACT_DEBUG_FFLAGS}

include hact.dep

hact.ace: ${ROOT_DIR}/hact.tpl
	${ECHO} '-- *** GENERATED BY '\''make hact.ace'\'' *** --' > hact.ace
	${GEPP} ${ROOT_DIR}/hact.tpl >> hact.ace

hact-debug.ace: ${ROOT_DIR}/hact.tpl
	${ECHO} '-- *** GENERATED BY '\''make hact-debug.ace'\'' *** --' > hact-debug.ace
	${GEPP} -DASSERTION ${ROOT_DIR}/hact.tpl >> hact-debug.ace

hact.dep: ${ROOT_DIR}/hact.tpl
	${ECHO} -n 'hact.ace:' > hact.dep
	${GEPP} -M ${ROOT_DIR}/hact.tpl >> hact.dep

install-hact:
	-${CP} -f ${TARGET}_gen/${HACT_CODEGEN}/${TARGET_EXE} ${BIN_DIR}
	-${CP} -f ${TARGET}_gen/${HACT_CODEGEN}/${TARGET}.h2o ${BIN_DIR}

install-hact-debug:
	-${CP} -f ${TARGET}_gen/${HACT_DEBUG_CODEGEN}/${TARGET_EXE} ${BIN_DIR}
	-${CP} -f ${TARGET}_gen/${HACT_DEBUG_CODEGEN}/${TARGET}.h2o ${BIN_DIR}

clean-hact:
	-${RM} -rf ${TARGET}_gen
	-${RM} -f ${TARGET}.eif

clean-hact-debug:
	-${RM} -rf ${TARGET}_gen
	-${RM} -f ${TARGET}.eif


# Visual Eiffel

ve:
	${MAKE} compile-ve
	${MAKE} install-ve 'BIN_DIR=${BIN_DIR}'
	${MAKE} clean-ve

ve-debug:
	${MAKE} compile-ve-debug
	${MAKE} install-ve-debug 'BIN_DIR=${BIN_DIR}'
	${MAKE} clean-ve-debug

compile-ve: ve.esd
	${VE_COMPILER} ${VE_CFLAGS} -a:ve.esd

compile-ve-debug: ve.esd
	${VE_COMPILER} ${VE_DEBUG_CFLAGS} -a:ve.esd

ve.esd: ${ROOT_DIR}/ve.esd
	${CP} ${ROOT_DIR}/ve.esd ve.esd

install-ve:
	-${CP} -f ${TARGET_EXE} ${BIN_DIR}

install-ve-debug:
	-${CP} -f ${TARGET_EXE} ${BIN_DIR}

clean-ve:
	${VE_COMPILER} -eu -y -no

clean-ve-debug:
	${VE_COMPILER} -eu -y -no
