indexing

	description:

		"Scanners for Lace parsers"

	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 1999, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2001/03/18 12:56:30 $"
	revision:   "$Revision: 1.3 $"

class ET_LACE_SCANNER

inherit

	ET_LACE_SCANNER_SKELETON

creation

	make

feature -- Status report

	valid_start_condition (sc: INTEGER): BOOLEAN is
			-- Is `sc' a valid start condition?
		do
			Result := (INITIAL <= sc and sc <= IN_STR)
		end

feature {NONE} -- Implementation

	yy_build_tables is
			-- Build scanner tables.
		do
			yy_nxt ?= yy_nxt_template
			yy_chk ?= yy_chk_template
			yy_base ?= yy_base_template
			yy_def ?= yy_def_template
			yy_ec ?= yy_ec_template
			yy_meta ?= yy_meta_template
			yy_accept ?= yy_accept_template
		end

	yy_execute_action (yy_act: INTEGER) is
			-- Execute semantic action.
		do
if yy_act <= 27 then
if yy_act <= 14 then
if yy_act <= 7 then
if yy_act <= 4 then
if yy_act <= 2 then
if yy_act = 1 then
--|#line 32
-- Ignore separators
else
--|#line 33
eif_lineno := eif_lineno + text_count
end
else
if yy_act = 3 then
--|#line 38
-- Ignore comments
else
--|#line 39
eif_lineno := eif_lineno + 1
end
end
else
if yy_act <= 6 then
if yy_act = 5 then
--|#line 44
last_token := Semicolon_code
else
--|#line 45
last_token := Colon_code
end
else
--|#line 46
last_token := Comma_code
end
end
else
if yy_act <= 11 then
if yy_act <= 9 then
if yy_act = 8 then
--|#line 47
last_token := Left_parenthesis_code
else
--|#line 48
last_token := Right_parenthesis_code
end
else
if yy_act = 10 then
--|#line 53
last_token := L_ABSTRACT
else
--|#line 54
last_token := L_ALL
end
end
else
if yy_act <= 13 then
if yy_act = 12 then
--|#line 55
last_token := L_CLUSTER
else
--|#line 56
last_token := L_DEFAULT
end
else
--|#line 57
last_token := L_END
end
end
end
else
if yy_act <= 21 then
if yy_act <= 18 then
if yy_act <= 16 then
if yy_act = 15 then
--|#line 58
last_token := L_EXCLUDE
else
--|#line 59
last_token := L_EXTERNAL
end
else
if yy_act = 17 then
--|#line 60
last_token := L_OPTION
else
--|#line 61
last_token := L_ROOT
end
end
else
if yy_act <= 20 then
if yy_act = 19 then
--|#line 62
last_token := L_SYSTEM
else
--|#line 67

				last_token := L_IDENTIFIER
				last_value := new_identifier (text)
			
end
else
--|#line 75

				last_token := L_STRING
				last_value := new_identifier (text_substring (2, text_count - 1))
			
end
end
else
if yy_act <= 24 then
if yy_act <= 23 then
if yy_act = 22 then
--|#line 79

				if text_count > 1 then
					eif_buffer.append_string (text_substring (2, text_count))
				end
				set_start_condition (IN_STR)
			
else
--|#line 85
eif_buffer.append_string (text)
end
else
--|#line 86
eif_buffer.append_character ('%A')
end
else
if yy_act <= 26 then
if yy_act = 25 then
--|#line 87
eif_buffer.append_character ('%B')
else
--|#line 88
eif_buffer.append_character ('%C')
end
else
--|#line 89
eif_buffer.append_character ('%D')
end
end
end
end
else
if yy_act <= 40 then
if yy_act <= 34 then
if yy_act <= 31 then
if yy_act <= 29 then
if yy_act = 28 then
--|#line 90
eif_buffer.append_character ('%F')
else
--|#line 91
eif_buffer.append_character ('%H')
end
else
if yy_act = 30 then
--|#line 92
eif_buffer.append_character ('%L')
else
--|#line 93
eif_buffer.append_character ('%N')
end
end
else
if yy_act <= 33 then
if yy_act = 32 then
--|#line 94
eif_buffer.append_character ('%Q')
else
--|#line 95
eif_buffer.append_character ('%R')
end
else
--|#line 96
eif_buffer.append_character ('%S')
end
end
else
if yy_act <= 37 then
if yy_act <= 36 then
if yy_act = 35 then
--|#line 97
eif_buffer.append_character ('%T')
else
--|#line 98
eif_buffer.append_character ('%U')
end
else
--|#line 99
eif_buffer.append_character ('%V')
end
else
if yy_act <= 39 then
if yy_act = 38 then
--|#line 100
eif_buffer.append_character ('%%')
else
--|#line 101
eif_buffer.append_character ('%'')
end
else
--|#line 102
eif_buffer.append_character ('%"')
end
end
end
else
if yy_act <= 47 then
if yy_act <= 44 then
if yy_act <= 42 then
if yy_act = 41 then
--|#line 103
eif_buffer.append_character ('%(')
else
--|#line 104
eif_buffer.append_character ('%)')
end
else
if yy_act = 43 then
--|#line 105
eif_buffer.append_character ('%<')
else
--|#line 106
eif_buffer.append_character ('%>')
end
end
else
if yy_act <= 46 then
if yy_act = 45 then
--|#line 107

			code_ := text_substring (3, text_count - 1).to_integer
			if (code_ > Platform.Maximum_character_code) then
				last_token := L_STRERR
				set_start_condition (INITIAL)
			else
				eif_buffer.append_character (INTEGER_.to_character (code_))
			end
		
else
--|#line 120
eif_lineno := eif_lineno + 1
end
else
--|#line 121

			last_token := L_STRING
			if text_count > 1 then
				eif_buffer.append_string (text_substring (1, text_count - 1))
			end
			str_ := STRING_.make (eif_buffer.count)
			str_.append_string (eif_buffer)
			eif_buffer.wipe_out
			last_value := new_identifier (str_)
			set_start_condition (INITIAL)
		
end
end
else
if yy_act <= 50 then
if yy_act <= 49 then
if yy_act = 48 then
--|#line 134
eif_buffer.append_character (text_item (2))
else
--|#line 136
	-- Catch-all rules (no backing up)
							last_token := L_STRERR
							set_start_condition (INITIAL)
						
end
else
--|#line 137
	-- Catch-all rules (no backing up)
							last_token := L_STRERR
							set_start_condition (INITIAL)
						
end
else
if yy_act <= 52 then
if yy_act = 51 then
--|#line 138
	-- Catch-all rules (no backing up)
							last_token := L_STRERR
							set_start_condition (INITIAL)
						
else
--|#line 148
last_token := text_item (1).code
end
else
--|#line 0
last_token := yyError_token
fatal_error ("scanner jammed")
end
end
end
end
end
		end

	yy_execute_eof_action (yy_sc: INTEGER) is
			-- Execute EOF semantic action.
		do
			inspect yy_sc
when 0 then
--|#line 0
terminate
when 1 then
--|#line 0
	-- Catch-all rules (no backing up)
							last_token := L_STRERR
							set_start_condition (INITIAL)
						
			else
				terminate
			end
		end

feature {NONE} -- Table templates

	yy_nxt_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    6,    7,    8,    9,    6,    6,   10,   11,   12,
			   13,    6,    6,   14,   15,    6,    6,   16,   17,   18,
			   19,   20,   17,   17,   17,   17,   17,   17,   17,   21,
			   17,   17,   22,   23,   17,   17,   17,   17,   17,    6,
			   16,   17,   18,   19,   17,   17,   17,   22,   23,   17,
			   17,   25,   26,   27,   25,   26,   27,   34,   36,   71,
			   38,   73,   72,   47,   78,   35,   82,   80,   84,   39,
			   81,   47,   81,   47,   71,   33,   73,   36,   38,   78,
			   34,   72,   80,   84,   35,   45,   46,   47,   48,   49,
			   50,   51,   52,   45,   45,   53,   45,   45,   45,   54,

			   55,   56,   57,   58,   59,   45,   60,   45,   61,   45,
			   62,   45,   63,   45,   45,   64,   65,   66,   67,   68,
			   69,   45,   45,   45,   45,   45,   45,   45,   45,   45,
			   45,   45,   45,   45,   45,   74,   75,   76,   85,   86,
			   90,   91,   87,   92,   83,  100,  110,  103,   93,   94,
			   95,   96,   77,   85,   97,   90,   91,   74,  102,   75,
			   76,   87,   86,   93,   94,   95,   96,   77,  100,   97,
			  103,  104,  105,  107,  111,  106,  108,  102,  109,  112,
			  113,   24,   24,   24,   30,   43,   30,   43,  101,  104,
			  105,  108,   99,  109,  112,   98,  107,  111,   89,  113,

			   32,   32,   32,   88,   70,   83,   44,   79,   70,   31,
			   29,   28,   44,   42,   41,   40,   37,   32,   31,   29,
			   28,  114,    5,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114>>)
		end

	yy_chk_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    3,    3,    3,    4,    4,    4,   16,   18,   34,
			   20,   36,   35,   47,   40,   16,   47,   42,   71,   20,
			   46,   46,   81,   81,   34,  117,   36,   18,   20,   40,
			   16,   35,   42,   71,   16,   27,   27,   27,   27,   27,
			   27,   27,   27,   27,   27,   27,   27,   27,   27,   27,

			   27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
			   27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
			   27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
			   27,   27,   27,   27,   27,   37,   38,   39,   73,   74,
			   79,   80,   76,   83,   83,   93,  103,   96,   84,   85,
			   86,   87,   39,   73,   88,   79,   80,   37,   95,   38,
			   39,   76,   74,   84,   85,   86,   87,   39,   93,   88,
			   96,   97,   98,  100,  104,   99,  101,   95,  102,  107,
			  111,  115,  115,  115,  116,  118,  116,  118,   94,   97,
			   98,  101,   91,  102,  107,   89,  100,  104,   78,  111,

			  119,  119,  119,   77,   70,   53,   43,   41,   32,   30,
			   29,   28,   24,   23,   22,   21,   19,   13,    9,    8,
			    7,    5,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114>>)
		end

	yy_base_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,   48,   51,  221,  222,  218,  216,  214,
			  222,  222,  222,  207,  222,  222,   39,    0,   32,  195,
			   32,  185,  185,  175,  208,  222,  222,   84,  209,  207,
			  205,  222,  205,    0,   26,   36,   26,  113,  116,  118,
			   30,  178,   34,  202,  222,  222,   68,   61,  222,  222,
			  222,  222,  222,  193,  222,  222,  222,  222,  222,  222,
			  222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
			  202,   34,    0,  105,  122,    0,  116,  182,  173,  106,
			  107,   70,  222,  132,  116,  115,  115,  116,  122,  166,
			    0,  171,  222,  128,  167,  132,  127,  143,  144,  148,

			  154,  144,  144,  125,  157,    0,    0,  145,    0,    0,
			    0,  154,    0,    0,  222,  180,  183,   72,  184,  199>>)
		end

	yy_def_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,  114,    1,  115,  115,  114,  114,  114,  114,  116,
			  114,  114,  114,  114,  114,  114,  117,  117,  117,  117,
			  117,  117,  117,  117,  118,  114,  114,  114,  114,  114,
			  116,  114,  119,  117,  117,  117,  117,  117,  117,  117,
			  117,  117,  117,  118,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
			  114,  117,  117,  117,  117,  117,  117,  117,  117,  117,
			  117,  114,  114,  114,  117,  117,  117,  117,  117,  117,
			  117,  117,  114,  117,  117,  117,  117,  117,  117,  117,

			  117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
			  117,  117,  117,  117,    0,  114,  114,  114,  114,  114>>)
		end

	yy_ec_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    2,
			    3,    1,    1,    2,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    2,    1,    4,    1,    1,    5,    1,    6,
			    7,    8,    1,    1,    9,   10,    1,   11,   12,   12,
			   12,   12,   12,   12,   12,   12,   12,   12,   13,   14,
			   15,    1,   16,    1,    1,   17,   18,   19,   20,   21,
			   22,   23,   24,   25,   23,   23,   26,   27,   28,   29,
			   30,   31,   32,   33,   34,   35,   36,   23,   37,   38,
			   23,    1,    1,    1,    1,   39,    1,   40,   41,   42,

			   43,   21,   44,   23,   23,   25,   23,   23,   45,   27,
			   46,   29,   30,   23,   47,   48,   49,   50,   23,   23,
			   37,   38,   23,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1>>)
		end

	yy_meta_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    2,    1,    2,    1,    1,    1,    1,
			    1,    1,    3,    1,    1,    1,    1,    3,    3,    3,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
			    3>>)
		end

	yy_accept_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,    0,    0,   54,   52,    1,    2,   22,
			    8,    9,    7,   52,    6,    5,   20,   20,   20,   20,
			   20,   20,   20,   20,   23,   49,   47,   49,    1,    2,
			   22,   21,    3,   20,   20,   20,   20,   20,   20,   20,
			   20,   20,   20,   23,   47,   48,   48,   50,   40,   38,
			   39,   41,   42,   48,   43,   44,   24,   25,   26,   27,
			   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
			    4,   20,   11,   20,   20,   14,   20,   20,   20,   20,
			   20,    0,   46,   51,   20,   20,   20,   20,   20,   20,
			   18,   20,   45,   20,   20,   20,   20,   20,   20,   20,

			   20,   20,   20,   20,   20,   17,   19,   20,   12,   13,
			   15,   20,   10,   16,    0>>)
		end

feature {NONE} -- Constants

	yyJam_base: INTEGER is 222
			-- Position in `yy_nxt'/`yy_chk' tables
			-- where default jam table starts

	yyJam_state: INTEGER is 114
			-- State id corresponding to jam state

	yyTemplate_mark: INTEGER is 115
			-- Mark between normal states and templates

	yyNull_equiv_class: INTEGER is 1
			-- Equivalence code for NULL character

	yyReject_used: BOOLEAN is false
			-- Is `reject' called?

	yyVariable_trail_context: BOOLEAN is false
			-- Is there a regular expression with
			-- both leading and trailing parts having
			-- variable length?

	yyReject_or_variable_trail_context: BOOLEAN is false
			-- Is `reject' called or is there a
			-- regular expression with both leading
			-- and trailing parts having variable length?

	yyNb_rules: INTEGER is 53
			-- Number of rules

	yyEnd_of_buffer: INTEGER is 54
			-- End of buffer rule code

	yyLine_used: BOOLEAN is false
			-- Are line and column numbers used?

	yyPosition_used: BOOLEAN is false
			-- Is `position' used?

	INITIAL: INTEGER is 0
	IN_STR: INTEGER is 1
			-- Start condition codes

feature -- User-defined features



end -- class ET_LACE_SCANNER
