package antlr;

/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.3.0 MageLang Institute, 1998
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.3.0 MageLang Institute, 1998
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */
class ObjcCharFormatter implements CharFormatter {


	/** Given a character value, return a string representing the character
	 * that can be embedded inside a string literal or character literal
	 * This works for Java/C/C++ code-generation and languages with compatible
	 * special-character-escapment.
	 * Code-generators for languages should override this method.
	 * @param c   The character of interest.
	 * @param forCharLiteral  true to escape for char literal, false for string literal
	 */
	public String escapeChar(int c, boolean forCharLiteral)
	{
		switch (c)
			{
			case '\n':
				return "\\n";
			case '\t' :
				return "\\t";
			case '\r' :
				return "\\r";
			case '\\' :
				return "\\\\";
			case '\'' :
				return forCharLiteral ? "\\'" : "'";
			case '"' : 
				return forCharLiteral ? "\"" : "\\\"";
			default :
				if ( c<' '|| c>126 )
					{
						if (c > 255)
							{
								//return "\\u" + Integer.toString(c,16);
								return "0x"+Integer.toString(c,16);
							}
						else
							{
								//return "\\" + Integer.toString(c,8);
								return "0x"+Integer.toString(c,16);
							};
					}
				else
					{
						return String.valueOf((char)c);
					};
			};
	};
	/** Converts a String into a representation that can be use as a literal
	 * when surrounded by double-quotes.
	 * @param s The String to be changed into a literal
	 */
	public String escapeString(String s)
	{
		String retval = new String();
		for (int i = 0; i < s.length(); i++)
			{
				retval += escapeChar(s.charAt(i), false);
			}
		return retval;
	}
	/** Given a character value, return a string representing the character
	 * literal that can be recognized by the target language compiler.
	 * This works for languages that use single-quotes for character literals.
	 * Code-generators for languages should override this method.
	 * @param c   The character of interest.
	 */
	public String literalChar(int c)
	{
		//return "((unichar)('"  + escapeChar(c, true) + "'))";
		switch (c)
			{
			case '\n':
			case '\t' :
			case '\r' :
			case '\\' :
			case '\'' :
			case '"' : 
				return "((unichar)('"  + escapeChar(c, true) + "'))";
			default :
				if ( c<' '|| c>126 )
					return "((unichar)("  + escapeChar(c, true) + "))";
				else
					return "((unichar)('"  + escapeChar(c, true) + "'))";
			};
	}
	/** Converts a String into a string literal
	 * This works for languages that use double-quotes for string literals.
	 * Code-generators for languages should override this method.
	 * @param s The String to be changed into a literal
	 */
	public String literalString(String s)
	{
		return "\"" + escapeString(s) + "\"";
	}
}
