#
# Copyright 2010 Free Software Foundation, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from xml.dom import minidom

def make_set_simd(dom, machines) :
    tempstring = "";
    tempstring = tempstring +'dnl this file is auto generated by volk_register.py\n\n';

    tempstring = tempstring +'\ndnl define arch checks\n';
    for domarch in dom:
        if str(domarch.attributes["type"].value) != "all":
            arch = str(domarch.attributes["name"].value);
            flag = domarch.getElementsByTagName("flag");
            flag = str(flag[0].firstChild.data);
            tempstring = tempstring + "AC_DEFUN([_TRY_ADD_" + arch.swapcase() + "],\n";
            tempstring = tempstring + "[\n";
            tempstring = tempstring + "  LF_CHECK_CC_FLAG([-" + flag + "])\n";
            tempstring = tempstring + "  LF_CHECK_CXX_FLAG([-" + flag + "])\n";
            tempstring = tempstring + "])\n";

    tempstring = tempstring +'\ndnl main set_simd_flags\n';
    tempstring = tempstring + "AC_DEFUN([LV_SET_SIMD_FLAGS],\n";
    tempstring = tempstring + "[\n";
    #tempstring = tempstring + "  AC_REQUIRE([GR_SET_MD_CPU])\n";
    tempstring = tempstring + "  AC_SUBST(LV_CXXFLAGS)\n";
    tempstring = tempstring + "  indCC=no\n";
    tempstring = tempstring + "  indCXX=no\n";
    tempstring = tempstring + "  indLV_ARCH=no\n";
    tempstring = tempstring + "  AC_ARG_WITH(lv_arch,\n";
    tempstring = tempstring + "    AC_HELP_STRING([--with-lv_arch=ARCH],[set volk hardware speedups as space separated string with elements from the following list(";
    
    for domarch in dom:
        arch = str(domarch.attributes["name"].value);
        tempstring = tempstring + arch + ", "
    tempstring = tempstring[0:len(tempstring) - 2];
        
    tempstring = tempstring + ")]),\n";
    tempstring = tempstring + "      [cf_with_lv_arch=\"$withval\"],\n";
    tempstring = tempstring + "      [cf_with_lv_arch=\"\"])\n";
    if str(domarch.attributes["type"].value) == "all":
        arch = str(domarch.attributes["name"].value);    
        tempstring = tempstring + "  AC_DEFINE(LV_MAKE_" + arch.swapcase() + ", 1, [always set "+ arch + "!])\n";
    tempstring = tempstring + "  ADDONS=\"\"\n";
    tempstring = tempstring + "  BUILT_ARCHS=\"\"\n";
    #tempstring = tempstring + "  _MAKE_FAKE_PROCCPU\n";
    tempstring = tempstring + "  OVERRULE_FLAG=\"no\"\n";
    tempstring = tempstring + "  if test -z \"$cf_with_lv_arch\"; then\n";
    tempstring = tempstring + "    cf_with_lv_arch=\"";
    for domarch in dom:
        arch = str(domarch.attributes["name"].value);
        tempstring = tempstring + arch + " ";
    tempstring = tempstring[0:-1] + "\"\n";
    tempstring = tempstring + "    OVERRULE_FLAG=\"yes\"\n";
    tempstring = tempstring + "  fi\n";
    
    tempstring = tempstring +'\ndnl init LV_MAKE_XXX and then try to add archs\n';
    for domarch in dom:
        if str(domarch.attributes["type"].value) != "all":
            arch = str(domarch.attributes["name"].value);
            tempstring = tempstring + "  LV_MAKE_" + arch.swapcase() + "=no\n";

    for domarch in dom:
        arch = str(domarch.attributes["name"].value);
        atype = str(domarch.attributes["type"].value);
        if atype != "all":
            tempstring = tempstring + "  _TRY_ADD_" + arch.swapcase() + "\n";

    for domarch in dom:
        arch = str(domarch.attributes["name"].value);
        atype = str(domarch.attributes["type"].value);
        tempstring = tempstring +'\ndnl add in flags for arch ' + arch + '\n';
        overrule = domarch.getElementsByTagName("overrule");
        if overrule:
            overrule = str(overrule[0].firstChild.data);
        else:
            overrule = "";
        overrule_val = domarch.getElementsByTagName("overrule_val");
        if overrule_val:
            overrule_val = str(overrule_val[0].firstChild.data);
        else:
            overrule_val = "";
        flag = domarch.getElementsByTagName("flag");
        flag = str(flag[0].firstChild.data);
        if atype != "all":
            tempstring = tempstring + "  for i in $lf_CXXFLAGS\n"
            tempstring = tempstring + "  do\n"
            tempstring = tempstring + "    if test \"X$i\" = X-" + flag +"; then\n";
            tempstring = tempstring + "      indCXX=yes\n";
            tempstring = tempstring + "    fi\n"
            tempstring = tempstring + "  done\n"
            tempstring = tempstring + "  for i in $lf_CFLAGS\n"
            tempstring = tempstring + "  do\n"
            tempstring = tempstring + "    if test \"X$i\" = X-" + flag +"; then\n";
            tempstring = tempstring + "      indCC=yes\n";
            tempstring = tempstring + "    fi\n"
            tempstring = tempstring + "  done\n"
            tempstring = tempstring + "  for i in $cf_with_lv_arch\n"
            tempstring = tempstring + "  do\n"
            tempstring = tempstring + "    if test \"X$i\" = X" + arch + "; then\n";
            tempstring = tempstring + "      indLV_ARCH=yes\n"
            tempstring = tempstring + "    fi\n"
            tempstring = tempstring + "  done\n"
            tempstring = tempstring + "  if  test -n \"" + overrule + "\" && test \"$" + overrule + "\" == \"" + overrule_val + "\" && test \"$OVERRULE_FLAG\" == \"yes\" && test \"$indLV_ARCH\" == \"yes\"; then\n"
            tempstring = tempstring + "    indLV_ARCH=no\n"
            tempstring = tempstring + "  fi\n"
            
            tempstring = tempstring + "  if test \"$indCC\" == \"yes\" && test \"$indCXX\" == \"yes\" && test \"$indLV_ARCH\" == \"yes\"; then\n"        
            
            #tempstring = tempstring + "    ADDONS=\"${ADDONS} -" + flag + "\"\n";
            tempstring = tempstring + "    BUILT_ARCHS=\"${BUILT_ARCHS} " + arch + "\"\n";
            tempstring = tempstring + "    LV_MAKE_" + arch.swapcase() + "=yes\n";
            tempstring = tempstring + "  fi\n"
            tempstring = tempstring + "  indCC=no\n"
            tempstring = tempstring + "  indCXX=no\n"
            tempstring = tempstring + "  indLV_ARCH=no\n"
        else:
            tempstring = tempstring + "  for i in $cf_with_lv_arch\n"
            tempstring = tempstring + "  do\n"
            tempstring = tempstring + "    if test \"X$i\" = X" + arch + "; then\n";
            tempstring = tempstring + "      indLV_ARCH=yes\n"
            tempstring = tempstring + "    fi\n"
            tempstring = tempstring + "  done\n"
            tempstring = tempstring + "  if  test -n \"" + overrule + "\" && test \"$" + overrule + "\" == \"" + overrule_val + "\" && test \"$OVERRULE_FLAG\" == \"yes\" && test \"$indLV_ARCH\" == \"yes\"; then\n"
            tempstring = tempstring + "    indLV_ARCH=no\n"
            tempstring = tempstring + "  fi\n"
            tempstring = tempstring + "  if test \"$indLV_ARCH\" == \"yes\"; then\n"        
            tempstring = tempstring + "    LV_MAKE_" + arch.swapcase() + "=yes\n";
            tempstring = tempstring + "    BUILT_ARCHS=\"${BUILT_ARCHS} " + arch + "\"\n";
            tempstring = tempstring + "  fi\n"
            tempstring = tempstring + "  indLV_ARCH=no\n"
            

    for domarch in dom:
        arch = str(domarch.attributes["name"].value);
        tempstring = tempstring + "  AM_CONDITIONAL(LV_MAKE_" + arch.swapcase() + ", test \"$LV_MAKE_" + arch.swapcase() + "\" == \"yes\")\n";
    
    tempstring += "\n"
    #now we can define the machines we're compiling
    for machine_name in machines:
        tempstring += "  AM_CONDITIONAL(LV_MACHINE_" + machine_name.swapcase() + ", "
        marchlist = machines[machine_name]
        for march in marchlist:
            tempstring += "test \"$LV_MAKE_" + march.swapcase() + "\" == \"yes\" && "
            
        tempstring += "test true)\n" #just so we don't have to detect the last one in the group, i know
    tempstring = tempstring + "  LV_CXXFLAGS=\"${LV_CXXFLAGS} ${ADDONS}\"\n"
    tempstring = tempstring + "])\n"
   
    return tempstring;

        
