/*
**  GNUMail+TaskManager.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_GNUMail_TaskManager
#define _GNUMail_H_GNUMail_TaskManager

#include "GNUMail.h"
#include "Task.h"

#include <Foundation/NSString.h>

@class MailWindowController;
@class URLName;

//
// TaskManager related methods
//
@interface GNUMail (TaskManager)

- (void) addTask: (Task *) theTask;
- (void) removeTask: (Task *) theTask;

- (NSArray *) allTasks;

- (void) authenticationFailed: (NSDictionary *) theDictionary;

- (void) checkForNewMail: (id) theSender
              controller: (MailWindowController *) theMailWindowController;

- (void) consoleWindowNeedsDisplay;

- (Task *) currentTask;

- (void) runAlertPanel: (NSDictionary *) theDictionary;

- (Task *) nextTask;

- (NSString *) passwordForKey: (id) theKey
                         type: (int) theType;

- (void) startTaskManager;
- (void) startTimer;
- (void) stopTaskManager;
- (void) stopTimer;

- (void) taskCompleted;

- (void) updateStatusLabelWithMessage: (NSString *) theString;

@end

#endif // _GNUMail_H_GNUMail_TaskManager
