/*
**  RAWSourceWindowController.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "RAWSourceWindowController.h"

#import "GNUMailConstants.h"

#ifndef MACOSX
#import "RAWSourceWindow.h"
#endif

@implementation RAWSourceWindowController

- (id) initWithWindowNibName: (NSString *) windowNibName
{
#ifdef MACOSX
  
  self = [super initWithWindowNibName: windowNibName];
  
#else
  RAWSourceWindow *rawSourceWindow;

  rawSourceWindow = [[RAWSourceWindow alloc] initWithContentRect:NSMakeRect(100,100,500,250)
					     styleMask: (NSTitledWindowMask
							 | NSClosableWindowMask
							 | NSResizableWindowMask)
					     backing: NSBackingStoreBuffered
					     defer: NO];

  self = [super initWithWindow: rawSourceWindow];
  
  [rawSourceWindow layoutWindow];
  [rawSourceWindow setDelegate: self];

  // We set out outlets
  textView = [rawSourceWindow textView];

  RELEASE(rawSourceWindow);
#endif

  [[self window] setTitle: _(@"RAW Source")];

  return self;
}


- (void) dealloc
{
  NSLog(@"RAWSourceWindowController: -dealloc");

  RELEASE(rawSource);
  
  [super dealloc];
}


//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification
{
  AUTORELEASE(self);
}


- (void) windowDidLoad
{
 
}

//
// access/mutation methods
//

- (NSString *) rawSource
{
  return rawSource;
}

- (void) setRAWSource: (NSString*) theRAWSource
{
  RETAIN(theRAWSource);
  RELEASE(rawSource);
  rawSource = theRAWSource;

  if ( [[NSUserDefaults standardUserDefaults] objectForKey: @"MESSAGE_FONT_NAME"] )
    {
      [textView setFont: [NSFont fontWithName: [[NSUserDefaults standardUserDefaults] stringForKey: @"MESSAGE_FONT_NAME"]
                                size: [[NSUserDefaults standardUserDefaults] floatForKey: @"MESSAGE_FONT_SIZE"]]];
    }
  else
    {
      [textView setFont: [NSFont userFixedPitchFontOfSize: 0]];
    }

  [textView setString: rawSource];
}

@end
