/*
**  NewMailboxPanel.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "NewMailboxPanel.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation NewMailboxPanel

- (void) dealloc
{
  NSLog(@"NewMailboxPanel: -dealloc");

  RELEASE(mailboxNameField);
  [super dealloc];
}

- (void) layoutPanel
{
  NSButton *okButton, *cancelButton;
  LabelWidget *mailboxNameLabel;
  
  mailboxNameLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(20,80,250,TextFieldHeight)
				  label: _(@"Please enter the name of the new Mailbox:")];
  [[self contentView] addSubview: mailboxNameLabel];
  
  mailboxNameField = [[NSTextField alloc] initWithFrame: NSMakeRect(20,50,250,TextFieldHeight)];
  [mailboxNameField setSelectable:YES];
  [[self contentView] addSubview: mailboxNameField];
    
  cancelButton = [[NSButton alloc] initWithFrame: NSMakeRect(140,10,60,ButtonHeight)];
  AUTORELEASE(cancelButton);
  [cancelButton setButtonType:NSMomentaryPushButton];
  [cancelButton setTitle: _(@"Cancel")];
  [cancelButton setTarget: [self windowController]];
  [cancelButton setAction: @selector(cancelClicked:)];
  [[self contentView] addSubview: cancelButton];

  okButton = [[NSButton alloc] initWithFrame:  NSMakeRect(210,10,60,ButtonHeight)];
  AUTORELEASE(okButton);
  [okButton setButtonType:NSMomentaryPushButton];
  [okButton setKeyEquivalent: @"\r"];
  [okButton setImagePosition: NSImageRight];
  [okButton setImage: [NSImage imageNamed: @"common_ret"]];
  [okButton setAlternateImage: [NSImage imageNamed: @"common_retH"]];
  [okButton setTitle: _(@"OK")];
  [okButton setTarget: [self windowController]];
  [okButton setAction: @selector(okClicked:)];
  [[self contentView] addSubview:okButton];
}


- (NSTextField *) mailboxNameField
{
  return mailboxNameField;
}

@end
