//
// NSStringExtensions.m
//
// $Id: NSStringExtensions.m,v 1.1.1.1 2002/02/17 20:43:25 ludo Exp $
//
// Jonathan B. Leffert <jonathan@leffert.net>
// Ludovic Marcotte <ludovic@Sophos.ca>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#import "NSStringExtensions.h"

#import "GNUMailConstants.h"

@implementation NSString (GNUMailStringExtensions)

- (NSString *) stringByTrimmingWhiteSpaces
{
#ifdef GNUSTEP_BASE_VERSION
  return [self stringByTrimmingSpaces];
#else
  NSMutableString *mutableCopy = nil;
  NSRange theRange;

  mutableCopy = [[NSMutableString alloc] initWithString: self];

  theRange.location = 0;
  theRange.length = 1;

  while ( [mutableCopy hasPrefix: @" "] )
    {
      [mutableCopy deleteCharactersInRange: theRange];
    }

  theRange.location = [mutableCopy length] - 1;
  while ( [mutableCopy hasSuffix: @" "] )
    {
      [mutableCopy deleteCharactersInRange: theRange];
      theRange.location = [mutableCopy length] - 1;
    }

  return AUTORELEASE(mutableCopy);
#endif
}


- (int) indexOfCharacter: (unichar) theCharacter
{
  int i;
  
  for (i = 0; i < [self length]; i++)
    {
      if ([self characterAtIndex: i] == theCharacter)
	{
	  return i;
	}
    }
  
  return -1;
}

@end
