/*
**  MailWindowController.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import <AppKit/AppKit.h>

@class FilterManager;
@class Folder;
@class LabelWidget;
@class MailWindow;
@class Message;
@class MimeTypeManager;

@interface MailWindowController : NSWindowController
{
  // Outlets
  IBOutlet NSScrollView *tableScrollView; 
  IBOutlet NSScrollView *textScrollView;

  IBOutlet NSSplitView *splitView;
  IBOutlet NSTableView *tableView;
  IBOutlet NSTextView *textView;
  
  IBOutlet NSButton *next;
  IBOutlet NSButton *previous;
  IBOutlet NSButton *delete;
  IBOutlet NSButton *mailboxes;
  IBOutlet NSButton *compose;
  IBOutlet NSButton *forward;
  IBOutlet NSButton *reply;
  IBOutlet NSButton *addresses;
  IBOutlet NSButton *find;

  IBOutlet NSTextField *label;
  
  IBOutlet NSTableColumn *statusColumn;
  IBOutlet NSTableColumn *idColumn;
  IBOutlet NSTableColumn *dateColumn;
  IBOutlet NSTableColumn *fromColumn;
  IBOutlet NSTableColumn *subjectColumn;
  IBOutlet NSTableColumn *sizeColumn;

  // Other ivar
  MimeTypeManager *mimeTypeManager;
  FilterManager *filterManager;

  Folder *folder;

  NSArray *allMessages;
  BOOL isReverseOrder;
  NSString *previousOrder;
  NSString *currentOrder;
  
  BOOL showAllHeaders;
  BOOL showSizes;
  BOOL _isReloading;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

//
// action methods
//
- (IBAction) doubleClickedOnTableView: (id) sender;

- (IBAction) deleteMessage: (id) sender;

- (IBAction) lastMessage: (id) sender;
- (IBAction) firstMessage: (id) sender;

- (IBAction) nextMessage: (id) sender;
- (IBAction) previousMessage: (id) sender;

- (IBAction) composeMessage: (id) sender;
- (IBAction) forwardMessage: (id) sender;
- (IBAction) replyMessage: (id) sender;
- (IBAction) replyAllMessage: (id) sender;

- (IBAction) loadFilters: (id) sender;
- (IBAction) loadMimeTypes: (id) sender;
- (IBAction) updateMessageFlags: (id) sender;


//
// access / mutation methods
//
- (Folder *) folder;
- (void) setFolder: (Folder *) theFolder;

- (Message *) selectedMessage;
- (NSArray *) selectedMessages;

- (BOOL) showAllHeaders;
- (void) setShowAllHeaders: (BOOL) aBOOL;

- (BOOL) showSizes;
- (void) setShowSizes: (BOOL) aBOOL;

- (NSTableView *) tableView;
- (NSTextView *) textView;


//
// delegate methods
//
- (int) numberOfRowsInTableView: (NSTableView *)aTableView;

- (id)           tableView: (NSTableView *) aTableView
 objectValueForTableColumn: (NSTableColumn *) aTableColumn
                       row: (int) rowIndex;

- (void) tableView: (NSTableView *) aTableView
   willDisplayCell: (id) aCell
    forTableColumn: (NSTableColumn *) aTableColumn
               row: (int) rowIndex;

- (void) tableViewSelectionDidChange: (NSNotification *) aNotification;

-  (void) textView: (NSTextView *) aTextView
     clickedOnCell: (id <NSTextAttachmentCell>) attachmentCell
	    inRect: (NSRect) cellFrame
           atIndex: (unsigned) charIndex;

- (BOOL) textView: (NSTextView *) textView
    clickedOnLink: (id) link 
          atIndex: (unsigned) charIndex;

- (void) windowWillClose: (NSNotification *) not;

- (void) windowDidLoad;

- (void) windowDidBecomeKey: (NSNotification *) aNotification;


//
// Other methods
//
- (void) showMessage: (Message *) theMessage;

- (void) updateStatusLabel;

- (void) tableViewShouldReloadData;

- (void) reloadTableColumns;

@end


//
// Private interface for MailWindowContrller
//
@interface MailWindowController (Private)

- (void) _highlightAndActivateURLs;

- (void) _launchExternalProgram: (NSDictionary *) theDictionary;

- (NSMutableAttributedString *) _quoteMessageContentFromAttributedString: (NSAttributedString *) theAttributedString;

- (void) _loadAccessoryViews;

- (void) _updateMessageSelectionUsingIndex: (int) theIndex;

- (void) _restoreSortingOrder;

- (void) _restoreSplitViewSize;

@end


//
//
//
@interface NSWindow (KeyDownSupport)

- (void) keyDown: (NSEvent *)theEvent;

@end
