/*
**  MailWindow.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "MailWindow.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

//
// FIXME: We should remove that code soon (ie., after the next release of GNUstep GUI).
//
// We DO NOT use the -deselectAll method from the GNUstep GUI 0.7.5 since
// it's buggy. We use the new version from the CVS (Feb. 13, 2002).
//
@implementation NSTableView (GNUMail)

- (void) deselectAll: (id) sender
{
  SEL selector;
  
  if (_allowsEmptySelection == NO)
    {
      return;
    }

  
  selector = @selector (selectionShouldChangeInTableView:);
  if ([_delegate respondsToSelector: selector] == YES)
    {
      if ([_delegate selectionShouldChangeInTableView: self] == NO)
        {
          return;
        }
    }

  if (_textObject != nil)
    {
      [self validateEditing];
      [self abortEditing];
    }

  _selectedRow = -1;

  if (([_selectedColumns count] > 0) || ([_selectedRows count] > 0))
    {
      NSNotificationCenter *nc;

      nc = [NSNotificationCenter defaultCenter];
      [_selectedColumns removeAllObjects];
      [_selectedRows removeAllObjects];
      [nc postNotificationName: NSTableViewSelectionDidChangeNotification
          object: self];
    }

  _selectedColumn = -1;
  _selectingColumns = NO;
}

@end

@implementation MailWindow

//
//
//
- (void) dealloc
{
  //NSLog(@"MailWindow: -dealloc");

  RELEASE(previous);
  RELEASE(next);
  RELEASE(delete);
  RELEASE(mailboxes);
  RELEASE(compose);
  RELEASE(reply);
  RELEASE(forward);
  RELEASE(addresses);
  RELEASE(find);
  
  RELEASE(label);

  RELEASE(splitView);
  RELEASE(tableView);
  RELEASE(tableScrollView);
  RELEASE(textView);
  RELEASE(textScrollView);

  RELEASE(statusColumn);
  RELEASE(idColumn);
  RELEASE(dateColumn);
  RELEASE(fromColumn);
  RELEASE(subjectColumn);
  RELEASE(sizeColumn);
  
  [super dealloc];
}

//
//
//
- (void) layoutWindow
{
  NSRect mRect = {{0,0}, {700,150}};

  previous = [[NSButton alloc] initWithFrame:NSMakeRect(24,554,64,30)];
  [previous setTitle:@""];
  [previous setImagePosition: NSImageOnly];
  [previous setImage: [NSImage imageNamed: @"up.tiff"]];
  [previous setTarget: [self windowController]];
  [previous setAction: @selector(previousMessage:)];
  [previous setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:previous];
  
  next = [[NSButton alloc] initWithFrame:NSMakeRect(24,520,64,30)];
  [next setTitle:@""];
  [next setImagePosition: NSImageOnly];
  [next setImage: [NSImage imageNamed: @"down.tiff"]];
  [next setTarget: [self windowController]];
  [next setAction: @selector(nextMessage:)];
  [next setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: next];
  
  delete = [[NSButton alloc] initWithFrame:NSMakeRect(96,520,64,64)];
  [delete setTitle: _(@"Delete")];
  [delete setFont:[NSFont systemFontOfSize: 8]];
  [delete setImagePosition: NSImageAbove];
  [delete setImage: [NSImage imageNamed: @"MailIcon_delete.tiff"]];
  [delete setTarget: [self windowController]];
  [delete setAction: @selector(deleteMessage:)];
  [delete setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: delete];
  
  mailboxes = [[NSButton alloc] initWithFrame:NSMakeRect(168,520,64,64)];
  [mailboxes setTitle: _(@"Mailboxes")];
  [mailboxes setFont:[NSFont systemFontOfSize: 8]];
  [mailboxes setImagePosition: NSImageAbove];
  [mailboxes setImage: [NSImage imageNamed: @"MailIcon_mailboxes.tiff"]];
  [mailboxes setTarget: [NSApp delegate]];
  [mailboxes setAction: @selector(showMailboxManager:)];
  [mailboxes setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:mailboxes];
  
  compose = [[NSButton alloc] initWithFrame:NSMakeRect(236,520,64,64)];
  [compose setTitle: _(@"Compose")];
  [compose setFont:[NSFont systemFontOfSize: 8]];
  [compose setImagePosition: NSImageAbove];
  [compose setImage: [NSImage imageNamed: @"MailIcon_create.tiff"]];
  [compose setTarget: [self windowController]];
  [compose setAction: @selector(composeMessage:)];
  [compose setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:compose];
  
  reply = [[NSButton alloc] initWithFrame:NSMakeRect(308,520,64,64)];
  [reply setTitle: _(@"Reply")];
  [reply setFont:[NSFont systemFontOfSize: 8]];
  [reply setImagePosition: NSImageAbove];
  [reply setImage: [NSImage imageNamed: @"MailIcon_reply.tiff"]];
  [reply setTarget: [self windowController]];
  [reply setAction: @selector(replyMessage:)];
  [reply setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:reply];
  
  forward = [[NSButton alloc] initWithFrame:NSMakeRect(380,520,64,64)];
  [forward setTitle: _(@"Forward")];
  [forward setFont:[NSFont systemFontOfSize: 8]];
  [forward setImagePosition: NSImageAbove];
  [forward setImage: [NSImage imageNamed: @"MailIcon_forward.tiff"]];
  [forward setTarget: [self windowController]];
  [forward setAction: @selector(forwardMessage:)];
  [forward setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:forward];
  
  addresses = [[NSButton alloc] initWithFrame:NSMakeRect(452,520,64,64)];
  [addresses setTitle: _(@"Addresses")];
  [addresses setFont:[NSFont systemFontOfSize: 8]];
  [addresses setImagePosition: NSImageAbove];
  [addresses setImage: [NSImage imageNamed: @"MailIcon_addresses.tiff"]];
  [addresses setTarget: [NSApp delegate]];
  [addresses setAction: @selector(showAddressBook:)];
  [addresses setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:addresses];
  
  find = [[NSButton alloc] initWithFrame:NSMakeRect(524,520,64,64)];
  [find setTitle: _(@"Find")];
  [find setFont:[NSFont systemFontOfSize: 8]];
  [find setImagePosition: NSImageAbove];
  [find setImage: [NSImage imageNamed: @"Magnifier.tiff"]];
  [find setTarget: [NSApp delegate]];
  [find setAction: @selector(showFindWindow:)];
  [find setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:find];
  
  label = [LabelWidget labelWidgetWithFrame:NSMakeRect(24,498,500,20)
		       label: @""];
  RETAIN(label);
  [label setFont:[NSFont systemFontOfSize: 10]];
  [label setTextColor:[NSColor darkGrayColor]];
  [label setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:label];
  
  // We create our split view
  splitView = [[NSSplitView alloc] initWithFrame:NSMakeRect(5,5,740,490)];
  [splitView setVertical: NO];
  [splitView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];
  
  statusColumn = [[NSTableColumn alloc] initWithIdentifier: @"Status"];
  [statusColumn setEditable: NO];
  [statusColumn setResizable: YES];
  [[statusColumn headerCell] setStringValue: _(@"Status")];
  [statusColumn setMinWidth: 50];
  [statusColumn setMaxWidth: 50];

  idColumn = [[NSTableColumn alloc] initWithIdentifier: @"Id"];
  [idColumn setEditable: NO];
  [idColumn setResizable: YES];
  [[idColumn headerCell] setStringValue: _(@"Id")];
  [idColumn setMinWidth: 40];
  [idColumn setMaxWidth: 40];
  
  dateColumn = [[NSTableColumn alloc] initWithIdentifier: @"Date"];
  [dateColumn setEditable: NO];
  [dateColumn setResizable: YES];
  [[dateColumn headerCell] setStringValue: _(@"Date")];
  [dateColumn setMinWidth: 85];
  [dateColumn setMaxWidth: 85];
  [[dateColumn headerCell] setAlignment: NSLeftTextAlignment];
  
  fromColumn = [[NSTableColumn alloc] initWithIdentifier: @"From"];
  [fromColumn setEditable: NO];
  [fromColumn setResizable: YES];
  [[fromColumn headerCell] setStringValue: _(@"From")];
  [fromColumn setMinWidth: 170];
  [[fromColumn headerCell] setAlignment: NSLeftTextAlignment];
  
  subjectColumn = [[NSTableColumn alloc] initWithIdentifier: @"Subject"];
  [subjectColumn setEditable: NO];
  [subjectColumn setResizable: YES];
  [[subjectColumn headerCell] setStringValue: _(@"Subject")];
  [subjectColumn setMinWidth: 330];
  [[subjectColumn headerCell] setAlignment: NSLeftTextAlignment];

  sizeColumn = [[NSTableColumn alloc] initWithIdentifier: @"Size"];
  [sizeColumn setEditable: NO];
  [sizeColumn setResizable: YES];
  [[sizeColumn headerCell] setStringValue: _(@"Size")];
  [sizeColumn setMinWidth: 50];
  [sizeColumn setMaxWidth: 70];
  [[sizeColumn headerCell] setAlignment: NSRightTextAlignment];

  tableView = [[NSTableView alloc] initWithFrame:mRect];
  [tableView setDrawsGrid: NO];
  [tableView setAllowsColumnSelection: NO];
  [tableView setAllowsColumnReordering: NO];
  [tableView setAllowsColumnResizing: YES];
  [tableView setAllowsEmptySelection: YES];
  [tableView setAllowsMultipleSelection: YES];
  [tableView addTableColumn: statusColumn];
  [tableView addTableColumn: idColumn];
  [tableView addTableColumn: dateColumn];
  [tableView addTableColumn: fromColumn];
  [tableView addTableColumn: subjectColumn];
  [tableView addTableColumn: sizeColumn];
  [tableView setAutoresizesAllColumnsToFit: YES];
  [tableView sizeLastColumnToFit];
  [tableView setDataSource: [self windowController]];
  [tableView setDelegate: [self windowController]];
  [tableView setDoubleAction: @selector(doubleClickedOnTableView:)];

  tableScrollView = [[NSScrollView alloc] initWithFrame:mRect];
  [tableScrollView setHasHorizontalScroller: NO];
  [tableScrollView setHasVerticalScroller: YES];
  [tableScrollView setDocumentView:tableView];
  [tableScrollView setAutoresizingMask: NSViewWidthSizable | NSViewHeightSizable];
  
  textScrollView = [[NSScrollView alloc] initWithFrame:mRect];
  [textScrollView setHasHorizontalScroller: NO];
  [textScrollView setHasVerticalScroller: YES];
 
  mRect = [[textScrollView contentView] frame];
  textView = [[NSTextView alloc] initWithFrame:mRect];
  [textView setTextContainerInset: NSMakeSize(5,5)];
  [textView setBackgroundColor: [NSColor whiteColor]];
  [textView setRichText: YES];
  [textView setUsesFontPanel: YES];
  [textView setDelegate: [self windowController]];
  [textView setHorizontallyResizable: NO];
  [textView setVerticallyResizable: YES];
  [textView setMinSize: NSMakeSize (0, 0)];
  [textView setMaxSize: NSMakeSize (1E7, 1E7)];
  [textView setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable];
  [[textView textContainer] setContainerSize: NSMakeSize (mRect.size.width, 1E7)];

  [[textView textContainer] setWidthTracksTextView: YES];
  [textView setEditable: NO];
  [textView setString:@""];
  
  [textScrollView setDocumentView:textView];
  
  [splitView addSubview: tableScrollView];
  [splitView addSubview: textScrollView];
  [splitView adjustSubviews];
  
  [[self contentView] addSubview: splitView];
}

//
// access / mutation methods
//

- (NSScrollView *) tableScrollView;
{
  return tableScrollView;
}

- (NSScrollView *) textScrollView
{
  return textScrollView;
}

- (NSSplitView *) splitView
{
  return splitView;
}

- (NSTableView *) tableView
{
  return tableView;
}

- (NSTextView *) textView;
{
  return textView;
}

- (NSButton *) next
{
  return next;
}

- (NSButton *) previous
{
  return previous;
}

- (NSButton *) delete
{
  return delete;
}

- (NSButton *) mailboxes
{
  return mailboxes;
}

- (NSButton *) compose
{
  return compose;
}

- (NSButton *) forward
{
  return forward;
}

- (NSButton *) reply
{
  return reply;
}

- (NSButton *) addresses
{
  return addresses;
}

- (NSButton *) find
{
  return find;
}

- (LabelWidget *) label
{
  return label;
}

- (NSTableColumn *) statusColumn
{
  return statusColumn;
}

- (NSTableColumn *) idColumn
{
  return idColumn;
}

- (NSTableColumn *) dateColumn
{
  return dateColumn;
}

- (NSTableColumn *) fromColumn
{
  return fromColumn;
}

- (NSTableColumn *) subjectColumn
{
  return subjectColumn;
}

- (NSTableColumn *) sizeColumn
{
  return sizeColumn;
}

@end
