/*
**  LocalInboxWindowController.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>
#import "MailWindowController.h"

@class LocalInboxWindow;
@class LocalMailDelivery;
@class LocalStore;
@class POP3Folder;

@interface LocalInboxWindowController : MailWindowController
{
  // Outlets
  IBOutlet NSButton *icon;
  IBOutlet NSButton *get;

  // Other ivar
  NSLock *lock;
  LocalMailDelivery *localMailDelivery;

  NSTimer *timer;

  NSTimer *animation;
  int animation_index;

  NSMutableDictionary *passwordCache;
  NSMutableArray *filteredMessageBoxes;

  int transferredMessageCount, filteredMessageCount;
  BOOL initiatedFromTimer;
  
  NSModalSession modalSession;
  id panel;

  NSConnection *connection;
  NSArray *ports;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;

- (void) dealloc;

//
// action methods
//

- (IBAction) getNewMessages: (id) sender;

- (void) startTimer: (id) sender;
- (void) stopTimer: (id) sender;

//
// access/mutation methods
//

- (LocalMailDelivery *) localMailDelivery;
- (void) setLocalMailDelivery: (LocalMailDelivery *) theObject;


//
// class methods
//

+ (id) localInboxWindowController;

@end

//
// private methods
//
@interface LocalInboxWindowController (Private)

- (NSString *) _passwordForServerName: (NSString *) theName
                               prompt: (BOOL) aBOOL;

- (void) _transferMessagesUsingPorts: (NSArray *) thePorts;

- (int) _transferMessagesFromPOP3Folder: (POP3Folder *) theFolder
                             connection: (NSConnection *) theConnection;

- (void) _matchFilterRuleFromRawSource: (NSData *) theRawSource
                            connection: (NSConnection *) theConnection;

- (void) _transferMessageFromRawSource: (NSData *) theRawSource
                      toFolderWithName: (NSString *) theFolderName;

- (BOOL) _folderNameExists: (NSString *) theFolderName
                  forStore: (LocalStore *) theLocalStore;
@end
