/*
**  IMAPMailWindowController.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

#import "MailWindowController.h"

@interface IMAPMailWindowController : MailWindowController
{  
  // Outlets
  IBOutlet NSButton *get;

  // Other ivar
  NSLock *fetchingLock;
  NSTimer *timer;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;

- (void) dealloc;

//
// action methods
//

- (IBAction) getNewMessages: (id) sender;

//
// access/mutation methods
//


@end

//
// Private interface
//
@interface IMAPMailWindowController (Private)

- (void) _transferMessagesToTrashFolder;

@end
