/*
**  GNUMailConstants.h
**
**  Copyright (c) 2001, 2002
** 
**  Author: Jonathan B. Leffert <jonathan@leffert.net>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import <Foundation/NSString.h>

#ifndef GNUSTEP_BASE_VERSION
#define RETAIN(object)          [object retain]
#define RELEASE(object)         [object release]
#define AUTORELEASE(object)     [object autorelease]
#define TEST_RELEASE(object)    ({ if (object) [object release]; })
#define ASSIGN(object,value)    ({\
id __value = (id)(value); \
id __object = (id)(object); \
if (__value != __object) \
  { \
    if (__value != nil) \
      { \
        [__value retain]; \
      } \
    object = __value; \
    if (__object != nil) \
      { \
        [__object release]; \
      } \
  } \
})

#define DESTROY(object) ({ \
  if (object) \
    { \
      id __o = object; \
      object = nil; \
      [__o release]; \
    } \
})

#define CREATE_AUTORELEASE_POOL(X)      \
  NSAutoreleasePool *(X) = [NSAutoreleasePool new]

#define NSLocalizedString(key, comment) \
  [[NSBundle mainBundle] localizedStringForKey:(key) value:@"" table:nil]

#define _(X) NSLocalizedString (X, @"")

#endif

// GNUMail.app version number string
extern const NSString *GNUMAIL_VERSION;

// Contants for the whole application
extern const int MANUALLY;
extern const int AUTOMATICALLY;

extern const int SHOW_ALL_HEADERS;
extern const int HIDE_ALL_HEADERS;

extern const int DELETE_MESSAGE;
extern const int UNDELETE_MESSAGE;

extern const int MARK_AS_READ;
extern const int MARK_AS_UNREAD;

extern const int SHOW_DELETED_MESSAGES;
extern const int HIDE_DELETED_MESSAGES;

extern const int SHOW_SIZES;
extern const int HIDE_SIZES;

extern const int POP3;
extern const int IMAP;

extern const int TRANSPORT_MAILER;
extern const int TRANSPORT_SMTP;

extern const int SIGNATURE_BEGINNING;
extern const int SIGNATURE_END;
extern const int SIGNATURE_HIDDEN;

// Contants for the UI
extern const int TextFieldHeight;
extern const int ButtonHeight;


extern const int FilterTextFieldTag;

// Identifiers
extern const id MimeTypeColumnIdentifier;
extern const id FileExtensionsColumnIdentifier;
extern const id MailcapWindowCommandColumnIdentifier;

extern const id MainTabViewItemIdentifier;
extern const id ServerTypeTabViewItemIdentifier;

extern const id SendingViewTransportMethodColumnIdentifier;
extern const id SendingViewTransportValueColumnIdentifier;
extern const id SendingViewHeaderKeyColumnIdentifier;
extern const id SendingViewHeaderValueColumnIdentifier;

extern const id FilteringViewRulesColumnIdentifier;

extern const id FilterHeaderEditorTableColumnIdentifier;

// Notifications used in GNUMail.app
extern NSString *MimeTypesHaveChanged;
extern NSString *SelectionOfMessageHasChanged;
extern NSString *ShouldCloseMailbox;
extern NSString *ReceivingValuesHaveChanged;

extern NSString *ShouldStartLocalInboxTimer;
extern NSString *ShouldStopLocalInboxTimer;

extern NSString *FiltersHaveChanged;

extern NSString *ReplyToMessageWasSuccessful;

extern NSString *PersonalProfilesHaveChanged;
extern NSString *TransportMethodsHaveChanged;
