/*
**  Filter.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

// criteria source
#define TO 1
#define CC 2
#define TO_OR_CC 3
#define SUBJECT 4
#define FROM 5
#define EXPERT 6

// criteria find operations
#define CONTAINS 1
#define IS_EQUAL 2
#define HAS_PREFIX 3
#define HAS_SUFFIX 4
#define MATCH_REGEXP 5

// actions
#define SET_COLOR 1
#define TRANSFER_TO_FOLDER 2
#define BOUNCE_OR_FORWARD_OR_REPLY 3
#define DELETE 4

// email operations
#define BOUNCE 1
#define FORWARD 2
#define REPLY 3

@class Folder;

@interface Filter: NSObject <NSCoding, NSCopying>
{
  BOOL isActive;
  NSString *description;
  
  int criteriaSource;
  NSArray *criteriaHeaders;
  int criteriaFindOperation;
  NSString *criteriaString;

  int action;
  NSColor *actionColor;
  NSString *actionFolderName;
  int actionEMailOperation;
  NSString *actionEMailString;
  NSString *actionMessageString;
}

//
//
//
- (id) init;
- (void) dealloc;

//
// Coding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;

//
// access/mutation methods
//
- (BOOL) isActive;
- (void) setIsActive: (BOOL) theBOOL;

- (NSString *) description;
- (void) setDescription: (NSString *) theDescription;

- (int) criteriaSource;
- (void) setCriteriaSource: (int) theCriteriaSource;

- (NSArray *) criteriaHeaders;
- (void) setCriteriaHeaders: (NSArray *) theCriteriaHeaders;

- (int) criteriaFindOperation;
- (void) setCriteriaFindOperation: (int) theCriteriaFindOperation;

- (NSString *) criteriaString;
- (void) setCriteriaString: (NSString *) theCriteriaString;

- (int) action;
- (void) setAction: (int) theAction;

- (NSColor *) actionColor;
- (void) setActionColor: (NSColor *) theActionColor;

- (NSString *) actionFolderName;
- (void) setActionFolderName: (NSString *) theActionFolderName; 

- (int) actionEMailOperation;
- (void) setActionEMailOperation: (int) theActionEMailOperation;

- (NSString *) actionEMailString;
- (void) setActionEMailString: (NSString *) theActionEMailString;

- (NSString *) actionMessageString;
- (void) setActionMessageString: (NSString *) theActionMessageString;

//
// class methods
//


@end
