/*
**  TransportMethodEditorWindow.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "TransportMethodEditorWindow.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation TransportMethodEditorWindow

//
//
//
- (void) dealloc
{
  NSLog(@"TransportMethoEditorWindow: -dealloc");
  
  RELEASE(transportMethodPopUpButton);
  
  RELEASE(mailerField);

  RELEASE(smtpHostField);
  RELEASE(smtpUsernameField);
  RELEASE(smtpPasswordSecureField);
  RELEASE(rememberPassword);

  RELEASE(authenticateUsingButton);
  RELEASE(supportedMechanismsButton);
  RELEASE(supportedMechanismsPopUp);

  RELEASE(personalProfilePopUpButton);

  RELEASE(cancelButton);
  RELEASE(okButton);

  [super dealloc];
}


//
//
//
- (void) layoutWindow
{
  LabelWidget *transportMethodLabel, *mailerLabel, *smtpHostLabel, *smtpUsernameLabel;
  LabelWidget *smtpPasswordLabel, *personalProfileLabel;
  NSBox *box;

  transportMethodLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,343,110,TextFieldHeight)
				      label: _(@"Transport method:")];
  [[self contentView] addSubview: transportMethodLabel];
  
  transportMethodPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(130,343,125,ButtonHeight)];
  [transportMethodPopUpButton addItemWithTitle: _(@"Mailer")];
  [transportMethodPopUpButton addItemWithTitle: _(@"SMTP")];
  [transportMethodPopUpButton setTarget: [self windowController]];
  [transportMethodPopUpButton setAction: @selector(transportMethodHasChanged:)];
  [[self contentView] addSubview: transportMethodPopUpButton];
  
  // We create our Mailbox box and its content
  box = [[NSBox alloc] initWithFrame: NSMakeRect(5,273,390,68)];
  [box setTitle: _(@"Mailer")];

  mailerLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,10,60,TextFieldHeight)
			     label: _(@"Mailer:")];
  [[box contentView] addSubview: mailerLabel];

  mailerField = [[NSTextField alloc] initWithFrame: NSMakeRect(75,10,305,TextFieldHeight)];
  [[box contentView] addSubview: mailerField];

  [[self contentView] addSubview: box];
  RELEASE(box);

  // We create our SMTP box and its content
  box = [[NSBox alloc] initWithFrame: NSMakeRect(5,80,390,193)];
  [box setTitle: _(@"SMTP")];

  smtpHostLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,135,60,TextFieldHeight)
			       label: _(@"Host:")];
  [[box contentView] addSubview: smtpHostLabel];

  smtpHostField = [[NSTextField alloc] initWithFrame: NSMakeRect(75,135,305,TextFieldHeight)];
  [[box contentView] addSubview: smtpHostField];

  authenticateUsingButton = [[NSButton alloc] initWithFrame: NSMakeRect(5,100,130,ButtonHeight)];
  [authenticateUsingButton setButtonType: NSSwitchButton];
  [authenticateUsingButton setBordered: NO];
  [authenticateUsingButton setTitle: _(@"Authenticate using")];
  [authenticateUsingButton setTarget: [self windowController]];
  [authenticateUsingButton setAction: @selector(authenticateUsingButtonClicked:)];
  [[box contentView] addSubview: authenticateUsingButton];

  supportedMechanismsPopUp = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(140,100,80,ButtonHeight)];
  [supportedMechanismsPopUp setAutoenablesItems: NO];
  [supportedMechanismsPopUp addItemWithTitle: _(@"Most secure")];
  [[box contentView] addSubview: supportedMechanismsPopUp];

  supportedMechanismsButton = [[NSButton alloc] initWithFrame: NSMakeRect(230,100,145,ButtonHeight)];
  [supportedMechanismsButton setTitle: _(@"Supported mechanisms")];
  [supportedMechanismsButton setTarget: [self windowController]];
  [supportedMechanismsButton setAction: @selector(supportedMechanismsButtonClicked:)];
  [[box contentView] addSubview: supportedMechanismsButton];

  smtpUsernameLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,70,60,TextFieldHeight)
				   label: _(@"Username:")];
  [[box contentView] addSubview: smtpUsernameLabel];

  smtpUsernameField = [[NSTextField alloc] initWithFrame: NSMakeRect(75,70,305,TextFieldHeight)];
  [[box contentView] addSubview: smtpUsernameField];

  smtpPasswordLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,40,60,TextFieldHeight)
				   label: _(@"Password:")];
  [[box contentView] addSubview: smtpPasswordLabel];
  
  smtpPasswordSecureField = [[NSSecureTextField alloc] initWithFrame: NSMakeRect(75,40,305,TextFieldHeight)];
  [[box contentView] addSubview: smtpPasswordSecureField];
  
  rememberPassword = [[NSButton alloc] initWithFrame: NSMakeRect(5,10,200,ButtonHeight)];
  [rememberPassword setButtonType: NSSwitchButton];
  [rememberPassword setBordered: NO];
  [rememberPassword setTitle: _(@"Remember password")];
  [box addSubview: rememberPassword];
  
  [[self contentView] addSubview: box];
  RELEASE(box);
  

  // We add out label/popup button for our personal profile
  personalProfileLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,45,160,TextFieldHeight)
				      label: _(@"Associated personal profile:")];
  [[self contentView] addSubview: personalProfileLabel];

  personalProfilePopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(180,45,215,ButtonHeight)];
  [personalProfilePopUpButton setAutoenablesItems: NO];
  [[self contentView] addSubview: personalProfilePopUpButton];

  // We finally add our ok/cancel buttons
  cancelButton = [[NSButton alloc] initWithFrame: NSMakeRect(260,10,60,ButtonHeight)];
  [cancelButton setButtonType:NSMomentaryPushButton];
  [cancelButton setTitle: _(@"Cancel")];
  [cancelButton setTarget: [self windowController]];
  [cancelButton setAction: @selector(cancelClicked:)];
  [[self contentView] addSubview: cancelButton];

  okButton = [[NSButton alloc] initWithFrame:  NSMakeRect(330,10,60,ButtonHeight)];
  [okButton setButtonType:NSMomentaryPushButton];
  [okButton setKeyEquivalent: @"\r"];
  [okButton setImagePosition: NSImageRight];
  [okButton setImage: [NSImage imageNamed: @"common_ret"]];
  [okButton setAlternateImage: [NSImage imageNamed: @"common_retH"]];
  [okButton setTitle: _(@"OK")];
  [okButton setTarget: [self windowController]];
  [okButton setAction: @selector(okClicked:)];
  [[self contentView] addSubview:okButton];
}


//
// access methods
//
- (NSPopUpButton *) transportMethodPopUpButton
{
  return transportMethodPopUpButton;
}

- (NSTextField *) mailerField
{
  return mailerField;
}

- (NSTextField *) smtpHostField
{
  return smtpHostField;
}

- (NSTextField *) smtpUsernameField
{
  return smtpUsernameField;
}

- (NSSecureTextField *) smtpPasswordSecureField
{
  return smtpPasswordSecureField;
}

- (NSButton *) rememberPassword
{
  return rememberPassword;
}

- (NSButton *) authenticateUsingButton
{
  return authenticateUsingButton;
}

- (NSButton *) supportedMechanismsButton
{
  return supportedMechanismsButton;
}

- (NSPopUpButton *) supportedMechanismsPopUp
{
  return supportedMechanismsPopUp;
}

- (NSPopUpButton *) personalProfilePopUpButton
{
  return personalProfilePopUpButton;
}

- (NSButton *) cancelButton
{
  return cancelButton;
}

- (NSButton *) okButton
{
  return okButton;
}

@end
