/*
**  ReceivingWindow.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "ReceivingWindow.h"
#import "LabelWidget.h"
#import "GNUMailConstants.h"
#import "IMAPView.h"
#import "POP3View.h"

@implementation ReceivingWindow

- (void) dealloc
{
  //NSLog(@"ReceivingWindow: -dealloc");
  
  RELEASE(tabView);

  RELEASE(tabViewItem1);
  RELEASE(tabViewItem2);

  RELEASE(imapView);
  RELEASE(pop3View);
  
  RELEASE(serverNameField);
  RELEASE(usernameField);
  RELEASE(passwordSecureField);
  RELEASE(rememberPassword);

  RELEASE(popup);

  [super dealloc];
}

- (void) layoutWindow
{
  // For the UI
  NSButton *okButton, *cancelButton;
  NSBox *box1;
  LabelWidget *serverNameLabel, *serverPortLabel, *serverTypeLabel, *usernameLabel, *passwordLabel;
  
  tabView = [[NSTabView alloc] initWithFrame: NSMakeRect(0,35,400,240)];

  box1 = [[NSBox alloc] initWithFrame: NSMakeRect(5,5,350,200)];
  AUTORELEASE(box1);
  [box1 setTitlePosition: NSNoTitle];
  [box1 setBorderType: NSNoBorder];

  serverNameLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,165,80,TextFieldHeight)
				 label: _(@"Server name:")];
  [box1 addSubview: serverNameLabel];
  serverNameField = [[NSTextField alloc] initWithFrame:NSMakeRect(100,165,150,TextFieldHeight)];
  [serverNameField setSelectable:YES];
  [box1 addSubview:serverNameField];


  serverPortLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(260,165,40,TextFieldHeight)
				 label: _(@"Port:")];
  [box1 addSubview: serverPortLabel];
  serverPortField = [[NSTextField alloc] initWithFrame:NSMakeRect(300,165,60,TextFieldHeight)];
  [serverPortField setSelectable: YES];
  [box1 addSubview: serverPortField];
  
  serverTypeLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,130,80,TextFieldHeight)
				 label: _(@"Server type:")];
  [box1 addSubview: serverTypeLabel];

  popup = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(100,130,100,ButtonHeight)];
  [popup addItemWithTitle: _(@"POP3")];
  [popup addItemWithTitle: _(@"IMAP")];
  [popup setTarget: [self windowController] ];
  [popup setAction: @selector(setType:) ];
  [[box1 contentView] addSubview:popup];
  
  usernameLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,95,65,TextFieldHeight) 
			       label: _(@"Username:")];
  [box1 addSubview:usernameLabel];    
  usernameField = [[NSTextField alloc] initWithFrame: NSMakeRect(80,95,125,TextFieldHeight)];
  [usernameField setSelectable:YES];
  [box1 addSubview: usernameField];
  

  passwordLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,65,65,TextFieldHeight) 
			       label: _(@"Password:")];
  [box1 addSubview:passwordLabel];  
  passwordSecureField = [[NSSecureTextField alloc] initWithFrame: NSMakeRect(80,65,125,TextFieldHeight)];
  [passwordSecureField setSelectable:YES];
  [box1 addSubview: passwordSecureField];
  
  
  rememberPassword = [[NSButton alloc] initWithFrame: NSMakeRect(5,25,200,ButtonHeight)];
  [rememberPassword setButtonType:NSSwitchButton];
  [rememberPassword setBordered:NO];
  [rememberPassword setTitle: _(@"Remember password")];
  [box1 addSubview: rememberPassword];

  // We init our first tabview item
  tabViewItem1 = [[NSTabViewItem alloc] initWithIdentifier: MainTabViewItemIdentifier];
  [tabViewItem1 setLabel: _(@"General")];
  [tabViewItem1 setView: box1];
  [tabView addTabViewItem: tabViewItem1];
 
  // We init our second tabview item but we leave it empty for now
  tabViewItem2 = [[NSTabViewItem alloc] initWithIdentifier: ServerTypeTabViewItemIdentifier];
  [tabViewItem2 setLabel: @""];
  [tabView addTabViewItem: tabViewItem2];

  cancelButton = [[NSButton alloc] initWithFrame: NSMakeRect(240,5,60,ButtonHeight)];;
  AUTORELEASE(cancelButton);
  [cancelButton setButtonType:NSMomentaryPushButton];
  [cancelButton setTitle: _(@"Cancel")];
  [cancelButton setTarget: [self windowController] ];
  [cancelButton setAction: @selector(cancelClicked:)];
  [[self contentView] addSubview: cancelButton];
 
  okButton = [[NSButton alloc] initWithFrame: NSMakeRect(310,5,60,ButtonHeight)];
  AUTORELEASE(okButton);
  [okButton setButtonType: NSMomentaryPushButton];
  [okButton setKeyEquivalent: @"\r"];
  [okButton setImagePosition: NSImageRight];
  [okButton setImage: [NSImage imageNamed: @"common_ret"]];
  [okButton setAlternateImage: [NSImage imageNamed: @"common_retH"]];
  [okButton setTitle: _(@"OK")];
  [okButton setTarget: [self windowController] ];
  [okButton setAction: @selector(okClicked:)];
  [[self contentView] addSubview: okButton];

  // We initialize our pop3 and imap view
  pop3View = [[POP3View alloc] initWithFrame: NSMakeRect(5,5,350,200)];
  [pop3View initUI];
 
  imapView = [[IMAPView alloc] initWithFrame: NSMakeRect(5,5,350,200)];
  [imapView initUI];
				       
  // We finally  add our tabView
  [[self contentView] addSubview: tabView];

  // We set the initial responder and the next key views
  [self setInitialFirstResponder: serverNameField];
  [serverNameField setNextKeyView: popup];
  [popup setNextKeyView: usernameField];
  [usernameField setNextKeyView: passwordSecureField];
  [passwordSecureField setNextKeyView: rememberPassword];
  [rememberPassword setNextKeyView: cancelButton];
  [cancelButton setNextKeyView: okButton];
  [okButton setNextKeyView: serverNameField];
}


//
// access/mutation methods
//

- (NSTabView *) tabView
{
  return tabView;
}

- (NSTabViewItem *) tabViewItem1
{
  return tabViewItem1;
}

- (NSTabViewItem *) tabViewItem2
{
  return tabViewItem2;
}

- (IMAPView *) imapView
{
  return imapView;
}

- (POP3View *) pop3View
{
  return pop3View;
}

- (NSTextField *) serverNameField
{
  return serverNameField;
}

- (NSTextField *) serverPortField
{
  return serverPortField;
}

- (NSTextField *) usernameField
{
  return usernameField;
}

- (NSPopUpButton *) popup
{
  return popup;
}

- (NSSecureTextField *) passwordSecureField
{
  return passwordSecureField;
}

- (NSButton *) rememberPassword
{
  return rememberPassword;
}

@end





