/*
**  PersonalViewController.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

#import "PreferencesModule.h"

@interface PersonalViewController : NSObject <PreferencesModule>
{
  // Outlets
  IBOutlet id view;
  
  IBOutlet NSBox *box;
  IBOutlet NSPopUpButton *popUpButton;

  IBOutlet NSTextField *nameField;
  IBOutlet NSTextField *emailField;
  IBOutlet NSTextField *replytoField;
  IBOutlet NSTextField *organizationField;
  
  IBOutlet NSPopUpButton *signaturePopUp;
  IBOutlet NSTextField *signatureField;
  
  IBOutlet NSButton *showWaitPanels;

  IBOutlet NSButton *defaultProfileButton;

  // Other ivars
  NSMutableDictionary *allPersonalProfiles;
  NSArray *allKeys;

  NSString *defaultPersonal;
}

//
// action methods
//

- (IBAction) addClicked: (id) sender;

- (IBAction) changePersonalSelection: (id) sender;

- (IBAction) defaultProfileButtonClicked: (id) sender;

- (IBAction) deleteClicked: (id) sender;

- (IBAction) getSignature: (id) sender;

// 
// private method
//
- (void) _synchronizePersonalPreferencesWithCurrentSelection;


@end
