/*
**  MimeTypeEditorWindowController.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class MimeTypeManager;
@class MimeType;

@interface MimeTypeEditorWindowController: NSWindowController
{
  // Outlets
  IBOutlet NSTextField *mimeTypeField;
  IBOutlet NSTextField *fileExtensionsField;
  IBOutlet NSTextField *descriptionField;
  IBOutlet NSTextField *dataHandlerCommandField;

  IBOutlet NSButton *dataHandlerCommandButton;
  IBOutlet NSButton *needsTerminalButton;
  IBOutlet NSButton *iconButton;
  
  IBOutlet NSMatrix *viewMatrix;
  IBOutlet NSMatrix *actionMatrix;
 
  // Other ivar
  MimeTypeManager *mimeTypeManager;
  MimeType *mimeType;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification;
- (void) windowDidLoad;

//
// action methods
//
- (IBAction) okClicked: (id) sender;

- (IBAction) cancelClicked: (id) sender;

- (IBAction) chooseDataHandlerCommand: (id) sender;
- (IBAction) chooseIcon: (id) sender;

- (IBAction) selectionHasChanged : (id) sender;

//
// access/mutation methods
//
- (void) setMimeTypeManager: (MimeTypeManager *) theMimeTypeManager;
- (MimeTypeManager *) mimeTypeManager;

- (void) setMimeType: (MimeType *) theMimeType;
- (MimeType *) mimeType;

@end

