/*
**  MailcapWindowController.h
**
**  Copyright (c) 2001
**
**  Author: Vincent Ricard <vricard@wanadoo.fr> 
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class MimeType;

@interface MailcapWindowController: NSWindowController
{
  // Outlets
  IBOutlet NSTableView *tableView;
  IBOutlet NSTableColumn *mimeTypesColumn;
  IBOutlet NSTableColumn *commandColumn;
  
  // Other ivar
  NSString *filename;
  NSMutableArray *mimeTypes, *chosenMimeTypes;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;

- (void) dealloc;

//
// delegate methods
//

- (void) windowDidLoad;

//
// action methods
//
- (IBAction) importClicked: (id) sender;
- (IBAction) cancelClicked: (id) sender;

//
// access / mutation methods
//

- (NSArray *) getChoices;

- (MimeType *) mimeType: (int) aIndex;

- (NSString *) filename;
- (void) setFilename: (NSString *) theFilename;


//
// other methods
//
- (void) chose: (int) aIndex;

@end
