/*
**  FontsView.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Sir Raorn <raorn@binec.ru>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import <AppKit/AppKit.h>
#import "FontsView.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation FontsView

- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;

  return self;
}

- (void) layoutView
{
  LabelWidget *headerNameLabel, *headerValueLabel, *messageContentLabel, *label;
  NSButton *headerNameButton, *headerValueButton, *messageContentButton;
  
  label =  [LabelWidget labelWidgetWithFrame: NSMakeRect(5, 325, 300, TextFieldHeight)
			label: _(@"Font used when displaying a message for:")];
  [self addSubview: label];
  
  //
  // Header name
  //
  headerNameLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5, 280, 125, TextFieldHeight)
			  label: _(@"Header name:")
			  alignment: NSRightTextAlignment];
  [self addSubview: headerNameLabel];

  headerNameField = [[NSTextField alloc] initWithFrame: NSMakeRect(135, 270, 230, 40)];
  [headerNameField setEditable: NO];
  [headerNameField setSelectable: NO];
  [headerNameField setBezeled: NO];
  [headerNameField setBordered: YES];
  [self addSubview: headerNameField];

  headerNameButton = [[NSButton alloc] initWithFrame: NSMakeRect(375, 270, 60, ButtonHeight)];
  [headerNameButton setTitle: _(@"Set...")];
  [headerNameButton setTarget: parent];
  [headerNameButton setAction: @selector(headerNameClicked:)];
  [self addSubview: headerNameButton];
  RELEASE(headerNameButton);


  //
  // Header value
  //
  headerValueLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5, 230, 125, TextFieldHeight)
                             label: _(@"Header value:")
			     alignment: NSRightTextAlignment];
  [self addSubview:headerValueLabel];

  headerValueField = [[NSTextField alloc] initWithFrame: NSMakeRect(135, 220, 230, 40)];
  [headerValueField setEditable: NO];
  [headerValueField setSelectable: NO];
  [headerValueField setBezeled: NO];
  [headerValueField setBordered: YES];
  [self addSubview: headerValueField];

  headerValueButton = [[NSButton alloc] initWithFrame: NSMakeRect(375, 220, 60, ButtonHeight)];
  [headerValueButton setTitle: _(@"Set...")];
  [headerValueButton setTarget: parent];
  [headerValueButton setAction: @selector(headerValueClicked:)];
  [self addSubview: headerValueButton];
  RELEASE(headerValueButton);


  //
  // Content of message
  //
  messageContentLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5, 180, 125, TextFieldHeight)
                              label: _(@"Content of message:")
			      alignment: NSRightTextAlignment];
  [self addSubview:messageContentLabel];

  messageContentField = [[NSTextField alloc] initWithFrame: NSMakeRect(135, 170, 230, 40)];
  [messageContentField setEditable: NO];
  [messageContentField setSelectable: NO];
  [messageContentField setBezeled: NO];
  [messageContentField setBordered: YES];
  [self addSubview: messageContentField];

  messageContentButton = [[NSButton alloc] initWithFrame: NSMakeRect(375, 170, 60, ButtonHeight)];
  [messageContentButton setTitle: _(@"Set...")];
  [messageContentButton setTarget: parent];
  [messageContentButton setAction: @selector(messageContentClicked:)];
  [self addSubview: messageContentButton];
  RELEASE(messageContentButton);
}

- (void) dealloc
{
  RELEASE(headerNameField);
  RELEASE(headerValueField);
  RELEASE(messageContentField);

  [super dealloc];
}

- (NSTextField *) headerNameField
{
  return headerNameField;
}

- (NSTextField *) headerValueField
{
  return headerValueField;
}

- (NSTextField *) messageContentField
{
  return messageContentField;
}

- (void) changeFont: (id) sender
{
  [parent changeFont: sender];
}


@end
