/*
**  ComposeView.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "ComposeView.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"


@implementation ComposeView

- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;

  return self;
}

- (void) layoutView
{
  LabelWidget *replyLabel1, *replyLabel2, *forwardLabel1, *forwardLabel2;
  LabelWidget *label1, *label2;

  // our reply information
  replyLabel1 = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,325,300,TextFieldHeight)
			     label: _(@"When replying to an E-Mail, add the signature to the") ];
  [self addSubview: replyLabel1];
  
  replyPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(20,295,120,ButtonHeight)];
  [replyPopUpButton addItemWithTitle: _(@"beginning")];
  [replyPopUpButton addItemWithTitle: _(@"end")];
  [replyPopUpButton setTarget: parent];
  [replyPopUpButton setAction: @selector(selectionOfReplyPopUpButtonHasChanged:)];
  [self addSubview: replyPopUpButton];

  replyLabel2 = [LabelWidget labelWidgetWithFrame: NSMakeRect(145,295,150,TextFieldHeight)
			     label: _(@"of the message.") ];
  [self addSubview: replyLabel2];
  
  
  // our forward information
  forwardLabel1 = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,265,300,TextFieldHeight)
			       label: _(@"When forwarding an E-Mail, add the signature to the") ];
  [self addSubview: forwardLabel1];
  
  forwardPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(20,235,120,ButtonHeight)];
  [forwardPopUpButton addItemWithTitle: _(@"beginning")];
  [forwardPopUpButton addItemWithTitle: _(@"end")];
  [forwardPopUpButton setTarget: parent];
  [forwardPopUpButton setAction: @selector(selectionOfForwardPopUpButtonHasChanged:)];
  [self addSubview: forwardPopUpButton];

  forwardLabel2 = [LabelWidget labelWidgetWithFrame: NSMakeRect(145,235,150,TextFieldHeight)
			       label: _(@"of the message.") ];
  [self addSubview: forwardLabel2];

  
  label1 = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,205,80,TextFieldHeight)
			label: _(@"Wrap lines at")];
  [self addSubview: label1];
  
  lineWrapLimitField = [[NSTextField alloc] initWithFrame: NSMakeRect(90,205,40,TextFieldHeight)];
  [self addSubview: lineWrapLimitField];
  
  label2 = [LabelWidget labelWidgetWithFrame: NSMakeRect(135,205,275,TextFieldHeight)
			label: _(@"characters when sending plain/text messages.")];
  [self addSubview: label2];

}

- (void) dealloc
{
  //NSLog(@"ComposeView: -dealloc");
  
  RELEASE(replyPopUpButton);
  RELEASE(forwardPopUpButton);
  RELEASE(lineWrapLimitField);
  
  [super dealloc];
}

//
// access methods
//

- (NSPopUpButton *) replyPopUpButton
{
  return replyPopUpButton;
}

- (NSPopUpButton *) forwardPopUpButton
{
  return forwardPopUpButton;
}

- (NSTextField *) lineWrapLimitField
{
  return lineWrapLimitField;
}

@end
