/*
**  BounceWindowController.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

#import "AddressTaker.h"

@class Address;
@class Message;

@interface BounceWindowController: NSWindowController <AddressTaker>
{
  // Outlets
  IBOutlet NSTextField *toField;
  IBOutlet NSTextField *ccField;
  IBOutlet NSTextField *bccField;
  
  IBOutlet NSButton *icon;
  IBOutlet NSButton *sendButton;
  IBOutlet NSButton *addressesButton;
  IBOutlet NSButton *cancelButton;
  
  IBOutlet NSPopUpButton *personalProfilePopUpButton;
  IBOutlet NSPopUpButton *transportMethodPopUpButton;

  // Other ivar
  Message *message;

  NSConnection *connection;
  NSArray *ports;

  NSTimer *animation;
  int animation_index;

  NSMutableDictionary *passwordCache;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

//
// action methods
//

- (IBAction) send : (id) sender;

- (IBAction) personalProfilesSelectionHasChanged: (id) sender;

- (IBAction) updateAnimatedIcon: (id) sender;

//
// delegate methods
//

- (BOOL) windowShouldClose: (id) sender;

- (void) windowWillClose: (NSNotification *) theNotification;

- (void) windowDidBecomeMain: (NSNotification *) theNotification;

- (void) windowDidLoad;

//
// access/mutation methods
//

- (Message *) message;
- (void) setMessage: (Message *) theMessage;

//
// other methods
//

- (void) authenticationFailedForServer: (NSString *) theServer;
- (void) messageWasSent;
- (void) errorOccuredWhenSendingMessage;

@end

//
// private methods
//
@interface BounceWindowController (Private)

- (BOOL) _appendAdditionalHeadersToData: (NSMutableData *) theData;

- (void) _loadPersonalProfiles;

- (void) _loadTransportMethods;

- (NSString *) _passwordForServerName: (NSString *) theName
                               prompt: (BOOL) aBOOL;

- (void) _sendMessageUsingInfoFromDictionary: (NSDictionary *) theDictionary;

@end
