/*
**  AddressBook.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**          Jonathan B. Leffert <jonathan@leffert.net>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class Address;
@class Group;

NSString *PathToAddressBook();

@interface AddressBook: NSObject <NSCoding>
{
  NSMutableArray *allGroups;
}

- (id) init;
- (void) dealloc;

- (BOOL) synchronize;

//
// NSCoding protocol
//

- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;

//
// access/mutation methods
//

- (void) addGroup: (Group *) theGroup;
- (void) removeGroup: (Group *) theGroup;

- (NSArray *) allGroups;
- (void) setGroups: (NSArray *) theGroups;

- (Group *) groupAtIndex: (int) theIndex;
- (Group *) groupForName: (NSString *) theName;

- (unsigned int) indexOfGroup: (Group *) theGroup;

- (void) sort;

//
// class methods
//

+ (id) addressBook;
+ (id) addressBookFromDisk;

@end
