/* GnoSamba 0.3.3
 * copyright 1998-9 Perry Piplani
 * redistributable under the terms of the GPL:
 * http://www.gnu.org/copyleft/gpl.html
 */


#include <gtk/gtk.h>
#include <strings.h>
#include "gtksamba.h"
#include "../pix/share.xpm"
#include "../pix/delshare.xpm"
#include "../pix/delete.xpm"
#include "../pix/exit.xpm"
#include "../pix/new.xpm" 
#include "../pix/open.xpm"
#include "../pix/edit.xpm"
#include "../pix/save.xpm"
#include "../pix/samba.xpm"


void get_user_list(GtkWidget *combo){
  FILE *passwd;
  GList *list=NULL;
  char buff[1024], *s;

  if( (passwd=fopen("/etc/passwd","r")) == NULL)
    return;

  while(fgets(buff,1024,passwd)){
    s=strtok(buff,":");
    if(strcmp(s,"root"))
      list=g_list_append(list,g_strdup(s));
  }
  fclose(passwd);
  
  if(list){
    gtk_combo_set_popdown_strings (GTK_COMBO (combo), list);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),"");
  }

  while(list){
    g_free(list->data);
    list=g_list_remove_link(list,list);
  }

  return;

}

void get_group_list(GtkWidget *combo){
  FILE *passwd;
  GList *list=NULL;
  char buff[1024],s[34];

  if( (passwd=fopen("/etc/group","r")) == NULL)
    return;

  s[0]='@';

  while(fgets(buff,1024,passwd)){
    strncpy(s+1,strtok(buff,":"),32);
    if(strcmp(s,"@root"))
      list=g_list_append(list,g_strdup(s));
  }
  fclose(passwd);
  
  if(list){
    gtk_combo_set_popdown_strings (GTK_COMBO (combo), list);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),"");
  }
  
  while(list){
    g_free(list->data);
    list=g_list_remove_link(list,list);
  }

  return;

}

void c_button_list_add(GtkWidget *button, gpointer clist){
  GtkWidget *entry;
  gchar *text;
  int row;

  entry=gtk_object_get_data(GTK_OBJECT(button),"entry");
  text=gtk_entry_get_text(GTK_ENTRY(entry));

  if(GTK_CLIST(clist)->selection){
    row = (int)(GTK_CLIST(clist)->selection->data);
    gtk_clist_insert(GTK_CLIST(clist),row+1,&text);
  }
  else
    gtk_clist_insert(GTK_CLIST(clist),0,&text);

}

void c_button_list_rem(GtkWidget *button, gpointer clist){
  int row;

  if(GTK_CLIST(clist)->selection){
    row = (int)(GTK_CLIST(clist)->selection->data);
    gtk_clist_remove(GTK_CLIST(clist),row);
  }
  return;
}

void c_button_list_clr(GtkWidget *button, gpointer clist){

  gtk_clist_clear(GTK_CLIST(clist));
  return;
}
  
void c_toggle_insensitive(GtkWidget *toggle,gpointer widget){
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(toggle)))
    gtk_widget_set_sensitive(GTK_WIDGET(widget),FALSE);
  else
    gtk_widget_set_sensitive(GTK_WIDGET(widget),TRUE);
  return;
}

void c_choice_insensitive_one(GtkWidget *choicebox, gpointer widget){
  int index;

  index=gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox));
  if(index==1)
    gtk_widget_set_sensitive(GTK_WIDGET(widget),FALSE);
  else
    gtk_widget_set_sensitive(GTK_WIDGET(widget),TRUE);
  return;
}

void c_choice_insensitive_two(GtkWidget *choicebox, gpointer widget){
  int index;

  index=gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox));
  if(index==2)
    gtk_widget_set_sensitive(GTK_WIDGET(widget),FALSE);
  else
    gtk_widget_set_sensitive(GTK_WIDGET(widget),TRUE);
  return;
}

    

  

void handle_sensitivity(GtkWidget *mguru){
  
  switch(gnome_mguru_get_page(GNOME_MGURU(mguru))){
  case 0:
    gnome_mguru_set_state(GNOME_MGURU(mguru),
			  GNOME_MGURU_START);
    break;

  case 8:
    gnome_mguru_set_state(GNOME_MGURU(mguru),
			  GNOME_MGURU_LAST);
    break;
    
  default:
    gnome_mguru_set_state(GNOME_MGURU(mguru),
			  GNOME_MGURU_MIDDLE);
  }
  
}

int is_oct_string(char *s){
  char *p;
  for(p=s;*p && is_oct(*p); p++);
  if(*p)
    return 0;
  else
    return 1;
}

int is_dig_string(char *s){
  char *p;
  for(p=s;*p && isdigit(*p); p++);
  if(*p)
    return 0;
  else
    return 1;
}

void insert_service_modify_check(GtkWidget *mguru,GtkWidget *window){
  GtkWidget *entry;
  GtkWidget *servicelist;
  gchar *text, *name;
  int j;

  servicelist=gtk_object_get_data(GTK_OBJECT(window),"servicelist");
  entry=gtk_object_get_data(GTK_OBJECT(mguru),"name_entry");
  name=gtk_entry_get_text(GTK_ENTRY(entry));


  for(j=0; j < GTK_CLIST(servicelist)->rows; j++){
    gtk_clist_get_text(GTK_CLIST(servicelist),
		       j,0,&text);
    if(!strcasecmp(text,name)){
      gtk_clist_select_row(GTK_CLIST(servicelist),j,0);
      gtk_object_set_data(GTK_OBJECT(mguru),
			  "modify",GINT_TO_POINTER(1));
      return;
    }
  }
  gtk_object_set_data(GTK_OBJECT(mguru),
		      "modify",GINT_TO_POINTER(0));
  return;
}
char *make_string_list(GtkWidget *clist){
  char *list, *text;
  int j, len;
  int blocks=1;

  list=g_malloc(1024);
  list[0]='\0';
  len=1;

  for(j=0; j < GTK_CLIST(clist)->rows; j++){
    gtk_clist_get_text(GTK_CLIST(clist),
		       j,0,&text);
  
    len=len+strlen(text)+2;
    if(len > 1024*blocks)
      list=g_realloc(list,(++blocks)*1024);
    if(j)
      strcat(list,", ");
    strcat(list,text);
  }
  if(strlen(list))
    return list;
  
  g_free(list);
  return NULL;

}	

void mguru_make_service(GtkWidget *mguru,GtkWidget *window){
  GtkWidget *entry;
  GtkWidget *sublist;
  gchar *text;
  gchar *pair[2];
  GtkWidget *choicebox1, *choicebox2;
  int index1, index2;
  GtkWidget *clist;
  GtkWidget *checkbutton;
  
  index1=GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(mguru),
					      "modify"));
  if(index1)
    smbwin_delete_service(window);

  entry=gtk_object_get_data(GTK_OBJECT(mguru),"name_entry");
  text=gtk_entry_get_text(GTK_ENTRY(entry));

  smbwin_insert_service(text,window);
  sublist=gtk_object_get_data(GTK_OBJECT(window),"sublist");

  entry=gtk_object_get_data(GTK_OBJECT(mguru),"comment_entry");
  if(GTK_ENTRY(entry)->text_length){
    pair[1]=gtk_entry_get_text(GTK_ENTRY(entry));
    pair[0]=g_strdup("comment");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
  }

  entry=gtk_object_get_data(GTK_OBJECT(mguru),"path_entry");
  if(GTK_ENTRY(entry)->text_length){
    pair[1]=gtk_entry_get_text(GTK_ENTRY(entry));
    pair[0]=g_strdup("path");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
  }

  choicebox1=gtk_object_get_data(GTK_OBJECT(mguru),"users_choice");
  index1=gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox1));
  choicebox2=gtk_object_get_data(GTK_OBJECT(mguru),"guest_choice");
  index2=gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox2));

  if(index2 != 2){
    pair[0]=g_strdup("guest ok");
    pair[1]=g_strdup("yes");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
    g_free(pair[1]);

    entry=gtk_object_get_data(GTK_OBJECT(mguru),"guest_account_entry");
    if(GTK_ENTRY(entry)->text_length){
      pair[1]=gtk_entry_get_text(GTK_ENTRY(entry));
      pair[0]=g_strdup("guest_account");
      gtk_clist_append(GTK_CLIST(sublist),pair);
      g_free(pair[0]);
  }

    
  }

  if(index2 == 1){
    pair[0]=g_strdup("guest only");
    pair[1]=g_strdup("yes");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
    g_free(pair[1]);
  }

  if(index1 == 1  &&  index2 !=1){
    clist=gtk_object_get_data(GTK_OBJECT(mguru),"valid_users_list");
    pair[1]=make_string_list(clist);
    if(pair[1]){
      pair[0]=g_strdup("valid users");
      gtk_clist_append(GTK_CLIST(sublist),pair);
      g_free(pair[0]);
      g_free(pair[1]);
    }
    
    clist=gtk_object_get_data(GTK_OBJECT(mguru),"invalid_users_list");
    pair[1]=make_string_list(clist);
    if(pair[1]){
      pair[0]=g_strdup("invalid users");
      gtk_clist_append(GTK_CLIST(sublist),pair);
      g_free(pair[0]);
      g_free(pair[1]);
    }
    
  }

  checkbutton=gtk_object_get_data(GTK_OBJECT(mguru),"all_hosts_toggle");
  if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton))){
    clist=gtk_object_get_data(GTK_OBJECT(mguru),"hosts_allow_list");
    pair[1]=make_string_list(clist);
    if(pair[1]){
      pair[0]=g_strdup("hosts allow");
      gtk_clist_append(GTK_CLIST(sublist),pair);
      g_free(pair[0]);
      g_free(pair[1]);
    }

    clist=gtk_object_get_data(GTK_OBJECT(mguru),"hosts_deny_list");
    pair[1]=make_string_list(clist);
    if(pair[1]){
      pair[0]=g_strdup("hosts deny");
      gtk_clist_append(GTK_CLIST(sublist),pair);
      g_free(pair[0]);
      g_free(pair[1]);
    }
  }

  choicebox1=gtk_object_get_data(GTK_OBJECT(mguru),"read_write_choice");
  index1=gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox1));


  pair[0]=g_strdup("writeable");
  if(index1 < 2)
    pair[1]=g_strdup("no");
  else
    pair[1]=g_strdup("yes");
  gtk_clist_append(GTK_CLIST(sublist),pair);
  g_free(pair[0]);
  g_free(pair[1]);
  
  if(index1 == 1 || index2 == 2){
    clist=gtk_object_get_data(GTK_OBJECT(mguru),"read_list");
    pair[1]=make_string_list(clist);
    if(pair[1]){
      pair[0]=g_strdup("read list");
      gtk_clist_append(GTK_CLIST(sublist),pair);
      g_free(pair[0]);
      g_free(pair[1]);
    }

    clist=gtk_object_get_data(GTK_OBJECT(mguru),"write_list");
    pair[1]=make_string_list(clist);
    if(pair[1]){
      pair[0]=g_strdup("write list");
      gtk_clist_append(GTK_CLIST(sublist),pair);
      g_free(pair[0]);
      g_free(pair[1]);
    }
  }

  entry=gtk_object_get_data(GTK_OBJECT(mguru),"file_create_entry");
  if(GTK_ENTRY(entry)->text_length){
    pair[1]=gtk_entry_get_text(GTK_ENTRY(entry));
    pair[0]=g_strdup("create mask");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
  }

  entry=gtk_object_get_data(GTK_OBJECT(mguru),"force_create_entry");
  if(GTK_ENTRY(entry)->text_length){
    pair[1]=gtk_entry_get_text(GTK_ENTRY(entry));
    pair[0]=g_strdup("force create mode");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
  }

  entry=gtk_object_get_data(GTK_OBJECT(mguru),"directory_create_entry");
  if(GTK_ENTRY(entry)->text_length){
    pair[1]=gtk_entry_get_text(GTK_ENTRY(entry));
    pair[0]=g_strdup("directory mask");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
  }

  entry=gtk_object_get_data(GTK_OBJECT(mguru),"force_directory_entry");
  if(GTK_ENTRY(entry)->text_length){
    pair[1]=gtk_entry_get_text(GTK_ENTRY(entry));
    pair[0]=g_strdup("force directory mode");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
  }

  checkbutton=gtk_object_get_data(GTK_OBJECT(mguru),"browseable_toggle");
  if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton))){
    pair[0]=g_strdup("browseable");
    pair[1]=g_strdup("no");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
    g_free(pair[1]);
  }

  checkbutton=gtk_object_get_data(GTK_OBJECT(mguru),"hide_dot_toggle");
  if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton))){
    pair[0]=g_strdup("hide dot files");
    pair[1]=g_strdup("no");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
    g_free(pair[1]);
  }

  entry=gtk_object_get_data(GTK_OBJECT(mguru),"max_connect_entry");
  if(GTK_ENTRY(entry)->text_length){
    pair[1]=gtk_entry_get_text(GTK_ENTRY(entry));
    pair[0]=g_strdup("max connections");
    gtk_clist_append(GTK_CLIST(sublist),pair);
    g_free(pair[0]);
  }

  return;
}

void c_service_mguru_button(GtkWidget *mguru, 
			  gint page,
			  gint button,
			  gpointer window){

  GtkWidget *entry;
  GtkWidget *choicebox1, *choicebox2;
  int index;
  GtkWidget *dialog;
                   
  switch(button){
  case 0:
    dialog=gtk_object_get_data(GTK_OBJECT(mguru),"dialog");
    make_user_mesg("New service cancelled.","Information");
    gtk_widget_destroy(GTK_WIDGET(dialog));
    resensitize_sw(GTK_WIDGET(window));
    break;
    
    
  case 1:
    if(page==1)
      gnome_mguru_set_page(GNOME_MGURU(mguru),0);
    else if(page==2)
      gnome_mguru_set_page(GNOME_MGURU(mguru),1);
    else if(page==3)
      gnome_mguru_set_page(GNOME_MGURU(mguru),2);
    else if(page==4){
      choicebox1=gtk_object_get_data(GTK_OBJECT(mguru),"users_choice");
      choicebox2=gtk_object_get_data(GTK_OBJECT(mguru),"guest_choice");
      if(gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox1))==0 ||
	 gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox2))==1)
	gnome_mguru_set_page(GNOME_MGURU(mguru),2);
      else
	gnome_mguru_set_page(GNOME_MGURU(mguru),3);
    }
    else if(page==5)
      gnome_mguru_set_page(GNOME_MGURU(mguru),4);
    else if(page==6)
      gnome_mguru_set_page(GNOME_MGURU(mguru),5);
    else if(page==7){
      choicebox1=gtk_object_get_data(GTK_OBJECT(mguru),"read_write_choice");
      index=gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox1));
      if( index==0 || index==3 )
	gnome_mguru_set_page(GNOME_MGURU(mguru),5);
      else
	gnome_mguru_set_page(GNOME_MGURU(mguru),6);
    }
    else if(page==8)
      gnome_mguru_set_page(GNOME_MGURU(mguru),7);
    handle_sensitivity(mguru);
    break;
    
    
  case 2:
    if(page==0){
      entry=gtk_object_get_data(GTK_OBJECT(mguru),"name_entry");
      if(!(GTK_ENTRY(entry)->text_length))
	make_user_mesg("Enter the service name!","Warning");
      else{
	insert_service_modify_check(mguru,window);
	gnome_mguru_set_page(GNOME_MGURU(mguru),1);
      }
    }
    else if(page==1){
      entry=gtk_object_get_data(GTK_OBJECT(mguru),"path_entry");
      if(!(GTK_ENTRY(entry)->text_length))
	make_user_mesg("Enter a path to share!","Warning");
      else
	gnome_mguru_set_page(GNOME_MGURU(mguru),2);
    }
    else if(page==2){
      choicebox1=gtk_object_get_data(GTK_OBJECT(mguru),"users_choice");
      choicebox2=gtk_object_get_data(GTK_OBJECT(mguru),"guest_choice");
      if(gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox1))==0 ||
	 gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox2))==1)
	gnome_mguru_set_page(GNOME_MGURU(mguru),4);
      else
	gnome_mguru_set_page(GNOME_MGURU(mguru),3);
    }
    else if(page==3)
      gnome_mguru_set_page(GNOME_MGURU(mguru),4);
    else if(page==4)
      gnome_mguru_set_page(GNOME_MGURU(mguru),5);
    else if(page==5){
      choicebox1=gtk_object_get_data(GTK_OBJECT(mguru),"read_write_choice");
      index=gnome_choice_box_get_index(GNOME_CHOICE_BOX(choicebox1));
      if( index==0 || index==3 )
	gnome_mguru_set_page(GNOME_MGURU(mguru),7);
      else
	gnome_mguru_set_page(GNOME_MGURU(mguru),6);
    }
    else if(page==6)
      gnome_mguru_set_page(GNOME_MGURU(mguru),7);
    else if(page==7){
      index=0;
      entry=gtk_object_get_data(GTK_OBJECT(mguru),"file_create_entry");
      if(GTK_ENTRY(entry)->text_length)
	if(!is_oct_string(gtk_entry_get_text(GTK_ENTRY(entry))))
	  index=1;
      entry=gtk_object_get_data(GTK_OBJECT(mguru),"force_create_entry");
      if(GTK_ENTRY(entry)->text_length)
	if(!is_oct_string(gtk_entry_get_text(GTK_ENTRY(entry))))
	  index=1;
      entry=gtk_object_get_data(GTK_OBJECT(mguru),"directory_create_entry");
      if(GTK_ENTRY(entry)->text_length)
	if(!is_oct_string(gtk_entry_get_text(GTK_ENTRY(entry))))
	  index=1;
      entry=gtk_object_get_data(GTK_OBJECT(mguru),"force_directory_entry");
      if(GTK_ENTRY(entry)->text_length)
	if(!is_oct_string(gtk_entry_get_text(GTK_ENTRY(entry))))
	  index=1;
      if(index)
	make_user_mesg("Enter octal values or leave blank","Warning");
      else
	gnome_mguru_set_page(GNOME_MGURU(mguru),8);
    }
    handle_sensitivity(mguru);
    break;
    
    
  case 3:
    entry=gtk_object_get_data(GTK_OBJECT(mguru),"max_connect_entry");
    if(GTK_ENTRY(entry)->text_length)
      if(!is_dig_string(gtk_entry_get_text(GTK_ENTRY(entry)))){
	make_user_mesg("Enter integer value or leave blank","Warning");
	return;
      }
      
    mguru_make_service(mguru,GTK_WIDGET(window));
    dialog=gtk_object_get_data(GTK_OBJECT(mguru),"dialog");
    make_user_mesg("New service created","Information");
    gtk_widget_destroy(GTK_WIDGET(dialog));
    resensitize_sw(GTK_WIDGET(window));
  }
    
  return;
  
}



GtkWidget *service_guru_page_one(GtkWidget *guru, GtkWidget *window){
  GtkWidget *vbox;
  GtkWidget *label;
  GtkWidget *combo;
  GList *services=NULL;
  int j;
  gchar *text;
  GtkWidget *servicelist;

  servicelist=gtk_object_get_data(GTK_OBJECT(window),"servicelist");


  vbox=gtk_vbox_new(TRUE,0);
  
  label = gtk_label_new("Enter a new service name or\n choose and existing one");
  gtk_box_pack_start (GTK_BOX (vbox), 
                      label, TRUE, TRUE, 10);
  gtk_widget_show (label);
  
    label = gtk_label_new
      ("Note: this will overwrite an\nexisting service. Future versions\n will allow you to modify a service.");
  gtk_box_pack_start (GTK_BOX (vbox), 
                      label, TRUE, TRUE, 10);
  gtk_widget_show (label);

  for(j=0; j < GTK_CLIST(servicelist)->rows; j++){
    gtk_clist_get_text(GTK_CLIST(servicelist),
		       j,0,&text);
    if(strcasecmp(text,"global") &&
       strcasecmp(text,"printers") &&
       strcasecmp(text,"homes"))
      services=g_list_append(services,text);
  }

  combo=gtk_combo_new ();
  if(services)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo), services);
  gtk_box_pack_start (GTK_BOX (vbox), 
                      combo, TRUE, TRUE, 10);
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),"");
  gtk_widget_show (combo);

  gtk_object_set_data(GTK_OBJECT(guru),"name_entry",
		      GTK_COMBO(combo)->entry);

    while(services){
    services=g_list_remove_link(services,services);
  }
  
  return vbox;

}

GtkWidget *service_guru_page_two(GtkWidget *guru){
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *path_entry;
  GtkWidget *comment_entry;

  table=gtk_table_new (2, 3, TRUE);
  
  label = gtk_label_new("Comment:");
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,0,1);
  gtk_widget_show (label);

  comment_entry=gnome_entry_new("comment entry");
  gtk_table_attach_defaults(GTK_TABLE(table),comment_entry,1,3,0,1);
  gtk_widget_show (comment_entry);

  gtk_object_set_data(GTK_OBJECT(guru),"comment_entry",
		      gnome_entry_gtk_entry(GNOME_ENTRY(comment_entry)));

  label = gtk_label_new("Path:");
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,1,2);
  gtk_widget_show (label);

  path_entry=gnome_file_entry_new("path entry",
			     "Path to be served");
  gtk_table_attach(GTK_TABLE(table),path_entry,1,3,1,2,
		   GTK_FILL | GTK_EXPAND,
		   GTK_EXPAND,0,0);
  gtk_widget_show (path_entry);

  gtk_object_set_data(GTK_OBJECT(guru),"path_entry",
		      gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(path_entry)));

  return table;

}




GtkWidget *service_guru_page_three(GtkWidget *guru){
  GtkWidget *vbox;
  GtkWidget *separator;
  GtkWidget *choicebox1, *choicebox2;
  GtkWidget *combo;
  GtkWidget *label;
  GtkWidget *hbox;

  vbox=gtk_vbox_new(FALSE,0);

  choicebox1=gnome_choice_box_new(CHOICE_BOX_VV,NULL,
				 "Allow all users",
				 "Select valid and invalid users",
				 NULL);
  gtk_box_pack_start (GTK_BOX (vbox), 
                      choicebox1, TRUE, TRUE, 0);
  gnome_choice_box_set_index(GNOME_CHOICE_BOX(choicebox1),1);
  gtk_widget_show (choicebox1);

  gtk_object_set_data(GTK_OBJECT(guru),"users_choice",choicebox1);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), 
                      separator, TRUE, TRUE, 0);
  gtk_widget_show (separator);

  choicebox2=gnome_choice_box_new(CHOICE_BOX_VV,NULL,
				 "Allow guest access",
				 "Allow only guest access",
				 "Do not allow guest access",
				 NULL);
  gtk_box_pack_start (GTK_BOX (vbox), 
                      choicebox2, TRUE, TRUE, 0);
  gnome_choice_box_set_index(GNOME_CHOICE_BOX(choicebox2),2);
  gtk_widget_show (choicebox2);

  gtk_object_set_data(GTK_OBJECT(guru),"guest_choice",choicebox2);

  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start (GTK_BOX (vbox), 
                      hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new("Account for guest access:");
  gtk_box_pack_start (GTK_BOX (hbox), 
                      label, TRUE, TRUE, 10);
  gtk_widget_show (label);

  combo=gtk_combo_new ();
  get_user_list(combo);
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),"nobody");  
  gtk_box_pack_start (GTK_BOX (hbox), 
                      combo, TRUE, TRUE, 10);
  gtk_widget_show (combo);

  gtk_object_set_data(GTK_OBJECT(guru),"guest_account_entry",
		      GTK_COMBO(combo)->entry);

  gtk_signal_connect(GTK_OBJECT(choicebox2),"choice_made",
		     c_choice_insensitive_one,choicebox1);
  gtk_signal_connect(GTK_OBJECT(choicebox2),"choice_made",
		     c_choice_insensitive_two,hbox);
  

  return vbox;

}

GtkWidget *service_guru_page_four(GtkWidget *guru){
  GtkWidget *table;
  GtkWidget *button;
  GtkWidget *gcombo, *ucombo;
  GtkWidget *label;
  GtkWidget *scrolled;
  GtkWidget *clist_allow;
  GtkWidget *clist_deny;
  char *valid_users[1] = {
    "valid users"
  };
  char *invalid_users[1] = {
    "invalid users"
  };

  table=gtk_table_new(8,4,TRUE);

  gtk_table_set_col_spacings(GTK_TABLE(table),5);
  gtk_table_set_row_spacings(GTK_TABLE(table),5);

  clist_allow=gtk_clist_new_with_titles( 1,valid_users );
  gtk_clist_set_selection_mode(GTK_CLIST(clist_allow),
			       GTK_SELECTION_BROWSE);
  scrolled=gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled), 
				 GTK_POLICY_AUTOMATIC, 
				 GTK_POLICY_AUTOMATIC);
  gtk_table_attach_defaults(GTK_TABLE(table),scrolled,0,1,0,8);
  gtk_widget_show (scrolled);
  gtk_container_add(GTK_CONTAINER(scrolled),clist_allow);
  gtk_widget_show (clist_allow);

  gtk_object_set_data(GTK_OBJECT(guru),"valid_users_list",
		      clist_allow);

  ucombo=gtk_combo_new ();
  get_user_list(ucombo);
  gtk_table_attach_defaults(GTK_TABLE(table),ucombo,1,3,1,2);
  gtk_widget_show (ucombo);

  gcombo=gtk_combo_new ();
  get_group_list(gcombo);
  gtk_table_attach_defaults(GTK_TABLE(table),gcombo,1,3,4,5);
  gtk_widget_show (gcombo);

  clist_deny=gtk_clist_new_with_titles( 1,invalid_users );
  gtk_clist_set_selection_mode(GTK_CLIST(clist_deny),
			       GTK_SELECTION_BROWSE);
  scrolled=gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled), 
				 GTK_POLICY_AUTOMATIC, 
				 GTK_POLICY_AUTOMATIC);
  gtk_table_attach_defaults(GTK_TABLE(table),scrolled,3,4,0,8);
  gtk_widget_show (scrolled);
  gtk_container_add(GTK_CONTAINER(scrolled),clist_deny);
  gtk_widget_show (clist_deny); 

  gtk_object_set_data(GTK_OBJECT(guru),"invalid_users_list",
		      clist_deny);


  button=gtk_button_new_with_label(">>>  ");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,6,7);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_rem,clist_allow);
  
  button=gtk_button_new_with_label("<--Clear");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,7,8);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_clr,clist_allow);

  label = gtk_label_new("Users:");
  gtk_table_attach_defaults(GTK_TABLE(table),label,1,3,0,1);
  gtk_widget_show (label);

  button=gtk_button_new_with_label("<<<  ");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,2,3);
  gtk_widget_show (button);
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(ucombo)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_allow);

  label = gtk_label_new("Groups:");
  gtk_table_attach_defaults(GTK_TABLE(table),label,1,3,3,4);
  gtk_widget_show (label);


  button=gtk_button_new_with_label("<<<  ");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,5,6);
  gtk_widget_show (button);
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(gcombo)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_allow);		     
  
  button=gtk_button_new_with_label("  >>>");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,2,3);
  gtk_widget_show (button);
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(ucombo)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_deny);  
  
  button=gtk_button_new_with_label("  >>>");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,5,6);
  gtk_widget_show (button);  
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(gcombo)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_deny);

  button=gtk_button_new_with_label("  <<<");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,6,7);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_rem,clist_deny);
  
  button=gtk_button_new_with_label("Clear-->");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,7,8);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_clr,clist_deny);

  return table;

}

GtkWidget *service_guru_page_five(GtkWidget *guru){
  GtkWidget *vbox;
  GtkWidget *checkbutton;
  GtkWidget *table;
  GtkWidget *button;
  GtkWidget *hostlist;
  GtkWidget *label;
  GtkWidget *scrolled;
  GtkWidget *clist_allow;
  GtkWidget *clist_deny;
  char *valid_hosts[1] = {
    "valid hosts"
  };
  char *invalid_hosts[1] = {
    "invalid hosts"
  };

  vbox=gtk_vbox_new(FALSE,0);

  checkbutton=gtk_check_button_new_with_label("Allow all hosts");
  gtk_box_pack_start (GTK_BOX (vbox), 
                      checkbutton, TRUE, TRUE, 10); 
  gtk_widget_show (checkbutton);

  gtk_object_set_data(GTK_OBJECT(guru),"all_hosts_toggle",
		      checkbutton);  
  
  table=gtk_table_new(6,4,TRUE);

  gtk_table_set_row_spacings(GTK_TABLE(table),5);
  gtk_table_set_col_spacings(GTK_TABLE(table),5);

  clist_allow=gtk_clist_new_with_titles( 1,valid_hosts );
  gtk_clist_set_selection_mode(GTK_CLIST(clist_allow),
			       GTK_SELECTION_BROWSE);
  scrolled=gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled), 
				 GTK_POLICY_AUTOMATIC, 
				 GTK_POLICY_AUTOMATIC);
  gtk_table_attach_defaults(GTK_TABLE(table),scrolled,0,1,0,6);
  gtk_widget_show (scrolled);
  gtk_container_add(GTK_CONTAINER(scrolled),clist_allow);
  gtk_widget_show (clist_allow);

  gtk_object_set_data(GTK_OBJECT(guru),"hosts_allow_list",
		      clist_allow);

  clist_deny=gtk_clist_new_with_titles( 1,invalid_hosts );
  gtk_clist_set_selection_mode(GTK_CLIST(clist_deny),
			       GTK_SELECTION_BROWSE);
  scrolled=gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled), 
				 GTK_POLICY_AUTOMATIC, 
				 GTK_POLICY_AUTOMATIC);
  gtk_table_attach_defaults(GTK_TABLE(table),scrolled,3,4,0,6);
  gtk_widget_show (scrolled);
  gtk_container_add(GTK_CONTAINER(scrolled),clist_deny);
  gtk_widget_show (clist_deny); 

  gtk_object_set_data(GTK_OBJECT(guru),"hosts_deny_list",
		      clist_deny);

  hostlist=gnome_entry_new("host list");
  gtk_table_attach_defaults(GTK_TABLE(table),hostlist,1,3,1,2);
  gtk_widget_show (hostlist);

  button=gtk_button_new_with_label(">>>  ");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,4,5);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_rem,clist_allow);
  
  button=gtk_button_new_with_label("<--Clear");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,5,6);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_clr,clist_allow);

  label = gtk_label_new("Hostnames or IP addresses");
  gtk_table_attach_defaults(GTK_TABLE(table),label,1,3,0,1);
  gtk_widget_show (label);  



  button=gtk_button_new_with_label("<<<  ");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,2,3);
  gtk_widget_show (button);
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(hostlist)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_allow);
  
  button=gtk_button_new_with_label("  >>>");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,2,3);
  gtk_widget_show (button);
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(hostlist)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_deny);

  button=gtk_button_new_with_label("  <<<");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,4,5);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_rem,clist_deny);
  
  button=gtk_button_new_with_label("Clear-->");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,5,6);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_clr,clist_deny);

  gtk_box_pack_start (GTK_BOX (vbox), 
                      table, TRUE, TRUE, 10); 
  gtk_widget_show (table);

  gtk_signal_connect(GTK_OBJECT(checkbutton),"toggled",
		     c_toggle_insensitive,table);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton),FALSE);

  return vbox;

}

GtkWidget *service_guru_page_six(GtkWidget *guru){
  GtkWidget *choicebox;

  choicebox=gnome_choice_box_new
    (CHOICE_BOX_VV,
     "Select an option for read write access\nNote all Unix access restrictions still apply",
     "Make service read only",
     "Default to read only, then specify access by user",
     "Default to read/write, then specify access by user",
     "Let Unix access restrictions alone control access",
     NULL);

  gtk_object_set_data(GTK_OBJECT(guru),"read_write_choice",
		      choicebox);

  return choicebox;

}

GtkWidget *service_guru_page_seven(GtkWidget *guru){
  GtkWidget *table;
  GtkWidget *button;
  GtkWidget *ucombo, *gcombo;
  GtkWidget *label;
  GtkWidget *scrolled;
  GtkWidget *clist_read;
  GtkWidget *clist_write;
  char *read_list[1] = {
    "read only list"
  };
  char *write_list[1] = {
    "write list"
  };

  table=gtk_table_new(8,4,TRUE);

  gtk_table_set_col_spacings(GTK_TABLE(table),5);
  gtk_table_set_row_spacings(GTK_TABLE(table),5);

  clist_read=gtk_clist_new_with_titles( 1,read_list );
  gtk_clist_set_selection_mode(GTK_CLIST(clist_read),
			       GTK_SELECTION_BROWSE);
  scrolled=gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled), 
				 GTK_POLICY_AUTOMATIC, 
				 GTK_POLICY_AUTOMATIC);
  gtk_table_attach_defaults(GTK_TABLE(table),scrolled,0,1,0,8);
  gtk_widget_show (scrolled);
  gtk_container_add(GTK_CONTAINER(scrolled),clist_read);
  gtk_widget_show (clist_read);

  gtk_object_set_data(GTK_OBJECT(guru),"read_list",
		      clist_read);

  ucombo=gtk_combo_new ();
  get_user_list(ucombo);
  gtk_table_attach_defaults(GTK_TABLE(table),ucombo,1,3,1,2);
  gtk_widget_show (ucombo);

  gcombo=gtk_combo_new ();
  get_group_list(gcombo);
  gtk_table_attach_defaults(GTK_TABLE(table),gcombo,1,3,4,5);
  gtk_widget_show (gcombo);

  clist_write=gtk_clist_new_with_titles( 1,write_list );
  gtk_clist_set_selection_mode(GTK_CLIST(clist_write),
			       GTK_SELECTION_BROWSE);
  scrolled=gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled), 
				 GTK_POLICY_AUTOMATIC, 
				 GTK_POLICY_AUTOMATIC);
  gtk_table_attach_defaults(GTK_TABLE(table),scrolled,3,4,0,8);
  gtk_widget_show (scrolled);
  gtk_container_add(GTK_CONTAINER(scrolled),clist_write);
  gtk_widget_show (clist_write); 

  gtk_object_set_data(GTK_OBJECT(guru),"write_list",
		      clist_write);

  button=gtk_button_new_with_label(">>>  ");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,6,7);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_rem,clist_read);
  
  button=gtk_button_new_with_label("<--Clear");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,7,8);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_clr,clist_read);

  label = gtk_label_new("Users:");
  gtk_table_attach_defaults(GTK_TABLE(table),label,1,3,0,1);
  gtk_widget_show (label);

  button=gtk_button_new_with_label("<<<  ");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,2,3);
  gtk_widget_show (button);
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(ucombo)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_read);

  label = gtk_label_new("Groups:");
  gtk_table_attach_defaults(GTK_TABLE(table),label,1,3,3,4);
  gtk_widget_show (label);


  button=gtk_button_new_with_label("<<<  ");
  gtk_table_attach_defaults(GTK_TABLE(table),button,1,2,5,6);
  gtk_widget_show (button);
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(gcombo)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_read);		     
  
  button=gtk_button_new_with_label("  >>>");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,2,3);
  gtk_widget_show (button);
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(ucombo)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_write);  
  
  button=gtk_button_new_with_label("  >>>");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,5,6);
  gtk_widget_show (button);  
  gtk_object_set_data(GTK_OBJECT(button),"entry",
		      GTK_COMBO(gcombo)->entry);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_add,clist_write);

  button=gtk_button_new_with_label("  <<<");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,6,7);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_rem,clist_write);
  
  button=gtk_button_new_with_label("Clear-->");
  gtk_table_attach_defaults(GTK_TABLE(table),button,2,3,7,8);
  gtk_widget_show (button);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     c_button_list_clr,clist_write);

  return table;

}
  

GtkWidget *service_guru_page_eight(GtkWidget *guru){
  GtkWidget *table;
  GtkWidget *entry;
  GtkWidget *label;
  GtkRequisition requisition;

  table=gtk_table_new(5,4,TRUE);

  gtk_table_set_row_spacings(GTK_TABLE(table),5);
  gtk_table_set_col_spacings(GTK_TABLE(table),5);

  label = gtk_label_new("Enter octal values, or leave blank for defaults:");
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,4,0,1);
  gtk_widget_show (label); 

  label = gtk_label_new("File Creation Mode (default 0744)\nTo be masked with DOS mode");
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,3,1,2);
  gtk_widget_show (label); 

  entry=gtk_entry_new_with_max_length(4);
  gtk_widget_size_request(entry,&requisition);
  gtk_widget_set_usize(entry,20,requisition.height);
  gtk_table_attach_defaults(GTK_TABLE(table),entry,3,4,1,2);
  gtk_widget_show (entry);

  gtk_object_set_data(GTK_OBJECT(guru),"file_create_entry",
		      entry);

  label = gtk_label_new("Force Creation Mode (default 0000)\nTo be bitwise OR'ed with mode above");
  gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_RIGHT);
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,3,2,3);
  gtk_widget_show (label); 

  entry=gtk_entry_new_with_max_length(4);
  gtk_widget_size_request(entry,&requisition);
  gtk_widget_set_usize(entry,20,requisition.height);
  gtk_table_attach_defaults(GTK_TABLE(table),entry,3,4,2,3);
  gtk_widget_show (entry);

  gtk_object_set_data(GTK_OBJECT(guru),"force_create_entry",
		      entry);

  label = gtk_label_new("Directory Creation Mode (default 0744)\nTo be masked with DOS mode");
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,3,3,4);
  gtk_widget_show (label);

  entry=gtk_entry_new_with_max_length(4);
  gtk_widget_size_request(entry,&requisition);
  gtk_widget_set_usize(entry,20,requisition.height);
  gtk_table_attach_defaults(GTK_TABLE(table),entry,3,4,3,4);
  gtk_widget_show (entry);

    gtk_object_set_data(GTK_OBJECT(guru),"directory_create_entry",
		      entry);

  label = gtk_label_new("Force Directory Mode (default 0000)\nTo be bitwise OR'ed with mode above");
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,3,4,5);
  gtk_widget_show (label); 

  entry=gtk_entry_new_with_max_length(4);
  gtk_widget_size_request(entry,&requisition);
  gtk_widget_set_usize(entry,20,requisition.height);
  gtk_table_attach_defaults(GTK_TABLE(table),entry,3,4,4,5);
  gtk_widget_show (entry);

  gtk_object_set_data(GTK_OBJECT(guru),"force_directory_entry",
		      entry);

  return table;

}

GtkWidget *service_guru_page_nine(GtkWidget *guru){
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *entry;
  GtkWidget *checkbutton;
  GtkWidget *label;

  vbox=gtk_vbox_new(FALSE,0);

  checkbutton=gtk_check_button_new_with_label("Make service browseable");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton),TRUE);
  gtk_box_pack_start (GTK_BOX (vbox), 
                      checkbutton, TRUE, TRUE, 10); 
  gtk_widget_show (checkbutton); 

  gtk_object_set_data(GTK_OBJECT(guru),"browseable_toggle",
		      checkbutton);

  checkbutton=gtk_check_button_new_with_label("Hide hidden (dot) files");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton),TRUE);
  gtk_box_pack_start (GTK_BOX (vbox), 
                      checkbutton, TRUE, TRUE, 10); 
  gtk_widget_show (checkbutton);

  gtk_object_set_data(GTK_OBJECT(guru),"hide_dot_toggle",
		      checkbutton);

  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start (GTK_BOX (vbox), 
                      hbox, TRUE, TRUE, 10);
  gtk_widget_show (hbox);

  label = gtk_label_new("Maximum number of connections:");
  gtk_box_pack_start (GTK_BOX (hbox), 
                      label, TRUE, TRUE, 10);
  gtk_widget_show (label);

  entry=gnome_entry_new ("max_connect");
  gtk_box_pack_start (GTK_BOX (hbox),
                      entry, TRUE, TRUE, 10);
  gtk_widget_show (entry); 

  gtk_object_set_data(GTK_OBJECT(guru),"max_connect_entry",
		      gnome_entry_gtk_entry(GNOME_ENTRY(entry))); 

  return vbox;

}

gint c_guru_diag_delete(GtkWidget *button, GdkEvent *event, 
			gpointer window){

  resensitize_sw(GTK_WIDGET(window));
  return FALSE;

}

void make_insert_service_dialog(GtkWidget *window){

  GtkWidget *mguru;
  GtkWidget *dialog;
  GtkWidget *page;
  GtkWidget *graphic=NULL;

  desensitize_sw(GTK_WIDGET(window));

  graphic = gnome_pixmap_new_from_xpm_d(samba_xpm);

  dialog = gnome_dialog_new(_("GnoSamba Service Guru"),
			    NULL);
  gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                     GTK_SIGNAL_FUNC(c_guru_diag_delete),
                     window);

  mguru = gnome_mguru_new(TRUE,GNOME_DIALOG(dialog),graphic);                   
  
  
  page=service_guru_page_one(mguru,window);
  gtk_widget_show(page);
  gnome_mguru_append_page(GNOME_MGURU(mguru),page,"Select a service");
  
  page=service_guru_page_two(mguru);
  gtk_widget_show(page);
  gnome_mguru_append_page(GNOME_MGURU(mguru),page,"Basic parameters");
  
  page=service_guru_page_three(mguru);
  gtk_widget_show(page);
  gnome_mguru_append_page(GNOME_MGURU(mguru),page,"User Access Control");

  page=service_guru_page_four(mguru);
  gtk_widget_show(page);
  gnome_mguru_append_page(GNOME_MGURU(mguru),page,"Select User Access Control");

  page=service_guru_page_five(mguru);
  gtk_widget_show(page);
  gnome_mguru_append_page(GNOME_MGURU(mguru),page,"Host Access Control");

  page=service_guru_page_six(mguru);
  gtk_widget_show(page);
  gnome_mguru_append_page(GNOME_MGURU(mguru),page,"Read Write Control");

  page=service_guru_page_seven(mguru);
  gtk_widget_show(page);
  gnome_mguru_append_page(GNOME_MGURU(mguru),page,"Read Write Control");

  page=service_guru_page_eight(mguru);
  gtk_widget_show(page);
  gnome_mguru_append_page(GNOME_MGURU(mguru),page,"Read Write Control");

  page=service_guru_page_nine(mguru);
  gtk_widget_show(page);
  gnome_mguru_append_page(GNOME_MGURU(mguru),page,"Read Write Control");

  gtk_object_set_data(GTK_OBJECT(mguru),"dialog",dialog);
  gtk_signal_connect(GTK_OBJECT(mguru),
		     "mguru_click",
		     GTK_SIGNAL_FUNC(c_service_mguru_button),
		     window);
  gtk_widget_show(mguru);
  gtk_widget_show(dialog);
  handle_sensitivity(mguru);
  return;

}

void c_del_diag_ok(GtkWidget *button, gpointer window){
  GtkWidget *diagwin;
  int row;
  GtkWidget *sublist;

  diagwin=gtk_object_get_data(GTK_OBJECT(window),"dialog");
  sublist=gtk_object_get_data(GTK_OBJECT(window),"sublist");
  
  
  row = (int)(GTK_CLIST(sublist)->selection->data);
  gtk_clist_remove(GTK_CLIST(sublist),row);

  resensitize_sw(GTK_WIDGET(window));
  

  gtk_widget_destroy(diagwin);
  gtk_object_set_data(GTK_OBJECT(window),"dialog",NULL);
  return;
  
}

void make_del_dialog(GtkWidget *window){
  GtkWidget *diagwin;  
  GtkWidget *label;
  GtkWidget *vbox;
  char *text;
  int row;
  GtkWidget *sublist;

  desensitize_sw(window);

  sublist=gtk_object_get_data(GTK_OBJECT(window),"sublist");
  row = (int)(GTK_CLIST(sublist)->selection->data);

  gtk_clist_get_text(GTK_CLIST(sublist),
			row ,0,&text);

  diagwin = gnome_dialog_new (text,NULL);
  gtk_object_set_data(GTK_OBJECT(window),"dialog",diagwin);

  vbox=gtk_vbox_new(FALSE,0);
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (diagwin)->vbox), 
		      vbox, TRUE, TRUE, 10);
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_widget_show (vbox);

  gtk_signal_connect(GTK_OBJECT(diagwin), "delete_event",
                     GTK_SIGNAL_FUNC(c_param_diag_delete),
                     window);
  gtk_window_position (GTK_WINDOW (diagwin),GTK_WIN_POS_CENTER);
  label = gtk_label_new("delete parameter:");
  gtk_box_pack_start (GTK_BOX (vbox), 
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);
  label = gtk_label_new(text);
  gtk_box_pack_start (GTK_BOX (vbox), 
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  gnome_dialog_append_button_with_pixmap(GNOME_DIALOG(diagwin),
					 "Delete",
					 GNOME_STOCK_MENU_CUT);
  gnome_dialog_append_button(GNOME_DIALOG(diagwin),
			     GNOME_STOCK_BUTTON_CANCEL);
  gnome_dialog_button_connect(GNOME_DIALOG(diagwin), 0,
			      GTK_SIGNAL_FUNC(c_del_diag_ok),
			      window);
  gnome_dialog_button_connect(GNOME_DIALOG(diagwin), 1,
			      GTK_SIGNAL_FUNC(c_param_diag_cancel),
			      window);
  
  gtk_widget_show(diagwin);
  return;
}

void c_del_service_ok(GtkWidget *button, gpointer window){
  GtkWidget *diagwin;

  diagwin=gtk_object_get_data(GTK_OBJECT(window),"dialog");
  
  smbwin_delete_service(GTK_WIDGET(window));
  
  resensitize_sw(GTK_WIDGET(window));

  gtk_widget_destroy(diagwin);
  gtk_object_set_data(GTK_OBJECT(window),"dialog",NULL);
  return;
  
}

void make_del_service_dialog(GtkWidget *window){
  GtkWidget *diagwin;
  GtkWidget *label;
  GtkWidget *vbox;
  char *text;
  int row;
  GtkWidget *servicelist;

  servicelist=gtk_object_get_data(GTK_OBJECT(window),"servicelist");


  desensitize_sw(GTK_WIDGET(window));

  row = (int)(GTK_CLIST(servicelist)->selection->data);

  gtk_clist_get_text(GTK_CLIST(servicelist),
			row ,0,&text);

  diagwin = gnome_dialog_new (text,NULL);
  gtk_object_set_data(GTK_OBJECT(window),"dialog",diagwin);

  vbox=gtk_vbox_new(FALSE,0);
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (diagwin)->vbox), 
		      vbox, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox), 10);
  gtk_widget_show (vbox);

  gtk_signal_connect(GTK_OBJECT(diagwin), "delete_event",
                     GTK_SIGNAL_FUNC(c_param_diag_delete),
                     window);
  
  gtk_window_position (GTK_WINDOW(diagwin),GTK_WIN_POS_CENTER);
  label = gtk_label_new("delete service:");
  gtk_box_pack_start (GTK_BOX (vbox), 
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);
  label = gtk_label_new(text);
  gtk_box_pack_start (GTK_BOX (vbox), 
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  gnome_dialog_append_button_with_pixmap(GNOME_DIALOG(diagwin),
					 "Delete",
					 GNOME_STOCK_MENU_CUT);
  gnome_dialog_append_button(GNOME_DIALOG(diagwin),
			     GNOME_STOCK_BUTTON_CANCEL);
  gnome_dialog_button_connect(GNOME_DIALOG(diagwin), 0,
			      GTK_SIGNAL_FUNC(c_del_service_ok),
			      window);
  gnome_dialog_button_connect(GNOME_DIALOG(diagwin), 1,
			      GTK_SIGNAL_FUNC(c_param_diag_cancel),
			      window);

  gtk_widget_show(diagwin);
  return;
}


void make_user_mesg(char *message, char *title){
  if(!strcasecmp("Error",title))
    gnome_error_dialog(message);
  else if(!strcasecmp("Warning",title))
    gnome_warning_dialog(message);
  else
    gnome_ok_dialog(message);
  return;
}

void sw_main_menu(GtkWidget *window){

  GnomeUIInfo filemenu[] = {
    { GNOME_APP_UI_ITEM, 
      N_("Open Configuration File"), NULL,
      c_conf_open, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
      's', GDK_CONTROL_MASK, NULL},
    { GNOME_APP_UI_ITEM,
      N_("Open Alternate File"), NULL,
      c_alt_open, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
      'o', GDK_CONTROL_MASK, NULL},    
    { GNOME_APP_UI_ITEM,
      N_("Open From Server"), NULL,
      NULL, NULL, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_JUMP_TO,
      0, 0, NULL},    
    GNOMEUIINFO_SEPARATOR,
    { GNOME_APP_UI_ITEM, 
      N_("Write to Current File"), NULL,
      c_write_conf, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
      'w', GDK_CONTROL_MASK, NULL},
    { GNOME_APP_UI_ITEM,
      N_("Write to Alternate File"), NULL,
      c_write_alt, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS,
      'a', GDK_CONTROL_MASK, NULL},    
    { GNOME_APP_UI_ITEM,
      N_("Write to Server"), NULL,
      NULL,NULL,NULL,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_JUMP_TO,
      0, 0, NULL},    
    GNOMEUIINFO_SEPARATOR,  
    { GNOME_APP_UI_ITEM,
      N_("Preferences"), NULL,
      c_make_pref_box, NULL, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
      'p', GDK_CONTROL_MASK, NULL},
    GNOMEUIINFO_SEPARATOR,
    { GNOME_APP_UI_ITEM,
      N_("Close"), NULL,
      c_smbwin_close, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
      'c', GDK_CONTROL_MASK, NULL}, 
    { GNOME_APP_UI_ITEM,
      N_("New Window"), NULL,
      c_smbwin_new, window, NULL, 
      GNOME_APP_PIXMAP_NONE, NULL,
      0,0, NULL},
    { GNOME_APP_UI_ITEM,
      N_("Exit"), NULL,
      c_make_exit_dialog, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
      'q', GDK_CONTROL_MASK, NULL},
    GNOMEUIINFO_END
  };

  GnomeUIInfo editmenu[] = {
    { GNOME_APP_UI_ITEM,
      N_("Edit Parameter"), NULL,
      c_edit_param, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
      'e', GDK_CONTROL_MASK, NULL},
    { GNOME_APP_UI_ITEM,
      N_("New Parameter"), NULL,
      c_make_inserter, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_COPY,
      'i', GDK_CONTROL_MASK , NULL},
    { GNOME_APP_UI_ITEM,
      N_("New Service"), NULL,
      c_insert_service, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PASTE,
      'n',GDK_CONTROL_MASK, NULL},
    GNOMEUIINFO_SEPARATOR,
    { GNOME_APP_UI_ITEM,
      N_("Delete Parameter"), NULL,
      c_delete_param, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CUT,
      'd', GDK_CONTROL_MASK, NULL},
    { GNOME_APP_UI_ITEM,
      N_("Delete Service"), NULL,
      c_delete_service, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CUT,
      0, 0, NULL},
    GNOMEUIINFO_END
  };

  GnomeUIInfo optionsmenu[] = {
    { GNOME_APP_UI_ITEM,
      N_("Run testparm"), NULL,
      c_run_testparm, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXEC,
      't', GDK_CONTROL_MASK, NULL},
    { GNOME_APP_UI_ITEM,
      N_("Run smbstatus"), NULL,
      c_run_smbstatus, NULL, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
      0, 0, NULL},
    { GNOME_APP_UI_ITEM,
      N_("Restart Samba"), NULL,
      c_restart_samba, NULL, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH,
      0, 0, NULL},
    GNOMEUIINFO_END
  };

  GnomeUIInfo helpmenu[] = {
    { GNOME_APP_UI_ITEM,
      N_("smb.conf(5)"), NULL,
      c_make_overview, NULL, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
      0, 0, NULL},
    { GNOME_APP_UI_ITEM,
      N_("testparm(1)"), NULL,
      c_man_testparm, NULL, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
      0, 0, NULL},
    { GNOME_APP_UI_ITEM,
      N_("smbstatus(1)"), NULL,
      c_man_smbstatus, NULL, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
      0, 0, NULL}, 
    GNOMEUIINFO_SEPARATOR,
    { GNOME_APP_UI_ITEM,
      N_("Selected Parameter"), NULL,
      c_help_sel_param, window, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
      0, 0, NULL},
    { GNOME_APP_UI_ITEM,
      N_("Look Up Parameter"), NULL,
      c_make_param_lookup, NULL, NULL, 
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
      0, 0, NULL},
    GNOMEUIINFO_SEPARATOR,
    { GNOME_APP_UI_ITEM,
      N_("About"), NULL,
      c_help_about, NULL, NULL, 
      GNOME_APP_PIXMAP_NONE, NULL,
      0, 0, NULL},
    GNOMEUIINFO_END
  };

  GnomeUIInfo mainmenu[] = {
    GNOMEUIINFO_SUBTREE(N_("_File"), filemenu),
    GNOMEUIINFO_SUBTREE(N_("_Edit"), editmenu),
    GNOMEUIINFO_SUBTREE(N_("_Options"), optionsmenu),
    GNOMEUIINFO_SUBTREE(N_("_Help"), helpmenu),
    GNOMEUIINFO_END
  };

  gnome_app_create_menus(GNOME_APP(window), mainmenu);
  return;

}

void sw_toolbars(GtkWidget *window){
  GnomeUIInfo toolbar[] = {
    { GNOME_APP_UI_ITEM, 
      N_("Open"), N_("Open Configuration"),
      GTK_SIGNAL_FUNC(c_alt_open), window, NULL, 
      GNOME_APP_PIXMAP_DATA, open_xpm,
      0, 0, NULL},
    { GNOME_APP_UI_ITEM, 
      N_("Write"), N_("Write Configuration"),
      GTK_SIGNAL_FUNC(c_write_alt), window, NULL, 
      GNOME_APP_PIXMAP_DATA, save_xpm,
      0, 0, NULL},
    GNOMEUIINFO_SEPARATOR,
    { GNOME_APP_UI_ITEM, 
      N_("Insert"), N_("Insert Service"),
      GTK_SIGNAL_FUNC(c_insert_service), window, NULL, 
      GNOME_APP_PIXMAP_DATA, share_xpm,
      0, 0, NULL},
    { GNOME_APP_UI_ITEM, 
      N_("Delete"), N_("Delete Service"),
      GTK_SIGNAL_FUNC(c_delete_service), window, NULL, 
      GNOME_APP_PIXMAP_DATA, delshare_xpm,
      0, 0, NULL},
    GNOMEUIINFO_SEPARATOR,
    { GNOME_APP_UI_ITEM, 
      N_("Edit"), N_("Edit Parameter"),
      GTK_SIGNAL_FUNC(c_edit_param), window, NULL, 
      GNOME_APP_PIXMAP_DATA, edit_xpm,
      0, 0, NULL},
    { GNOME_APP_UI_ITEM, 
      N_("Insert"), N_("Insert Parameter"),
      GTK_SIGNAL_FUNC(c_make_inserter), window, NULL, 
      GNOME_APP_PIXMAP_DATA, new_xpm,
      0, 0, NULL},
    { GNOME_APP_UI_ITEM, 
      N_("Delete"), N_("Delete Parameter"),
      GTK_SIGNAL_FUNC(c_delete_param), window, NULL, 
      GNOME_APP_PIXMAP_DATA, delete_xpm,
      0, 0, NULL},
    GNOMEUIINFO_SEPARATOR,
    { GNOME_APP_UI_ITEM, 
      N_("Exit"), N_("Quit Program"),
      GTK_SIGNAL_FUNC(c_make_exit_dialog), window, NULL, 
      GNOME_APP_PIXMAP_DATA, exit_xpm,
      0, 0, NULL},
    GNOMEUIINFO_END
  };
  gnome_app_create_toolbar(GNOME_APP(window), toolbar);
  return;
}

    


  
