/***************************************************************************
 *            notification.c
 *
 *  Sun May 30 16:03:06 2004
 *  Copyright  2004  Vladimir Đokić
 *  vladeck@gnome-ppp.org
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gnome-ppp.h"


void init_notification (void)
{
	gchar *sr;
	gchar *s;
	gchar *r;
	gchar *i;
	
	if (gnome_ppp.notification.tray == NULL)
		gnome_ppp.notification.tray = egg_tray_icon_new ("GNOME PPP");
	
	gnome_ppp.notification.box = gtk_event_box_new ();
	gnome_ppp.notification.pixmap = gtk_image_new ();
	
	g_signal_connect (G_OBJECT (gnome_ppp.notification.box), "button_press_event",
			G_CALLBACK (on_notification_bpress_event), NULL);
	
	gtk_container_add (GTK_CONTAINER (gnome_ppp.notification.tray), gnome_ppp.notification.box);
	gtk_container_add (GTK_CONTAINER (gnome_ppp.notification.box), gnome_ppp.notification.pixmap);
	g_object_ref (G_OBJECT (gnome_ppp.notification.tray));
	
	/* notification icon paths */
	sr = g_build_filename (PACKAGE_DATA_DIR, "gnome_ppp_sending_receiving.png", NULL);
	r = g_build_filename (PACKAGE_DATA_DIR, "gnome_ppp_receiving.png", NULL);
	s = g_build_filename (PACKAGE_DATA_DIR, "gnome_ppp_sending.png", NULL);
	i = g_build_filename (PACKAGE_DATA_DIR, "gnome_ppp_idle.png", NULL);
	
	/* register icon factory */
	gnome_ppp.icon_factory = gtk_icon_factory_new ();
	gtk_icon_factory_add (gnome_ppp.icon_factory, "sending_receiving",
				gtk_icon_set_new_from_pixbuf (gdk_pixbuf_new_from_file (sr, NULL)));
				
	gtk_icon_factory_add (gnome_ppp.icon_factory, "receiving",
				gtk_icon_set_new_from_pixbuf (gdk_pixbuf_new_from_file (r, NULL)));
				
	gtk_icon_factory_add (gnome_ppp.icon_factory, "sending",
				gtk_icon_set_new_from_pixbuf (gdk_pixbuf_new_from_file (s, NULL)));
				
	gtk_icon_factory_add (gnome_ppp.icon_factory, "idle",
				gtk_icon_set_new_from_pixbuf (gdk_pixbuf_new_from_file (i, NULL)));
				
	gtk_icon_factory_add_default (gnome_ppp.icon_factory);
	
	/* free icon paths */
	g_free (sr);
	g_free (r);
	g_free (s);
	g_free (i);
	
	/* popup menu */
	GtkWidget *item;
	
	if (gnome_ppp.notification.menu == NULL)		
		gnome_ppp.notification.menu = gtk_menu_new ();
	
	item = gtk_image_menu_item_new_with_label (_("Connection log"));
	g_signal_connect (G_OBJECT (item), "activate",
			G_CALLBACK (on_notification_menu), "log");
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item),
					gtk_image_new_from_stock (GTK_STOCK_JUSTIFY_FILL, GTK_ICON_SIZE_MENU));
	gtk_menu_shell_append (GTK_MENU_SHELL (gnome_ppp.notification.menu), item);
	gtk_widget_show (item);
	
	item = gtk_image_menu_item_new_with_label (_("Details"));
	g_signal_connect (G_OBJECT (item), "activate",
			G_CALLBACK (on_notification_menu), "details");
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item),
					gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_MENU));
	gtk_menu_shell_append (GTK_MENU_SHELL (gnome_ppp.notification.menu), item);
	gtk_widget_show (item);
	
	item = gtk_image_menu_item_new_with_label (_("Disconnect"));
	g_signal_connect (G_OBJECT (item), "activate",
			G_CALLBACK (on_notification_menu), "disconnect");
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item),
					gtk_image_new_from_stock (GTK_STOCK_STOP, GTK_ICON_SIZE_MENU));
	gtk_menu_shell_append (GTK_MENU_SHELL (gnome_ppp.notification.menu), item);
	gtk_widget_show (item);
	
	item = gtk_separator_menu_item_new ();
	gtk_menu_shell_append (GTK_MENU_SHELL (gnome_ppp.notification.menu), item);
	gtk_widget_show (item);
	
	item = gtk_image_menu_item_new_with_label (_("About"));
	g_signal_connect (G_OBJECT (item ), "activate",
			G_CALLBACK (on_notification_menu), "about");
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item),
					gtk_image_new_from_stock (GNOME_STOCK_ABOUT, GTK_ICON_SIZE_MENU));
	gtk_menu_shell_append (GTK_MENU_SHELL (gnome_ppp.notification.menu), item);
	gtk_widget_show (item);
}

void update_notification (guint status)
{
	if (status == 0) /* sending_receiving */
		gtk_image_set_from_stock (GTK_IMAGE (gnome_ppp.notification.pixmap),
					"sending_receiving",
					GTK_ICON_SIZE_LARGE_TOOLBAR);
	else if (status == 1) /* receiving */
		gtk_image_set_from_stock (GTK_IMAGE (gnome_ppp.notification.pixmap),
					"receiving",
					GTK_ICON_SIZE_LARGE_TOOLBAR);
	else if (status == 2) /* sending */
		gtk_image_set_from_stock (GTK_IMAGE (gnome_ppp.notification.pixmap),
					"sending",
					GTK_ICON_SIZE_LARGE_TOOLBAR);
	else if (status == 3) /* idle */
		gtk_image_set_from_stock (GTK_IMAGE (gnome_ppp.notification.pixmap),
					"idle",
					GTK_ICON_SIZE_LARGE_TOOLBAR);
}

void show_notification (gboolean show)
{
	if (gnome_ppp.notification.tray) {
		
		if (show)
			gtk_widget_show_all (GTK_WIDGET (gnome_ppp.notification.tray));
		else
			gtk_widget_hide_all (GTK_WIDGET (gnome_ppp.notification.tray));
	}
}

void on_notification_bpress_event (GtkWidget *widget, GdkEventButton *event, gpointer *data)
{
	if (event->type != GDK_BUTTON_PRESS)
		return;
	
	if (event->button == 1) { /* left button */
		
		if (gnome_ppp.connected.show == TRUE) {
			gtk_widget_hide (gnome_ppp.connected.window);
			gnome_ppp.connected.show = FALSE;
		} else {
			gtk_widget_show (gnome_ppp.connected.window);
			gnome_ppp.connected.show = TRUE;
		}
	}
	
	if (event->button == 3 ) /* right button */
		gtk_menu_popup (GTK_MENU (gnome_ppp.notification.menu), NULL, NULL, NULL, NULL, event->button, event->time);
}

void on_notification_menu (GtkWidget *widget, gpointer data)
{
	gchar *tmp = NULL;
	
	tmp = (gchar *)data;
	
	if (g_strrstr (data, "details") != NULL)		
		gtk_widget_show (gnome_ppp.details.window);
	
	if (g_strrstr (data, "disconnect") != NULL)		
		on_conn_disconnect (NULL, NULL);
	
	if (g_strrstr (data, "about") != NULL) {
		gchar *icon;

		icon = g_build_filename (PACKAGE_APPICON_DIR, "gnome-ppp.png", NULL);

		static const gchar *authors [] = {
			"Vladimir Đokić <vladeck@gnome-ppp.org>",
			"",
			"Contributor: Dan Korostelev <dan@ats.energo.ru>",
			NULL
		};
		const gchar *documenters [] = { NULL };
		const gchar *translator_credits = _("translator_credits");
		gnome_ppp.about = gnome_about_new (_("GNOME PPP"), VERSION,
				"Copyright \xc2\xa9 2004 Vladimir Đokić\n",
				_("GNOME Dialup Tool."), authors, documenters,
				strcmp (translator_credits, "translator_credits") != 0 ? translator_credits : NULL,
				gdk_pixbuf_new_from_file (icon, NULL));
		g_free (icon);
		
		g_signal_connect (G_OBJECT (gnome_ppp.about), "destroy",
				G_CALLBACK (gtk_widget_destroyed), &gnome_ppp.about);
		
		gtk_widget_show (gnome_ppp.about);
	}
	
	if (g_strrstr (data, "log") != NULL)		
		gtk_widget_show (gnome_ppp.log.window);
}

void destroy_notification (void)
{
	gtk_widget_destroy (GTK_WIDGET (gnome_ppp.notification.tray));
	gtk_widget_destroy (gnome_ppp.notification.menu);
	g_object_unref (G_OBJECT (gnome_ppp.notification.tray));
	gnome_ppp.notification.tray = NULL;
	gnome_ppp.notification.menu = NULL;
	
	gtk_icon_factory_remove_default (gnome_ppp.icon_factory);
	gnome_ppp.icon_factory = NULL;
}
