--[[
	Hearts - example_player.lua
	Copyright 2006 Sander Marechal
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
]]

--[[
	This script shows the basic layout of a hearts player. I suggest you copy/paste
	it as a base to start building other players from. When you are done, rename your
	script to playername.lua and put it in the players directory. First off, there are
	a couple of global variables that will be set by the game. They contain the game's
	current rule settings (e.g. play and scoring variants), the players hand and the trick
	currently being played, the scores and which player you are.
	
	Your current hand is the global variable "hand{}" and the trick being played is
	the global variable trick{}. Both are tables. Each value in the table is a card.
	Cards are represented as tuples in the form of {suit, rank}. For example, a hand with
	a jack of spades and a nine of hearts looks like:
	
	hand = {
		{spades, jack}
		{hearts, nine}
	};
	
	The variable "rules{}" keeps track of the current game rules.
	
	The variable "score{}" keeps track of all the player's scores. It looks like this:
	
	score = {
		north = {this_hand, total},
		east  = {this_hand, total},
		south = {this_hand, total},
		west  = {this_hand, total}
	};
	
	Finally, the variable "me" contains a number that tells you which player you
	are (e.g. north (which is 1).
]]

--[[ The script is first executed as soon as a player is loaded. This is the beginning
	of each game. So, use global code to set up your player. ]]

math.randomseed = os.time()
valid_cards = {}

--[[ This function is called when you have to select three cards to pass to the
	next player. Return a list of three cards. ]]
function select_cards()
	result = {}
	for i = 1, 3 do
		j = math.random(table.getn(hand))
		table.insert(result, hand[j])
		table.remove(hand, j)	-- no problem. hand is reset before each function call
	end
	return result
end

--[[ This function is called whenever you have to play a card. You must return a
	single variable: a valid card in the form of {suit, rank}. Use the function 
	is_valid_card({suit, rank}) to check if it is valid to play that card. ]]
function play_card()
	local valid_cards = get_valid_cards(hand)
	i = math.random(table.getn(valid_cards))
	return (valid_cards[i])
end

--[[ This function is called at the end of each trick so you can see what cards were
	played by all the players. Use trick_get_winner() to see who's won under the current
	ruleset and use trick_get_score() to see how much points the trick was worth. ]]
function trick_end()
end

--[[ This function is called at the end of each round. ]]
function round_end()
end
