/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4:ts=4:
 *
 * Gnome Apt sources.list editor
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    1999 Olivier Aubin <ogaubin@ucalgary.ca>
 * 	    2002, 2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_SOURCES_H
#define GNOME_APT_SOURCES_H

#include <string>
#include <gtk/gtktreeselection.h>

using namespace std;

class SourcesList;

class Sources {
public:
  Sources();

  void edit();

  typedef enum {
    Ok,
    BadDist,
    BadURI,
    BadSection
  } SourceAddResult;
	SourceAddResult add_source (string, string, string*, gint);

	void apply (GtkWidget*);
	gint close (GtkWidget*);
	void edit_source (GtkWidget*);

private:
	SourcesList* src_list;
	GtkTreeSelection* selection;

  GtkWidget* b_add_;
  GtkWidget* b_del_;
  GtkWidget* b_edit_;

  GtkWidget* edit_dialog_dist_;
  GtkWidget* edit_dialog_uri_;
  GtkWidget* edit_dialog_section_;

  static void add_wizard_cb (GtkWidget* w, gpointer data);
  void add_wizard();

  static void delete_source_cb (GtkWidget* w, gpointer data);
  void delete_source();

  static void edit_source_cb (GtkWidget* w, gpointer data);
	void edit_source_close (GtkWidget*);

	static void edit_source_click_cb (GtkWidget*, gint, gpointer);
  void edit_source_ok();
};

Sources* gnome_apt_sources();
void     gnome_apt_sources_shutdown();

#endif
