/**
 * vim: sw=4:ts=4:
 *
 * GNOME Apt dependency check class
 *
 * 	(C) 2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef _GAPT_DEPRESOLVER_H
#define _GAPT_DEPRESOLVER_H

#include <map>

#include "cache.h"
#include "redlistview.h"

typedef struct {
	const gchar* deptype;
	const gchar* name;
	const gchar* needver;
	const gchar* newver;
} DepInfo;

typedef multimap<string, DepInfo, less<string> > RDepMap;

class GAptDepResolver {
	GAptCache* g_cache;

	enum {
		C_PACKAGE,
		C_NEEDVER, C_NEWVER,
		C_RELATION, C_PROBLEM,
		N_COLS
	};

public:
	GAptDepResolver (GAptCache* cache = 0) : g_cache (cache) {}
	GtkWidget* depview (void);
};

#endif
