/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

using namespace std;

#include "pkglist.h"
#include "cache.h"
#include "search.h"
#include "menus.h"
#include "preferences.h"
#include "sources.h"

#include <map>


GAptPkgList::GAptPkgList(GAptPkgTree* tree, GnomeAppBar* bar)
  : tree_(tree)
{  
  ////////// Setup package tree

  table_ = gtk_table_new(2,3, FALSE);

  GtkWidget* hbox = gtk_hbox_new(FALSE,0);

  tree_frame_ = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(tree_frame_), GTK_SHADOW_IN);

  gtk_widget_set_name(tree_->tree()->widget(), "AptPkgTree");

  gtk_container_add(GTK_CONTAINER(tree_frame_), tree_->tree()->widget());

  gtk_box_pack_start(GTK_BOX(hbox), tree_frame_, TRUE, TRUE, 0);

  gtk_table_attach(GTK_TABLE(table_),
                   hbox,
                   0, 2,
                   1, 2,
                   static_cast<GtkAttachOptions>(GTK_EXPAND | GTK_FILL | GTK_SHRINK),
                   static_cast<GtkAttachOptions>(GTK_EXPAND | GTK_FILL | GTK_SHRINK),
                   0, 0);

  // Filter Bar
  
  filter_    = new Filter();

  tree_->set_filter(filter_);

  filterbar_ = new GAptFilterBar(filter_);

  gtk_table_attach(GTK_TABLE(table_),
                   filterbar_->widget(),
                   0, 2,
                   0, 1,
                   static_cast<GtkAttachOptions>(GTK_EXPAND | GTK_FILL | GTK_SHRINK),
                   static_cast<GtkAttachOptions>(GTK_FILL),
                   0, 0);  

  // Scroll bars

  GtkWidget* w;

#if 0  
  w = gtk_hscrollbar_new (NULL);
  gtk_table_attach (GTK_TABLE (table_), w,
                    0, 1, 2, 3,
                    static_cast<GtkAttachOptions>(GTK_FILL),
                    static_cast<GtkAttachOptions>(GTK_FILL),
                    0, 0);

  tree_->tree()->set_hadjustment(GTK_RANGE(w)->adjustment);
#endif

  GtkAdjustment* vadj = GTK_ADJUSTMENT(gtk_adjustment_new(0.0, 0.0, 0.0, 
                                                          0.0, 0.0, 0.0));
  
  w = gtk_vscrollbar_new (vadj);
#if 0
  gtk_table_attach (GTK_TABLE (table_), w,
                    1, 2, 1, 2,
                    static_cast<GtkAttachOptions>(0),
                    static_cast<GtkAttachOptions>(GTK_EXPAND | GTK_FILL | GTK_SHRINK),
                    0, 0);
#endif
  gtk_box_pack_end(GTK_BOX(hbox), w, FALSE, FALSE, 0);

  tree_->tree()->set_vadjustment(GTK_RANGE(w)->adjustment);

  tree_->set_sort(GAptPkgTree::SortAlpha);

  tree_->set_category(GAptPkgTree::CategoryAlpha);

  paned_ = gtk_hpaned_new();

  gtk_container_set_border_width(GTK_CONTAINER(paned_), GNOME_PAD_SMALL);

  gtk_paned_pack2(GTK_PANED(paned_), table_, TRUE, TRUE);

  //  gtk_container_set_border_width(GTK_CONTAINER(table_), GNOME_PAD_SMALL);

  gnome_apt_cache_file()->add_view(tree_);


  ////////////////////// End package tree

  ////////////////////// Setup other stuff

  info_ = new GAptInfoPanes;

  gnome_apt_cache_file()->add_view(info_);

  // Before adding the info widget, since we might not show it.
  gtk_widget_show_all(paned_);

  gtk_paned_pack1(GTK_PANED(paned_), info_->widget(), TRUE, TRUE);

  // dept of red. dept
  gboolean info_hidden = FALSE;
  info_hidden = 
    gnome_config_get_bool_with_default("/gnome-apt/preferences/info_hidden=false",
                                      &info_hidden);

  set_info_hidden(info_hidden);

  gnome_apt_cache_file()->add_view(&details_);

  gnome_apt_preferences()->set_pkglist(this);
  //  gnome_apt_sources()->set_pkglist(this);

  // last so that it reflects current state.
  gnome_apt_create_pkglist_menu(this, bar);
}

GAptPkgList::~GAptPkgList()
{
  // must destroy GUI, then represented items,
  //  since the GUI has pointers to the models.
  // e.g. filterbar operates on filter in its destructor.
  delete info_;
  info_ = 0;
  delete filterbar_;
  filterbar_ = 0;
  delete filter_;
  filter_ = 0;
}

void 
GAptPkgList::set_selection(pkgCache::Package* pkg)
{
  selection_ = pkg;
  info_->set_selection(pkg);
  details_.set_selection(pkg);
}

void 
GAptPkgList::set_info_hidden(bool state)
{
  gnome_config_set_bool("/gnome-apt/preferences/info_hidden",
                        state);
  gnome_config_sync();
  
  info_->set_hidden(state);

  if (state)
    {
      gtk_paned_set_gutter_size(GTK_PANED(paned_), 0);
      gtk_paned_set_handle_size(GTK_PANED(paned_), 0);
      gtk_paned_set_position(GTK_PANED(paned_), 0);
    }
  else 
    {
      gtk_paned_set_gutter_size(GTK_PANED(paned_), 19);
      gtk_paned_set_handle_size(GTK_PANED(paned_), 10);
      gtk_paned_set_position(GTK_PANED(paned_), -1);
    }
}

static void no_selection()
{
  GtkWidget* dialog = gnome_error_dialog(_("No package selected."));
  gnome_apt_setup_dialog(dialog);
}

void
GAptPkgList::install()
{
  pkgCache::Package* p = get_selection();

  if (p == 0) no_selection();
  else {
    Util::install(p,tree_);
  }
}

void 
GAptPkgList::remove()
{
  pkgCache::Package* p = get_selection();

  if (p == 0) no_selection();
  else {
    Util::remove(p,tree_);
  }
}

void
GAptPkgList::keep()
{
  pkgCache::Package* p = get_selection();
  
  if (p == 0) no_selection();
  else {
    Util::keep(p,tree_);
  }
}

void
GAptPkgList::details()
{
  details_.show();
}

void
GAptPkgList::search()
{
  gnome_apt_search(tree_);
}
