/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "infopanes.h"
#include "pkgutil.h"
#include <apt-pkg/strutl.h>

GAptInfoPanes::GAptInfoPanes()
  : gd_(_("GNOME Apt")), pkg_(0), cache_(0)
{

  set_selection(0);
}

GAptInfoPanes::~GAptInfoPanes()
{

}

void
GAptInfoPanes::set_hidden(bool state)
{
  if (state && get_hidden()) return;
  if (!state && !get_hidden()) return;  

  if (!get_hidden())
    {
      gtk_widget_hide(gd_.widget());
    }
  else 
    {
      gtk_widget_show_all(gd_.widget());
    }
}

void 
GAptInfoPanes::set_selection(pkgCache::Package* pkg)
{
  if (cache_ == 0) return;

  pkg_ = pkg;

  if (pkg != 0)
    {
      // causes an update in GDeb
      gd_.set_package(this); 
    }
  else 
    {
      gd_.set_package(0);
    }
}

void 
GAptInfoPanes::set_cache    (GAptCache* cache)
{
  cache_ = cache;
  set_selection(0);
}

  // Stuff to display
string 
GAptInfoPanes::Name() 
{ 
  g_return_val_if_fail(pkg_ != 0, "");

  pkgCache::PkgIterator i(*cache_,pkg_);

  return i.Name();
}


string 
GAptInfoPanes::Version() 
{ 
  g_return_val_if_fail(pkg_ != 0, "");

  pkgCache::PkgIterator i(*cache_,pkg_);
  pkgCache::VerIterator vi = Util::display_version(i,cache_);

  const char* s = 0;
  if (vi.end()) s = _("(no version)");
  else s = vi.VerStr();

  return string(s);
}

string 
GAptInfoPanes::Description_Short()  
{
  g_return_val_if_fail(pkg_ != 0, "");
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  pkgRecords::Parser* p = Util::pkg_parser(i,cache_);

  string s;

  if (p != 0) s = p->ShortDesc();
  if (s.empty()) s= _("No description available");
  return s;
}

string  
GAptInfoPanes::Description_Long() 
{
  g_return_val_if_fail(pkg_ != 0, "");
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  pkgRecords::Parser* p = Util::pkg_parser(i,cache_);

  string s;
  if (p != 0) s = p->LongDesc();
  if (s.empty()) s = _("No description available");
  return s;
}

string  
GAptInfoPanes::Section()  
{ 
  g_return_val_if_fail(pkg_ != 0, "");
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  const char* s = i.Section();
  
  if (s == 0) return _("Unknown");
  else return s;
}

string  
GAptInfoPanes::Priority()  
{
  g_return_val_if_fail(pkg_ != 0, "");
        
  pkgCache::PkgIterator i(*cache_, pkg_);

  return Util::priority_string(i, cache_, 0);
}

string
GAptInfoPanes::Size()  
{ 
  g_return_val_if_fail(pkg_ != 0, "");

  pkgCache::PkgIterator i(*cache_,pkg_);
  pkgCache::VerIterator vi = Util::display_version(i,cache_);
  
  if (vi.end()) return "";

  if (!vi.Downloadable()) return _("N/A");
  else return SizeToStr(vi->Size);
}

string
GAptInfoPanes::Installed_Size()  
{ 
  g_return_val_if_fail(pkg_ != 0, "");

  pkgCache::PkgIterator i(*cache_,pkg_);

  pkgCache::VerIterator vi = Util::display_version(i,cache_);
  
  if (vi.end()) return "";
  else return SizeToStr(vi->InstalledSize);
}

string
GAptInfoPanes::Maintainer()  
{ 
  g_return_val_if_fail(pkg_ != 0, "");
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  pkgRecords::Parser* p = Util::pkg_parser(i,cache_);

  string s;
  if (p != 0) s = p->Maintainer();
  if (s.empty()) s = _("Unknown");
  return s;
}

string
GAptInfoPanes::Status()  
{ 
  g_return_val_if_fail(pkg_ != 0, "");
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  return Util::status_string(Util::status_type(i, cache_));
}

string
GAptInfoPanes::Current_Version()  { return ""; }

string
GAptInfoPanes::Architecture()  { return ""; }

string
GAptInfoPanes::Source()  { return ""; }

string
GAptInfoPanes::Filename()  { return ""; }

bool    
GAptInfoPanes::Essential() 
{ 
  g_return_val_if_fail(pkg_ != 0, false);
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  return ((i->Flags & pkgCache::Flag::Essential) == pkgCache::Flag::Essential);
}

bool   
GAptInfoPanes::Downloadable()
{
  g_return_val_if_fail(pkg_ != 0, false);
  
  pkgCache::PkgIterator i(*cache_,pkg_);
  
  pkgCache::VerIterator vi = Util::display_version(i,cache_);
  
  if (vi.end()) return false;  
  else return vi.Downloadable();
}

bool   
GAptInfoPanes::Automatic()
{
  g_return_val_if_fail(pkg_ != 0, false);
  
  pkgCache::PkgIterator i(*cache_,pkg_);

  pkgCache::VerIterator vi = Util::display_version(i,cache_);
  
  if (vi.end()) return false;  
  else return vi.Automatic();
}

vector<string>  
GAptInfoPanes::Provides() { return vector<string>(0); }

vector<string>  
GAptInfoPanes::PreDepends()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Depends()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Recommends()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Suggests()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Conflicts()  { return vector<string>(0); }

vector<string>  
GAptInfoPanes::Replaces()  { return vector<string>(0); }
  
void 
GAptInfoPanes::Install() { g_warning(__FUNCTION__); }

void 
GAptInfoPanes::Delete() { g_warning(__FUNCTION__); }

void  
GAptInfoPanes::Keep() { g_warning(__FUNCTION__); }



//////////////////////////////// Hack alert
#include "gdeb/gdeb.cc" // since automake gets confused about doing this
