/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_APP_H
#define GNOME_APT_APP_H

#include "pkglist.h"
#include "drawtree.h"
#include <apt-pkg/progress.h>

class GAptApp : public GAptPkgTree::Status {
public:
  class Progress;

  GAptApp();
  GAptApp(const gchar* geometry);
  virtual ~GAptApp();

  void set_status(const char* s) {
    if (appbar_) gnome_appbar_set_default(GNOME_APPBAR(appbar_), s);
  }

  void set_selection(pkgCache::Package* pkg);

  Progress & progress() { return *progress_; }

  GAptPkgList* pkglist() { return pkglist_; }

  GtkWidget* widget() { return app_; }

private:
  GtkWidget* app_;
  GtkWidget* appbar_;

  GAptPkgTree* pkgtree_;
  GAptPkgList* pkglist_;

  Progress* progress_;

  void init(const gchar* geometry);

  static gint keypress_cb(GtkWidget* w, GdkEventKey* event, gpointer data);
  gint key(GdkEventKey* event);
};

class GAptApp::Progress : public OpProgress
{
private:
  GtkWidget* appbar_;
protected:
  
  virtual void Update();
  
public:
  
  virtual void Done();
  
  Progress(GtkWidget* appbar);
  virtual ~Progress();
};


#endif

