/*

  $Id$

  G N O K I I

  A Linux/Unix toolset and driver for the mobile phones.

  This file is part of gnokii.

  Gnokii is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Gnokii is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with gnokii; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Copyright (C) 1999-2000 Hugh Blemings & Pavel Janik ml.
  Copyright (C) 2002-2003 Pawel Kot, Ladis Michl
  Copyright (C) 2002      Feico de Boer

  This file implements GSM networks searching.

*/

#include "config.h"

#include <string.h>

#include "compat.h"
#include "misc.h"
#include "gnokii.h"

/* The following data is taken from:
 * http://en.wikipedia.org/wiki/Mobile_network_code
 */
static gn_country countries[] = {
	{"412", "Afghanistan"},
	{"276", "Albania"},
	{"603", "Algeria"},
	{"213", "Andorra"},
	{"631", "Angola"},
	{"365", "Anguilla"},
	{"344", "Antigua and Barbuda"},
	{"722", "Argentina"},
	{"283", "Armenia"},
	{"363", "Aruba"},
	{"505", "Australia"},
	{"232", "Austria"},
	{"400", "Azerbaijan"},
	{"426", "Bahrain"},
	{"880", "Bangladesh"},
	{"338", "Barbados"},
	{"342", "Barbados"},
	{"257", "Belarus"},
	{"206", "Belgium"},
	{"702", "Belize"},
	{"616", "Benin"},
	{"350", "Bermuda"},
	{"402", "Bhutan"},
	{"218", "Bosnia and Herzegovina"},
	{"652", "Botswana"},
	{"724", "Brazil"},
	{"348", "British Virgin Islands"},
	{"528", "Brunei Darussalam"},
	{"284", "Bulgaria"},
	{"613", "Burkina Faso"},
	{"642", "Burundi"},
	{"456", "Cambodia"},
	{"624", "Cameroon"},
	{"302", "Canada"},
	{"625", "Cape Verde"},
	{"346", "Cayman Islands"},
	{"623", "Central African Republic"},
	{"622", "Chad"},
	{"730", "Chile"},
	{"460", "China"},
	{"732", "Colombia"},
	{"654", "Comoros"},
	{"548", "Cook Islands"},
	{"712", "Costa Rica"},
	{"219", "Croatia"},
	{"368", "Cuba"},
	{"280", "Cyprus"},
	{"230", "Czech Republic"},
	{"630", "Democratic Republic of the Congo"},
	{"238", "Denmark"},
	{"638", "Djibouti"},
	{"370", "Dominican Republic"},
	{"740", "Ecuador"},
	{"602", "Egypt"},
	{"706", "El Salvador"},
	{"248", "Estonia"},
	{"636", "Ethiopia"},
	{"288", "Faroe Islands"},
	{"542", "Fiji"},
	{"244", "Finland"},
	{"208", "France"},
	{"547", "French Polynesia"},
	{"628", "Gabon"},
	{"607", "Gambia"},
	{"282", "Georgia"},
	{"262", "Germany"},
	{"620", "Ghana"},
	{"266", "Gibraltar"},
	{"202", "Greece"},
	{"290", "Greenland"},
	{"340", "Guadeloupe"},
	{"704", "Guatemala"},
	{"611", "Guinea"},
	{"632", "Guinea-Bissau"},
	{"738", "Guyana"},
	{"708", "Honduras"},
	{"454", "Hong Kong"},
	{"216", "Hungary"},
	{"274", "Iceland"},
	{"404", "India"},
	{"405", "India"},
	{"510", "Indonesia"},
	{"901", "International"},
	{"432", "Iran"},
	{"418", "Iraq"},
	{"272", "Ireland"},
	{"425", "Israel"},
	{"222", "Italy"},
	{"612", "Ivory Coast"},
	{"338", "Jamaica"},
	{"440", "Japan"},
	{"416", "Jordan"},
	{"401", "Kazakhstan"},
	{"639", "Kenya"},
	{"450", "Korea"},
	{"212", "Kosovo"},
	{"419", "Kuwait"},
	{"437", "Kyrgyzstan"},
	{"457", "Laos"},
	{"247", "Latvia"},
	{"415", "Lebanon"},
	{"651", "Lesotho"},
	{"618", "Liberia"},
	{"606", "Libya"},
	{"295", "Liechtenstein"},
	{"246", "Lithuania"},
	{"270", "Luxembourg"},
	{"455", "Macao"},
	{"646", "Madagascar"},
	{"650", "Malawi"},
	{"502", "Malaysia"},
	{"472", "Maldives"},
	{"610", "Mali"},
	{"278", "Malta"},
	{"609", "Mauritania"},
	{"617", "Mauritius"},
	{"334", "Mexico"},
	{"550", "Micronesia"},
	{"259", "Moldova"},
	{"208", "Monaco"},
	{"428", "Mongolia"},
	{"297", "Montenegro"},
	{"604", "Morocco"},
	{"643", "Mozambique"},
	{"414", "Myanmar"},
	{"649", "Namibia"},
	{"429", "Nepal"},
	{"204", "Netherlands"},
	{"362", "Netherlands Antilles"},
	{"546", "New Caledonia"},
	{"530", "New Zealand"},
	{"710", "Nicaragua"},
	{"614", "Niger"},
	{"621", "Nigeria"},
	{"242", "Norway"},
	{"422", "Oman"},
	{"410", "Pakistan"},
	{"552", "Palau"},
	{"714", "Panama"},
	{"537", "Papua New Guinea"},
	{"744", "Paraguay"},
	{"716", "Peru"},
	{"260", "Poland"},
	{"268", "Portugal"},
	{"427", "Qatar"},
	{"629", "Republic of Congo"},
	{"294", "Republic of Macedonia"},
	{"647", "Reunion"},
	{"226", "Romania"},
	{"250", "Russian Federation"},
	{"635", "Rwanda"},
	{"308", "Saint Pierre and Miquelon"},
	{"549", "Samoa"},
	{"292", "San Marino"},
	{"626", "Sao Tome and Principe"},
	{"420", "Saudi Arabia"},
	{"608", "Senegal"},
	{"220", "Serbia"},
	{"633", "Seychelles"},
	{"619", "Sierra Leone"},
	{"525", "Singapore"},
	{"231", "Slovakia"},
	{"293", "Slovenia"},
	{"655", "South Africa"},
	{"214", "Spain"},
	{"413", "Sri Lanka"},
	{"634", "Sudan"},
	{"746", "Suriname"},
	{"653", "Swaziland"},
	{"240", "Sweden"},
	{"228", "Switzerland"},
	{"417", "Syria"},
	{"466", "Taiwan"},
	{"436", "Tajikistan"},
	{"640", "Tanzania"},
	{"520", "Thailand"},
	{"615", "Togo"},
	{"539", "Tonga"},
	{"374", "Trinidad and Tobago"},
	{"605", "Tunisia"},
	{"286", "Turkey"},
	{"438", "Turkmenistan"},
	{"641", "Uganda"},
	{"255", "Ukraine"},
	{"424", "United Arab Emirates"},
	{"234", "United Kingdom"},
	{"310", "United States of America"},
	{"311", "United States of America"},
	{"316", "United States of America"},
	{"748", "Uruguay"},
	{"434", "Uzbekistan"},
	{"541", "Vanuatu"},
	{"225", "Vatican"},
	{"734", "Venezuela"},
	{"452", "Viet Nam"},
	{"421", "Yemen"},
	{"645", "Zambia"},
	{"648", "Zimbabwe"},

	{ NULL, NULL }
};

static gn_network networks[] = {
	{"202 01", "Cosmote"},
	{"202 05", "Vodafone"},
	{"202 09", "Q-telecom"},
	{"202 10", "WIND"},
	{"204 02", "Tele2 Netherlands"},
	{"204 04", "Vodafone"},
	{"204 08", "KPN"},
	{"204 12", "Telfort / O2 (KPN)"},
	{"204 16", "T-Mobile / Ben"},
	{"204 20", "Orange / Dutchtone (T-mobile)"},
	{"204 21", "NS Railinfrabeheer B.V."},
	{"206 01", "Proximus"},
	{"206 10", "Mobistar"},
	{"206 20", "BASE"},
	{"208 01", "France Telecom"},
	{"208 02", "Orange"},
	{"208 05", "Globalstar Europe"},
	{"208 06", "Globalstar Europe"},
	{"208 07", "Globalstar Europe"},
	{"208 10", "SFR"},
	{"208 11", "SFR (UMTS)"},
	{"208 13", "SFR (Zones Blanches)"},
	{"208 20", "Bouygues Telecom"},
	{"208 21", "Bouygues Telecom"},
	{"208 88", "Bouygues Telecom (Zones Blanches)"},
	{"213 03", "Mobiland"},
	{"214 01", "Vodafone / Airtel"},
	{"214 03", "Orange / Amena"},
	{"214 04", "Yoigo / Xfera"},
	{"214 05", "Telefonica Moviles Espana (used by resellers)"},
	{"214 06", "Vodafone (used by resellers)"},
	{"214 07", "Telefonica Moviles Espana (Movistar)"},
	{"214 08", "Euskaltel (MVNO)"},
	{"214 09", "Orange (used by resellers)"},
	{"216 01", "Pannon"},
	{"216 30", "T-Mobile"},
	{"216 70", "Vodafone"},
	{"218 01", "Cronet"},
	{"218 03", "Eronet Mobile Communications Ltd."},
	{"218 05", "MOBI's (Mobilina Srpske)"},
	{"218 19", "PTT Bosnia"},
	{"218 90", "PE PTT BIH"},
	{"219 01", "T-Mobile Croatia"},
	{"219 02", "Tele2"},
	{"219 10", "VIPnet"},
	{"220 01", "Telenor"},
	{"220 02", "ProMonte"},
	{"220 03", "MTS - Telekom Srbija"},
	{"220 04", "T-Mobile Montenegro"},
	{"220 05", "VIP Mobile"},
	{"222 01", "TIM"},
	{"222 02", "Elsacom"},
	{"222 10", "Vodafone"},
	{"222 30", "RFI"},
	{"222 77", "IPSE 2000"},
	{"222 88", "Wind"},
	{"222 98", "Blu"},
	{"222 99", "H3G"},
	{"226 01", "Vodafone"},
	{"226 03", "Cosmote"},
	{"226 05", "digi tel"},
	{"226 10", "Orange"},
	{"228 01", "Swisscom NATEL / Telecom FL A"},
	{"228 02", "diAx mobile / Sunrise"},
	{"228 03", "Orange"},
	{"228 05", "Togewanet AG"},
	{"228 06", "SBB AG"},
	{"228 07", "IN&Phone SA"},
	{"228 08", "Tele2 Telecommunications AG"},
	{"228 12", "Sunrise UMTS"},
	{"228 50", "3G Mobile AG"},
	{"228 51", "BebbiCell"},
	{"230 01", "T-Mobile Czech Republic"},
	{"230 02", "Telefonica O2 Czech Republic"},
	{"230 03", "Vodafone"},
	{"230 98", "SZDC s.o."},
	{"230 99", "Cesky Mobil a.s., R&D Centre"},
	{"231 01", "Orange"},
	{"231 02", "T-Mobile Slovensko"},
	{"231 03", "Unient Communications"},
	{"231 04", "T-Mobile Slovensko (UMTS)"},
	{"231 05", "Mobile Entertainment Company (UMTS)"},
	{"231 06", "Telefonica O2 Slovakia"},
	{"231 99", "ZSR"},
	{"232 01", "Mobilkom Austria / A1"},
	{"232 03", "T-Mobile"},
	{"232 05", "One / Orange Oesterreich"},
	{"232 07", "T-Mobile Austria"},
	{"232 09", "Tele2"},
	{"232 10", "Hutchison 3G - '3'"},
	{"234 00", "Virgin 3510i"},
	{"234 02", "O2"},
	{"234 03", "Jersey Telenet / Bharti / AirTel"},
	{"234 10", "Cellnet / O2"},
	{"234 11", "O2"},
	{"234 12", "Railtrack"},
	{"234 15", "Vodafone"},
	{"234 18", "Cloud9"},
	{"234 20", "3 / Hutchison 3G"},
	{"234 30", "T-Mobile"},
	{"234 31", "Virgin"},
	{"234 32", "Virgin"},
	{"234 33", "Orange"},
	{"234 34", "Orange"},
	{"234 50", "Jersey Telecom / Wave (Guernsey)"},
	{"234 55", "Cable & Wireless Guernsey / Sure Mobile (Jersey)"},
	{"234 58", "Manx Telecom"},
	{"238 01", "TDC"},
	{"238 02", "Sonofon"},
	{"238 03", "MIGway A/S"},
	{"238 04", "TetraStar"},
	{"238 05", "Sonofon"},
	{"238 06", "3"},
	{"238 10", "TDC"},
	{"238 20", "Telia"},
	{"238 30", "Telia"},
	{"238 77", "Tele2"},
	{"240 01", "Telia"},
	{"240 02", "3"},
	{"240 03", "Nordisk Mobiltelefon"},
	{"240 04", "3G Infrastructure Services"},
	{"240 05", "Sweden 3G  (Owned by Telia and Tele2)"},
	{"240 06", "Telenor"},
	{"240 07", "Tele2"},
	{"240 08", "Telenor"},
	{"240 09", "Telenor Mobile Sverige"},
	{"240 10", "SpringMobil"},
	{"240 20", "Wireless Maingate"},
	{"240 21", "Banverket"},
	{"242 01", "Telenor Mobil"},
	{"242 02", "NetCom GSM"},
	{"242 03", "Teletopia"},
	{"242 04", "Tele2"},
	{"242 05", "Network Norway"},
	{"242 07", "Ventelo"},
	{"242 56", "Chess Communication"},
	{"244 03", "DNA ltd. (formerly: Telia)"},
	{"244 04", "Finnet Networks Ltd."},
	{"244 05", "Elisa"},
	{"244 09", "Finnet Group / Lannen Puhelin / Helsingin Puhelin"},
	{"244 12", "FinNet"},
	{"244 14", "Alands Mobiltelefon AB"},
	{"244 16", "Oy Finland Tele2 AB"},
	{"244 21", "Elisa (formerly: Saunalahti Group Ltd.)"},
	{"244 91", "TeliaSonera Corporation"},
	{"246 01", "Omnitel"},
	{"246 02", "UAB Bite GSM"},
	{"246 03", "Tele 2"},
	{"247 01", "Latvian Mobile Tel."},
	{"247 02", "Tele 2 / BALTCOM GSM"},
	{"247 03", "Telekom Baltija"},
	{"247 04", "Beta Telecom"},
	{"248 01", "Estonian Mobile Telecom"},
	{"248 02", "Elisa"},
	{"248 03", "Tele 2"},
	{"248 04", "OY Top Connect"},
	{"248 05", "AS Bravocom Mobiil"},
	{"248 06", "OY ViaTel"},
	{"250 01", "MTS"},
	{"250 02", "Megafon"},
	{"250 03", "NCC / Nizhegorodskaya Cellular Communications"},
	{"250 04", "Sibchallenge"},
	{"250 05", "ETK / Yeniseytelecom"},
	{"250 07", "Zao SMARTS"},
	{"250 10", "Dontelekom"},
	{"250 11", "Orensot"},
	{"250 12", "Baykal Westcom / New Telephone Company / Far Eastern Cellular"},
	{"250 13", "Kuban GSM"},
	{"250 14", "Di-ex / Teleset LTD"},
	{"250 16", "NTC / New Telephone Company"},
	{"250 17", "Ermak RMS"},
	{"250 19", "Volgograd Mobile / INDIGO"},
	{"250 20", "Tele2 / ECC"},
	{"250 28", "Extel"},
	{"250 39", "Uraltel / Uralsvyazinform"},
	{"250 44", "Stavtelesot / North Caucasian GSM"},
	{"250 92", "Primtelefon"},
	{"250 93", "Telecom XXI"},
	{"250 99", "Beeline"},
	{"255 01", "MTS"},
	{"255 02", "Beeline"},
	{"255 03", "Kyivstar"},
	{"255 04", "IT CDMA/InterTelecom"},
	{"255 05", "Golden Telecom"},
	{"255 06", "life:)/A-stelit"},
	{"255 07", "Utel/UkrTelecom"},
	{"255 21", "PEOPLEnet/Telesystems of Ukraine"},
	{"255 23", "ITC CDMA Ukraine"},
	{"257 01", "Velcom"},
	{"257 02", "MTS"},
	{"257 04", "BeST"},
	{"259 01", "Orange"},
	{"259 02", "Moldcell"},
	{"259 03", "Unite"},
	{"259 04", "Eventis"},
	{"260 01", "Plus (Polkomtel)"},
	{"260 02", "Era (PTC)"},
	{"260 03", "Orange (PTK Centertel)"},
	{"260 04", "Tele2 Polska"},
	{"260 06", "Play (P4)"},
	{"260 07", "Premium Internet"},
	{"260 08", "E-Telko"},
	{"260 09", "Telekomunikacja Kolejowa"},
	{"260 10", "Telefonu Opalenickie"},
	{"260 12", "Halo Polsat"},
	{"262 01", "T-Mobile / D1 - DeTe Mobil"},
	{"262 02", "Vodafone"},
	{"262 03", "E-Plus"},
	{"262 04", "Vodafone"},
	{"262 05", "E-Plus"},
	{"262 06", "T-Mobile"},
	{"262 07", "O2"},
	{"262 08", "O2"},
	{"262 09", "Vodafone"},
	{"262 10", "Arcor AG & Co"},
	{"262 11", "O2"},
	{"262 12", "Dolphin Telecom"},
	{"262 13", "Mobilcom Multimedia"},
	{"262 14", "Group 3G UMTS"},
	{"262 15", "Airdata"},
	{"262 16", "vistream (MVNO)"},
	{"262 60", "DB Telematik"},
	{"262 76", "Siemens AG"},
	{"262 77", "E-Plus"},
	{"266 01", "Gibraltar Telecoms GibTel"},
	{"268 01", "Vodafone"},
	{"268 03", "Optimus"},
	{"268 06", "TMN"},
	{"270 01", "P&T Luxembourg"},
	{"270 77", "Tango"},
	{"270 99", "Voxmobile"},
	{"272 01", "Vodafone"},
	{"272 02", "O2"},
	{"272 03", "Meteor"},
	{"272 04", "Access Telecom"},
	{"272 07", "Eircom"},
	{"272 09", "Clever Communications"},
	{"274 01", "Iceland Telecom Siminn"},
	{"274 02", "Vodafone"},
	{"274 03", "Islandssimi ehf"},
	{"274 04", "IMC Islande ehf"},
	{"274 07", "IceCell ehf"},
	{"276 01", "Albanian Mobile Communications"},
	{"276 02", "Vodafone"},
	{"278 01", "Vodafone"},
	{"278 21", "go mobile"},
	{"280 01", "Cytamobile-Vodafone"},
	{"280 10", "Areeba"},
	{"282 01", "Geocell Limited"},
	{"282 02", "Magticom GSM"},
	{"282 03", "Iberiatel Ltd."},
	{"282 04", "Mobitel"},
	{"283 01", "ArmenTel"},
	{"283 05", "Vivacell"},
	{"284 01", "M-Tel"},
	{"284 03", "Vivatel"},
	{"284 05", "GLOBUL"},
	{"286 01", "Turkcell"},
	{"286 02", "Vodafone (Formerly known as Telsim)"},
	{"286 03", "Avea (Formerly known as Aria)"},
	{"286 04", "Aycell (Merged into Aria to form Avea)"},
	{"288 01", "Faroese Telecom"},
	{"288 02", "Kell GSM"},
	{"290 01", "Tele Greenland"},
	{"292 01", "Prima (San Marino Telecom)"},
	{"293 40", "Si Mobil"},
	{"293 41", "Mobitel"},
	{"293 70", "Vega"},
	{"294 01", "Mobimak / T-Mobile Macedonia"},
	{"294 02", "Cosmofon"},
	{"295 02", "Viag Europlatform AG"},
	{"295 05", "Mobilkom (Liechtenstein) AG"},
	{"295 77", "Tele2 AG"},
	{"297 03", "m:tel"},
	{"302 360", "Telus Mobility"},
	{"302 361", "Telus Mobility"},
	{"302 370", "Fido brand Rogers wireless"},
	{"302 620", "ICE Wireless"},
	{"302 651", "Bell Mobility"},
	{"302 652", "BC Tel Mobility"},
	{"302 653", "Telus Mobility"},
	{"302 654", "Sask Tel Mobility"},
	{"302 655", "MTS Mobility"},
	{"302 656", "Tbay Mobility"},
	{"302 657", "Telus (Quebec) Mobility"},
	{"302 701", "MB Tel Mobility"},
	{"302 702", "MT&T Mobility"},
	{"302 703", "New Tel Mobility"},
	{"302 710", "Globalstar"},
	{"302 720", "Rogers Wireless"},
	{"308 01", "St. Pierre-et-Miquelon Telecom"},
	{"310 000", "Mid-Tex Celular"},
	{"310 010", "MCI"},
	{"310 012", "Verizon Wireless"},
	{"310 013", "MobileTel"},
	{"310 014", "Testing"},
	{"310 016", "Cricket Communications"},
	{"310 017", "North Sight Communications Inc."},
	{"310 020", "APC Sprint Spectrum / Union Telephone Company"},
	{"310 030", "Centennial Communications"},
	{"310 032", "IT&E Overseas, Inc."},
	{"310 033", "Guam Telephone Authority"},
	{"310 034", "Nevada Wireless LLC"},
	{"310 040", "Concho Cellular Telephone Co., Inc."},
	{"310 060", "Consolidated Telcom"},
	{"310 070", "Highland Cellular, Inc."},
	{"310 080", "Corr Wireless Communications LLC"},
	{"310 090", "Edge Wireless"},
	{"310 100", "New Mexico RSA 4 East Ltd. Partnership"},
	{"310 110", "Wireless 2000 Telephone"},
	{"310 150", "Cingular / Bell South / BellSouth Mobility DCS"},
	{"310 160", "T-Mobile / Omnipoint Communications"},
	{"310 170", "Cingular / Pacific Bell Wireless / T-Mobile"},
	{"310 180", "Cingular / West Central Wireless"},
	{"310 190", "Alaska Telecom Mobile / Alaska Wireless Communications"},
	{"310 200", "T-Mobile / T-Mobile Idaho / Oregon / Washington State"},
	{"310 210", "T-Mobile / T-Mobile Iowa"},
	{"310 220", "T-Mobile / T-Mobile Kansas / Oklahoma"},
	{"310 230", "T-Mobile / T-Mobile Utah"},
	{"310 240", "T-Mobile / T-Mobile New Mexico / Texas / Arizona"},
	{"310 250", "T-Mobile / T-Mobile Hawaii"},
	{"310 260", "T-Mobile / Western Wireless / Voicestream"},
	{"310 270", "T-Mobile / Powertel"},
	{"310 280", "T-Mobile"},
	{"310 290", "T-Mobile"},
	{"310 300", "T-Mobile"},
	{"310 310", "T-Mobile / T-Mobile Florida / Aerial Communications"},
	{"310 340", "High Plains Midwest LLC (Westlink Communications)"},
	{"310 380", "AT&T Wireless / Cingular"},
	{"310 410", "AT&T"},
	{"310 420", "Cincinnati Bell Wireless"},
	{"310 430", "Alaska Digitel"},
	{"310 450", "North East Cellular"},
	{"310 460", "TMP Corporation"},
	{"310 470", "Guam Wireless Telephone Company"},
	{"310 480", "Choice Phone"},
	{"310 490", "Triton PCS"},
	{"310 500", "Public Service Cellular"},
	{"310 510", "Airtel Wireless"},
	{"310 520", "VeriSign"},
	{"310 530", "West Virginia Wireless"},
	{"310 540", "Oklahoma Western Telephone Company"},
	{"310 560", "American Cellular Corporation"},
	{"310 570", "MTPCS, LLC / Chinook Wireless"},
	{"310 580", "PCS ONE"},
	{"310 590", "Western Wireless Corporation / Alltel"},
	{"310 610", "Elkhart Telephone Co. / Epic Touch Co."},
	{"310 620", "Coleman County Telecommunications / Trans Texas PCS"},
	{"310 630", "Comtel PCS Mainstreet LP"},
	{"310 640", "Airadigm Communications"},
	{"310 660", "T-Mobile"},
	{"310 670", "Northstar"},
	{"310 680", "Noverr Publishing, Inc. dba NPI Wireless"},
	{"310 690", "Conestoga Wireless Company"},
	{"310 730", "SeaMobile"},
	{"310 740", "Telemetrix Technologies"},
	{"310 760", "Panhandle Telecommunications Systems Inc."},
	{"310 770", "Iowa Wireless Services"},
	{"310 780", "Message Express Company dba Airlink PCS"},
	{"310 790", "PinPoint Communications"},
	{"310 800", "T-Mobile"},
	{"310 830", "Caprock Cellular"},
	{"310 850", "Aeris Communications"},
	{"310 870", "Kaplan Telephone Company"},
	{"310 880", "Advantage Cellular Systems"},
	{"310 890", "Rural Cellular Corporation"},
	{"310 900", "Taylor Telecommunications"},
	{"310 910", "Southern IL RSA Partnership / First Cellular of Southern Illinois"},
	{"310 940", "Poka Lambro Telecommunications"},
	{"310 950", "Texas RSA 1 dba XIT Cellular (XIT Wireless)"},
	{"310 970", "Globalstar"},
	{"310 980", "AT&T Wireless Services"},
	{"311 000", "Mid-Tex Cellular"},
	{"311 010", "Chariton Valley Communications"},
	{"311 020", "Missouri RSA 5 Partnership"},
	{"311 030", "Indigo Wireless"},
	{"311 040", "Commet Wireless"},
	{"311 050", "Farmers Cellular Telephone"},
	{"311 060", "Farmers Cellular Telephone"},
	{"311 070", "Easterbrooke Cellular Corporation"},
	{"311 080", "Pine Cellular / Pine Telephone Company"},
	{"311 090", "Siouxland PCS"},
	{"311 100", "High Plains Wireless"},
	{"311 110", "High Plains Wireless"},
	{"311 120", "Choice Phone"},
	{"311 130", "Amarillo License"},
	{"311 140", "MBO Wireless / Cross Telephone Company"},
	{"311 150", "Wilkes Cellular"},
	{"311 160", "Endless Mountains Wireless"},
	{"311 180", "Cingular Wireless / Licensee Pacific Telesis Mobile Services"},
	{"311 210", "Farmers Cellular Telephone"},
	{"316 010", "Nextel Communications"},
	{"316 011", "Southern Communications Services"},
	{"334 01", "Nextel Mexico"},
	{"334 02", "Telcel"},
	{"334 03", "Telefonica Moviles Mexico (movistar)"},
	{"338 020", "Cable & Wireless"},
	{"338 05", "Digicel"},
	{"338 050", "Mossel Digicel"},
	{"338 070", "ODJ"},
	{"338 180", "C&W"},
	{"340 01", "Orange Caraibe Mobiles"},
	{"340 02", "Outremer Telecom"},
	{"340 03", "Saint Martin et Saint Barthelemy Telcell Sarl"},
	{"340 20", "Digicel (ex-Bouygues Telecom Caraibes)"},
	{"342 600", "Cable & Wireless (Barbados) Ltd."},
	{"342 820", "Sunbeach Communications"},
	{"344 030", "APUA"},
	{"344 920", "bmobile"},
	{"344 930", "Digicel"},
	{"346 140", "Cable & Wireless (Cayman)"},
	{"348 570", "Caribbean Cellular Telephone"},
	{"362 51", "TELCELL GSM"},
	{"362 69", "CT GSM"},
	{"362 91", "SETEL GSM / CHIPP"},
	{"363 01", "Setar"},
	{"363 20", "Digicell"},
	{"365 10", "Weblinks Limited"},
	{"368 01", "Cubacel"},
	{"370 01", "Orange Dominicana"},
	{"370 02", "Compania Dominicana de Telefonos, C por A. (Claro)"},
	{"370 03", "Tricom S.A."},
	{"370 04", "Centennial Dominicana"},
	{"374 12", "TSTT"},
	{"374 13", "Digicel"},
	{"400 01", "Azercell"},
	{"400 02", "Bakcell"},
	{"400 03", "Catel"},
	{"400 04", "Nar Mobile"},
	{"401 01", "K-Mobile/Beeline/ Kar-Tel"},
	{"401 02", "K'Cell / JSC \"Kazakhtelecom\""},
	{"401 07", "Dalacom / JSC \"Altel\""},
	{"401 77", "NEO Telecom / JSC \"Kazakhtelecom\""},
	{"402 17", "B-Mobile"},
	{"404 01", "AirCell Digilink"},
	{"404 02", "Airtel"},
	{"404 03", "Airtel / Bharti Telenet"},
	{"404 04", "Idea Cellular"},
	{"404 05", "Hutch / Fascel"},
	{"404 06", "Airtel"},
	{"404 07", "TATA Cellular / Idea Cellular"},
	{"404 09", "Reliance Telecom Private"},
	{"404 10", "Airtel"},
	{"404 11", "Essar / Sterling Cellular"},
	{"404 12", "Escotel Mobile Comms"},
	{"404 13", "Hutchison Essar South"},
	{"404 14", "Spice Communications / Modi Telstra Modicom"},
	{"404 15", "Aircell Digilink Essar Cellph."},
	{"404 20", "Vodafone Mumbai (formerly Hutchison Maxtouch / Orange/ Hutch Mumbai)"},
	{"404 21", "BPL Mobile Mumbai"},
	{"404 22", "Idea Cellular Maharashtra & Goa"},
	{"404 24", "Idea Cellular"},
	{"404 27", "BPL USWest Cellular / Cellular Comms"},
	{"404 30", "Usha Martin Tel. Command"},
	{"404 31", "Airtel"},
	{"404 34", "BSNL"},
	{"404 36", "Reliance Telecom Private"},
	{"404 38", "BSNL"},
	{"404 40", "Airtel"},
	{"404 41", "RPG MAA"},
	{"404 42", "Srinivas Cellcom / Aircel"},
	{"404 43", "BPL Mobile Cellular"},
	{"404 44", "Spice"},
	{"404 45", "Airtel"},
	{"404 46", "BPL Cellular (Now vodafone)"},
	{"404 49", "Airtel"},
	{"404 50", "Reliance Telecom Private"},
	{"404 51", "BSNL"},
	{"404 52", "Reliance Telecom Private"},
	{"404 53", "BSNL"},
	{"404 54", "BSNL"},
	{"404 55", "BSNL"},
	{"404 56", "Escotel Mobile Communications Private"},
	{"404 57", "BSNL"},
	{"404 58", "BSNL"},
	{"404 59", "BSNL"},
	{"404 60", "Aircell Digilink"},
	{"404 62", "BSNL"},
	{"404 64", "BSNL"},
	{"404 66", "BSNL"},
	{"404 67", "Reliance Telecom Private"},
	{"404 68", "Mahanagar Telephone Nigam"},
	{"404 69", "DOLPHIN / Mahanagar Telephone Nigam"},
	{"404 70", "Airtel"},
	{"404 71", "BSNL"},
	{"404 72", "BSNL Kerala"},
	{"404 73", "BSNL"},
	{"404 74", "BSNL"},
	{"404 75", "BSNL / CellOne"},
	{"404 76", "BSNL"},
	{"404 77", "BSNL"},
	{"404 78", "BTA Cellcom"},
	{"404 80", "BSNL"},
	{"404 81", "BSNL"},
	{"404 82", "Escorts Telecom"},
	{"404 83", "Reliable Internet Services"},
	{"404 84", "Hutchison Essar South"},
	{"404 85", "Reliance Telecom Private"},
	{"404 86", "Hutchinson Essar South"},
	{"404 87", "Escorts Telecom"},
	{"404 88", "Escorts Telecom"},
	{"404 89", "Escorts Telecom"},
	{"404 90", "Airtel Maharashtra & Goa"},
	{"404 92", "Airtel Mumbai"},
	{"404 93", "Airtel Gujrat"},
	{"404 94", "Airtel"},
	{"404 95", "Airtel"},
	{"404 96", "Airtel"},
	{"404 97", "Airtel"},
	{"404 98", "Airtel"},
	{"405 51", "Airtel"},
	{"405 52", "Airtel"},
	{"405 66", "Hutch"},
	{"410 01", "Mobilink"},
	{"410 03", "UFONE"},
	{"410 04", "Paktel"},
	{"410 06", "Telenor"},
	{"410 07", "Warid"},
	{"412 01", "Afghan Wireless Communication Company"},
	{"412 20", "Roshan"},
	{"412 40", "Areeba"},
	{"412 50", "Etisalat"},
	{"413 01", "Mobitel Lanka Ltd."},
	{"413 02", "Dialog Telekom PLC."},
	{"413 03", "Celtel Lanka Ltd / Tigo."},
	{"413 08", "Hutch Sri Lanka."},
	{"414 01", "Myanmar Post and Telecommunication"},
	{"415 01", "Alfa"},
	{"415 03", "MTC Touch"},
	{"416 01", "J.M.T.S. Fastlink"},
	{"416 77", "MobCom"},
	{"417 01", "SyriaTel"},
	{"417 02", "Spacetel Syria"},
	{"417 09", "Syrian Telecom Est. MOBILE"},
	{"418 01", "Iraq Telecom"},
	{"419 02", "Mobile Telecoms / MTCNet"},
	{"419 03", "Wataniya"},
	{"420 01", "Saudi Telecom / Ministry of PTT Al Jawal"},
	{"420 07", "Electronics App' Est. / EAE"},
	{"421 01", "SabaFon"},
	{"421 02", "MTN"},
	{"422 02", "General Telecoms"},
	{"424 02", "Etisalat"},
	{"424 03", "Emirates Integrated Telecommunications Company (du)"},
	{"425 01", "Orange"},
	{"425 02", "Cellcom"},
	{"425 03", "Pelephone"},
	{"425 77", "Mirs"},
	{"426 01", "Batelco"},
	{"426 02", "MTC-VFBH"},
	{"427 01", "Q-Net / Q-Tel QATARNET"},
	{"428 88", "Unitel"},
	{"428 99", "Mobicom"},
	{"429 01", "Nepal Telecommunications"},
	{"429 02", "Spice Nepal Pvt. Ltd."},
	{"429 03", "United Telecom Ltd."},
	{"432 11", "Mobile Communications Company of Iran / IR-MCI"},
	{"432 14", "Telecommunication Kish Co. (Kifzo)"},
	{"432 19", "Mobile Telecommunications Company of Esfahan (MTCE)"},
	{"432 32", "Taliya"},
	{"432 35", "MTN Irancell"},
	{"434 01", "Buztel"},
	{"434 02", "Uzmacom"},
	{"434 04", "Beeline"},
	{"434 05", "Coscom"},
	{"434 07", "MTS"},
	{"436 01", "JC Somoncom"},
	{"436 02", "CJSC Indigo Tajikistan"},
	{"436 03", "TT mobile"},
	{"436 04", "Josa Babilon-T"},
	{"436 05", "CTJTHSC Tajik-tel"},
	{"437 01", "Bitel"},
	{"438 01", "Barash Communication Technologies (BCTI)"},
	{"438 02", "TM-Cell"},
	{"440 01", "NTT DoCoMo"},
	{"440 02", "NTT DoCoMo Kansai"},
	{"440 03", "NTT DoCoMo Hokuriku"},
	{"440 04", "Vodafone"},
	{"440 06", "Vodafone"},
	{"440 07", "KDDI Corporation"},
	{"440 08", "KDDI Corporation"},
	{"440 09", "NTT DoCoMo Kansai"},
	{"440 10", "NTT DoCoMo Kansai"},
	{"440 11", "NTT DoCoMo Tokai"},
	{"440 12", "NTT DoCoMo"},
	{"440 13", "NTT DoCoMo"},
	{"440 14", "NTT DoCoMo Tohoku"},
	{"440 15", "NTT DoCoMo"},
	{"440 16", "NTT DoCoMo"},
	{"440 17", "NTT DoCoMo"},
	{"440 18", "NTT DoCoMo Tokai"},
	{"440 19", "NTT DoCoMo Hokkaido"},
	{"440 20", "NTT DoCoMo Hokuriku"},
	{"440 21", "NTT DoCoMo"},
	{"440 22", "NTT DoCoMo Kansai"},
	{"440 23", "NTT DoCoMo Tokai"},
	{"440 24", "NTT DoCoMo Chugoku"},
	{"440 25", "NTT DoCoMo Hokkaido"},
	{"440 26", "NTT DoCoMo Kyushu"},
	{"440 27", "NTT DoCoMoTohoku"},
	{"440 28", "NTT DoCoMo Shikoku"},
	{"440 29", "NTT DoCoMo"},
	{"440 30", "NTT DoCoMo"},
	{"440 31", "NTT DoCoMo Kansai"},
	{"440 32", "NTT DoCoMo"},
	{"440 33", "NTT DoCoMo Tokai"},
	{"440 34", "NTT DoCoMo Kyushu"},
	{"440 35", "NTT DoCoMo Kansai"},
	{"440 36", "NTT DoCoMo"},
	{"440 37", "NTT DoCoMo"},
	{"440 38", "NTT DoCoMo"},
	{"440 39", "NTT DoCoMo"},
	{"440 40", "Vodafone"},
	{"440 41", "Vodafone"},
	{"440 42", "Vodafone"},
	{"440 43", "Vodafone"},
	{"440 44", "Vodafone"},
	{"440 45", "Vodafone"},
	{"440 46", "Vodafone"},
	{"440 47", "Vodafone"},
	{"440 48", "Vodafone"},
	{"440 49", "NTT DoCoMo"},
	{"440 50", "KDDI Corporation"},
	{"440 51", "KDDI Corporation"},
	{"440 52", "KDDI Corporation"},
	{"440 53", "KDDI Corporation"},
	{"440 54", "KDDI Corporation"},
	{"440 55", "KDDI Corporation"},
	{"440 56", "KDDI Corporation"},
	{"440 58", "NTT DoCoMo Kansai"},
	{"440 60", "NTT DoCoMo Kansai"},
	{"440 61", "NTT DoCoMo Chugoku"},
	{"440 62", "NTT DoCoMo Kyushu"},
	{"440 63", "NTT DoCoMo"},
	{"440 64", "NTT DoCoMo"},
	{"440 65", "NTT DoCoMo Shikoku"},
	{"440 66", "NTT DoCoMo"},
	{"440 67", "NTT DoCoMo Tohoku"},
	{"440 68", "NTT DoCoMo Kyushu"},
	{"440 69", "NTT DoCoMo"},
	{"440 70", "KDDI Corporation"},
	{"440 71", "KDDI Corporation"},
	{"440 72", "KDDI Corporation"},
	{"440 73", "KDDI Corporation"},
	{"440 74", "KDDI Corporation"},
	{"440 75", "KDDI Corporation"},
	{"440 76", "KDDI Corporation"},
	{"440 77", "KDDI Corporation"},
	{"440 78", "Okinawa Cellular Telephone"},
	{"440 79", "KDDI Corporation"},
	{"440 80", "TU-KA Cellular Tokyo"},
	{"440 81", "TU-KA Cellular Tokyo"},
	{"440 82", "TU-KA Phone Kansai"},
	{"440 83", "TU-KA Cellular Tokai"},
	{"440 84", "TU-KA Phone Kansai"},
	{"440 85", "TU-KA Cellular Tokai"},
	{"440 86", "TU-KA Cellular Tokyo"},
	{"440 87", "NTT DoCoMo Chugoku"},
	{"440 88", "KDDI Corporation"},
	{"440 89", "KDDI Corporation"},
	{"440 90", "Vodafone"},
	{"440 92", "Vodafone"},
	{"440 93", "Vodafone"},
	{"440 94", "Vodafone"},
	{"440 95", "Vodafone"},
	{"440 96", "Vodafone"},
	{"440 97", "Vodafone"},
	{"440 98", "Vodafone"},
	{"440 99", "NTT DoCoMo"},
	{"450 02", "KTF CDMA"},
	{"450 05", "SK Telecom"},
	{"450 08", "KTF WCDMA"},
	{"452 00", "Mobifone / MTSC"},
	{"452 01", "Mobifone / MTSC"},
	{"452 02", "Vinaphone / DGPT"},
	{"452 03", "S-Phone / S-Telecom"},
	{"452 98", "HT Mobile / Hanoi Telecom"},
	{"452 99", "E-Phone / EVN Telecom"},
	{"454 00", "CSL"},
	{"454 01", "MVNO)"},
	{"454 02", "CSL 3G"},
	{"454 03", "Hutchison Telecom / 3 (3G)"},
	{"454 04", "Hutchison Telecom / 3 (2G)"},
	{"454 05", "Hutchison Telecom / 3 CDMA"},
	{"454 06", "SmarTone Mobile Comms / Smartone-Vodafone"},
	{"454 07", "MVNO)"},
	{"454 08", "MVNO)"},
	{"454 09", "MVNO)"},
	{"454 10", "New World PCS"},
	{"454 11", "MVNO)"},
	{"454 12", "China Mobile Peoples Telephone Company"},
	{"454 14", "Hutchison Telecom"},
	{"454 15", "SMT (UMTS)"},
	{"454 16", "PCCW Mobile (PCCW Ltd)"},
	{"454 17", "SmarTone"},
	{"454 18", "Hong Kong Telecom CSL / Pacific Link"},
	{"454 19", "PCCW Mobile (PCCW Ltd)"},
	{"455 00", "Smartone Mobile Communications (Macao) Ltd"},
	{"455 01", "C.T.M. Telemovel+"},
	{"455 03", "Hutchison Telecom / 3"},
	{"456 01", "Mobitel / Cam GSM"},
	{"456 02", "Samart / Casacom"},
	{"456 03", "S Telecom"},
	{"456 04", "Cadcomms"},
	{"456 18", "Camshin / Shinawatra"},
	{"457 01", "Lao Shinawatra Telecom"},
	{"457 02", "ETL Mobile"},
	{"457 08", "Millicom"},
	{"460 00", "China Mobile"},
	{"460 01", "China Unicom"},
	{"466 01", "FarEasTone"},
	{"466 06", "Tuntex Telecom"},
	{"466 11", "Chunghwa"},
	{"466 88", "KG Telecom"},
	{"466 89", "VIBO Telecom"},
	{"466 92", "LDTA"},
	{"466 93", "Mobitai Communications"},
	{"466 97", "Pacific Cellular TWN GSM"},
	{"466 99", "TransAsia Telecoms"},
	{"472 01", "DhiMobile"},
	{"472 02", "Choq Mobile"},
	{"502 00", "Art900"},
	{"502 02", "My BSB"},
	{"502 03", "Binariang"},
	{"502 12", "Maxis / Binariang Communications"},
	{"502 13", "Celcom TM / TM Touch"},
	{"502 16", "DiGi Telecommunications"},
	{"502 17", "TimeCel / Binariang Communications Maxis"},
	{"502 19", "Celcom TM"},
	{"505 01", "Telstra"},
	{"505 02", "Optus"},
	{"505 03", "Vodafone"},
	{"505 038", "Crazy John's"},
	{"505 04", "Department of Defence"},
	{"505 05", "Ozitel"},
	{"505 06", "Hutchison 3G (3)"},
	{"505 07", "Vodafone"},
	{"505 08", "One. Tel"},
	{"505 09", "Airnet"},
	{"505 11", "Telstra"},
	{"505 12", "Hutchison 3G (3)"},
	{"505 14", "AAPT"},
	{"505 15", "3GIS"},
	{"505 24", "Advanced Communications Technologies"},
	{"505 71", "Telstra"},
	{"505 72", "Telstra"},
	{"505 88", "Localstar"},
	{"505 90", "Optus"},
	{"505 99", "One. Tel"},
	{"510 00", "PSN"},
	{"510 01", "PT Satelindo / PT Satelit Palapa / INDOSAT"},
	{"510 08", "Natrindo (Lippo Telecom)"},
	{"510 10", "Telkomsel"},
	{"510 11", "PT Excelcomindo Excelcom / proXL"},
	{"510 21", "IND IM3 / INDOSAT"},
	{"510 28", "Komselindo"},
	{"510 89", "Hutchinson Telecommunication Indonesia / HCPT"},
	{"520 00", "CAT CDMA"},
	{"520 01", "AIS / Advanced Info Service GSM"},
	{"520 10", "WCS IQ"},
	{"520 15", "Thai Mobile / ACT Mobile"},
	{"520 18", "DTAC / Total Access Comms"},
	{"520 23", "Digital Phone Hello"},
	{"520 99", "True / Orange"},
	{"525 01", "Singapore Telecom / SingTel"},
	{"525 02", "Singapore Telecom / SingTel"},
	{"525 03", "MobileOne Asia / SGP-M1-3GS"},
	{"525 05", "StarHub"},
	{"525 12", "Digital Trunked Radio Network"},
	{"528 01", "Jabatan Telekom"},
	{"528 02", "BRU-bmobile"},
	{"528 11", "DST Communications"},
	{"530 00", "Telecom New Zealand (AMPS MIN based IMSI's)"},
	{"530 01", "Vodafone New Zealand"},
	{"530 02", "Telecom New Zealand (CDMA Mobile Network)"},
	{"530 03", "Woosh Wireless New Zealand"},
	{"530 04", "TelstraClear New Zealand"},
	{"530 28", "Econet Wireless New Zealand"},
	{"537 01", "Pacific Mobile Comms"},
	{"539 01", "Tonga Communications Corporation"},
	{"539 43", "Shoreline Communication"},
	{"541 01", "SMILE"},
	{"542 01", "Vodafone"},
	{"546 01", "OPT Mobilis"},
	{"547 20", "Tikiphone"},
	{"548 01", "Telecom Cook"},
	{"549 01", "Telecom Samoa Cellular Ltd."},
	{"550 01", "FSM Telecom"},
	{"552 01", "Palau National Communications Corp. - PNCC"},
	{"602 01", "Mobinil"},
	{"602 02", "Vodafone"},
	{"602 03", "Etisalat"},
	{"603 01", "ATM Mobilis"},
	{"603 02", "Djezzy"},
	{"603 03", "Nedjma"},
	{"604 00", "Meditel"},
	{"604 01", "IAM / Ittissalat Al Maghrib / Maroc Telecom"},
	{"605 02", "Tunicell / Tunisian PTT / Tunisie Telecom"},
	{"605 03", "Orascom Telecom"},
	{"606 00", "Libyana"},
	{"606 01", "AlMadar"},
	{"607 01", "Gamcel"},
	{"607 02", "Africel"},
	{"608 01", "Sonatel ALIZE"},
	{"608 02", "Sentel GSM"},
	{"609 01", "Mattel"},
	{"610 01", "Malitel"},
	{"611 01", "Spacetel"},
	{"611 02", "Sotelgui Lagui"},
	{"612 01", "Cora de Comstar"},
	{"612 02", "Moov"},
	{"612 03", "Orange"},
	{"612 04", "KOZ de Comium"},
	{"612 05", "MTN"},
	{"613 01", "Onatel"},
	{"613 02", "Celtel"},
	{"613 03", "Telecel / Moov"},
	{"614 01", "Sahel.Com"},
	{"614 02", "Celtel"},
	{"614 03", "Telecel"},
	{"615 01", "Togo Telecom / TOGO CELL"},
	{"616 01", "Libercom"},
	{"616 02", "Telecel / Moov"},
	{"616 03", "Spacetel Benin"},
	{"617 01", "Cellplus"},
	{"617 02", "Mahanagar Telephone (Mauritius) Ltd."},
	{"617 10", "Emtel"},
	{"618 01", "Omega Communications"},
	{"618 04", "Comium Liberi"},
	{"619 01", "Celtel"},
	{"619 02", "Millicom"},
	{"619 03", "Datatel"},
	{"619 04", "Comium"},
	{"619 05", "Africell"},
	{"619 25", "Mobitel"},
	{"620 01", "MTN - Areeba / ScanCom"},
	{"620 02", "Onetouch / Ghana Telecom"},
	{"620 03", "Tigo / Mobitel"},
	{"621 20", "Celtel / V-Mobile / Econet Wireless Nigeria Ltd."},
	{"621 30", "MTN"},
	{"621 40", "Nigeria Telecommunications Ltd."},
	{"621 50", "Glo"},
	{"622 01", "Celtel"},
	{"622 02", "Tchad Mobile"},
	{"623 01", "Centrafrique Telecom Plus (CTP)"},
	{"623 02", "Telecel Centrafrique (TC)"},
	{"623 03", "Orange RCA"},
	{"623 04", "Nationlink RCA"},
	{"624 01", "Mobile Telephone Network"},
	{"624 02", "Orange"},
	{"625 01", "Cabo Verde Telecom"},
	{"626 01", "Companhia Santomese de Telecomunicacoes (CSTmovel)"},
	{"628 01", "Libertis S.A."},
	{"628 02", "Moov (Telecel) Gabon S.A."},
	{"628 03", "Celtel Gabon S.A."},
	{"629 01", "Celtel"},
	{"629 10", "Libertis Telecom"},
	{"630 01", "Vodacom Congo RDC sprl"},
	{"630 86", "Congo-Chine Telecom s.a.r.l."},
	{"631 02", "UNITEL"},
	{"632 02", "Spacetel Guine-Bissau S.A."},
	{"633 01", "Cable & Wireless (Seychelles) Ltd."},
	{"633 02", "Mediatech International Ltd."},
	{"633 10", "Telecom Airtel"},
	{"634 01", "Mobitel / Mobile Telephone Company"},
	{"634 02", "MTN Sudan"},
	{"635 10", "Rwandacell / MTN"},
	{"636 01", "ETH MTN / Ethiopian Telecoms Auth."},
	{"638 01", "Evatis"},
	{"639 02", "Safaricom Ltd."},
	{"639 03", "Kencell Communications Ltd."},
	{"640 01", "Tritel"},
	{"640 02", "MIC"},
	{"640 03", "Zantel"},
	{"640 04", "Vodacom"},
	{"640 05", "Celtel"},
	{"641 01", "Celtel Cellular"},
	{"641 10", "MTN Uganda"},
	{"641 11", "Uganda Telecom Ltd."},
	{"642 01", "Spacetel Burundi"},
	{"642 02", "Safaris"},
	{"642 03", "Telecel Burundi Company"},
	{"643 01", "Mocambique Celular S.A.R.L (mCel)"},
	{"643 04", "VM, S.A.R.L. (Vodacom Mozambique)"},
	{"645 01", "Celtel"},
	{"645 02", "Telecel"},
	{"645 03", "MTN"},
	{"646 01", "Madacom"},
	{"646 02", "Orange"},
	{"646 03", "Sacel"},
	{"647 00", "Orange La Reunion"},
	{"647 02", "Outremer Telecom"},
	{"647 10", "SRR / Societe Reunionnaise du Radiotelephone"},
	{"648 01", "Net One"},
	{"648 03", "Telecel"},
	{"648 04", "Econet"},
	{"649 01", "MTC"},
	{"650 01", "TNL / Telecom Network Callpoint"},
	{"650 10", "Celtel ltd."},
	{"651 01", "Vodacom"},
	{"651 02", "Econet Ezin-cel"},
	{"652 01", "Mascom Wireless"},
	{"652 02", "Orange Botswana"},
	{"653 10", "Swazi MTN"},
	{"654 01", "HURI - SNPT"},
	{"655 01", "Vodacom"},
	{"655 06", "Sentech (Pty) Ltd."},
	{"655 07", "Cell C"},
	{"655 10", "MTN / Mobile Telephone Networks"},
	{"655 11", "SAPS Gauteng"},
	{"655 21", "Cape Town Metropolitan Council"},
	{"655 30", "Bokamoso Consortium"},
	{"655 31", "Karabo Telecoms (Pty) Ltd."},
	{"655 32", "Ilizwi Telecommunications"},
	{"655 33", "Thinta Thinta Telecommunications"},
	{"702 67", "Belize Telecommunications Ltd."},
	{"702 68", "International Telecommunications Ltd."},
	{"704 01", "SERCOM / PCS Digital / Claro"},
	{"704 02", "Comcel / Tigo"},
	{"704 03", "Telefonica Moviles Guatemala (movistar)"},
	{"706 01", "Personal / Telecom / Claro"},
	{"706 02", "Digicel Group (digicel)"},
	{"706 03", "Telemovil (Millicom) / Tigo"},
	{"706 04", "Telefonica Moviles El Salvador (movistar)"},
	{"706 10", "Personal / Telecom / Claro"},
	{"708 01", "Megatel / Alo / Claro"},
	{"708 02", "Celtel / Tigo"},
	{"708 30", "Hondutel"},
	{"710 21", "Empresa Nicaraguense de Telecomunicaciones, S.A. (Claro)"},
	{"710 30", "Telefonica Moviles Nicaragua (movistar)"},
	{"710 73", "SERCOM / Servicios de Comunicaciones S.A. / Claro"},
	{"712 01", "Instituto Costarricense de Electricidad (ICE)"},
	{"712 02", "Instituto Costarricense de Electricidad (ICE)"},
	{"714 01", "Cable & Wireless Panama S.A."},
	{"714 02", "BSC de Panama S.A. (movistar)"},
	{"716 07", "Telefonica Moviles Peru (movistar)"},
	{"716 10", "TIM Peru / America Movil Peru / Claro"},
	{"722 010", "Compania de Radiocomunicaciones Moviles S.A. (Movicom)"},
	{"722 020", "Nextel Argentina srl"},
	{"722 070", "Unifon"},
	{"722 310", "CTI PCS S.A."},
	{"722 320", "CTI Movil"},
	{"722 330", "CTI Movil"},
	{"722 340", "Telecom Personal"},
	{"722 350", "Hutchinson (PORT HABLE)"},
	{"724 00", "Telet"},
	{"724 01", "CRT Celular"},
	{"724 02", "TIM"},
	{"724 03", "TIM"},
	{"724 04", "TIM"},
	{"724 05", "Claro"},
	{"724 06", "Claro (former Tess)"},
	{"724 07", "Sercontel Celular"},
	{"724 08", "Maxitel"},
	{"724 09", "Telepar Celular"},
	{"724 10", "Vivo (SP)"},
	{"724 11", "Vivo"},
	{"724 12", "Claro (Former Americel)"},
	{"724 13", "Vivo (Former Telesp Celular)"},
	{"724 14", "Maxitel BA"},
	{"724 15", "CTBC Celular"},
	{"724 16", "Brasil Telecom"},
	{"724 17", "Ceterp Celular"},
	{"724 18", "Oi (also known as Telemar / Norte Brasil Telecom)"},
	{"724 19", "Telemig Celular"},
	{"724 21", "Telerj Celular"},
	{"724 23", "Telest Celular"},
	{"724 25", "Telebrasilia Celular"},
	{"724 27", "Telegoias Celular"},
	{"724 29", "Telemat Celular"},
	{"724 31", "Oi"},
	{"724 33", "Teleron Celular"},
	{"724 35", "Telebahia Celular"},
	{"724 37", "Telergipe Celular"},
	{"724 39", "Telasa Celular"},
	{"724 41", "Telpe Celular"},
	{"724 43", "Telepisa Celular"},
	{"724 45", "Telpa Celular"},
	{"724 47", "Telem Celular"},
	{"724 48", "Teleceara Celular"},
	{"724 51", "Telma Celular"},
	{"724 53", "Telepara Celular"},
	{"724 55", "Teleamazon Celular"},
	{"724 57", "Teleamapa Celular"},
	{"724 59", "Telaima Celular"},
	{"730 01", "Entel Telefonia Movil"},
	{"730 02", "Movistar Chile"},
	{"730 03", "Claro Chile"},
	{"730 10", "Entel PCS Telecom"},
	{"732 001", "Colombia Telecomunicaciones S.A. - Telecom"},
	{"732 002", "Edatel S.A."},
	{"732 101", "Comcel S.A. Occel S.A. / Celcaribe"},
	{"732 102", "Bellsouth Colombia S.A. (movistar)"},
	{"732 103", "Colombia Movil S.A."},
	{"732 111", "Colombia Movil S.A."},
	{"732 123", "Telefonica Moviles Colombia S.A. (movistar)"},
	{"734 01", "Digitel / Infonet"},
	{"734 02", "Digitel"},
	{"734 03", "Digitel / Digicel"},
	{"734 04", "Telefonica Moviles Venezuela (movistar)"},
	{"738 01", "Cel*Star"},
	{"740 00", "Otecel S.A. - (formerly Bellsouth) (Movistar)"},
	{"740 01", "Porta GSM"},
	{"740 02", "Telecsa S.A."},
	{"744 01", "VOX / Hola Paraguay S.A."},
	{"744 02", "Hutchison Telecom S.A. / America Movil Paraguay / CTI Movil"},
	{"744 03", "Compania Privada de Comunicaciones S.A."},
	{"744 04", "Telecel / Tigo"},
	{"746 02", "Telesu"},
	{"748 00", "Ancel"},
	{"748 01", "Ancel"},
	{"748 10", "America Movil Uruguay / CTI Movil"},
	{"880 11", "CityCell"},
	{"880 15", "TeleTalk"},
	{"880 16", "Warid Tel"},
	{"880 17", "GP (Grameen Phone)"},
	{"880 18", "AKtel (A. Khan Telecom)"},
	{"880 19", "BanglaLink"},
	{"901 01", "ICO Global Communications"},
	{"901 02", "Sense Communications International"},
	{"901 03", "Iridium Satellite"},
	{"901 04", "Globalstar (GMSS)"},
	{"901 05", "Thuraya RMSS Network"},
	{"901 06", "Thuraya Satellite Telecommunications Company"},
	{"901 07", "Ellipso"},
	{"901 08", "Reserved for station identification where the mobile does not have a subscription IMSI"},
	{"901 09", "Tele1 Europe"},
	{"901 10", "Asia Cellular Satellite (AceS)"},
	{"901 11", "Inmarsat"},
	{"901 12", "Maritime Communications Partner AS (MCP)"},
	{"901 13", "Global Networks"},
	{"901 14", "Telenor GSM - services in aircraft"},
	{"901 15", "SITA GSM - services in aircraft"},
	{"901 18", "Cingular Wireless"},

	{ NULL, NULL }
};

GNOKII_API char *gn_network_name_get(char *network_code)
{
	int index = 0;

	while (networks[index].code &&
	       strncmp(networks[index].code, network_code, 6)) index++;

	/* for now be compacrapatible ;) */
	return networks[index].name ? networks[index].name : _("unknown");
}

GNOKII_API char *gn_network_code_get(char *network_name)
{
	int index = 0;

	while (networks[index].name &&
	       strcasecmp(networks[index].name, network_name)) index++;

	return networks[index].code ? networks[index].code : _("undefined");
}

GNOKII_API char *gn_network_code_find(char *network_name, char *country_name)
{
	int index = 0;
	char country_code[5];
	
	snprintf(country_code, 4, "%3s ", gn_country_code_get(country_name));
	country_code[4] = 0;
	while (networks[index].name &&
	       (!strstr(networks[index].code, country_code) ||
	        strcasecmp(networks[index].name, network_name))) index++;

	return networks[index].code ? networks[index].code : _("undefined");
}

GNOKII_API char *gn_country_name_translate(char *country_name)
{
	/*
	 * Retrieve the translation of the given @country_name
	 * if the iso-codes package is installed and NLS is enabled.
	 *
	 * Use this function only with gn_country_get() because
	 * gn_country_name_get() and gn_network2country() alreadly
	 * return translated names.
	 */
	return dgettext("iso_3166", country_name);
}

GNOKII_API char *gn_country_name_get(char *country_code)
{
	int index = 0;

	while (countries[index].code &&
	       strncmp(countries[index].code, country_code, 3)) index++;

	return countries[index].name ? gn_country_name_translate(countries[index].name) : _("unknown");
}

GNOKII_API char *gn_country_code_get(char *country_name)
{
	/* 
	 * If the iso-codes package is installed and NLS is enabled
	 * @country_name must be given in the current language.
	 */
	int index = 0;

	while (countries[index].name &&
	       strcasecmp(gn_country_name_translate(countries[index].name), country_name)) index++;

	return countries[index].code ? countries[index].code : _("undefined");
}

GNOKII_API int gn_network_get(gn_network *network, int index)
{
	if (index < 0 || index >= ARRAY_LEN(networks) - 1)
		return false;
	*network = networks[index];
	return true;
}

GNOKII_API int gn_country_get(gn_country *country, int index)
{
	if (index < 0 || index >= ARRAY_LEN(countries) - 1)
		return false;
	*country = countries[index];
	return true;
}

GNOKII_API char *gn_network2country(char *network_code)
{
	char ccode[4];
	
	snprintf(ccode, sizeof(ccode), "%s", network_code);

	return gn_country_name_get(ccode);
}
