/*

  G N O K I I

  A Linux/Unix toolset and driver for Nokia mobile phones.

  Copyright (C) 1999 Hugh Blemings & Pavel Jank ml.

  Released under the terms of the GNU GPL, see file COPYING for more details.

  Last modification: Wed Dec 15 00:17:17 MET 1999
  Modified by Marcel Holtmann <marcel@rvs.uni-bielefeld.de>

*/

#include "unixserial.h"
#include "device.h"

#define TEKRAM_B115200 0x00
#define TEKRAM_B57600  0x01
#define TEKRAM_B38400  0x02
#define TEKRAM_B19200  0x03
#define TEKRAM_B9600   0x04

#define TEKRAM_PW     0x10 /* Pulse select bit */


/*
 * Structure to store the filedescriptor we use.
 *
 */

int device_portfd = -1;

int device_getfd(void) {

  return device_portfd;
}

int device_open(__const char *__file) {

  device_portfd = serial_opendevice(__file);

  return (device_portfd >= 0);
}

void device_close(void) {

  serial_setdtrrts(device_portfd, 0, 0);

  serial_close(device_portfd);
}

void device_reset(void) {

  serial_setdtrrts(device_portfd, 0, 0);

  usleep(50000);

  serial_setdtrrts(device_portfd, 1, 0);

  usleep(1000);

  serial_setdtrrts(device_portfd, 1, 1);

  usleep(50);


  serial_changespeed(device_portfd, 9600);
}

void device_setdtrrts(int __dtr, int __rts) {

  serial_setdtrrts(device_portfd, __dtr, __rts);
}

void device_changespeed(int __speed) {

  unsigned char speedbyte;


  switch (__speed) {

  default:
  case 9600:   speedbyte = TEKRAM_PW | TEKRAM_B9600;   break;
  case 19200:  speedbyte = TEKRAM_PW | TEKRAM_B19200;  break;
  case 38400:  speedbyte = TEKRAM_PW | TEKRAM_B38400;  break;
  case 57600:  speedbyte = TEKRAM_PW | TEKRAM_B57600;  break;
  case 115200: speedbyte = TEKRAM_PW | TEKRAM_B115200; break;

  }


  device_reset();

  serial_setdtrrts(device_portfd, 1, 0);

  usleep(7);

  serial_write(device_portfd, &speedbyte, 1);

  usleep(100000);

  serial_setdtrrts(device_portfd, 1, 1);


  serial_changespeed(device_portfd, __speed);
}

size_t device_read(__ptr_t __buf, size_t __nbytes) {

  return (serial_read(device_portfd, __buf, __nbytes));
}

size_t device_write(__const __ptr_t __buf, size_t __n) {

  return (serial_write(device_portfd, __buf, __n));
}
