/*
 * GNoise
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gnoise.h,v 1.16 2002/01/13 02:51:16 dengen Exp $
 *
 */

#ifndef _GNOISE_H
#define _GNOISE_H

#include "config.h"
#include <gtk/gtk.h>
#include <pthread.h>
#include <stddef.h>
#include <sys/types.h>

#ifdef ENABLE_GNOME
#  include <gnome.h>
#  include "gui-gnome.h"
#  include "gui-gnome-support.h"
#else
#  include "gui-gtk.h"
#  include "gui-gtk-support.h"
#endif

typedef gint8			chnl_indx;
typedef gint32			smpl_indx;
typedef struct _cmd		cmd_t;
typedef struct _snd_info	snd_info_t;
typedef struct _prefs		prefs_t;
typedef struct _prefs_sym	prefs_sym_t;

#ifndef NULL
#define NULL  ((void *)0)
#endif
#ifndef FALSE
#define FALSE (0)
#endif
#ifndef TRUE
#define TRUE  (1)
#endif


#define ZOOM_LEVELS	16	/* 1:1,2,4,8,16,32,64,128,...,32768 */
#define ZOOM_CACHE	512	/* first zoom level to cache, 1:512 */
#define CHANNEL_ALL	-1	/* a chnl_indx */
#define MAX_CHANNELS	4	// how many audio channels we handle
#define MAX_CMD_QUEUE	150


typedef enum
{
    CMD_ADJUST_ZOOM,
    CMD_DISPLAY_UPDATE,
    CMD_PLAY_POSITION_UPDATE,
    CMD_PROGRESS_BAR_UPDATE,
    CMD_WIDGET_SHOW,
    CMD_WIDGET_HIDE,
    CMD_REAP_LOAD_THREAD,
    CMD_REAP_PLAY_THREAD,
    CMD_REAP_RECORD_THREAD,
    CMD_REAP_EDIT_THREAD,
    CMD_SELECTION_DIALOG_UPDATE,
    CMD_STATUS_UPDATE,
} cmd_enum_t;

struct _cmd
{
    cmd_enum_t	cmd;
    void	*data;
};

struct _snd_info
{
    chnl_indx	channels;
    smpl_indx	samples;
    uint	sample_rate;
    uint	sample_bits;
};

typedef enum
{
    SMPL_FMT_PREFS,
    SMPL_FMT_SAMPLES,
    SMPL_FMT_BYTES,
    SMPL_FMT_SMART_SIZE,
    SMPL_FMT_CDSECTORS,
    SMPL_FMT_HHMMSS_SSS,
    SMPL_FMT_HHMMSS,
    SMPL_FMT_LAST,
} smpl_fmt_enum_t;
#define SMPL_FMT_MAX 30

struct _prefs
{
    snd_info_t		record;
    smpl_fmt_enum_t	display_fmt;
    gboolean		dcache_save;
    gboolean		playback_tracked;
    gboolean		playback_scrolled;
    gboolean		selection_bond;
    gboolean		show_time;
    gboolean		disable_undo;
    gboolean		remember_open_dir;
    gboolean		tb_transport;
    gboolean		tb_markers;
};

typedef enum
{
    LOOP_NONE,
    LOOP_SELECTION,
    LOOP_FILE,
} loop_t;

extern struct _GtkWaveSet	*ws;
extern gboolean			progress_cancel;
extern loop_t			playing_looped;
extern gboolean			playing;
extern gboolean			playing_stop;
extern gboolean			recording;
extern gboolean			recording_stop;
extern gboolean			file_open;
extern GtkWidget		*win_levels;
extern pthread_t		edit_thread;
extern pthread_t		record_thread;
extern guint8			lpeak;
extern guint8			rpeak;
extern gboolean			lclip;
extern gboolean			rclip;
extern prefs_t			prefs;
extern gboolean			scrolling;


/* service routines in gnoise.c */
void	 log			(const char *head, const char *fmt,...);
void	 status			(const char *fmt,...);
void     sample_fmt		(smpl_fmt_enum_t fmt, smpl_indx sample,
				 snd_info_t *si, char *buf, int bufsize);
void	 queue_cmd		(cmd_enum_t cmd_arg, void *data);
void	 set_time		(smpl_indx time);

/* prototypes from modules other than gnoise.c */
void	 dlgselection_update	(struct _GtkWaveSet *ws);
void	 dlglevels_update	(void);
gboolean prefs_load		(void);
gboolean prefs_save		(void);


/* 
 * gui callbacks
 */

/* menu items */
void	 on_new_file			(GtkMenuItem *, gpointer);
void	 on_open			(GtkMenuItem *, gpointer);
void	 on_save			(GtkMenuItem *, gpointer);
void	 on_close			(GtkMenuItem *, gpointer);
void	 on_properties			(GtkMenuItem *, gpointer);
void	 on_quit			(GtkMenuItem *, gpointer);

void	 on_cut				(GtkMenuItem *, gpointer);
void	 on_copy			(GtkMenuItem *, gpointer);
void	 on_paste			(GtkMenuItem *, gpointer);
void	 on_select_all			(GtkMenuItem *, gpointer);
void	 on_undo			(GtkMenuItem *, gpointer);
void	 on_dlgmarkers			(GtkMenuItem *, gpointer);
void	 on_dlgselection		(GtkMenuItem *, gpointer);
void	 on_save_selection_as		(GtkMenuItem *, gpointer);

void	 on_toolbars			(GtkMenuItem *, gpointer);
void	 on_zoom_in			(GtkMenuItem *, gpointer);
void	 on_zoom_out			(GtkMenuItem *, gpointer);
void	 on_zoom_out_full		(GtkMenuItem *, gpointer);
void	 on_dlglevels			(GtkMenuItem *, gpointer);
void	 on_dlgundo			(GtkMenuItem *, gpointer);

void	 on_mute			(GtkMenuItem *, gpointer);
void	 on_fade_in			(GtkMenuItem *, gpointer);
void	 on_fade_out			(GtkMenuItem *, gpointer);
void	 on_insert_silence		(GtkMenuItem *, gpointer);
void	 on_interpolate			(GtkMenuItem *, gpointer);
void	 on_reverse			(GtkMenuItem *, gpointer);
void	 on_normalize			(GtkMenuItem *, gpointer);

void	 on_aboutladspa			(GtkMenuItem *, gpointer);
void	 on_ladsparescan		(GtkMenuItem *, gpointer);

void	 on_dlgprefs			(GtkMenuItem *, gpointer);

void	 on_about			(GtkMenuItem *, gpointer);

/* main window items */
void	 on_playlinebegin		(GtkButton *, gpointer);
void	 on_playlineend			(GtkButton *, gpointer);
void	 on_stop			(GtkButton *, gpointer);
void	 on_play			(GtkButton *, gpointer);
void	 on_playlooped			(GtkButton *, gpointer);
void	 on_record			(GtkButton *, gpointer);
void	 on_zoom			(GtkButton *, gpointer);
void	 on_zoom_selection		(GtkButton *, gpointer);
void	 on_cancel			(GtkButton *, gpointer);


/* dialogs */
gboolean on_dlgselection_destroy	(GtkWidget *, GdkEvent *, gpointer);
void	 on_dlgselection_set		(GtkButton *, gpointer);
void	 on_dlgselection_close		(GtkButton *, gpointer);

gboolean on_dlglevels_destroy		(GtkWidget *, GdkEvent *, gpointer);

gboolean on_dlgundo_destroy		(GtkWidget *, GdkEvent *, gpointer);
void	 on_dlgundo_through		(GtkButton *, gpointer);
void	 on_dlgundo_close		(GtkButton *, gpointer);


gboolean on_dlgrecord_destroy		(GtkWidget *, GdkEvent *, gpointer);
void	 on_dlgrecord_browse		(GtkButton *, gpointer);
void	 on_dlgrecord_record		(GtkButton *, gpointer);
void	 on_dlgrecord_close		(GtkButton *, gpointer);
void	 on_dlgrecord_stop		(GtkButton *, gpointer);
gboolean dlgrecord			(char *);
void	 dlgrecord_update_levels	(void);

void	 on_dlgprefs_save		(GtkButton *, gpointer);
void	 on_dlgprefs_apply		(GtkButton *, gpointer);
void	 on_dlgprefs_close		(GtkButton *, gpointer);


gboolean on_dlgproperties_destroy	(GtkWidget *, GdkEvent *, gpointer);
gboolean on_dlgmarkers_destroy		(GtkWidget *, GdkEvent *, gpointer);

void	 on_markernew			(GtkButton *, gpointer);
void	 on_markerdel			(GtkButton *, gpointer);
void	 on_markernext			(GtkButton *, gpointer);
void	 on_markerprev			(GtkButton *, gpointer);


/* the only reason these are prototyped here *and* in the gtkwave*.h file is
 * since gui.c pulls us in, it will see prototypes and the compiler won't
 * complain
 */
GtkWidget  *gtk_wave_set_new (void);
GtkWidget  *gtk_levels_new   (void);

#endif /* _GNOISE_H */
