#ifndef TOOL_H
#define TOOL_H

#include "ui-types.h"

GNOFIN_API_BEGIN

typedef struct _Tool          Tool;
typedef struct _ToolFunctions ToolFunctions;

struct _ToolFunctions
{
  void (* init)    (gpointer private_data);
  void (* cleanup) (gpointer private_data);
  void (* run)     (gpointer private_data, UI *);
};

struct _Tool
{
  const gchar  *name;          /* name of tool */
  const gchar  *label;	       /* appears in menu (eg. "_Find...") */
  const gchar  *description;   /* appears in status bar */
  ToolFunctions funcs;
  gpointer      private_data;  /* the author of the tool may set this */
};

/* Called to register/unregister a tool */
gboolean tool_register   (Tool *tool); /* assumes reference (ie. tool must not be stack based) */
void     tool_unregister (Tool *tool);

/* Called to get the list of tools */
GSList  *tools_get       (guint *stamp); /* return by reference */
gboolean tools_changed   (guint stamp);

static inline void
tool_run (Tool *tool, UI *ui)
{
  if (tool && tool->funcs.run)
    tool->funcs.run (tool->private_data, ui);
}

GNOFIN_API_END

#endif
