/******************************************************************************\
 gnofin/row-color.h   $Revision: 1.1 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef ROW_COLOR_H
#define ROW_COLOR_H

#include <gdk/gdktypes.h>
#include "notification-list.h"

GNOFIN_API_BEGIN

GdkColor *row_color_bright_fg (void);
GdkColor *row_color_bright_bg (void);
GdkColor *row_color_dark_fg (void);
GdkColor *row_color_dark_bg (void);

void row_color_set (const GdkColor *dark_fg,
		    const GdkColor *dark_bg,
		    const GdkColor *bright_fg,
		    const GdkColor *bright_bg);
void row_color_get (GdkColor *dark_fg,
		    GdkColor *dark_bg,
		    GdkColor *bright_fg,
		    GdkColor *bright_bg);

/* Those interested in changes to the row color can attach to
 * this notification list. */
extern NotificationList row_color_change_listeners;

GNOFIN_API_END

#endif
