/******************************************************************************\
 gnofin/file-utils.c   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "file-utils.h"


/******************************************************************************
 * File utilities
 */

gboolean
file_exists (const gchar *path)
{
  struct stat buf;

  trace ("");
  g_return_val_if_fail (path, FALSE);

  return stat (path, &buf) == 0;
}

gboolean
file_backup (const gchar *path)
{
  gchar *buf;
  gint result;

  trace ("");
  g_return_val_if_fail (path, FALSE);

  buf = g_strdup_printf ("cp -f %s %s~", path, path);
  result = system (buf);
  g_free (buf);

  return result == 0;
}

gchar *
file_get_directory (const gchar *path)
{
  gchar *dir;
  gint n;

  trace ("");
  g_return_val_if_fail (path, NULL);

  /* Extract just the directory portion including the '/' character at
   * the end */
  n = strlen (path) - strlen (g_basename (path));
  dir = g_new (gchar, n + 1);
  strncpy (dir, path, n);
  dir[n] = '\0';
  return dir;
}
