/******************************************************************************\
 gnofin/record-type.h   $Revision: 1.5 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef RECORD_TYPE_H
#define RECORD_TYPE_H

#include "bankbook.h"

struct _RecordType
{
  guint     ref_count;
  guint     usage_count;  /* how many attached records use this type */
  Bankbook *parent;
  gchar    *name;
  gchar    *description;
  guint     numbered : 1;
  guint     linked   : 1;
  guint     sign     : 2;
};

RecordType *get_record_type_by_name    (const GList *types, const gchar *name);

guint       record_type_info_copy      (RecordTypeInfo *dest, const RecordTypeInfo *src, guint mask);
void        record_type_info_clear     (RecordTypeInfo *, guint mask);
gboolean    record_type_info_diff      (const RecordTypeInfo *, const RecordTypeInfo *, guint mask);

RecordType *record_type_new            (void);
void        record_type_ref            (RecordType *);
void        record_type_unref          (RecordType *);
void        record_type_destroy        (RecordType *);
RecordType *record_type_copy           (const RecordType *);
RecordType *record_type_copy_and_unref (RecordType *);
RecordType *record_type_attach         (RecordType *, Bankbook *parent);
void        record_type_detach         (RecordType *);
gboolean    record_type_set_info       (RecordType *, guint mask, const RecordTypeInfo *);
void        record_type_get_info       (const RecordType *, guint mask, RecordTypeInfo *);
gint        record_type_index          (const RecordType *);
void        record_type_dump           (const RecordType *);

#endif
