/*
 * properties.c - gnews properties dialog and functions
 * Copyright 2000-2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <gnome.h>

#include "properties.h"
#include "../include/gnewslib.h"
#include "gnews.h"
#include "plugins.h"

GtkWidget *propwindow = NULL;

GtkWidget *prop_lay_spin_width;
GtkWidget *prop_lay_spin_scroll;
GtkWidget *prop_lay_spin_upd;
GtkWidget *prop_lay_border;

GtkWidget *prop_beha_title_check;
GtkWidget *prop_beha_hints_check;
GtkWidget *prop_beha_sound_check;
GtkWidget *prop_beha_seppix_check;
GtkWidget *prop_beha_sepown_check;
GtkWidget *prop_beha_color_check;

GtkWidget *prop_beha_scroll_radio1;
GtkWidget *prop_beha_scroll_radio2;
GtkWidget *prop_beha_scroll_spin;

GtkWidget *prop_http_label_proxy;
GtkWidget *prop_http_entry_requestednews;
GtkWidget *prop_http_label_proxyurl;
GtkWidget *prop_http_label_proxyuser;
GtkWidget *prop_http_label_proxypasswd;
GtkWidget *prop_http_entry_proxyurl;
GtkWidget *prop_http_entry_proxyuser;
GtkWidget *prop_http_entry_proxypasswd;

GtkWidget *prop_news_clist_selected;
GtkWidget *prop_news_button_add;
GtkWidget *prop_news_button_prop;
GtkWidget *prop_news_ctree_available;

gint stype1 = 1, stype2 = 2;

gint selrow2;
ctreedata *selrowsite;

static void
prop_changed_refr (GtkWidget * widget, gint * data)
{
  refreshneeded = 1;
  gnome_property_box_changed (GNOME_PROPERTY_BOX (propwindow));
  return;
}

static void
scrolltype_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  gint *stype;

  stype = gtk_object_get_data (GTK_OBJECT (togglebutton), "scrolltype");
  switch (*stype) {
  case 1:
    gtk_widget_set_sensitive (GTK_WIDGET (user_data), FALSE);
    break;
  case 2:
    gtk_widget_set_sensitive (GTK_WIDGET (user_data), TRUE);
    break;
  }
  prop_changed_refr (NULL, NULL);
}

static void
titles_toggled (GtkWidget * widget, gint * data)
{
  config_show_titles = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (prop_beha_title_check));
  prop_changed_refr (NULL, NULL);
  return;
}

static void
hints_toggled (GtkWidget * widget, gint * data)
{
  config_show_hints = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (prop_beha_hints_check));
  prop_changed_refr (NULL, NULL);
  return;
}

static void
sound_toggled (GtkWidget * widget, gint * data)
{
  config_play_sound = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (prop_beha_sound_check));
  prop_changed_refr (NULL, NULL);
  return;
}

static void
seppix_toggled (GtkWidget * widget, gint * data)
{
  config_separator_pixmap = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (prop_beha_seppix_check));
//  gtk_widget_set_sensitive (prop_beha_sepown_check, config_separator_pixmap);
  prop_changed_refr (NULL, NULL);
  return;
}

static void
sepown_toggled (GtkWidget * widget, gint * data)
{
  config_separator_own = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (prop_beha_sepown_check));
  prop_changed_refr (NULL, NULL);
  return;
}

static void
color_toggled (GtkWidget * widget, gint * data)
{
  config_unique_colors = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (prop_beha_color_check));
  prop_changed_refr (NULL, NULL);
  return;
}

static void
proxy_toggled (GtkWidget * widget, gint * data)
{
  config_use_proxy = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (prop_http_label_proxy));
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_label_proxyurl), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_label_proxyuser), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_label_proxypasswd), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_entry_proxyurl), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_entry_proxyuser), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_entry_proxypasswd), config_use_proxy);
  prop_changed_refr (NULL, NULL);
  return;
}

static void
prop_changed (GtkWidget * widget, gint * data)
{
  gint *ft;
  if (data != NULL) {
    ft = gtk_object_get_data (GTK_OBJECT (data), "menuindex");
    config_frametype = *ft;
  }
  gnome_property_box_changed (GNOME_PROPERTY_BOX (propwindow));
  return;
}

static void
add_site (GtkButton * button, gpointer user_data)
{
  gint appended;

  if (selrowsite != NULL) {
    if (gtk_clist_find_row_from_data (GTK_CLIST (prop_news_clist_selected), selrowsite->data) == -1) {
      appended = gtk_clist_append (GTK_CLIST (prop_news_clist_selected), &selrowsite->name);
      gtk_clist_set_row_data (GTK_CLIST (prop_news_clist_selected), appended, selrowsite->data);
      requesteddb++;
      selrow2 = -1;
      gtk_clist_unselect_all (GTK_CLIST (prop_news_clist_selected));
      refreshneeded = 1;
      gnome_property_box_changed (GNOME_PROPERTY_BOX (propwindow));
    }
  }
}

static void
plugin_properties (GtkButton * button, gpointer user_data)
{
}

static void
up_site (GtkButton * button, gpointer user_data)
{
  if ((selrow2 != -1) && (selrow2 > 0)) {
    gtk_clist_row_move (GTK_CLIST (prop_news_clist_selected), selrow2, selrow2 - 1);
    selrow2 = -1;
    gtk_clist_unselect_all (GTK_CLIST (prop_news_clist_selected));
    refreshneeded = 1;
    gnome_property_box_changed (GNOME_PROPERTY_BOX (propwindow));
  }
}

static void
down_site (GtkButton * button, gpointer user_data)
{
  if ((selrow2 != -1) && (selrow2 < requesteddb - 1)) {
    gtk_clist_row_move (GTK_CLIST (prop_news_clist_selected), selrow2, selrow2 + 1);
    selrow2 = -1;
    gtk_clist_unselect_all (GTK_CLIST (prop_news_clist_selected));
    refreshneeded = 1;
    gnome_property_box_changed (GNOME_PROPERTY_BOX (propwindow));
  }
}

static void
delete_site (GtkButton * button, gpointer user_data)
{
  if (selrow2 != -1) {
    gtk_clist_row_move (GTK_CLIST (prop_news_clist_selected), selrow2, requesteddb - 1);
    gtk_clist_remove (GTK_CLIST (prop_news_clist_selected), requesteddb - 1);
    selrow2 = -1;
    requesteddb--;
    refreshneeded = 1;
    gnome_property_box_changed (GNOME_PROPERTY_BOX (propwindow));
  }
}

static void
selectrow_available_tree (GtkCTree * ctree, GList * node, gint column, gpointer user_data)
{
  ctreedata *ctd;
  plugindef *pd;

  ctd = gtk_ctree_node_get_row_data (GTK_CTREE (ctree), GTK_CTREE_NODE (node));
  if (ctd->data == NULL) {
    selrowsite = NULL;
    gtk_label_set_text (GTK_LABEL (user_data), NULL);
    gtk_widget_set_sensitive (prop_news_button_add, FALSE);
    gtk_widget_set_sensitive (prop_news_button_prop, FALSE);
  } else {
    selrowsite = ctd;
    pd = ctd->data;
    gtk_label_set_text (GTK_LABEL (user_data), g_module_name (pd->module));
    gtk_widget_set_sensitive (prop_news_button_add, TRUE);
    gtk_widget_set_sensitive (prop_news_button_prop, TRUE);
  }
}

static void
unselectrow_available_tree (GtkCTree * ctree, GList * node, gint column, gpointer user_data)
{
  selrowsite = NULL;
  gtk_label_set_text (GTK_LABEL (user_data), NULL);
  gtk_widget_set_sensitive (prop_news_button_add, FALSE);
  gtk_widget_set_sensitive (prop_news_button_prop, FALSE);
}

static void
selectrow_selected (GtkCList * clist, gint row, gint column, GdkEvent * event, gpointer user_data)
{
  selrow2 = row;
}

static void
unselectrow_selected (GtkCList * clist, gint row, gint column, GdkEvent * event, gpointer user_data)
{
  selrow2 = -1;
}

void
properties_layout_create (void)
{
  GtkWidget *tablabel;

  GtkWidget *prop_lay_hbox1;
  GtkWidget *prop_lay_vbox1;
  GtkWidget *prop_lay_label_width;
  GtkWidget *prop_lay_label_scroll;
  GtkWidget *prop_lay_vbox2;
  GtkWidget *prop_lay_hbox2;
  GtkObject *prop_lay_spin_width_adj;
  GtkWidget *prop_lay_label_spin_width;
  GtkWidget *prop_lay_hbox3;
  GtkObject *prop_lay_spin_scroll_adj;
  GtkWidget *prop_lay_label_spin_scroll;
  GtkWidget *prop_lay_label_border;
  GtkWidget *prop_lay_border_menu;
  GtkWidget *prop_lay_hbox4;
  GtkObject *prop_lay_spin_upd_adj;
  GtkWidget *prop_lay_label_upd;
  GtkWidget *glade_menuitem;

  gint *menuid;

  prop_lay_hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (prop_lay_hbox1);
  gtk_container_set_border_width (GTK_CONTAINER (prop_lay_hbox1), 4);

  prop_lay_vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (prop_lay_vbox1);
  gtk_box_pack_start (GTK_BOX (prop_lay_hbox1), prop_lay_vbox1, TRUE, TRUE, 0);

  prop_lay_label_width = gtk_label_new (_("Applet width:"));
  gtk_widget_show (prop_lay_label_width);
  gtk_box_pack_start (GTK_BOX (prop_lay_vbox1), prop_lay_label_width, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (prop_lay_label_width), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_lay_label_width), 0.01, 0.5);
  gtk_misc_set_padding (GTK_MISC (prop_lay_label_width), 0, 4);

  prop_lay_label_scroll = gtk_label_new (_("Scroll timeout:"));
  gtk_widget_show (prop_lay_label_scroll);
  gtk_box_pack_start (GTK_BOX (prop_lay_vbox1), prop_lay_label_scroll, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (prop_lay_label_scroll), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_lay_label_scroll), 0.01, 0.5);
  gtk_misc_set_padding (GTK_MISC (prop_lay_label_scroll), 0, 4);

  prop_lay_label_upd = gtk_label_new (_("Update timeout:"));
  gtk_widget_show (prop_lay_label_upd);
  gtk_box_pack_start (GTK_BOX (prop_lay_vbox1), prop_lay_label_upd, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (prop_lay_label_upd), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_lay_label_upd), 0.01, 0.5);
  gtk_misc_set_padding (GTK_MISC (prop_lay_label_upd), 0, 4);

  prop_lay_label_border = gtk_label_new (_("Border:"));
  gtk_widget_show (prop_lay_label_border);
  gtk_box_pack_start (GTK_BOX (prop_lay_vbox1), prop_lay_label_border, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (prop_lay_label_border), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_lay_label_border), 0.01, 0.5);
  gtk_misc_set_padding (GTK_MISC (prop_lay_label_border), 0, 4);

  prop_lay_vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (prop_lay_vbox2);
  gtk_box_pack_start (GTK_BOX (prop_lay_hbox1), prop_lay_vbox2, TRUE, TRUE, 0);

  prop_lay_hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (prop_lay_hbox2);
  gtk_box_pack_start (GTK_BOX (prop_lay_vbox2), prop_lay_hbox2, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (prop_lay_hbox2), 2);

  prop_lay_spin_width_adj = gtk_adjustment_new (config_width, 48, 1280, 1, 20, 20);
  prop_lay_spin_width = gtk_spin_button_new (GTK_ADJUSTMENT (prop_lay_spin_width_adj), 1, 0);
  gtk_widget_show (prop_lay_spin_width);
  gtk_box_pack_start (GTK_BOX (prop_lay_hbox2), prop_lay_spin_width, FALSE, TRUE, 0);
  gtk_widget_set_usize (prop_lay_spin_width, 60, -2);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (prop_lay_spin_width), GTK_UPDATE_IF_VALID);

  prop_lay_label_spin_width = gtk_label_new (_("pixels"));
  gtk_widget_show (prop_lay_label_spin_width);
  gtk_box_pack_start (GTK_BOX (prop_lay_hbox2), prop_lay_label_spin_width, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (prop_lay_label_spin_width), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_lay_label_spin_width), 0.01, 0.5);
  gtk_misc_set_padding (GTK_MISC (prop_lay_label_spin_width), 4, 0);

  prop_lay_hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (prop_lay_hbox3);
  gtk_box_pack_start (GTK_BOX (prop_lay_vbox2), prop_lay_hbox3, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (prop_lay_hbox3), 2);

  prop_lay_spin_scroll_adj = gtk_adjustment_new (config_scrolltimeout, 10, 2000, 1, 20, 20);
  prop_lay_spin_scroll = gtk_spin_button_new (GTK_ADJUSTMENT (prop_lay_spin_scroll_adj), 1, 0);
  gtk_widget_show (prop_lay_spin_scroll);
  gtk_box_pack_start (GTK_BOX (prop_lay_hbox3), prop_lay_spin_scroll, FALSE, TRUE, 0);
  gtk_widget_set_usize (prop_lay_spin_scroll, 60, -2);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (prop_lay_spin_scroll), GTK_UPDATE_IF_VALID);

  prop_lay_label_spin_scroll = gtk_label_new (_("msec"));
  gtk_widget_show (prop_lay_label_spin_scroll);
  gtk_box_pack_start (GTK_BOX (prop_lay_hbox3), prop_lay_label_spin_scroll, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (prop_lay_label_spin_scroll), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_lay_label_spin_scroll), 0.01, 0.5);
  gtk_misc_set_padding (GTK_MISC (prop_lay_label_spin_scroll), 4, 0);

  prop_lay_hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (prop_lay_hbox4);
  gtk_box_pack_start (GTK_BOX (prop_lay_vbox2), prop_lay_hbox4, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (prop_lay_hbox4), 2);

  prop_lay_spin_upd_adj = gtk_adjustment_new (config_refreshtimeout, 15, 60, 1, 20, 20);
  prop_lay_spin_upd = gtk_spin_button_new (GTK_ADJUSTMENT (prop_lay_spin_upd_adj), 1, 0);
  gtk_widget_show (prop_lay_spin_upd);
  gtk_box_pack_start (GTK_BOX (prop_lay_hbox4), prop_lay_spin_upd, FALSE, TRUE, 0);
  gtk_widget_set_usize (prop_lay_spin_upd, 60, -2);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (prop_lay_spin_upd), GTK_UPDATE_IF_VALID);

  prop_lay_label_spin_scroll = gtk_label_new (_("min"));
  gtk_widget_show (prop_lay_label_spin_scroll);
  gtk_box_pack_start (GTK_BOX (prop_lay_hbox4), prop_lay_label_spin_scroll, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (prop_lay_label_spin_scroll), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_lay_label_spin_scroll), 0.01, 0.5);
  gtk_misc_set_padding (GTK_MISC (prop_lay_label_spin_scroll), 4, 0);

  prop_lay_border = gtk_option_menu_new ();
  gtk_widget_show (prop_lay_border);
  gtk_box_pack_start (GTK_BOX (prop_lay_vbox2), prop_lay_border, FALSE, FALSE, 0);
  gtk_widget_set_usize (prop_lay_border, 80, -2);

  prop_lay_border_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("None"));
  menuid = g_malloc (sizeof (gint));
  *menuid = 0;
  gtk_object_set_data (GTK_OBJECT (glade_menuitem), "menuindex", menuid);
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (prop_lay_border_menu), glade_menuitem);
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate", GTK_SIGNAL_FUNC (prop_changed),
		      glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("In"));
  menuid = g_malloc (sizeof (gint));
  *menuid = 1;
  gtk_object_set_data (GTK_OBJECT (glade_menuitem), "menuindex", menuid);
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (prop_lay_border_menu), glade_menuitem);
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate", GTK_SIGNAL_FUNC (prop_changed),
		      glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Out"));
  menuid = g_malloc (sizeof (gint));
  *menuid = 2;
  gtk_object_set_data (GTK_OBJECT (glade_menuitem), "menuindex", menuid);
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (prop_lay_border_menu), glade_menuitem);
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate", GTK_SIGNAL_FUNC (prop_changed),
		      glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Etched In"));
  menuid = g_malloc (sizeof (gint));
  *menuid = 3;
  gtk_object_set_data (GTK_OBJECT (glade_menuitem), "menuindex", menuid);
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (prop_lay_border_menu), glade_menuitem);
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate", GTK_SIGNAL_FUNC (prop_changed),
		      glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Etched Out"));
  menuid = g_malloc (sizeof (gint));
  *menuid = 4;
  gtk_object_set_data (GTK_OBJECT (glade_menuitem), "menuindex", menuid);
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (prop_lay_border_menu), glade_menuitem);
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate", GTK_SIGNAL_FUNC (prop_changed),
		      glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (prop_lay_border), prop_lay_border_menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (prop_lay_border), config_frametype);

  gtk_signal_connect (GTK_OBJECT (prop_lay_spin_width), "changed", GTK_SIGNAL_FUNC (prop_changed), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_lay_spin_scroll), "changed", GTK_SIGNAL_FUNC (prop_changed), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_lay_spin_upd), "changed", GTK_SIGNAL_FUNC (prop_changed), NULL);

  tablabel = gtk_label_new (_("Layout"));
  gnome_property_box_append_page (GNOME_PROPERTY_BOX (propwindow), prop_lay_hbox1, tablabel);
}

void
properties_behaviour_create (void)
{
  GtkWidget *tablabel;

  GtkWidget *prop_beha_hbox1;
  GtkWidget *prop_beha_frame_scroll;
  GtkWidget *prop_beha_vbox1;
  GtkWidget *prop_beha_scroll_label1;
  GtkWidget *prop_beha_scroll_label2;
  GSList *prop_beha_scroll_group = NULL;
  GtkWidget *prop_beha_hbox2;
  GtkObject *prop_beha_scroll_spin_adj;
  GtkWidget *prop_beha_frame_other;
  GtkWidget *prop_beha_vbox2;

  prop_beha_hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (prop_beha_hbox1);
  gtk_container_set_border_width (GTK_CONTAINER (prop_beha_hbox1), 4);

  prop_beha_frame_scroll = gtk_frame_new (_("Scrolling"));
  gtk_widget_show (prop_beha_frame_scroll);
  gtk_container_set_border_width (GTK_CONTAINER (prop_beha_frame_scroll), 2);
  gtk_box_pack_start (GTK_BOX (prop_beha_hbox1), prop_beha_frame_scroll, FALSE, FALSE, 0);

  prop_beha_vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (prop_beha_vbox1);
  gtk_container_add (GTK_CONTAINER (prop_beha_frame_scroll), prop_beha_vbox1);

  prop_beha_scroll_radio1 = gtk_radio_button_new_with_label (prop_beha_scroll_group, _("Continous"));
  prop_beha_scroll_group = gtk_radio_button_group (GTK_RADIO_BUTTON (prop_beha_scroll_radio1));
  gtk_object_set_data (GTK_OBJECT (prop_beha_scroll_radio1), "scrolltype", &stype1);
  gtk_widget_show (prop_beha_scroll_radio1);
  gtk_box_pack_start (GTK_BOX (prop_beha_vbox1), prop_beha_scroll_radio1, FALSE, FALSE, 0);

  prop_beha_scroll_radio2 = gtk_radio_button_new_with_label (prop_beha_scroll_group, _("Pong"));
  prop_beha_scroll_group = gtk_radio_button_group (GTK_RADIO_BUTTON (prop_beha_scroll_radio2));
  gtk_object_set_data (GTK_OBJECT (prop_beha_scroll_radio2), "scrolltype", &stype2);
  gtk_widget_show (prop_beha_scroll_radio2);
  gtk_box_pack_start (GTK_BOX (prop_beha_vbox1), prop_beha_scroll_radio2, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prop_beha_scroll_radio2), TRUE);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(config_scrolltype == 1 ? prop_beha_scroll_radio1 : prop_beha_scroll_radio2),
				TRUE);

  prop_beha_hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (prop_beha_hbox2);
  gtk_box_pack_start (GTK_BOX (prop_beha_vbox1), prop_beha_hbox2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (prop_beha_hbox2), 2);

  prop_beha_scroll_label1 = gtk_label_new (_("delay"));
  gtk_widget_show (prop_beha_scroll_label1);
  gtk_box_pack_start (GTK_BOX (prop_beha_hbox2), prop_beha_scroll_label1, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (prop_beha_scroll_label1), 4, 0);

  prop_beha_scroll_spin_adj = gtk_adjustment_new (config_edgewait, 0, 60, 1, 10, 10);
  prop_beha_scroll_spin = gtk_spin_button_new (GTK_ADJUSTMENT (prop_beha_scroll_spin_adj), 1, 0);
  gtk_widget_show (prop_beha_scroll_spin);
  gtk_box_pack_start (GTK_BOX (prop_beha_hbox2), prop_beha_scroll_spin, FALSE, TRUE, 0);

  prop_beha_scroll_label2 = gtk_label_new (_("time units at the edges"));
  gtk_widget_show (prop_beha_scroll_label2);
  gtk_box_pack_start (GTK_BOX (prop_beha_hbox2), prop_beha_scroll_label2, FALSE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (prop_beha_scroll_label2), 4, 0);

  gtk_widget_set_sensitive (GTK_WIDGET (prop_beha_hbox2), (config_scrolltype == 2));

  prop_beha_frame_other = gtk_frame_new (_("Other"));
  gtk_widget_show (prop_beha_frame_other);
  gtk_container_set_border_width (GTK_CONTAINER (prop_beha_frame_other), 2);
  gtk_box_pack_start (GTK_BOX (prop_beha_hbox1), prop_beha_frame_other, TRUE, TRUE, 0);

  prop_beha_vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (prop_beha_vbox2);
  gtk_container_add (GTK_CONTAINER (prop_beha_frame_other), prop_beha_vbox2);

  prop_beha_title_check = gtk_check_button_new_with_label (_("Always show titles"));
  gtk_widget_show (prop_beha_title_check);
  gtk_box_pack_start (GTK_BOX (prop_beha_vbox2), prop_beha_title_check, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prop_beha_title_check), config_show_titles);

  prop_beha_hints_check = gtk_check_button_new_with_label (_("Always show hints"));
  gtk_widget_show (prop_beha_hints_check);
  gtk_box_pack_start (GTK_BOX (prop_beha_vbox2), prop_beha_hints_check, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prop_beha_hints_check), config_show_hints);

  prop_beha_sound_check = gtk_check_button_new_with_label (_("Warn on new headlines"));
  gtk_widget_show (prop_beha_sound_check);
  gtk_box_pack_start (GTK_BOX (prop_beha_vbox2), prop_beha_sound_check, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prop_beha_sound_check), config_play_sound);

  prop_beha_seppix_check = gtk_check_button_new_with_label (_("Use site separators"));
  gtk_widget_show (prop_beha_seppix_check);
  gtk_box_pack_start (GTK_BOX (prop_beha_vbox2), prop_beha_seppix_check, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prop_beha_seppix_check), config_separator_pixmap);

  prop_beha_sepown_check = gtk_check_button_new_with_label (_("Show site logos"));
  gtk_widget_show (prop_beha_sepown_check);
  gtk_box_pack_start (GTK_BOX (prop_beha_vbox2), prop_beha_sepown_check, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prop_beha_sepown_check), config_separator_own);
//  gtk_widget_set_sensitive (prop_beha_sepown_check, config_separator_pixmap);

  prop_beha_color_check = gtk_check_button_new_with_label (_("Use site colors"));
  gtk_widget_show (prop_beha_color_check);
  gtk_box_pack_start (GTK_BOX (prop_beha_vbox2), prop_beha_color_check, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prop_beha_color_check), config_unique_colors);

  gtk_signal_connect (GTK_OBJECT (prop_beha_scroll_radio1), "toggled",
		      GTK_SIGNAL_FUNC (scrolltype_toggled), prop_beha_hbox2);

  gtk_signal_connect (GTK_OBJECT (prop_beha_scroll_radio2), "toggled",
		      GTK_SIGNAL_FUNC (scrolltype_toggled), prop_beha_hbox2);

  gtk_signal_connect (GTK_OBJECT (prop_beha_scroll_spin), "changed", GTK_SIGNAL_FUNC (prop_changed), NULL);

  gtk_signal_connect (GTK_OBJECT (prop_beha_title_check), "toggled", GTK_SIGNAL_FUNC (titles_toggled), NULL);

  gtk_signal_connect (GTK_OBJECT (prop_beha_hints_check), "toggled", GTK_SIGNAL_FUNC (hints_toggled), NULL);

  gtk_signal_connect (GTK_OBJECT (prop_beha_sound_check), "toggled", GTK_SIGNAL_FUNC (sound_toggled), NULL);

  gtk_signal_connect (GTK_OBJECT (prop_beha_seppix_check), "toggled", GTK_SIGNAL_FUNC (seppix_toggled), NULL);

  gtk_signal_connect (GTK_OBJECT (prop_beha_sepown_check), "toggled", GTK_SIGNAL_FUNC (sepown_toggled), NULL);

  gtk_signal_connect (GTK_OBJECT (prop_beha_color_check), "toggled", GTK_SIGNAL_FUNC (color_toggled), NULL);

  tablabel = gtk_label_new (_("Behaviour"));
  gnome_property_box_append_page (GNOME_PROPERTY_BOX (propwindow), prop_beha_hbox1, tablabel);
}

void
properties_http_create (void)
{
  GtkWidget *tablabel;

  GtkWidget *prop_http_vbox1;
  GtkWidget *prop_http_table;

  prop_http_vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (prop_http_vbox1);

  prop_http_label_proxy = gtk_check_button_new_with_label (_("Use proxy"));
  gtk_widget_show (prop_http_label_proxy);
  gtk_box_pack_start (GTK_BOX (prop_http_vbox1), prop_http_label_proxy, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (prop_http_label_proxy), 2);

  prop_http_table = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (prop_http_table);
  gtk_box_pack_start (GTK_BOX (prop_http_vbox1), prop_http_table, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (prop_http_table), 4);
  gtk_table_set_row_spacings (GTK_TABLE (prop_http_table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (prop_http_table), 4);

  prop_http_label_proxyurl = gtk_label_new (_("Proxy url:"));
  gtk_widget_show (prop_http_label_proxyurl);
  gtk_table_attach (GTK_TABLE (prop_http_table), prop_http_label_proxyurl, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (prop_http_label_proxyurl), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_http_label_proxyurl), 0, 0.5);

  prop_http_label_proxyuser = gtk_label_new (_("Proxy username:"));
  gtk_widget_show (prop_http_label_proxyuser);
  gtk_table_attach (GTK_TABLE (prop_http_table), prop_http_label_proxyuser, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (prop_http_label_proxyuser), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_http_label_proxyuser), 0, 0.5);

  prop_http_label_proxypasswd = gtk_label_new (_("Proxy password:"));
  gtk_widget_show (prop_http_label_proxypasswd);
  gtk_table_attach (GTK_TABLE (prop_http_table), prop_http_label_proxypasswd, 0, 1, 2, 3,
		    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (prop_http_label_proxypasswd), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (prop_http_label_proxypasswd), 0, 0.5);

  prop_http_entry_proxyurl = gtk_entry_new ();
  gtk_widget_show (prop_http_entry_proxyurl);
  gtk_table_attach (GTK_TABLE (prop_http_table), prop_http_entry_proxyurl, 1, 2, 0, 1,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  if (config_proxy_url != NULL) {
    gtk_entry_set_text (GTK_ENTRY (prop_http_entry_proxyurl), config_proxy_url);
  }

  prop_http_entry_proxyuser = gtk_entry_new ();
  gtk_widget_show (prop_http_entry_proxyuser);
  gtk_table_attach (GTK_TABLE (prop_http_table), prop_http_entry_proxyuser, 1, 2, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  if (config_proxy_user != NULL) {
    gtk_entry_set_text (GTK_ENTRY (prop_http_entry_proxyuser), config_proxy_user);
  }

  prop_http_entry_proxypasswd = gtk_entry_new ();
  gtk_widget_show (prop_http_entry_proxypasswd);
  gtk_table_attach (GTK_TABLE (prop_http_table), prop_http_entry_proxypasswd, 1, 2, 2, 3,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (prop_http_entry_proxypasswd), FALSE);
  if (config_proxy_passwd != NULL) {
    gtk_entry_set_text (GTK_ENTRY (prop_http_entry_proxypasswd), config_proxy_passwd);
  }

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prop_http_label_proxy), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_label_proxyurl), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_label_proxyuser), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_label_proxypasswd), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_entry_proxyurl), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_entry_proxyuser), config_use_proxy);
  gtk_widget_set_sensitive (GTK_WIDGET (prop_http_entry_proxypasswd), config_use_proxy);

  gtk_signal_connect (GTK_OBJECT (prop_http_label_proxy), "toggled", GTK_SIGNAL_FUNC (proxy_toggled), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_http_entry_proxyurl), "changed",
		      GTK_SIGNAL_FUNC (prop_changed_refr), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_http_entry_proxyuser), "changed",
		      GTK_SIGNAL_FUNC (prop_changed_refr), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_http_entry_proxypasswd), "changed",
		      GTK_SIGNAL_FUNC (prop_changed_refr), NULL);

  tablabel = gtk_label_new (_("HTTP"));
  gnome_property_box_append_page (GNOME_PROPERTY_BOX (propwindow), prop_http_vbox1, tablabel);
}

void
properties_news_create (void)
{
  GtkWidget *tablabel;

  GtkWidget *prop_news_hbox1;
  GtkWidget *prop_news_vbox1;
  GtkWidget *prop_news_sw1c;
  GtkWidget *prop_news_ctree_available_label;
  GtkWidget *prop_news_bb1;
  GtkWidget *prop_news_vbox2;
  GtkWidget *prop_news_sw2;
  GtkWidget *prop_news_clist_selected_label;
  GtkWidget *prop_news_selected_info_label;
  GtkWidget *prop_news_bb2;
  GtkWidget *prop_news_button_up;
  GtkWidget *prop_news_button_down;
  GtkWidget *prop_news_button_delete;

  prop_news_hbox1 = gtk_hbox_new (FALSE, 1);
  gtk_widget_show (prop_news_hbox1);
  gtk_container_set_border_width (GTK_CONTAINER (prop_news_hbox1), 4);

  prop_news_vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (prop_news_vbox1);
  gtk_box_pack_start (GTK_BOX (prop_news_hbox1), prop_news_vbox1, FALSE, TRUE, 0);

  prop_news_sw1c = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (prop_news_sw1c);
  gtk_box_pack_start (GTK_BOX (prop_news_vbox1), prop_news_sw1c, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (prop_news_sw1c), GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);

  prop_news_ctree_available = gtk_ctree_new (1, 0);
  gtk_widget_show (prop_news_ctree_available);
  gtk_container_add (GTK_CONTAINER (prop_news_sw1c), prop_news_ctree_available);
  gtk_clist_set_column_width (GTK_CLIST (prop_news_ctree_available), 0, 80);
  gtk_clist_column_titles_show (GTK_CLIST (prop_news_ctree_available));
  gtk_clist_set_column_auto_resize (GTK_CLIST (prop_news_ctree_available), 0, TRUE);
  gtk_clist_column_titles_passive (GTK_CLIST (prop_news_ctree_available));

  prop_news_ctree_available_label = gtk_label_new (_("Available"));
  gtk_widget_show (prop_news_ctree_available_label);
  gtk_clist_set_column_widget (GTK_CLIST (prop_news_ctree_available), 0, prop_news_ctree_available_label);

  prop_news_bb1 = gtk_hbutton_box_new ();
  gtk_widget_show (prop_news_bb1);
  gtk_box_pack_start (GTK_BOX (prop_news_vbox1), prop_news_bb1, FALSE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (prop_news_bb1), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (prop_news_bb1), 0);
  gtk_button_box_set_child_ipadding (GTK_BUTTON_BOX (prop_news_bb1), 0, 0);

  prop_news_button_add = gtk_button_new_with_label (_("Add"));
  gtk_widget_show (prop_news_button_add);
  gtk_container_add (GTK_CONTAINER (prop_news_bb1), prop_news_button_add);
  gtk_container_set_border_width (GTK_CONTAINER (prop_news_button_add), 2);
  gtk_widget_set_sensitive (prop_news_button_add, FALSE);

  prop_news_button_prop = gtk_button_new_with_label (_("Properties"));
  gtk_widget_show (prop_news_button_prop);
  gtk_container_add (GTK_CONTAINER (prop_news_bb1), prop_news_button_prop);
  gtk_container_set_border_width (GTK_CONTAINER (prop_news_button_prop), 2);
  gtk_widget_set_sensitive (prop_news_button_prop, FALSE);

  prop_news_vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (prop_news_vbox2);
  gtk_box_pack_start (GTK_BOX (prop_news_hbox1), prop_news_vbox2, TRUE, TRUE, 0);

  prop_news_sw2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (prop_news_sw2);
  gtk_box_pack_start (GTK_BOX (prop_news_vbox2), prop_news_sw2, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (prop_news_sw2), GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);

  prop_news_clist_selected = gtk_clist_new (1);
  gtk_widget_show (prop_news_clist_selected);
  gtk_container_add (GTK_CONTAINER (prop_news_sw2), prop_news_clist_selected);
  gtk_clist_set_column_width (GTK_CLIST (prop_news_clist_selected), 0, 80);
  gtk_clist_column_titles_show (GTK_CLIST (prop_news_clist_selected));
  gtk_clist_column_titles_passive (GTK_CLIST (prop_news_clist_selected));
  gtk_clist_set_column_auto_resize (GTK_CLIST (prop_news_clist_selected), 0, TRUE);

  prop_news_clist_selected_label = gtk_label_new (_("Selected"));
  gtk_widget_show (prop_news_clist_selected_label);
  gtk_clist_set_column_widget (GTK_CLIST (prop_news_clist_selected), 0, prop_news_clist_selected_label);

  prop_news_selected_info_label = gtk_label_new (NULL);
  gtk_widget_show (prop_news_selected_info_label);
  gtk_box_pack_start (GTK_BOX (prop_news_vbox2), prop_news_selected_info_label, FALSE, FALSE, 0);

  prop_news_bb2 = gtk_hbutton_box_new ();
  gtk_widget_show (prop_news_bb2);
  gtk_box_pack_start (GTK_BOX (prop_news_vbox2), prop_news_bb2, FALSE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (prop_news_bb2), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (prop_news_bb2), 0);
  gtk_button_box_set_child_ipadding (GTK_BUTTON_BOX (prop_news_bb2), 0, 0);

  prop_news_button_up = gtk_button_new_with_label (_("Up"));
  gtk_widget_show (prop_news_button_up);
  gtk_container_add (GTK_CONTAINER (prop_news_bb2), prop_news_button_up);
  gtk_container_set_border_width (GTK_CONTAINER (prop_news_button_up), 2);

  prop_news_button_down = gtk_button_new_with_label (_("Down"));
  gtk_widget_show (prop_news_button_down);
  gtk_container_add (GTK_CONTAINER (prop_news_bb2), prop_news_button_down);
  gtk_container_set_border_width (GTK_CONTAINER (prop_news_button_down), 2);

  prop_news_button_delete = gtk_button_new_with_label (_("Delete"));
  gtk_widget_show (prop_news_button_delete);
  gtk_container_add (GTK_CONTAINER (prop_news_bb2), prop_news_button_delete);
  gtk_container_set_border_width (GTK_CONTAINER (prop_news_button_delete), 2);

  gtk_signal_connect (GTK_OBJECT (prop_news_button_add), "clicked", GTK_SIGNAL_FUNC (add_site), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_news_button_prop), "clicked",
		      GTK_SIGNAL_FUNC (plugin_properties), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_news_button_up), "clicked", GTK_SIGNAL_FUNC (up_site), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_news_button_down), "clicked", GTK_SIGNAL_FUNC (down_site), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_news_button_delete), "clicked", GTK_SIGNAL_FUNC (delete_site), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_news_ctree_available), "tree-select-row",
		      GTK_SIGNAL_FUNC (selectrow_available_tree), prop_news_selected_info_label);
  gtk_signal_connect (GTK_OBJECT (prop_news_ctree_available), "tree-unselect-row",
		      GTK_SIGNAL_FUNC (unselectrow_available_tree), prop_news_selected_info_label);
  gtk_signal_connect (GTK_OBJECT (prop_news_clist_selected), "select-row",
		      GTK_SIGNAL_FUNC (selectrow_selected), NULL);
  gtk_signal_connect (GTK_OBJECT (prop_news_clist_selected), "unselect-row",
		      GTK_SIGNAL_FUNC (unselectrow_selected), NULL);

  tablabel = gtk_label_new (_("News"));
  gnome_property_box_append_page (GNOME_PROPERTY_BOX (propwindow), prop_news_hbox1, tablabel);
}
