/****************************************************************************
 *                                                                          *
 *                         GNAT COMPILER COMPONENTS                         *
 *                                                                          *
 *                             A - A D A I N T                              *
 *                                                                          *
 *                            $Revision: 1.28 $
 *                                                                          *
 *                              C Header File                               *
 *                                                                          *
 *          Copyright (C) 1992-2001 Free Software Foundation, Inc.          *
 *                                                                          *
 * GNAT is free software;  you can  redistribute it  and/or modify it under *
 * terms of the  GNU General Public License as published  by the Free Soft- *
 * ware  Foundation;  either version 2,  or (at your option) any later ver- *
 * sion.  GNAT is distributed in the hope that it will be useful, but WITH- *
 * OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License *
 * for  more details.  You should have  received  a copy of the GNU General *
 * Public License  distributed with GNAT;  see file COPYING.  If not, write *
 * to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, *
 * MA 02111-1307, USA.                                                      *
 *                                                                          *
 * As a  special  exception,  if you  link  this file  with other  files to *
 * produce an executable,  this file does not by itself cause the resulting *
 * executable to be covered by the GNU General Public License. This except- *
 * ion does not  however invalidate  any other reasons  why the  executable *
 * file might be covered by the  GNU Public License.                        *
 *                                                                          *
 * GNAT was originally developed  by the GNAT team at  New York University. *
 * It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). *
 *                                                                          *
 ****************************************************************************/

/* Add prototype support.  */
#ifndef PROTO
#if defined (USE_PROTOTYPES) ? USE_PROTOTYPES : defined (__STDC__)
#define PROTO(ARGS) ARGS
#else
#define PROTO(ARGS) ()
#endif
#endif

#include <dirent.h>

extern void   __gnat_to_gm_time  \
              PROTO ((time_t *, int *, int *, int *, int *, int *, int *));
extern int    __gnat_get_maximum_file_Name_Length         PROTO ((void));
extern int    __gnat_get_switches_case_sensitive          PROTO ((void));
extern int    __gnat_get_file_names_case_sensitive        PROTO ((void));
extern char   __gnat_get_default_identifier_character_set PROTO ((void));
extern void   __gnat_get_current_dir          PROTO ((char *, int *));
extern void   __gnat_get_object_suffix_ptr    PROTO ((int *, char **));
extern void   __gnat_get_executable_suffix_ptr PROTO ((int *, char **));
extern void   __gnat_get_debuggable_suffix_ptr PROTO ((int *, char **));
extern int    __gnat_readlink                 PROTO ((char *, char *, size_t));
extern int    __gnat_symlink                  PROTO ((char *, char *));
extern int    __gnat_try_lock                 PROTO ((char *, char *));
extern int    __gnat_open_new                 PROTO ((char *, int));
extern int    __gnat_open_new_temp            PROTO ((char *, int));
extern int    __gnat_mkdir		      PROTO ((char *));
extern int    __gnat_stat		      PROTO ((char *,
						      struct stat *));
extern int    __gnat_open_read                PROTO ((char *, int));
extern int    __gnat_open_rw                  PROTO ((char *, int));
extern int    __gnat_open_create              PROTO ((char *, int));
extern int    __gnat_open_append              PROTO ((char *, int));
extern long   __gnat_file_length              PROTO ((int));
extern void   __gnat_tmp_name		      PROTO ((char *));
extern char*  __gnat_readdir                  PROTO ((DIR*, char*));
extern int    __gnat_readdir_is_thread_safe   PROTO ((void));
extern time_t __gnat_file_time_name           PROTO ((char *));
extern time_t __gnat_file_time_fd             PROTO ((int));
extern void   __gnat_get_env_value_ptr        PROTO ((char *, int *, char **));
extern void   __gnat_set_env_value            PROTO ((char *, char *));
extern int    __gnat_file_exists              PROTO ((char *));
extern int    __gnat_is_regular_file          PROTO ((char *));
extern int    __gnat_is_absolute_path         PROTO ((char *));
extern int    __gnat_is_directory	      PROTO ((char *));
extern int    __gnat_is_writable_file         PROTO ((char *));
extern int    __gnat_portable_spawn           PROTO ((char *[]));
extern int    __gnat_portable_no_block_spawn  PROTO ((char *[]));
extern int    __gnat_portable_wait            PROTO ((int *));
extern char   *__gnat_locate_exec             PROTO ((char *, char *));
extern char   *__gnat_locate_exec_on_path     PROTO ((char *));
extern char   *__gnat_locate_regular_file     PROTO ((char *, char *));
extern void   __gnat_maybe_glob_args          PROTO ((int *, char ***));
extern void   __gnat_os_exit		      PROTO ((int));
extern void   __gnat_set_env_value	      PROTO ((char *, char *));
extern char  *__gnat_get_libraries_from_registry PROTO ((void));
extern int    __gnat_to_canonical_file_list_init   PROTO ((char *, int));
extern char  *__gnat_to_canonical_file_list_next   PROTO ((void));
extern void   __gnat_to_canonical_file_list_free   PROTO ((void));
extern char   *__gnat_to_canonical_dir_spec   PROTO ((char *, int));
extern char   *__gnat_to_canonical_file_spec  PROTO ((char *));
extern char   *__gnat_to_host_dir_spec        PROTO ((char *, int));
extern char   *__gnat_to_host_file_spec       PROTO ((char *));
extern char  *__gnat_to_canonical_path_spec   PROTO ((char *));
extern void   __gnat_adjust_os_resource_limits PROTO ((void));

/* portable definition of strdup which is not available on all systems */
#define xstrdup(s)  strcpy ((char *) malloc (strlen(s)+1), s)
