------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--               G N A T . S O C K E T S . C O N S T A N T S                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--              Copyright (C) 2002 Ada Core Technologies, Inc.              --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT is maintained by Ada Core Technologies Inc (http://www.gnat.com).   --
--                                                                          --
------------------------------------------------------------------------------

--  This is the version for VxWorks

package GNAT.Sockets.Constants is

   --------------
   -- Families --
   --------------

   AF_INET            : constant :=    2; -- Internetwork: UDP, TCP...
   AF_INET6           : constant :=   -1; -- Internetwork: UDP, TCP... (IPV6)

   -----------
   -- Modes --
   -----------

   SOCK_STREAM        : constant :=    1; -- Stream socket
   SOCK_DGRAM         : constant :=    2; -- Datagram socket
   SOCK_RAW           : constant :=    3; -- Raw-protocol interface
   SOCK_RDM           : constant :=    4; -- Reliably-delivered message
   SOCK_SEQPACKET     : constant :=    5; -- Sequenced packet stream

   -----------------------
   -- POSIX Error codes --
   -----------------------

   EINTR              : constant :=    4; -- Interrupted system call
   EIO                : constant :=    5; -- I/O error
   EBADF              : constant :=    9; -- Bad file number
   EAGAIN             : constant :=   11; -- No more processes
   EACCES             : constant :=   13; -- Permission denied
   EMSGSIZE           : constant :=   36; -- Message size

   ---------------------
   -- Argument Errors --
   ---------------------

   ENOPROTOOPT        : constant :=   42; -- Protocol not available
   EPROTONOSUPPORT    : constant :=   43; -- Protocol not supported
   ESOCKTNOSUPPORT    : constant :=   44; -- Socket type not supported
   EOPNOTSUPP         : constant :=   45; -- Operation not supported on socket

   EPFNOSUPPORT       : constant :=   46; -- Protocol family not supported

   EAFNOSUPPORT       : constant :=   47; -- Addr family not supported
   EADDRINUSE         : constant :=   48; -- Address already in use
   EADDRNOTAVAIL      : constant :=   49; -- Can't assign requested address
   ENOTSOCK           : constant :=   50; -- Socket operation on non-socket

   EFAULT             : constant :=   14; -- Bad Address
   EINVAL             : constant :=   22; -- Invalid Argument

   ------------------------
   -- Operational Errors --
   ------------------------

   ENETUNREACH        : constant :=   51; -- Network is unreachable

   ENETRESET          : constant :=   52; -- Network dropped connect. on reset
   ECONNABORTED       : constant :=   53; -- Software caused connection abort
   ECONNRESET         : constant :=   54; -- Connection reset by peer

   ENOBUFS            : constant :=   55; -- No buffer space available
   EISCONN            : constant :=   56; -- Socket is already connected
   ENOTCONN           : constant :=   57; -- Socket is not connected

   ESHUTDOWN          : constant :=   58; -- Can't send after socket shutdown

   ETIMEDOUT          : constant :=   60; -- Connection timed out
   ECONNREFUSED       : constant :=   61; -- Connection refused

   ENETDOWN           : constant :=   62; -- Network is down
   EHOSTUNREACH       : constant :=   65; -- No route to host
   ENOTBLK            : constant :=   66; -- Block device required
   EHOSTDOWN          : constant :=   67; -- Host is down

   -----------------
   -- Host Errors --
   -----------------

   HOST_NOT_FOUND     : constant :=    1; -- Authoritative answr host not found
   TRY_AGAIN          : constant :=    2; -- Non-authoritative host not found
   NO_RECOVERY        : constant :=    3; -- Non recoverable errors
   NO_ADDRESS         : constant :=    4; -- No address

   -------------------
   -- Control Flags --
   -------------------

   FIONBIO            : constant :=   16; -- Set non-blocking I/O
   FIONREAD           : constant :=    1; -- Get num chars available to read

   --------------------
   -- Shutdown Modes --
   --------------------

   SHUT_RD            : constant :=   -1; -- Shut down read
   SHUT_WR            : constant :=   -1; -- Shut down write
   SHUT_RDWR          : constant :=   -1; -- Shut down read/write

   ---------------------
   -- Protocol Levels --
   ---------------------

   SOL_SOCKET         : constant := 65535; -- Options for socket level
   IPPROTO_IP         : constant :=     0; -- Dummy for IP
   IPPROTO_UDP        : constant :=    17; -- User datagram protocol
   IPPROTO_TCP        : constant :=     6; -- TCP

   --------------------
   -- Socket Options --
   --------------------

   TCP_NODELAY        : constant :=    1; -- No delay send to coalesce packets
   SO_DEBUG           : constant :=    1; -- Turn on debugging info recording
   SO_ACCEPTCONN      : constant :=    2; -- Socket has had listen()
   SO_REUSEADDR       : constant :=    4; -- Allow local address reuse
   SO_KEEPALIVE       : constant :=    8; -- Keep connections alive
   SO_DONTROUTE       : constant :=   16; -- Just use interface addresses
   SO_BROADCAST       : constant :=   32; -- Permit sending of broadcast msgs
   SO_USELOOPBACK     : constant :=   64; -- Bypass hardware when possible
   SO_LINGER          : constant :=  128; -- Linger on close if data present
   SO_OOBINLINE       : constant :=  256; -- Leave received OOB data in line
   SO_REUSEPORT       : constant :=  512; -- Allow local address & port reuse

   ------------------------
   -- Additional options --
   ------------------------

   SO_SNDBUF          : constant := 4097; -- Send buffer size
   SO_RCVBUF          : constant := 4098; -- Receive buffer size
   SO_SNDLOWAT        : constant := 4099; -- Send low-water mark
   SO_RCVLOWAT        : constant := 4100; -- Receive low-water mark
   SO_SNDTIMEO        : constant := 4101; -- Send timeout
   SO_RCVTIMEO        : constant := 4102; -- Receive timeout
   SO_ERROR           : constant := 4103; -- Get error status and clear
   SO_TYPE            : constant := 4104; -- Get socket type
   SO_PROTOTYPE       : constant := 4105; -- Get/set protocol type

   ------------------------------------
   -- Non-blocking and interrupt i/o --
   ------------------------------------

   EINPROGRESS        : constant :=   68; -- Operation now in progress
   EALREADY           : constant :=   69; -- Operation already in progress
   EWOULDBLOCK        : constant :=   70; -- Operation would block

   ---------------
   -- Multicast --
   ---------------

   IP_ADD_MEMBERSHIP  : constant :=   35; -- Add an IP group membership
   IP_DROP_MEMBERSHIP : constant :=   36; -- Drop an IP group membership
   IP_MULTICAST_TTL   : constant :=   33; -- Set/get IP multicast ttl
   IP_MULTICAST_LOOP  : constant :=   34; -- Set/get IP multicast loopback

end GNAT.Sockets.Constants;
