------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--               G N A T . S O C K E T S . C O N S T A N T S                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.6 $
--                                                                          --
--              Copyright (C) 2001 Ada Core Technologies, Inc.              --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT is maintained by Ada Core Technologies Inc (http://www.gnat.com).   --
--                                                                          --
------------------------------------------------------------------------------

--  This is the version for Linux

package GNAT.Sockets.Constants is
   AF_INET              : constant := 16#0002#;
   AF_INET6             : constant := 16#000A#;
   SOCK_STREAM          : constant := 16#0001#;
   SOCK_DGRAM           : constant := 16#0002#;
   EINTR                : constant := 16#0004#;
   EAGAIN               : constant := 16#000B#;
   EWOULDBLOCK          : constant := 16#000B#;
   EINPROGRESS          : constant := 16#0073#;
   EALREADY             : constant := 16#0072#;
   EISCONN              : constant := 16#006A#;
   ECONNREFUSED         : constant := 16#006F#;
   FIONBIO              : constant := 16#5421#;
   FIONREAD             : constant := 16#541B#;
   SHUT_RD              : constant := 16#0000#;
   SHUT_WR              : constant := 16#0001#;
   SHUT_RDWR            : constant := 16#0002#;
   TCP_NODELAY          : constant := 16#0001#;
   SOL_SOCKET           : constant := 16#0001#;
   IPPROTO_IP           : constant := 16#0000#;
   IPPROTO_UDP          : constant := 16#0011#;
   IPPROTO_TCP          : constant := 16#0006#;
   SO_SNDBUF            : constant := 16#0007#;
   SO_RCVBUF            : constant := 16#0008#;
   SO_REUSEADDR         : constant := 16#0002#;
   SO_KEEPALIVE         : constant := 16#0009#;
   SO_LINGER            : constant := 16#000D#;
   SO_ERROR             : constant := 16#0004#;
   SO_BROADCAST         : constant := 16#0006#;
   IP_ADD_MEMBERSHIP    : constant := 16#0023#;
   IP_DROP_MEMBERSHIP   : constant := 16#0024#;
   IP_MULTICAST_TTL     : constant := 16#0021#;
   IP_MULTICAST_LOOP    : constant := 16#0022#;
   HOST_NOT_FOUND       : constant := 16#0001#;
   TRY_AGAIN            : constant := 16#0002#;
   NO_RECOVERY          : constant := 16#0003#;
   NO_DATA              : constant := 16#0004#;
   NO_ADDRESS           : constant := 16#0004#;
end GNAT.Sockets.Constants;
