/*

Copyright (c) 2000, Red Hat, Inc.

This file is part of Source-Navigator.

Source-Navigator is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your option)
any later version.

Source-Navigator is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with Source-Navigator; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.



*/

#define rbool		char
#define rtrue		1
#define rfalse		0
#define StdIn		0

#include "Scanner.h"

#ifdef __cplusplus
extern "C" {
#include "Source.h"
#include "rSystem.h"
#include "General.h"
#include "DynArray.h"
#include "Position.h"
}
#else
#include "Source.h"
#include "rSystem.h"
#include "General.h"
#include "DynArray.h"
#include "Position.h"
#endif

#include <stdio.h>
#if defined __STDC__ | defined __cplusplus
#include <stdlib.h>
#endif

#define yyStart(State)	{ yyPreviousStart = yyStartState; yyStartState = State;}
#define yyPrevious	{ yyStateRange s = yyStartState; \
			yyStartState = yyPreviousStart; yyPreviousStart = s; }
#define yyEcho		{ (void) fwrite (TokenPtr, 1, \
			TokenLength, stdout); }
#define yyEol(Column)	{ yyLineCount ++; \
			yyLineStart = (unsigned char *) TokenPtr + \
			TokenLength - 1 - (Column); }
#define output(c)	(void) putchar ((int) c)
#define yyColumn(Ptr)	((int) ((Ptr) - (char *) yyLineStart))
#define yyOffset(Ptr)	(yyFileOffset + ((Ptr) - yyChBufferStart2))

#define yyDNoState		0
#define yyFirstCh	(unsigned char) '\0'
#define yyLastCh	(unsigned char) '\377'
#define yyEolCh	(unsigned char) '\12'
#define yyEobCh	(unsigned char) '\177'
#define yyDStateCount	515
#define yyTableSize	23727
#define yyEobState	433
#define yyDefaultState	434
#define STD	1
#define Comment_Entry	3
#define Note	5
#define Picture	7
#define String1	9
#define String2	11
#define SQL	13
#define Pseudo_Text	15
#define Continue_Picture	17
#define Continue_Int	19
#define Continue_Real	21
#define Continue_Para	23
#define Continue_Name	25
#define Include	27
#define Skip	29
#define Directive	31
#define xxyyPush
#define xxyyPop

static void yyExit ARGS ((void))
{ rExit (1); }

typedef unsigned short	yyStateRange;
typedef struct { yyStateRange yyCheck, yyNext; } yyCombType;

	char *		TokenPtr	;
	int		TokenLength	;
	tScanAttribute	Attribute	;
	void		(* Scanner_Exit)	ARGS ((void)) = yyExit;

static	void		yyErrorMessage	ARGS ((int yyErrorCode));
#ifdef xxinput
static	char		input		ARGS ((void));
#endif
static	void		unput		ARGS ((char));
static	void		yyLess		ARGS ((int));

static	yyCombType	yyComb		[yyTableSize   + 1] = {
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  128}, 
{   1,  435}, {   1,  124}, {   1,   92}, {   1,   92}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,   92}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  439}, {   1,   91}, {   1,  490}, 
{   1,   91}, {   1,   91}, {   1,   91}, {   1,  482}, {   1,  498}, 
{   1,  481}, {   1,  480}, {   1,  123}, {   1,  122}, {   1,   87}, 
{   1,  121}, {   1,  120}, {   1,  476}, {   1,   90}, {   1,   90}, 
{   1,   90}, {   1,   90}, {   1,   90}, {   1,   90}, {   1,  474}, 
{   1,  471}, {   1,  469}, {   1,   90}, {   1,  468}, {   1,  206}, 
{   1,  465}, {   1,   33}, {   1,  463}, {   1,   91}, {   1,   91}, 
{   1,  428}, {   1,  428}, {   1,  394}, {   1,  428}, {   1,  392}, 
{   1,  428}, {   1,  428}, {   1,  428}, {   1,  411}, {   1,  428}, 
{   1,  428}, {   1,  428}, {   1,  428}, {   1,  412}, {   1,  428}, 
{   1,  233}, {   1,  428}, {   1,  395}, {   1,  414}, {   1,  386}, 
{   1,  428}, {   1,  428}, {   1,  428}, {   1,  228}, {   1,  428}, 
{   1,  428}, {   1,   91}, {   1,   91}, {   1,   91}, {   1,   91}, 
{   1,   91}, {   1,   91}, {   1,  428}, {   1,  428}, {   1,  394}, 
{   1,  428}, {   1,  392}, {   1,  428}, {   1,  428}, {   1,  428}, 
{   1,  411}, {   1,  428}, {   1,  428}, {   1,  428}, {   1,  428}, 
{   1,  412}, {   1,  428}, {   1,  233}, {   1,  428}, {   1,  395}, 
{   1,  414}, {   1,  386}, {   1,  428}, {   1,  428}, {   1,  428}, 
{   1,  228}, {   1,  428}, {   1,  428}, {   1,   91}, {   1,   91}, 
{   1,   91}, {   1,   91}, {  16,  507}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, {   1,  124}, 
{   1,  124}, {   2,  440}, {   4,  323}, {  43,   58}, {  58,   58}, 
{   2,   39}, {   4,   39}, {  67,  459}, {  73,  433}, {   6,  443}, 
{ 123,  478}, {   2,  252}, {   4,   86}, {   6,  157}, {   2,  500}, 
{   4,  501}, {   2,  477}, {   4,   86}, { 124,  433}, {   6,  203}, 
{  89,  391}, {   8,  440}, {   6,  502}, { 154,  110}, {   6,  203}, 
{   8,  163}, { 155,  165}, {  58,   58}, {  14,  449}, {  18,  452}, 
{ 125,  260}, {   8,  406}, {  14,  160}, {  18,  162}, {   8,  503}, 
{ 123,  140}, {   8,  406}, {   2,   88}, {  14,  186}, {  18,  404}, 
{ 156,  154}, {  14,  506}, {  18,  508}, {  14,  186}, {  18,  404}, 
{  20,  452}, {  22,  452}, { 158,  319}, { 159,  317}, {  20,   39}, 
{  22,   39}, { 162,  347}, {  89,  391}, {  24,  452}, { 164,   82}, 
{  20,  173}, {  22,  173}, {  24,   39}, {  20,  509}, {  22,  510}, 
{  20,  173}, {  22,  173}, { 125,  260}, {  24,  170}, { 168,  165}, 
{ 169,  433}, {  24,  511}, { 123,  140}, {  24,  170}, {   2,   88}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  437}, 
{   3,  435}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  441}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, { 172,  299}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, {   3,  205}, 
{   3,  205}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,  128}, {   5,  435}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,  442}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,  499}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, { 183,  429}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, {   5,   85}, 
{   5,   85}, {   5,   85}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  128}, {   7,  435}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  439}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,   81}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,   81}, 
{   7,   81}, {   7,   81}, {   7,   81}, {   7,   80}, {   7,   81}, 
{   7,   81}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,   81}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,   81}, {   7,   81}, {   7,   81}, 
{   7,   81}, {   7,   81}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  320}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,   81}, {   7,  199}, {   7,   81}, 
{   7,   81}, {   7,  199}, {   7,  199}, {   7,   81}, {   7,  199}, 
{   7,   81}, {   7,  199}, {   7,   81}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,   81}, 
{   7,   81}, {   7,   81}, {   7,   81}, {   7,   81}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  320}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,   81}, 
{   7,  199}, {   7,   81}, {   7,   81}, {   7,  199}, {   7,  199}, 
{   7,   81}, {   7,  199}, {   7,   81}, {   7,  199}, {   7,   81}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, { 188,  165}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, {   7,  199}, 
{   7,  199}, {   7,  199}, {   7,  199}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,  495}, { 107,  292}, {   9,   75}, 
{   9,   75}, {   9,  493}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,  444}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,  491}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{ 107,  433}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, 
{   9,   75}, {   9,   75}, {   9,   75}, {   9,   75}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,   36}, { 190,  297}, 
{  10,  319}, {  10,  319}, {  10,  494}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  445}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  158}, {  10,  319}, {  10,  319}, {  10,  492}, {  10,  319}, 
{  10,  319}, {  10,  318}, {  10,  319}, {  10,  319}, {  10,  504}, 
{  10,  319}, {  10,  318}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, { 195,  360}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, {  10,  319}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,  487}, 
{ 205,  433}, {  11,   70}, {  11,   70}, {  11,  485}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,  446}, {  11,   70}, {  11,  483}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, { 208,  292}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, {  11,   70}, 
{  11,   70}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  127}, { 239,  372}, {  12,  317}, {  12,  317}, {  12,  486}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  447}, {  12,  317}, 
{  12,  484}, {  12,  317}, {  12,  159}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  316}, {  12,  317}, 
{  12,  317}, {  12,  505}, {  12,  317}, {  12,  316}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, { 240,  358}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, {  12,  317}, 
{  12,  317}, {  12,  317}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  128}, {  13,  435}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  448}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  185}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  185}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, { 249,  116}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, {  13,  187}, 
{  13,  187}, {  13,  187}, {  13,  187}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  461}, {  15,  460}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  450}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,   67}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{ 278,   94}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, 
{  15,  184}, {  15,  184}, {  15,  184}, {  15,  184}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  128}, {  17,  436}, 
{  17,  180}, {  17,  180}, {  17,  314}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  451}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,   65}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,   65}, {  17,   65}, {  17,   65}, {  17,   65}, 
{  17,   64}, {  17,   65}, {  17,   65}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,   65}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,   65}, 
{  17,   65}, {  17,   65}, {  17,   65}, {  17,   65}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,   65}, 
{  17,  180}, {  17,   65}, {  17,   65}, {  17,  180}, {  17,  180}, 
{  17,   65}, {  17,  180}, {  17,   65}, {  17,  180}, {  17,   65}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,   65}, {  17,   65}, {  17,   65}, {  17,   65}, 
{  17,   65}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,   65}, {  17,  180}, {  17,   65}, {  17,   65}, 
{  17,  180}, {  17,  180}, {  17,   65}, {  17,  180}, {  17,   65}, 
{  17,  180}, {  17,   65}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, { 292,  105}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, {  17,  180}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  128}, 
{  19,  436}, {  19,  176}, {  19,  176}, {  19,  312}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  451}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,   60}, 
{  19,  174}, {  19,   60}, {  19,  176}, {  19,   63}, {  19,   63}, 
{  19,   63}, {  19,   63}, {  19,   63}, {  19,   63}, {  19,   63}, 
{  19,   63}, {  19,   63}, {  19,   63}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, {  19,   57}, 
{  19,   57}, {  19,   57}, {  19,   57}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, { 294,   99}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, {  19,  176}, 
{  19,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  128}, {  21,  436}, {  21,  176}, {  21,  176}, {  21,  312}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  451}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  175}, 
{  21,  176}, {  21,  175}, {  21,  176}, {  21,  176}, {  21,  178}, 
{  21,  178}, {  21,  178}, {  21,  178}, {  21,  178}, {  21,  178}, 
{  21,  178}, {  21,  178}, {  21,  178}, {  21,  178}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  177}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  177}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, { 295,   96}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, {  21,  176}, 
{  21,  176}, {  21,  176}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,  128}, {  23,  436}, {  23,   56}, {  23,   56}, 
{  23,  172}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,  451}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,  171}, {  23,   56}, {  23,   56}, 
{  23,   59}, {  23,   59}, {  23,   59}, {  23,   59}, {  23,   59}, 
{  23,   59}, {  23,   59}, {  23,   59}, {  23,   59}, {  23,   59}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, {  23,   57}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, { 296,   82}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, {  23,   56}, 
{  23,   56}, {  23,   56}, {  23,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,  128}, {  25,  436}, {  25,   56}, 
{  25,   56}, {  25,  172}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,  451}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,  311}, {  25,   56}, 
{  25,   56}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, {  25,   57}, 
{  25,   57}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{ 297,  351}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, 
{  25,   56}, {  25,   56}, {  25,   56}, {  25,   56}, {  26,  452}, 
{ 286,  146}, { 298,  283}, { 286,  146}, {  26,   39}, { 299,   58}, 
{ 300,   43}, { 302,  291}, { 303,  292}, { 304,  294}, {  26,  170}, 
{ 305,  295}, { 306,  296}, {  26,  512}, { 307,  297}, {  26,  170}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  128}, 
{  27,  435}, {  27,  169}, {  27,   55}, {  27,   55}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,   55}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  439}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, {  27,   54}, 
{  27,   54}, {  27,   54}, {  27,   54}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, { 339,  429}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, {  27,  169}, 
{  27,  169}, {  28,  440}, { 309,  197}, { 340,  429}, { 310,  192}, 
{  28,   39}, { 310,  192}, { 342,  315}, { 343,  182}, { 309,  197}, 
{ 344,  321}, {  28,   53}, { 353,  240}, { 356,  102}, {  28,  513}, 
{ 360,  290}, {  28,   53}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  438}, {  29,  435}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  453}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, { 404,  426}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, {  29,  167}, 
{  29,  167}, {  29,  167}, {  29,  167}, {  30,  454}, { 308,  299}, 
{ 406,  427}, { 426,  429}, {  30,  161}, { 427,  429}, { 432,  433}, 
{ 463,  464}, { 465,  467}, { 465,  466}, {  30,  166}, { 469,  470}, 
{ 362,  360}, {  30,  514}, { 474,  475}, {  30,  166}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  128}, {  31,  458}, 
{  31,  124}, {  31,   37}, {  31,   37}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,   37}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  439}, {  31,  124}, {  31,  253}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  119}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  60,  179}, {  60,  179}, {  60,  179}, 
{  60,  179}, {  60,  179}, {  60,  179}, {  60,  179}, {  60,  179}, 
{  60,  179}, {  60,  179}, {  31,  124}, {  31,  124}, {  31,  457}, 
{  31,  456}, {  31,  455}, {  31,  124}, {  31,  124}, { 126,   48}, 
{  32,  440}, { 139,  142}, {  31,  368}, {  31,  254}, {  32,   39}, 
{ 140,  144}, { 141,  284}, {  31,  265}, { 142,  150}, { 144,  152}, 
{  32,  407}, { 149,   69}, {  31,  328}, {  32,  515}, { 150,  141}, 
{  32,  407}, { 151,  282}, {  31,  258}, { 140,  139}, { 152,  103}, 
{ 152,  103}, { 185,  277}, { 212,  112}, { 152,  103}, { 213,  114}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, { 126,   48}, { 209,  208}, { 139,  142}, {  31,  368}, 
{  31,  254}, { 308,  433}, { 140,  144}, { 141,  284}, {  31,  265}, 
{ 142,  150}, { 144,  152}, { 152,  103}, { 149,   69}, {  31,  328}, 
{ 483,  488}, { 150,  141}, { 362,  433}, { 151,  282}, {  31,  258}, 
{ 140,  139}, { 209,  209}, { 484,  489}, { 185,  277}, { 212,  112}, 
{ 491,  496}, { 213,  114}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, { 492,  497}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, {  31,  124}, 
{  33,  279}, { 352,  239}, { 358,  371}, { 378,  362}, {   0,    0}, 
{  33,  341}, {  34,  422}, {  34,  422}, {  34,  422}, {  34,  422}, 
{  34,  422}, {  34,  422}, {  34,  422}, {  34,  422}, {  34,  422}, 
{  34,  422}, { 153,  104}, { 153,  104}, {  38,  154}, {   0,    0}, 
{ 153,  104}, {  38,  156}, { 378,  378}, { 214,  115}, { 215,  118}, 
{  59,  134}, {  34,   51}, {  33,  462}, {  59,   59}, {  59,   59}, 
{  59,   59}, {  59,   59}, {  59,   59}, {  59,   59}, {  59,   59}, 
{  59,   59}, {  59,   59}, {  59,   59}, {   0,    0}, { 153,  104}, 
{  38,   38}, { 291,  100}, {  35,  132}, {   0,    0}, { 358,  433}, 
{  35,   35}, {  35,   35}, {  35,   35}, {  35,   35}, {  35,   35}, 
{  35,   35}, {  35,   35}, {  35,   35}, {  35,   35}, {  35,   35}, 
{ 214,  115}, { 215,  118}, { 218,  247}, {  34,   51}, { 219,  398}, 
{ 220,  210}, { 352,  433}, {  35,  422}, {  35,  422}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, { 221,  212}, { 218,  247}, 
{ 221,  428}, { 219,  398}, { 220,  210}, {  33,  433}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, 
{  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, {  35,  422}, 
{ 221,  212}, {   0,    0}, { 221,  428}, { 291,  433}, {  35,  433}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  38,  433}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  130}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,   78}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {   0,    0}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, {  36,  197}, 
{  36,  197}, {  44,  132}, { 471,  473}, { 471,  472}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {   0,    0}, 
{ 223,  428}, { 230,  220}, { 231,  219}, { 232,  225}, { 235,  227}, 
{ 223,  108}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, { 223,  428}, { 230,  220}, { 231,  219}, 
{ 232,  225}, { 235,  227}, { 223,  108}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, 
{  44,  422}, {  44,  422}, {  44,  422}, {  44,  422}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {   0,    0}, 
{  52,  167}, {  52,  167}, {  52,  168}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,   52}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  161}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {   0,    0}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, {  52,  167}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,   40}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {   0,    0}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, {  53,  429}, 
{  53,  429}, {  54,  133}, {   0,    0}, {   0,    0}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, { 216,  248}, 
{ 216,  248}, { 216,  248}, {   0,    0}, { 236,  232}, { 237,  229}, 
{   0,    0}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, { 228,  279}, { 256,   45}, { 216,  428}, 
{ 236,  232}, { 237,  229}, { 228,  341}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, 
{  54,   54}, {  54,   54}, {  54,   54}, {  54,   54}, {  57,  275}, 
{ 256,   45}, { 216,  428}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {   0,    0}, { 254,  261}, { 257,   44}, 
{ 254,  126}, { 260,   34}, { 228,  428}, { 264,  256}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{ 254,  261}, { 257,   44}, { 254,  126}, { 260,   34}, { 228,  428}, 
{ 264,  256}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, {  57,   57}, 
{  57,   57}, {  57,   57}, {  61,   61}, {  61,   61}, {  61,   61}, 
{  61,   61}, {  61,   61}, {  61,   61}, {  61,   61}, {  61,   61}, 
{  61,   61}, {  61,   61}, {  62,   62}, {  62,   62}, {  62,   62}, 
{  62,   62}, {  62,   62}, {  62,   62}, {  62,   62}, {  62,   62}, 
{  62,   62}, {  62,   62}, {  63,  400}, { 271,  333}, {  63,  400}, 
{   0,    0}, {  63,   63}, {  63,   63}, {  63,   63}, {  63,   63}, 
{  63,   63}, {  63,   63}, {  63,   63}, {  63,   63}, {  63,   63}, 
{  63,   63}, {  64,  381}, { 189,  165}, {   0,    0}, { 252,  479}, 
{ 189,   71}, { 357,  359}, {  64,  381}, {  64,  381}, {  64,  381}, 
{  64,  381}, {  64,  276}, {  64,  381}, {  64,  381}, { 248,  113}, 
{ 325,  105}, { 372,  354}, { 267,  263}, { 233,  218}, {   0,    0}, 
{ 271,  333}, {   0,    0}, {  64,  381}, {   0,    0}, { 189,  189}, 
{ 267,  422}, { 189,   73}, { 233,  430}, { 189,  310}, { 252,  334}, 
{  64,  381}, {  64,  381}, {  64,  381}, {  64,  381}, {  64,  381}, 
{ 101,  101}, { 101,  101}, { 101,  101}, { 101,  101}, { 101,  101}, 
{ 101,  101}, { 101,  101}, { 101,  101}, { 101,  101}, { 101,  101}, 
{  64,  381}, { 293,  352}, {  64,  381}, {  64,  381}, { 267,  263}, 
{ 233,  218}, {  64,  381}, { 248,  428}, {  64,  381}, {   0,    0}, 
{  64,  381}, {   0,    0}, { 267,  422}, { 372,  433}, { 233,  430}, 
{ 357,  433}, { 252,  334}, {  64,  381}, {  64,  381}, {  64,  381}, 
{  64,  381}, {  64,  381}, { 145,   61}, { 145,   61}, { 145,   61}, 
{ 145,   61}, { 145,   61}, { 145,   61}, { 145,   61}, { 145,   61}, 
{ 145,   61}, { 145,   61}, {  64,  381}, {  95,  295}, {  64,  381}, 
{  64,  381}, {  95,  305}, {  65,   65}, {  64,  381}, { 248,  428}, 
{  64,  381}, {  65,  347}, {  64,  381}, {  65,   65}, {  65,   65}, 
{  65,   65}, {  65,   65}, {  65,  135}, {  65,   65}, {  65,   65}, 
{ 293,  433}, {   0,    0}, { 325,  433}, {   0,    0}, { 258,  257}, 
{  95,  376}, { 283,  151}, {   0,    0}, {  65,   65}, { 354,  355}, 
{ 261,  259}, { 261,  422}, { 282,  149}, { 224,  217}, { 258,  423}, 
{ 333,  129}, {  65,   65}, {  65,   65}, {  65,   65}, {  65,   65}, 
{  65,   65}, {  95,   95}, {  95,   95}, {  95,   95}, {  95,   95}, 
{  95,   95}, {  95,   95}, {  95,   95}, {  95,   95}, {  95,   95}, 
{  95,   95}, {  65,   65}, { 224,  428}, {  65,   65}, {  65,   65}, 
{ 262,  422}, { 258,  257}, {  65,   65}, { 283,  151}, {  65,   65}, 
{ 262,   50}, {  65,   65}, { 261,  259}, { 261,  422}, { 282,  149}, 
{ 224,  217}, { 258,  423}, { 333,  129}, {  65,   65}, {  65,   65}, 
{  65,   65}, {  65,   65}, {  65,   65}, { 146,  313}, { 146,  313}, 
{ 146,  313}, { 146,  313}, { 146,  313}, { 146,  313}, { 146,  313}, 
{ 146,  313}, { 146,  313}, { 146,  313}, {  65,   65}, { 224,  428}, 
{  65,   65}, {  65,   65}, { 262,  422}, { 354,  433}, {  65,   65}, 
{ 282,  433}, {  65,   65}, { 262,   50}, {  65,   65}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {   0,    0}, {  68,  165}, 
{  68,  187}, {  68,  187}, {  68,  188}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,   68}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  160}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, { 355,   98}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{   0,    0}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, { 355,  433}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, {  68,  187}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {   0,    0}, 
{   0,    0}, {  70,   70}, {  70,   70}, {   0,    0}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {   0,    0}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {   0,    0}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, {  70,   70}, 
{  70,   70}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {   0,    0}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {   0,    0}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, {  71,  192}, 
{  71,  192}, {  71,  192}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {   0,    0}, {   0,    0}, {  75,   75}, {  75,   75}, 
{   0,    0}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {   0,    0}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {   0,    0}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, {  75,   75}, 
{  75,   75}, {  75,   75}, {  75,   75}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {   0,    0}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{   0,    0}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, 
{  76,  197}, {  76,  197}, {  76,  197}, {  76,  197}, {  80,  296}, 
{ 194,  165}, { 272,  241}, {  80,  306}, { 194,   76}, { 359,  353}, 
{ 272,  241}, { 120,  238}, { 120,  238}, { 120,  238}, { 120,  238}, 
{ 120,  238}, { 120,  238}, { 120,  238}, { 120,  238}, { 120,  238}, 
{ 120,  238}, { 226,  245}, { 226,  326}, { 384,  236}, { 277,  298}, 
{ 226,  111}, {  80,  377}, { 194,  194}, { 371,  356}, { 272,  241}, 
{  80,  382}, { 194,  309}, { 120,  401}, {   0,    0}, { 194,   78}, 
{   0,    0}, {  80,  382}, {  80,  382}, {  80,  382}, {  80,  382}, 
{  80,  280}, {  80,  382}, {  80,  382}, { 265,   46}, { 226,  246}, 
{ 244,  292}, {   0,    0}, { 266,  264}, { 244,  303}, { 225,  250}, 
{ 225,  327}, {  80,  382}, {   0,    0}, { 225,  117}, { 266,  422}, 
{ 384,  236}, { 277,  298}, { 265,  422}, { 359,  433}, {  80,  382}, 
{  80,  382}, {  80,  382}, {  80,  382}, {  80,  382}, { 120,  401}, 
{ 227,  243}, { 227,  325}, { 244,  374}, { 336,  164}, { 227,  107}, 
{   0,    0}, { 336,  370}, { 225,  251}, {   0,    0}, {  80,  382}, 
{ 265,   46}, {  80,  382}, {  80,  382}, { 284,  153}, { 266,  264}, 
{  80,  382}, { 385,  215}, {  80,  382}, { 277,  433}, {  80,  382}, 
{   0,    0}, { 266,  422}, { 371,  433}, { 227,  244}, { 265,  422}, 
{ 336,  336}, {  80,  382}, {  80,  382}, {  80,  382}, {  80,  382}, 
{  80,  382}, { 175,   62}, { 175,   62}, { 175,   62}, { 175,   62}, 
{ 175,   62}, { 175,   62}, { 175,   62}, { 175,   62}, { 175,   62}, 
{ 175,   62}, {  80,  382}, { 390,  223}, {  80,  382}, {  80,  382}, 
{ 284,  153}, {  81,   81}, {  80,  382}, { 385,  215}, {  80,  382}, 
{  81,  287}, {  80,  382}, {  81,   81}, {  81,   81}, {  81,   81}, 
{  81,   81}, {  81,  137}, {  81,   81}, {  81,   81}, { 225,  428}, 
{ 301,  165}, {   0,    0}, { 268,  125}, { 301,  155}, { 284,  433}, 
{   0,    0}, { 351,  351}, {  81,   81}, { 351,   74}, { 336,  429}, 
{   0,    0}, { 229,  213}, { 391,  216}, { 268,  422}, { 390,  223}, 
{  81,   81}, {  81,   81}, {  81,   81}, {  81,   81}, {  81,   81}, 
{  83,  296}, { 290,  290}, { 301,  301}, {  83,  306}, {   0,    0}, 
{   0,    0}, { 301,   39}, { 229,  428}, { 290,   79}, { 320,   84}, 
{  81,   81}, { 225,  428}, {  81,   81}, {  81,   81}, { 268,  125}, 
{   0,    0}, {  81,   81}, { 244,  433}, {  81,   81}, { 396,  415}, 
{  81,   81}, { 336,  429}, {  83,  377}, { 229,  213}, { 391,  216}, 
{ 268,  422}, {  83,  382}, {  81,   81}, {  81,   81}, {  81,   81}, 
{  81,   81}, {  81,   81}, {  83,  382}, {  83,  382}, {  83,  382}, 
{  83,  382}, {  83,  280}, {  83,  382}, {  83,  382}, { 229,  428}, 
{   0,    0}, { 320,   84}, {  81,   81}, {   0,    0}, {  81,   81}, 
{  81,   81}, {   0,    0}, {  83,  382}, {  81,   81}, {   0,    0}, 
{  81,   81}, { 396,  415}, {  81,   81}, { 320,  433}, { 408,  418}, 
{  83,  382}, {  83,  382}, {  83,  382}, {  83,  382}, {  83,  382}, 
{ 313,  313}, { 313,  313}, { 313,  313}, { 313,  313}, { 313,  313}, 
{ 313,  313}, { 313,  313}, { 313,  313}, { 313,  313}, { 313,  313}, 
{  83,  382}, { 329,  422}, {  83,  382}, {  83,  382}, { 409,  366}, 
{ 329,  365}, {  83,  382}, { 366,  422}, {  83,  382}, { 366,  266}, 
{  83,  382}, { 351,  433}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 408,  418}, {  83,  382}, {  83,  382}, {  83,  382}, 
{  83,  382}, {  83,  382}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 290,  433}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {  83,  382}, { 329,  422}, {  83,  382}, 
{  83,  382}, { 409,  366}, { 329,  365}, {  83,  382}, { 366,  422}, 
{  83,  382}, { 366,  266}, {  83,  382}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {   0,    0}, {   0,    0}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {   0,    0}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,  433}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, 
{  85,   85}, {  85,   85}, {  85,   85}, {  85,   85}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,   40}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {   0,    0}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, {  86,  429}, 
{  87,  294}, { 361,   43}, { 373,  291}, {  87,  304}, { 361,  300}, 
{ 373,  302}, { 374,  292}, {   0,    0}, {   0,    0}, { 374,  303}, 
{ 375,  294}, { 148,  295}, { 376,  295}, { 375,  304}, { 148,  305}, 
{ 376,  305}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {  87,  375}, { 361,  361}, { 373,  373}, 
{   0,    0}, {  90,  291}, { 361,   39}, { 374,  374}, {  90,  302}, 
{   0,    0}, { 410,  419}, { 375,  375}, { 148,  376}, { 376,  376}, 
{   0,    0}, {   0,    0}, {   0,    0}, {  87,  324}, {  87,  324}, 
{  87,  324}, {  87,  324}, {  87,  324}, {  87,  324}, {  87,  324}, 
{  87,  324}, {  87,  324}, {  87,  324}, {  90,  373}, { 148,   95}, 
{ 148,   95}, { 148,   95}, { 148,   95}, { 148,   95}, { 148,   95}, 
{ 148,   95}, { 148,   95}, { 148,   95}, { 148,   95}, {  87,  147}, 
{  90,  143}, {   0,    0}, {  90,  399}, { 410,  419}, {  90,   90}, 
{  90,   90}, {  90,   90}, {  90,   90}, {  90,   90}, {  90,   90}, 
{  90,   90}, {  90,   90}, {  90,   90}, {  90,   90}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  87,  147}, {  88,  207}, {  88,  207}, {  88,  208}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  209}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,   88}, {  88,  207}, {  88,  207}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, 
{  88,   88}, {  88,   88}, {  88,   88}, {  88,   88}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {   0,    0}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, {  88,  207}, 
{  88,  207}, {  88,  207}, {  97,  291}, {   0,    0}, {   0,    0}, 
{  97,  302}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 323,  165}, {   0,    0}, 
{   0,    0}, { 323,  155}, {   0,    0}, { 106,  303}, { 411,  393}, 
{ 177,  145}, {   0,    0}, { 177,  145}, {   0,    0}, {  97,  373}, 
{ 177,   61}, { 177,   61}, { 177,   61}, { 177,   61}, { 177,   61}, 
{ 177,   61}, { 177,   61}, { 177,   61}, { 177,   61}, { 177,   61}, 
{ 323,  301}, {  97,  143}, { 106,  374}, {  97,  399}, { 323,   39}, 
{  97,   97}, {  97,   97}, {  97,   97}, {  97,   97}, {  97,   97}, 
{  97,   97}, {  97,   97}, {  97,   97}, {  97,   97}, {  97,   97}, 
{ 106,  281}, { 411,  393}, {   0,    0}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, {   0,    0}, { 388,  226}, 
{ 388,  428}, { 398,  428}, { 398,  383}, { 412,  385}, { 413,  388}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 388,  226}, { 388,  428}, { 398,  428}, { 398,  383}, 
{ 412,  385}, { 413,  388}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, { 106,  428}, 
{ 106,  428}, { 106,  428}, { 106,  428}, { 109,  154}, { 377,  296}, 
{ 323,  433}, { 109,  156}, { 377,  306}, { 178,  178}, { 178,  178}, 
{ 178,  178}, { 178,  178}, { 178,  178}, { 178,  178}, { 178,  178}, 
{ 178,  178}, { 178,  178}, { 178,  178}, { 379,  297}, {   0,    0}, 
{   0,    0}, { 379,  307}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 109,   38}, { 377,  377}, {   0,    0}, {   0,    0}, { 178,  285}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 109,  138}, {   0,    0}, 
{ 379,  379}, { 109,  109}, { 109,  109}, { 109,  109}, { 109,  109}, 
{ 109,  109}, { 109,  109}, { 109,  109}, { 109,  109}, { 109,  109}, 
{ 109,  109}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 178,  285}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,   41}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, {   0,    0}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, { 119,  369}, 
{ 119,  369}, { 119,  369}, { 121,  291}, {   0,    0}, {   0,    0}, 
{ 121,  302}, { 347,  343}, { 347,  343}, { 347,  343}, { 347,  343}, 
{ 347,  343}, { 347,  343}, { 347,  343}, { 347,  343}, { 347,  343}, 
{ 347,  343}, {   0,    0}, { 122,  291}, {   0,    0}, {   0,    0}, 
{ 122,  302}, { 285,  145}, { 414,   89}, { 285,  145}, { 121,  373}, 
{   0,    0}, { 285,   61}, { 285,   61}, { 285,   61}, { 285,   61}, 
{ 285,   61}, { 285,   61}, { 285,   61}, { 285,   61}, { 285,   61}, 
{ 285,   61}, { 121,  143}, {   0,    0}, { 121,  399}, { 122,  373}, 
{ 121,   97}, { 121,   97}, { 121,   97}, { 121,   97}, { 121,   97}, 
{ 121,   97}, { 121,   97}, { 121,   97}, { 121,   97}, { 121,   97}, 
{ 122,  357}, { 122,  143}, {   0,    0}, { 122,  399}, { 414,   89}, 
{ 122,  101}, { 122,  101}, { 122,  101}, { 122,  101}, { 122,  101}, 
{ 122,  101}, { 122,  101}, { 122,  101}, { 122,  101}, { 122,  101}, 
{ 121,  293}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  242}, { 129,   40}, { 129,  429}, { 129,  429}, { 129,  242}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  242}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, {   0,    0}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, { 129,  429}, 
{ 129,  429}, { 129,  429}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, {   0,    0}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  130}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,   78}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, {   0,    0}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, { 130,  197}, 
{ 130,  197}, { 130,  197}, { 130,  197}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, {   0,    0}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  131}, { 131,  192}, { 131,   73}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{   0,    0}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, 
{ 131,  192}, { 131,  192}, { 131,  192}, { 131,  192}, { 132,  132}, 
{   0,    0}, {   0,    0}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, {   0,    0}, { 415,  413}, { 418,  271}, 
{ 419,  409}, { 420,  421}, { 421,  410}, { 423,  420}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 415,  413}, { 418,  271}, { 419,  409}, { 420,  421}, { 421,  410}, 
{ 423,  420}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, { 132,  422}, 
{ 132,  422}, { 132,  422}, { 133,  133}, {   0,    0}, {   0,    0}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{   0,    0}, { 430,  396}, { 431,  408}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 430,  396}, { 431,  408}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, { 133,   54}, 
{ 134,  134}, {   0,    0}, {   0,    0}, { 134,   59}, { 134,   59}, 
{ 134,   59}, { 134,   59}, { 134,   59}, { 134,   59}, { 134,   59}, 
{ 134,   59}, { 134,   59}, { 134,   59}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, { 134,   57}, 
{ 134,   57}, { 134,   57}, { 134,   57}, { 135,  381}, { 380,  299}, 
{   0,    0}, {   0,    0}, { 380,  308}, {   0,    0}, { 135,  381}, 
{ 135,  381}, { 135,  381}, { 135,  381}, { 135,   66}, { 135,  381}, 
{ 135,  381}, { 368,  367}, {   0,    0}, {   0,    0}, { 367,  268}, 
{ 368,  329}, {   0,    0}, { 387,  237}, {   0,    0}, { 135,  381}, 
{   0,    0}, { 380,  380}, { 368,  422}, {   0,    0}, { 367,  422}, 
{ 387,  428}, {   0,    0}, { 135,  381}, { 135,  381}, { 135,  381}, 
{ 135,  381}, { 135,  381}, { 179,  179}, { 179,  179}, { 179,  179}, 
{ 179,  179}, { 179,  179}, { 179,  179}, { 179,  179}, { 179,  179}, 
{ 179,  179}, { 179,  179}, { 135,  381}, { 368,  367}, { 135,  381}, 
{ 135,  381}, { 367,  268}, { 368,  329}, { 135,  381}, { 387,  237}, 
{ 135,  381}, {   0,    0}, { 135,  381}, { 179,  286}, { 368,  422}, 
{   0,    0}, { 367,  422}, { 387,  428}, {   0,    0}, { 135,  381}, 
{ 135,  381}, { 135,  381}, { 135,  381}, { 135,  381}, { 287,  345}, 
{ 287,  345}, { 287,  345}, { 287,  345}, { 287,  345}, { 287,  345}, 
{ 287,  345}, { 287,  345}, { 287,  345}, { 287,  345}, { 135,  381}, 
{   0,    0}, { 135,  381}, { 135,  381}, { 136,   93}, {   0,    0}, 
{ 135,  381}, {   0,    0}, { 135,  381}, {   0,    0}, { 135,  381}, 
{ 179,  286}, {   0,    0}, { 136,  136}, { 136,  136}, { 136,  136}, 
{ 136,  136}, { 136,  136}, { 136,  136}, { 136,  136}, { 136,  136}, 
{ 136,  136}, { 136,  136}, { 137,  296}, {   0,    0}, {   0,    0}, 
{ 137,  306}, {   0,    0}, {   0,    0}, {   0,    0}, { 136,  136}, 
{ 136,  136}, { 136,  136}, { 136,  136}, { 136,  136}, { 136,  136}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 334,  332}, { 386,  384}, {   0,    0}, {   0,    0}, { 137,  377}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 137,  382}, {   0,    0}, 
{ 334,  429}, {   0,    0}, { 386,  428}, { 334,  431}, { 137,  382}, 
{ 137,  382}, { 137,  382}, { 137,  382}, { 137,   83}, { 137,  382}, 
{ 137,  382}, { 136,  136}, { 136,  136}, { 136,  136}, { 136,  136}, 
{ 136,  136}, { 136,  136}, {   0,    0}, { 287,  433}, { 137,  382}, 
{   0,    0}, {   0,    0}, { 334,  332}, { 386,  384}, { 395,  389}, 
{   0,    0}, { 392,  230}, { 137,  382}, { 137,  382}, { 137,  382}, 
{ 137,  382}, { 137,  382}, { 334,  429}, {   0,    0}, { 386,  428}, 
{ 334,  431}, { 392,  428}, {   0,    0}, {   0,    0}, { 395,  428}, 
{ 392,  231}, {   0,    0}, { 137,  382}, {   0,    0}, { 137,  382}, 
{ 137,  382}, {   0,    0}, {   0,    0}, { 137,  382}, {   0,    0}, 
{ 137,  382}, { 138,  156}, { 137,  382}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 395,  389}, {   0,    0}, { 392,  230}, { 137,  382}, 
{ 137,  382}, { 137,  382}, { 137,  382}, { 137,  382}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 392,  428}, {   0,    0}, 
{ 138,   38}, { 395,  428}, { 392,  231}, {   0,    0}, { 137,  382}, 
{   0,    0}, { 137,  382}, { 137,  382}, {   0,    0}, {   0,    0}, 
{ 137,  382}, {   0,    0}, { 137,  382}, { 138,  138}, { 137,  382}, 
{   0,    0}, { 138,  109}, { 138,  109}, { 138,  109}, { 138,  109}, 
{ 138,  109}, { 138,  109}, { 138,  109}, { 138,  109}, { 138,  109}, 
{ 138,  109}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, { 138,  428}, 
{ 138,  428}, { 143,  294}, { 345,  201}, {   0,    0}, { 143,  304}, 
{   0,    0}, { 394,  235}, {   0,    0}, {   0,    0}, { 345,  345}, 
{ 345,  345}, { 345,  345}, { 345,  345}, { 345,  345}, { 345,  345}, 
{ 345,  345}, { 345,  345}, { 345,  345}, { 345,  345}, { 394,  390}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 143,  375}, { 394,  428}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 147,  294}, {   0,    0}, 
{   0,    0}, { 147,  304}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 394,  235}, { 143,  324}, 
{ 143,  324}, { 143,  324}, { 143,  324}, { 143,  324}, { 143,  324}, 
{ 143,  324}, { 143,  324}, { 143,  324}, { 143,  324}, {   0,    0}, 
{ 147,  375}, { 394,  390}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 394,  428}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 143,  147}, { 147,  288}, {   0,    0}, { 147,  288}, {   0,    0}, 
{   0,    0}, { 147,  288}, { 147,  288}, { 147,  288}, { 147,  288}, 
{ 147,  288}, { 147,  288}, { 147,  288}, { 147,  288}, { 147,  288}, 
{ 147,  288}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, {   0,    0}, { 143,  147}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, {   0,    0}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, {   0,    0}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, { 157,   85}, 
{ 157,   85}, { 157,   85}, { 157,   85}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, {   0,    0}, {   0,    0}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, {   0,    0}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, {   0,    0}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{   0,    0}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, 
{ 160,  187}, { 160,  187}, { 160,  187}, { 160,  187}, { 163,  296}, 
{   0,    0}, {   0,    0}, { 163,  306}, { 346,  344}, { 346,  344}, 
{ 346,  344}, { 346,  344}, { 346,  344}, { 346,  344}, { 346,  344}, 
{ 346,  344}, { 346,  344}, { 346,  344}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 163,  377}, {   0,    0}, {   0,    0}, { 288,  304}, 
{ 163,   81}, {   0,    0}, {   0,    0}, {   0,    0}, { 163,  287}, 
{   0,    0}, { 163,   81}, { 163,   81}, { 163,   81}, { 163,   81}, 
{ 163,  137}, { 163,   81}, { 163,   81}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 288,  375}, {   0,    0}, 
{   0,    0}, { 163,   81}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 163,   81}, 
{ 163,   81}, { 163,   81}, { 163,   81}, { 163,   81}, { 288,  288}, 
{ 288,  288}, { 288,  288}, { 288,  288}, { 288,  288}, { 288,  288}, 
{ 288,  288}, { 288,  288}, { 288,  288}, { 288,  288}, { 163,   81}, 
{   0,    0}, { 163,   81}, { 163,   81}, {   0,    0}, {   0,    0}, 
{ 163,   81}, {   0,    0}, { 163,   81}, {   0,    0}, { 163,   81}, 
{   0,    0}, {   0,    0}, { 346,  433}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 163,   81}, { 163,   81}, { 163,   81}, { 163,   81}, 
{ 163,   81}, { 348,  342}, { 348,  342}, { 348,  342}, { 348,  342}, 
{ 348,  342}, { 348,  342}, { 348,  342}, { 348,  342}, { 348,  342}, 
{ 348,  342}, { 163,   81}, {   0,    0}, { 163,   81}, { 163,   81}, 
{   0,    0}, {   0,    0}, { 163,   81}, {   0,    0}, { 163,   81}, 
{   0,    0}, { 163,   81}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, {   0,    0}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, {   0,    0}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, { 166,  166}, 
{ 166,  166}, { 166,  166}, { 166,  166}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, {   0,    0}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{   0,    0}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, 
{ 167,  167}, { 167,  167}, { 167,  167}, { 167,  167}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,   40}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, {   0,    0}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, { 170,  429}, 
{ 171,  134}, {   0,    0}, {   0,    0}, { 171,   59}, { 171,   59}, 
{ 171,   59}, { 171,   59}, { 171,   59}, { 171,   59}, { 171,   59}, 
{ 171,   59}, { 171,   59}, { 171,   59}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, { 171,   57}, 
{ 171,   57}, { 171,   57}, { 171,   57}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,   40}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  181}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  339}, { 181,  429}, 
{ 181,  181}, { 181,  181}, { 181,  181}, { 181,  181}, { 181,  269}, 
{ 181,  181}, { 181,  181}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  181}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  181}, { 181,  181}, 
{ 181,  181}, { 181,  181}, { 181,  181}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  181}, { 181,  429}, 
{ 181,  181}, { 181,  181}, { 181,  429}, { 181,  429}, { 181,  181}, 
{ 181,  429}, { 181,  181}, { 181,  429}, { 181,  181}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  181}, { 181,  181}, { 181,  181}, { 181,  181}, { 181,  181}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  181}, { 181,  429}, { 181,  181}, { 181,  181}, { 181,  429}, 
{ 181,  429}, { 181,  181}, { 181,  429}, { 181,  181}, { 181,  429}, 
{ 181,  181}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{   0,    0}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, 
{ 181,  429}, { 181,  429}, { 181,  429}, { 181,  429}, { 182,   65}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 182,   65}, { 182,   65}, { 182,   65}, { 182,   65}, { 182,  135}, 
{ 182,   65}, { 182,   65}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 182,   65}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 182,   65}, { 182,   65}, 
{ 182,   65}, { 182,   65}, { 182,   65}, { 397,  397}, { 397,  397}, 
{ 397,  397}, { 397,  397}, { 397,  397}, { 397,  397}, { 397,  397}, 
{ 397,  397}, { 397,  397}, { 397,  397}, { 182,   65}, {   0,    0}, 
{ 182,   65}, { 182,   65}, {   0,    0}, {   0,    0}, { 182,   65}, 
{   0,    0}, { 182,   65}, {   0,    0}, { 182,   65}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 182,   65}, { 182,   65}, { 182,   65}, { 182,   65}, { 182,   65}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 182,   65}, {   0,    0}, { 182,   65}, { 182,   65}, {   0,    0}, 
{   0,    0}, { 182,   65}, {   0,    0}, { 182,   65}, {   0,    0}, 
{ 182,   65}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{   0,    0}, {   0,    0}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, {   0,    0}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, {   0,    0}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, { 184,  184}, 
{ 184,  184}, { 184,  184}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, {   0,    0}, {   0,    0}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, {   0,    0}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, {   0,    0}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, {   0,    0}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, { 186,  186}, 
{ 186,  186}, { 186,  186}, { 186,  186}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, {   0,    0}, {   0,    0}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, {   0,    0}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, {   0,    0}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{   0,    0}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, 
{ 187,  187}, { 187,  187}, { 187,  187}, { 187,  187}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, {   0,    0}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, {   0,    0}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, { 191,  191}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{   0,    0}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, {   0,    0}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, { 192,  192}, 
{ 192,  192}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, {   0,    0}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, {   0,    0}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, { 196,  196}, 
{ 196,  196}, { 196,  196}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, {   0,    0}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, {   0,    0}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, { 197,  197}, 
{ 197,  197}, { 197,  197}, { 197,  197}, { 200,  164}, {   0,    0}, 
{   0,    0}, { 200,  370}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 399,  238}, { 399,  238}, { 399,  238}, { 399,  238}, 
{ 399,  238}, { 399,  238}, { 399,  238}, { 399,  238}, { 399,  238}, 
{ 399,  238}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 200,  336}, {   0,    0}, {   0,    0}, {   0,    0}, { 200,  200}, 
{   0,    0}, {   0,    0}, { 399,  401}, { 200,  340}, {   0,    0}, 
{ 200,  200}, { 200,  200}, { 200,  200}, { 200,  200}, { 200,  270}, 
{ 200,  200}, { 200,  200}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 200,  200}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 200,  200}, { 200,  200}, 
{ 200,  200}, { 200,  200}, { 200,  200}, { 201,  296}, { 399,  401}, 
{   0,    0}, { 201,  306}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 200,  200}, {   0,    0}, 
{ 200,  200}, { 200,  200}, {   0,    0}, {   0,    0}, { 200,  200}, 
{   0,    0}, { 200,  200}, {   0,    0}, { 200,  200}, {   0,    0}, 
{ 201,  377}, {   0,    0}, {   0,    0}, {   0,    0}, { 201,   81}, 
{ 200,  200}, { 200,  200}, { 200,  200}, { 200,  200}, { 200,  200}, 
{ 201,   81}, { 201,   81}, { 201,   81}, { 201,   81}, { 201,  137}, 
{ 201,   81}, { 201,   81}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 200,  200}, {   0,    0}, { 200,  200}, { 200,  200}, {   0,    0}, 
{ 201,   81}, { 200,  200}, {   0,    0}, { 200,  200}, {   0,    0}, 
{ 200,  200}, {   0,    0}, {   0,    0}, { 201,   81}, { 201,   81}, 
{ 201,   81}, { 201,   81}, { 201,   81}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 201,   81}, {   0,    0}, 
{ 201,   81}, { 201,   81}, {   0,    0}, {   0,    0}, { 201,   81}, 
{   0,    0}, { 201,   81}, {   0,    0}, { 201,   81}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 201,   81}, { 201,   81}, { 201,   81}, { 201,   81}, { 201,   81}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 201,   81}, {   0,    0}, { 201,   81}, { 201,   81}, {   0,    0}, 
{   0,    0}, { 201,   81}, {   0,    0}, { 201,   81}, {   0,    0}, 
{ 201,   81}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{   0,    0}, { 202,  164}, { 202,  429}, { 202,  429}, { 202,  370}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  336}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  200}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  200}, { 202,  200}, 
{ 202,  200}, { 202,  200}, { 202,  270}, { 202,  200}, { 202,  200}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  200}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  200}, { 202,  200}, { 202,  200}, { 202,  200}, 
{ 202,  200}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  200}, { 202,  429}, { 202,  200}, { 202,  200}, 
{ 202,  429}, { 202,  429}, { 202,  200}, { 202,  429}, { 202,  200}, 
{ 202,  429}, { 202,  200}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  200}, { 202,  200}, 
{ 202,  200}, { 202,  200}, { 202,  200}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  200}, { 202,  429}, 
{ 202,  200}, { 202,  200}, { 202,  429}, { 202,  429}, { 202,  200}, 
{ 202,  429}, { 202,  200}, { 202,  429}, { 202,  200}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, {   0,    0}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, { 202,  429}, 
{ 202,  429}, { 202,  429}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  429}, { 203,   40}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  429}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, {   0,    0}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, { 203,  203}, 
{ 203,  203}, { 203,  203}, { 203,  203}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, {   0,    0}, { 204,  165}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, {   0,    0}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{   0,    0}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, 
{ 204,   85}, { 204,   85}, { 204,   85}, { 204,   85}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, {   0,    0}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, {   0,    0}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, { 207,  207}, 
{ 210,  292}, {   0,    0}, {   0,    0}, { 210,  303}, { 400,  179}, 
{ 400,  179}, { 400,  179}, { 400,  179}, { 400,  179}, { 400,  179}, 
{ 400,  179}, { 400,  179}, { 400,  179}, { 400,  179}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 210,  374}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 210,  281}, {   0,    0}, {   0,    0}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  428}, { 210,  428}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, { 210,  249}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, {   0,    0}, {   0,    0}, { 400,  433}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  249}, { 210,  428}, { 210,  428}, { 210,  428}, 
{ 210,  428}, { 210,  428}, { 210,  428}, { 211,  292}, {   0,    0}, 
{   0,    0}, { 211,  303}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 211,  374}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 211,  281}, {   0,    0}, 
{   0,    0}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, 
{ 211,  428}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 211,  428}, { 211,  106}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  106}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, { 211,  428}, 
{ 211,  428}, { 217,  292}, {   0,    0}, {   0,    0}, { 217,  303}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 217,  374}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 217,  281}, {   0,    0}, {   0,    0}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 217,  428}, { 217,  428}, { 217,  211}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, 
{ 217,  428}, { 217,  428}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 217,  428}, { 217,  428}, 
{ 217,  211}, { 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, 
{ 217,  428}, { 217,  428}, { 217,  428}, { 217,  428}, { 222,  292}, 
{   0,    0}, {   0,    0}, { 222,  303}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 222,  374}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 222,  281}, 
{   0,    0}, {   0,    0}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  428}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 222,  428}, 
{ 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  221}, 
{ 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  221}, { 222,  428}, { 222,  428}, { 222,  428}, 
{ 222,  428}, { 222,  428}, { 234,  292}, {   0,    0}, {   0,    0}, 
{ 234,  303}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 234,  374}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 234,  281}, {   0,    0}, {   0,    0}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  224}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 234,  224}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, { 234,  428}, 
{ 238,  295}, {   0,    0}, {   0,    0}, { 238,  305}, { 269,  181}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 269,  181}, { 269,  181}, { 269,  181}, { 269,  181}, { 269,  269}, 
{ 269,  181}, { 269,  181}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 238,  376}, {   0,    0}, {   0,    0}, 
{ 269,  181}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 269,  181}, { 269,  181}, 
{ 269,  181}, { 269,  181}, { 269,  181}, { 238,  238}, { 238,  238}, 
{ 238,  238}, { 238,  238}, { 238,  238}, { 238,  238}, { 238,  238}, 
{ 238,  238}, { 238,  238}, { 238,  238}, { 269,  181}, {   0,    0}, 
{ 269,  181}, { 269,  181}, {   0,    0}, {   0,    0}, { 269,  181}, 
{   0,    0}, { 269,  181}, {   0,    0}, { 269,  181}, { 238,  289}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 269,  181}, { 269,  181}, { 269,  181}, { 269,  181}, { 269,  181}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 269,  181}, {   0,    0}, { 269,  181}, { 269,  181}, {   0,    0}, 
{   0,    0}, { 269,  181}, {   0,    0}, { 269,  181}, {   0,    0}, 
{ 269,  181}, { 238,  289}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,   40}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, {   0,    0}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, { 241,  429}, 
{ 241,  429}, { 241,  429}, { 241,  429}, { 247,  281}, {   0,    0}, 
{   0,    0}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, 
{ 247,  428}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 247,  428}, { 247,  222}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  222}, 
{ 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, { 247,  428}, 
{ 247,  428}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, {   0,    0}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,   42}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, {   0,    0}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, { 253,  335}, 
{ 253,  335}, { 253,  335}, { 255,  132}, {   0,    0}, {   0,    0}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 255,  422}, { 255,   49}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,   49}, { 255,  422}, 
{ 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, { 255,  422}, 
{ 259,  132}, {   0,    0}, {   0,    0}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,  422}, { 259,  422}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, { 259,   47}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,   47}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, { 259,  422}, 
{ 259,  422}, { 259,  422}, { 259,  422}, { 263,  132}, {   0,    0}, 
{   0,    0}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 263,  262}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 263,  262}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, { 263,  422}, 
{ 263,  422}, { 270,  164}, {   0,    0}, {   0,    0}, { 270,  370}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 270,  336}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 270,  200}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 270,  200}, { 270,  200}, 
{ 270,  200}, { 270,  200}, { 270,  270}, { 270,  200}, { 270,  200}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 270,  200}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 270,  200}, { 270,  200}, { 270,  200}, { 270,  200}, 
{ 270,  200}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 270,  200}, {   0,    0}, { 270,  200}, { 270,  200}, 
{   0,    0}, {   0,    0}, { 270,  200}, {   0,    0}, { 270,  200}, 
{   0,    0}, { 270,  200}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 270,  200}, { 270,  200}, 
{ 270,  200}, { 270,  200}, { 270,  200}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 270,  200}, {   0,    0}, 
{ 270,  200}, { 270,  200}, {   0,    0}, {   0,    0}, { 270,  200}, 
{   0,    0}, { 270,  200}, {   0,    0}, { 270,  200}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  360}, 
{ 273,  197}, { 273,  197}, { 273,  195}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  273}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,   78}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, {   0,    0}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, { 273,  197}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  297}, { 274,  192}, { 274,  192}, { 274,  190}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  274}, { 274,  192}, { 274,   73}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, {   0,    0}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, { 274,  192}, 
{ 274,  192}, { 275,  275}, {   0,    0}, {   0,    0}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, 
{ 275,   57}, { 275,   57}, { 275,   57}, { 275,   57}, { 276,  381}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 276,  381}, { 276,  381}, { 276,  381}, { 276,  381}, { 276,  276}, 
{ 276,  381}, { 276,  381}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 276,  381}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 276,  381}, { 276,  381}, 
{ 276,  381}, { 276,  381}, { 276,  381}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 276,  381}, {   0,    0}, 
{ 276,  381}, { 276,  381}, {   0,    0}, {   0,    0}, { 276,  381}, 
{   0,    0}, { 276,  381}, {   0,    0}, { 276,  381}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 276,  381}, { 276,  381}, { 276,  381}, { 276,  381}, { 276,  381}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 276,  381}, {   0,    0}, { 276,  381}, { 276,  381}, {   0,    0}, 
{   0,    0}, { 276,  381}, {   0,    0}, { 276,  381}, {   0,    0}, 
{ 276,  381}, { 279,  278}, { 279,  278}, { 279,  278}, { 279,  278}, 
{ 279,  278}, { 279,  278}, { 279,  278}, { 279,  278}, { 279,  278}, 
{ 279,  278}, { 280,  296}, {   0,    0}, {   0,    0}, { 280,  306}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 279,  278}, { 279,  278}, 
{ 279,  278}, { 279,  278}, { 279,  278}, { 279,  278}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 280,  377}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 280,  382}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 280,  382}, { 280,  382}, 
{ 280,  382}, { 280,  382}, { 280,  280}, { 280,  382}, { 280,  382}, 
{ 279,  278}, { 279,  278}, { 279,  278}, { 279,  278}, { 279,  278}, 
{ 279,  278}, {   0,    0}, {   0,    0}, { 280,  382}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 280,  382}, { 280,  382}, { 280,  382}, { 280,  382}, 
{ 280,  382}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 280,  382}, {   0,    0}, { 280,  382}, { 280,  382}, 
{   0,    0}, {   0,    0}, { 280,  382}, {   0,    0}, { 280,  382}, 
{ 281,  303}, { 280,  382}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 280,  382}, { 280,  382}, 
{ 280,  382}, { 280,  382}, { 280,  382}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 281,  374}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 280,  382}, {   0,    0}, 
{ 280,  382}, { 280,  382}, {   0,    0}, {   0,    0}, { 280,  382}, 
{   0,    0}, { 280,  382}, { 281,  281}, { 280,  382}, {   0,    0}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, { 281,  428}, 
{ 289,  305}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 289,  376}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 289,  148}, {   0,    0}, { 289,  148}, {   0,    0}, {   0,    0}, 
{ 289,   95}, { 289,   95}, { 289,   95}, { 289,   95}, { 289,   95}, 
{ 289,   95}, { 289,   95}, { 289,   95}, { 289,   95}, { 289,   95}, 
{ 311,  275}, {   0,    0}, {   0,    0}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, { 311,   57}, 
{ 311,   57}, { 311,   57}, { 311,   57}, { 315,  381}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 315,  381}, 
{ 315,  381}, { 315,  381}, { 315,  381}, { 315,  276}, { 315,  381}, 
{ 315,  381}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 315,  381}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 315,  381}, { 315,  381}, { 315,  381}, 
{ 315,  381}, { 315,  381}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 315,  381}, {   0,    0}, { 315,  381}, 
{ 315,  381}, {   0,    0}, {   0,    0}, { 315,  381}, {   0,    0}, 
{ 315,  381}, {   0,    0}, { 315,  381}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 315,  381}, 
{ 315,  381}, { 315,  381}, { 315,  381}, { 315,  381}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 315,  381}, 
{   0,    0}, { 315,  381}, { 315,  381}, {   0,    0}, {   0,    0}, 
{ 315,  381}, {   0,    0}, { 315,  381}, {   0,    0}, { 315,  381}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,   40}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  316}, { 316,  191}, { 316,  193}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, {   0,    0}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, { 316,  191}, 
{ 316,  191}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, {   0,    0}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  317}, { 317,  192}, 
{ 317,   73}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, {   0,    0}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, { 317,  192}, 
{ 317,  192}, { 317,  192}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, {   0,    0}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  318}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  198}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, {   0,    0}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, { 318,  196}, 
{ 318,  196}, { 318,  196}, { 318,  196}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, {   0,    0}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  319}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,   78}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{   0,    0}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, 
{ 319,  197}, { 319,  197}, { 319,  197}, { 319,  197}, { 321,  296}, 
{   0,    0}, {   0,    0}, { 321,  306}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 321,  377}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 321,  382}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 321,  382}, { 321,  382}, { 321,  382}, { 321,  382}, 
{ 321,  280}, { 321,  382}, { 321,  382}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 321,  382}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 321,  382}, 
{ 321,  382}, { 321,  382}, { 321,  382}, { 321,  382}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 321,  382}, 
{   0,    0}, { 321,  382}, { 321,  382}, {   0,    0}, {   0,    0}, 
{ 321,  382}, {   0,    0}, { 321,  382}, {   0,    0}, { 321,  382}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 321,  382}, { 321,  382}, { 321,  382}, { 321,  382}, 
{ 321,  382}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 321,  382}, {   0,    0}, { 321,  382}, { 321,  382}, 
{   0,    0}, {   0,    0}, { 321,  382}, {   0,    0}, { 321,  382}, 
{   0,    0}, { 321,  382}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, {   0,    0}, {   0,    0}, { 322,   85}, { 322,   85}, 
{ 322,  204}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,  322}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,  157}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, {   0,    0}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, {   0,    0}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, { 322,   85}, 
{ 322,   85}, { 322,   85}, { 322,   85}, { 324,  294}, {   0,    0}, 
{   0,    0}, { 324,  304}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 341,  136}, 
{ 341,  136}, { 341,  136}, { 341,  136}, { 341,  136}, { 341,  136}, 
{ 341,  136}, { 341,  136}, { 341,  136}, { 341,  136}, {   0,    0}, 
{ 324,  375}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 341,  136}, { 341,  136}, { 341,  136}, { 341,  136}, 
{ 341,  136}, { 341,  136}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 324,  324}, { 324,  324}, { 324,  324}, { 324,  324}, 
{ 324,  324}, { 324,  324}, { 324,  324}, { 324,  324}, { 324,  324}, 
{ 324,  324}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 324,  350}, { 341,  136}, { 341,  136}, 
{ 341,  136}, { 341,  136}, { 341,  136}, { 341,  136}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 328,  132}, {   0,    0}, {   0,    0}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  422}, { 328,  422}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 324,  350}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, { 328,  255}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  255}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, { 328,  422}, 
{ 328,  422}, { 328,  422}, { 328,  422}, { 330,  181}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 330,  181}, 
{ 330,  181}, { 330,  181}, { 330,  181}, { 330,  183}, { 330,  181}, 
{ 330,  181}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 330,  181}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 330,  181}, { 330,  181}, { 330,  181}, 
{ 330,  181}, { 330,  181}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 330,  429}, { 330,  181}, {   0,    0}, { 330,  181}, 
{ 330,  181}, {   0,    0}, {   0,    0}, { 330,  181}, {   0,    0}, 
{ 330,  181}, {   0,    0}, { 330,  181}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 331,  200}, { 330,  181}, 
{ 330,  181}, { 330,  181}, { 330,  181}, { 330,  181}, { 331,  200}, 
{ 331,  200}, { 331,  200}, { 331,  200}, { 331,  202}, { 331,  200}, 
{ 331,  200}, {   0,    0}, {   0,    0}, { 330,  429}, { 330,  181}, 
{   0,    0}, { 330,  181}, { 330,  181}, {   0,    0}, { 331,  200}, 
{ 330,  181}, {   0,    0}, { 330,  181}, {   0,    0}, { 330,  181}, 
{   0,    0}, {   0,    0}, { 331,  200}, { 331,  200}, { 331,  200}, 
{ 331,  200}, { 331,  200}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 331,  200}, {   0,    0}, { 331,  200}, 
{ 331,  200}, {   0,    0}, {   0,    0}, { 331,  200}, {   0,    0}, 
{ 331,  200}, {   0,    0}, { 331,  200}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 331,  200}, 
{ 331,  200}, { 331,  200}, { 331,  200}, { 331,  200}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 331,  200}, 
{   0,    0}, { 331,  200}, { 331,  200}, {   0,    0}, {   0,    0}, 
{ 331,  200}, {   0,    0}, { 331,  200}, {   0,    0}, { 331,  200}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,   40}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  272}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  272}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, {   0,    0}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, { 332,  429}, 
{ 332,  429}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, {   0,    0}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,   42}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, {   0,    0}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, { 335,  335}, 
{ 335,  335}, { 335,  335}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,   40}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  417}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  337}, { 337,  337}, { 337,  337}, { 337,  337}, { 337,  337}, 
{ 337,  337}, { 337,  337}, { 337,  337}, { 337,  337}, { 337,  337}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, {   0,    0}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, { 337,  429}, 
{ 337,  429}, { 337,  429}, { 337,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,   40}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  416}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  338}, { 338,  338}, { 338,  338}, { 338,  338}, 
{ 338,  338}, { 338,  338}, { 338,  338}, { 338,  338}, { 338,  338}, 
{ 338,  338}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{   0,    0}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, 
{ 338,  429}, { 338,  429}, { 338,  429}, { 338,  429}, { 349,  295}, 
{   0,    0}, {   0,    0}, { 349,  305}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 350,  294}, 
{   0,    0}, {   0,    0}, { 350,  304}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 349,  376}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 350,  375}, { 349,  349}, { 349,  349}, { 349,  349}, 
{ 349,  349}, { 349,  349}, { 349,  349}, { 349,  349}, { 349,  349}, 
{ 349,  349}, { 349,  349}, { 350,  402}, {   0,    0}, { 350,  402}, 
{   0,    0}, {   0,    0}, { 350,  397}, { 350,  397}, { 350,  397}, 
{ 350,  397}, { 350,  397}, { 350,  397}, { 350,  397}, { 350,  397}, 
{ 350,  397}, { 350,  397}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, {   0,    0}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  363}, 
{ 363,  192}, { 363,   72}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, {   0,    0}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, { 363,  192}, 
{ 363,  192}, { 363,  192}, { 363,  192}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, {   0,    0}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  364}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,   77}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{   0,    0}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, 
{ 364,  197}, { 364,  197}, { 364,  197}, { 364,  197}, { 365,  132}, 
{   0,    0}, {   0,    0}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  422}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 365,  422}, 
{ 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  267}, 
{ 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  267}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, { 365,  422}, 
{ 365,  422}, { 365,  422}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, {   0,    0}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,   41}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, {   0,    0}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, { 369,  369}, 
{ 369,  369}, { 369,  369}, { 369,  369}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  164}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{   0,    0}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, 
{ 370,  429}, { 370,  429}, { 370,  429}, { 370,  429}, { 381,  381}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 381,  348}, {   0,    0}, 
{ 381,  381}, { 381,  381}, { 381,  381}, { 381,  381}, { 381,  276}, 
{ 381,  381}, { 381,  381}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 381,  381}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 381,  381}, { 381,  381}, 
{ 381,  381}, { 381,  381}, { 381,  381}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 381,  381}, {   0,    0}, 
{ 381,  381}, { 381,  381}, {   0,    0}, {   0,    0}, { 381,  381}, 
{   0,    0}, { 381,  381}, {   0,    0}, { 381,  381}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 381,  381}, { 381,  381}, { 381,  381}, { 381,  381}, { 381,  381}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 381,  381}, { 402,  294}, { 381,  381}, { 381,  381}, { 402,  304}, 
{ 382,  382}, { 381,  381}, {   0,    0}, { 381,  381}, { 382,  346}, 
{ 381,  381}, { 382,  382}, { 382,  382}, { 382,  382}, { 382,  382}, 
{ 382,  280}, { 382,  382}, { 382,  382}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 402,  375}, {   0,    0}, 
{   0,    0}, { 382,  382}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 382,  382}, 
{ 382,  382}, { 382,  382}, { 382,  382}, { 382,  382}, { 402,  397}, 
{ 402,  397}, { 402,  397}, { 402,  397}, { 402,  397}, { 402,  397}, 
{ 402,  397}, { 402,  397}, { 402,  397}, { 402,  397}, { 382,  382}, 
{   0,    0}, { 382,  382}, { 382,  382}, {   0,    0}, {   0,    0}, 
{ 382,  382}, {   0,    0}, { 382,  382}, {   0,    0}, { 382,  382}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 382,  382}, { 382,  382}, { 382,  382}, { 382,  382}, 
{ 382,  382}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 382,  382}, {   0,    0}, { 382,  382}, { 382,  382}, 
{   0,    0}, {   0,    0}, { 382,  382}, {   0,    0}, { 382,  382}, 
{ 383,  281}, { 382,  382}, {   0,    0}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  428}, { 383,  428}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, { 383,  214}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  214}, { 383,  428}, { 383,  428}, { 383,  428}, 
{ 383,  428}, { 383,  428}, { 383,  428}, { 389,  281}, {   0,    0}, 
{   0,    0}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  428}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 389,  428}, { 389,  428}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  234}, { 389,  428}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  234}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, { 389,  428}, 
{ 389,  428}, { 393,  281}, {   0,    0}, {   0,    0}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 393,  428}, { 393,  428}, { 393,  387}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, 
{ 393,  428}, { 393,  428}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 393,  428}, { 393,  428}, 
{ 393,  387}, { 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, 
{ 393,  428}, { 393,  428}, { 393,  428}, { 393,  428}, { 401,  295}, 
{   0,    0}, {   0,    0}, { 401,  305}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 401,  376}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 401,  349}, {   0,    0}, { 401,  349}, 
{   0,    0}, {   0,    0}, { 401,  349}, { 401,  349}, { 401,  349}, 
{ 401,  349}, { 401,  349}, { 401,  349}, { 401,  349}, { 401,  349}, 
{ 401,  349}, { 401,  349}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,   40}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  404}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  404}, 
{ 403,  404}, { 403,  404}, { 403,  404}, { 403,  330}, { 403,  404}, 
{ 403,  404}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  404}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  404}, { 403,  404}, { 403,  404}, 
{ 403,  404}, { 403,  404}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  404}, { 403,  429}, { 403,  404}, 
{ 403,  404}, { 403,  429}, { 403,  429}, { 403,  404}, { 403,  429}, 
{ 403,  404}, { 403,  429}, { 403,  404}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  404}, 
{ 403,  404}, { 403,  404}, { 403,  404}, { 403,  404}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  404}, 
{ 403,  429}, { 403,  404}, { 403,  404}, { 403,  429}, { 403,  429}, 
{ 403,  404}, { 403,  429}, { 403,  404}, { 403,  429}, { 403,  404}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, {   0,    0}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, { 403,  429}, 
{ 403,  429}, { 403,  429}, { 403,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  164}, { 405,  429}, 
{ 405,  429}, { 405,  370}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  336}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  406}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  406}, { 405,  406}, { 405,  406}, { 405,  406}, { 405,  331}, 
{ 405,  406}, { 405,  406}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  406}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  406}, { 405,  406}, 
{ 405,  406}, { 405,  406}, { 405,  406}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  406}, { 405,  429}, 
{ 405,  406}, { 405,  406}, { 405,  429}, { 405,  429}, { 405,  406}, 
{ 405,  429}, { 405,  406}, { 405,  429}, { 405,  406}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  406}, { 405,  406}, { 405,  406}, { 405,  406}, { 405,  406}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  406}, { 405,  429}, { 405,  406}, { 405,  406}, { 405,  429}, 
{ 405,  429}, { 405,  406}, { 405,  429}, { 405,  406}, { 405,  429}, 
{ 405,  406}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{   0,    0}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, 
{ 405,  429}, { 405,  429}, { 405,  429}, { 405,  429}, { 416,  181}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 416,  181}, { 416,  181}, { 416,  181}, { 416,  181}, { 416,  269}, 
{ 416,  181}, { 416,  181}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 416,  181}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 416,  181}, { 416,  181}, 
{ 416,  181}, { 416,  181}, { 416,  181}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 416,  181}, {   0,    0}, 
{ 416,  181}, { 416,  181}, {   0,    0}, {   0,    0}, { 416,  181}, 
{   0,    0}, { 416,  181}, {   0,    0}, { 416,  181}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 417,  200}, 
{ 416,  181}, { 416,  181}, { 416,  181}, { 416,  181}, { 416,  181}, 
{ 417,  200}, { 417,  200}, { 417,  200}, { 417,  200}, { 417,  270}, 
{ 417,  200}, { 417,  200}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 416,  181}, {   0,    0}, { 416,  181}, { 416,  181}, {   0,    0}, 
{ 417,  200}, { 416,  181}, {   0,    0}, { 416,  181}, {   0,    0}, 
{ 416,  181}, {   0,    0}, {   0,    0}, { 417,  200}, { 417,  200}, 
{ 417,  200}, { 417,  200}, { 417,  200}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, { 417,  200}, {   0,    0}, 
{ 417,  200}, { 417,  200}, {   0,    0}, {   0,    0}, { 417,  200}, 
{   0,    0}, { 417,  200}, {   0,    0}, { 417,  200}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 417,  200}, { 417,  200}, { 417,  200}, { 417,  200}, { 417,  200}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 417,  200}, {   0,    0}, { 417,  200}, { 417,  200}, {   0,    0}, 
{   0,    0}, { 417,  200}, {   0,    0}, { 417,  200}, { 422,  132}, 
{ 417,  200}, {   0,    0}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, { 422,  422}, 
{ 422,  422}, { 422,  422}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,   40}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  405}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  424}, { 424,  424}, { 424,  424}, { 424,  424}, { 424,  424}, 
{ 424,  424}, { 424,  424}, { 424,  424}, { 424,  424}, { 424,  424}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, {   0,    0}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, { 424,  429}, 
{ 424,  429}, { 424,  429}, { 424,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,   40}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  403}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  425}, { 425,  425}, { 425,  425}, { 425,  425}, 
{ 425,  425}, { 425,  425}, { 425,  425}, { 425,  425}, { 425,  425}, 
{ 425,  425}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{   0,    0}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, 
{ 425,  429}, { 425,  429}, { 425,  429}, { 425,  429}, { 428,  292}, 
{   0,    0}, {   0,    0}, { 428,  303}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 428,  374}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 428,  281}, 
{   0,    0}, {   0,    0}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, { 428,  428}, 
{ 428,  428}, { 428,  428}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,   40}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, {   0,    0}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, { 429,  429}, 
{ 429,  429}, { 429,  429}, { 429,  429}, 
};
static	yyCombType *	yyBasePtr	[yyDStateCount + 1] = { 0,
& yyComb [   0], & yyComb [ 224], & yyComb [ 325], & yyComb [ 225], 
& yyComb [ 581], & yyComb [ 232], & yyComb [ 837], & yyComb [ 244], 
& yyComb [1093], & yyComb [1349], & yyComb [1605], & yyComb [1861], 
& yyComb [2117], & yyComb [ 251], & yyComb [2373], & yyComb [  82], 
& yyComb [2629], & yyComb [ 252], & yyComb [2885], & yyComb [ 268], 
& yyComb [3141], & yyComb [ 269], & yyComb [3397], & yyComb [ 276], 
& yyComb [3653], & yyComb [3877], & yyComb [3925], & yyComb [4149], 
& yyComb [4197], & yyComb [4421], & yyComb [4469], & yyComb [4503], 
& yyComb [4691], & yyComb [4683], & yyComb [4722], & yyComb [4850], 
& yyComb [   0], & yyComb [4733], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [ 213], & yyComb [5061], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [5184], 
& yyComb [5440], & yyComb [5651], & yyComb [   0], & yyComb [   0], 
& yyComb [5729], & yyComb [ 250], & yyComb [4705], & yyComb [4469], 
& yyComb [5804], & yyComb [5814], & yyComb [5828], & yyComb [5850], 
& yyComb [5931], & yyComb [   0], & yyComb [ 201], & yyComb [6054], 
& yyComb [   0], & yyComb [6310], & yyComb [6566], & yyComb [   0], 
& yyComb [ 136], & yyComb [   0], & yyComb [6822], & yyComb [7078], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [7324], 
& yyComb [7405], & yyComb [   0], & yyComb [7465], & yyComb [   0], 
& yyComb [7588], & yyComb [7844], & yyComb [8090], & yyComb [8181], 
& yyComb [ 202], & yyComb [8116], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [5953], & yyComb [   0], 
& yyComb [8427], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [5872], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [8440], & yyComb [1093], & yyComb [   0], 
& yyComb [8553], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [8611], & yyComb [7293], 
& yyComb [8857], & yyComb [8872], & yyComb [ 223], & yyComb [ 146], 
& yyComb [ 207], & yyComb [4466], & yyComb [   0], & yyComb [   0], 
& yyComb [8931], & yyComb [9187], & yyComb [9443], & yyComb [9654], 
& yyComb [9732], & yyComb [9810], & yyComb [9897], & yyComb [9974], 
& yyComb [10022], & yyComb [10098], & yyComb [4458], & yyComb [4474], 
& yyComb [4462], & yyComb [4459], & yyComb [10211], & yyComb [4468], 
& yyComb [5904], & yyComb [5985], & yyComb [10238], & yyComb [8101], 
& yyComb [4479], & yyComb [4467], & yyComb [4463], & yyComb [4545], 
& yyComb [4732], & yyComb [ 233], & yyComb [ 271], & yyComb [ 285], 
& yyComb [10302], & yyComb [ 270], & yyComb [ 271], & yyComb [10558], 
& yyComb [   0], & yyComb [ 266], & yyComb [10804], & yyComb [ 264], 
& yyComb [   0], & yyComb [10927], & yyComb [11183], & yyComb [ 309], 
& yyComb [ 193], & yyComb [11439], & yyComb [11650], & yyComb [ 442], 
& yyComb [   0], & yyComb [   0], & yyComb [7378], & yyComb [   0], 
& yyComb [8412], & yyComb [8520], & yyComb [9919], & yyComb [   0], 
& yyComb [11773], & yyComb [11993], & yyComb [ 668], & yyComb [12116], 
& yyComb [4478], & yyComb [12372], & yyComb [12628], & yyComb [ 954], 
& yyComb [5877], & yyComb [1349], & yyComb [12884], & yyComb [13140], 
& yyComb [   0], & yyComb [7325], & yyComb [1466], & yyComb [13396], 
& yyComb [13652], & yyComb [   0], & yyComb [   0], & yyComb [13898], 
& yyComb [13958], & yyComb [14081], & yyComb [14337], & yyComb [14593], 
& yyComb [1488], & yyComb [   0], & yyComb [14849], & yyComb [1722], 
& yyComb [4554], & yyComb [15095], & yyComb [15208], & yyComb [4488], 
& yyComb [4490], & yyComb [4679], & yyComb [4680], & yyComb [5660], 
& yyComb [15321], & yyComb [4715], & yyComb [4717], & yyComb [4718], 
& yyComb [4731], & yyComb [15434], & yyComb [5036], & yyComb [5928], 
& yyComb [7370], & yyComb [7342], & yyComb [7386], & yyComb [5708], 
& yyComb [7398], & yyComb [5052], & yyComb [5053], & yyComb [5054], 
& yyComb [5830], & yyComb [15547], & yyComb [5048], & yyComb [5637], 
& yyComb [5629], & yyComb [15660], & yyComb [1795], & yyComb [1912], 
& yyComb [15762], & yyComb [   0], & yyComb [   0], & yyComb [7365], 
& yyComb [   0], & yyComb [   0], & yyComb [15973], & yyComb [5853], 
& yyComb [2198], & yyComb [   0], & yyComb [   0], & yyComb [5847], 
& yyComb [16096], & yyComb [5712], & yyComb [16307], & yyComb [5659], 
& yyComb [5705], & yyComb [5915], & yyComb [16385], & yyComb [5722], 
& yyComb [5907], & yyComb [5931], & yyComb [16463], & yyComb [5728], 
& yyComb [7303], & yyComb [7300], & yyComb [5826], & yyComb [7384], 
& yyComb [15638], & yyComb [16576], & yyComb [5794], & yyComb [7327], 
& yyComb [16699], & yyComb [16955], & yyComb [17166], & yyComb [17253], 
& yyComb [7286], & yyComb [2466], & yyComb [17328], & yyComb [17376], 
& yyComb [17452], & yyComb [5923], & yyComb [5917], & yyComb [7332], 
& yyComb [8843], & yyComb [3867], & yyComb [9951], & yyComb [10826], 
& yyComb [17562], & yyComb [7444], & yyComb [4721], & yyComb [2711], 
& yyComb [5853], & yyComb [2967], & yyComb [3223], & yyComb [3479], 
& yyComb [3735], & yyComb [3866], & yyComb [3869], & yyComb [3905], 
& yyComb [7445], & yyComb [3906], & yyComb [3907], & yyComb [3908], 
& yyComb [3910], & yyComb [3911], & yyComb [3913], & yyComb [4444], 
& yyComb [4150], & yyComb [4152], & yyComb [17575], & yyComb [   0], 
& yyComb [7487], & yyComb [   0], & yyComb [17662], & yyComb [17785], 
& yyComb [18041], & yyComb [18297], & yyComb [18553], & yyComb [7401], 
& yyComb [18799], & yyComb [18922], & yyComb [8438], & yyComb [19168], 
& yyComb [5855], & yyComb [   0], & yyComb [   0], & yyComb [19205], 
& yyComb [7467], & yyComb [19292], & yyComb [19352], & yyComb [19475], 
& yyComb [5919], & yyComb [9984], & yyComb [19731], & yyComb [7388], 
& yyComb [19987], & yyComb [20243], & yyComb [4011], & yyComb [4142], 
& yyComb [19141], & yyComb [4146], & yyComb [4147], & yyComb [4149], 
& yyComb [10181], & yyComb [10770], & yyComb [8823], & yyComb [10858], 
& yyComb [20489], & yyComb [20504], & yyComb [7429], & yyComb [4659], 
& yyComb [4125], & yyComb [5921], & yyComb [6054], & yyComb [4124], 
& yyComb [5818], & yyComb [4642], & yyComb [7261], & yyComb [4150], 
& yyComb [8091], & yyComb [4455], & yyComb [20562], & yyComb [20818], 
& yyComb [21029], & yyComb [7472], & yyComb [9879], & yyComb [9877], 
& yyComb [21152], & yyComb [21408], & yyComb [7290], & yyComb [5816], 
& yyComb [8092], & yyComb [8096], & yyComb [8100], & yyComb [8102], 
& yyComb [8554], & yyComb [4715], & yyComb [8568], & yyComb [9924], 
& yyComb [21628], & yyComb [21709], & yyComb [21785], & yyComb [7269], 
& yyComb [7327], & yyComb [9978], & yyComb [9876], & yyComb [8416], 
& yyComb [21863], & yyComb [7357], & yyComb [7387], & yyComb [10012], 
& yyComb [21941], & yyComb [10160], & yyComb [10015], & yyComb [7427], 
& yyComb [12015], & yyComb [8417], & yyComb [13868], & yyComb [15061], 
& yyComb [22054], & yyComb [21731], & yyComb [22112], & yyComb [4284], 
& yyComb [22368], & yyComb [4415], & yyComb [   0], & yyComb [7445], 
& yyComb [7470], & yyComb [8062], & yyComb [8376], & yyComb [8424], 
& yyComb [8421], & yyComb [8812], & yyComb [9644], & yyComb [22588], 
& yyComb [22648], & yyComb [9632], & yyComb [9645], & yyComb [9634], 
& yyComb [9650], & yyComb [22724], & yyComb [9633], & yyComb [22847], 
& yyComb [23103], & yyComb [4415], & yyComb [4417], & yyComb [23349], 
& yyComb [23472], & yyComb [9712], & yyComb [9714], & yyComb [4332], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [4399], & yyComb [   0], 
& yyComb [4400], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [4408], & yyComb [   0], & yyComb [5052], & yyComb [   0], 
& yyComb [   0], & yyComb [4413], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [4546], & yyComb [4553], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [4551], & yyComb [4557], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], 
};
static	yyStateRange	yyDefault	[yyDStateCount + 1] = { 0,
   35,     1,    35,     3,    35,     5,    35,     7,     1,     1, 
    1,     1,    35,    13,    35,    15,    35,    17,    35,    19, 
   35,    21,    35,    23,    35,    25,    35,    27,    35,    29, 
   35,    31,     0,    35,     0,    33,     0,     0,     0,     0, 
    0,     0,    73,    61,    44,    44,    44,    44,    44,    44, 
   44,    68,    73,    73,     0,     0,    61,    73,    57,    73, 
   73,    73,    59,    43,    73,    64,    73,    73,     0,    73, 
   68,     0,     0,     0,    73,    68,     0,    73,     0,    73, 
   83,     0,   107,     0,     0,   107,   107,   107,   106,   109, 
    0,     0,     0,     0,   107,     0,    95,     0,     0,     0, 
   97,     0,     0,     0,     0,   107,     0,   106,   106,     0, 
  107,   106,     0,   106,   106,     0,   107,   106,    85,    95, 
  124,   124,   124,     0,   132,   132,   131,   124,   124,   132, 
  132,   124,   124,   124,   124,   124,   124,   156,   124,   124, 
  124,   124,   124,   124,   124,   124,   124,   124,   124,   124, 
  124,   124,   124,   124,   124,   124,   124,   130,   131,   124, 
  167,   182,   169,   169,     0,   170,   178,   167,     0,   167, 
  178,   169,   170,   171,   169,     0,   169,   169,   169,     0, 
  167,   169,   181,   169,   169,   170,   169,   187,   192,   192, 
  170,   167,   170,   197,   197,   170,   167,   170,     0,   170, 
  205,   203,   201,   205,     0,     0,   205,   207,   208,   238, 
  238,   211,   211,   211,   211,   210,   238,   217,   217,   217, 
  210,   238,   210,   210,   210,   225,   225,   210,   210,   211, 
  211,   211,   221,   238,   234,   234,   222,   205,   205,   205, 
  275,   241,     0,     0,     0,   244,   244,   247,   248,     0, 
  244,   241,   255,   267,   277,   255,   255,   259,   277,   259, 
  255,   255,   277,   263,   255,   255,   255,   255,   241,   241, 
  241,   241,   241,   241,   255,   277,     0,   279,   277,   244, 
  303,     0,   282,     0,   287,   313,     0,   304,   305,     0, 
    0,   291,     0,   291,   291,   291,   291,   291,   291,   308, 
  308,   308,   308,   308,   308,   308,   308,     0,   319,   317, 
  282,   308,   287,   308,   282,   281,   287,   316,   287,     0, 
  323,   323,     0,   355,     0,   325,   325,   346,   328,   334, 
  336,   321,   332,   332,   325,   332,   321,   321,   338,   337, 
  352,   348,   347,   346,   346,     0,   346,   346,   346,   325, 
    0,     0,   352,     0,     0,   355,     0,     0,     0,   325, 
  362,     0,   365,   365,   371,   365,   365,   365,   365,   362, 
    0,     0,   362,   362,   362,   362,   362,   362,   362,   362, 
  371,   377,   374,   383,   383,   383,   383,   383,   374,   389, 
  389,   383,   374,   383,   383,   393,   375,   383,   376,     0, 
  432,   432,   432,   403,   432,   405,   429,   429,   422,   422, 
  428,   428,   428,   428,   428,   403,   405,   429,   422,   422, 
  422,   432,   422,   432,   432,   425,   424,   432,   432,   428, 
  429,     0,     0,     0,   432,   299,   205,   167,     0,   301, 
  205,    85,   322,    75,   194,    70,   189,   187,    68,   184, 
  380,   361,   167,    52,   124,   124,   124,   435,     0,   435, 
  128,     0,   124,     0,   124,     0,     0,   124,    90,    90, 
   90,    90,    90,    90,    90,   124,   407,     0,   429,   124, 
  124,   124,   379,   274,     0,   131,   128,     0,    73,   124, 
  378,   273,     0,   130,   128,     0,    78,   124,     0,   121, 
  205,    85,    81,   364,   363,   187,   184,    65,   174,   175, 
  171,   311,   169,   167,   124, 
};
static	yyStateRange	yyEobTrans	[yyDStateCount + 1] = { 0,
  124,   124,   205,   205,    85,    85,   199,   199,    75,   319, 
   70,   317,   187,   187,   184,   184,   180,   180,   176,   176, 
  176,   176,    56,    56,    56,    56,   169,   169,   167,   167, 
  124,   124,     0,     0,     0,   197,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,   167,   429,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,   187,     0,    70, 
  192,     0,     0,     0,    75,   197,     0,     0,     0,     0, 
    0,     0,     0,     0,    85,   429,     0,   207,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,   369,     0, 
    0,     0,     0,     0,     0,     0,   192,     0,   429,   197, 
  192,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,    85,   197,   192,   187, 
  167,     0,     0,     0,     0,   166,   167,   167,     0,   429, 
    0,     0,   429,     0,     0,     0,     0,     0,     0,     0, 
  429,     0,   429,   184,     0,   186,   187,   187,   192,   192, 
  191,   192,   429,   197,   197,   196,   197,   429,     0,   429, 
    0,   429,   203,    85,     0,     0,   207,   207,   207,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
  429,   429,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,   429,   335,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,   429,   429, 
  429,   429,   197,   192,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,   197,   192, 
    0,     0,     0,     0,     0,   191,   192,   196,   197,     0, 
    0,    85,     0,     0,     0,     0,     0,     0,     0,   429, 
  429,   429,   429,   429,   335,   429,   429,   429,   429,   429, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,   192,   197,     0,     0,     0,     0,   369,   429, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,   429,   429,   429,   429,   429,   429,     0,     0, 
    0,     0,     0,     0,     0,   429,   429,   429,     0,     0, 
    0,     0,     0,   429,   429,   429,   429,     0,   429,     0, 
  429,     0,     0,     0,     0,     0,     0,   167,     0,     0, 
    0,    85,    85,    75,   197,    70,   192,   187,   187,   184, 
    0,     0,   167,   167,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,   429,     0,   429,     0, 
    0,     0,     0,   192,     0,   192,     0,     0,     0,     0, 
    0,   197,     0,   197,     0,     0,     0,     0,     0,     0, 
    0,    85,     0,   197,   192,   187,   184,     0,     0,     0, 
    0,     0,     0,   167,     0, 
};
   static	short		yyAction	[yyDStateCount + 1] = { 0,
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,    76,   123,   109,    27,   108,   131,     5,     6, 
  110,   111,     7,   121,   122,   119,   117,   118,   120,   116, 
  115,    19,    56,    54,    55,    99,    97,    46,    96,    98, 
   94,    95,    93,    49,    47,    48,   102,   100,   101,    35, 
   33,    32,    34,    31,    25,    23,    22,    24,    21,    44, 
   42,    45,    43,    41,    10,     8,     1,     3,    87,    80, 
  106,     2,    85,    84,    83,    89,    82,    52,    90,    88, 
   81,    53,    17,    18,    92,    57,    15,    51,    86,    91, 
   16,    40,    13,    50,    58,    14,    12,     9,   124,    66, 
   65,    64,    62,   124,   123,   123,    37,   125,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,   131,   131,   131,   131,     5,     5,     5,     5, 
    5,     5,     5,     6,     7,    19,    19,    19,    56,    99, 
   99,    99,    98,    98,    98,    98,    98,    94,    93,    49, 
   47,    47,    48,   102,   100,   100,   100,   100,    35,    33, 
   33,    33,    34,    25,    23,    23,    23,    24,    44,    42, 
   42,    43,    10,    10,     8,     1,     3,     3,     3,    87, 
   87,    87,    87,    87,    87,    87,    87,    87,    87,    87, 
   87,    87,    87,    87,    87,    87,    87,    87,    87,    87, 
   87,    87,    87,    87,    87,    87,    87,    83,    52,    53, 
   17,    18,    15,    15,    16,    16,    40,    13,    14,    12, 
   12,    62,   124,   123,   123,   123,   123,   123,   123,   123, 
  123,   123,   123,   123,   123,   123,   123,   123,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,     5,     5, 
   99,    98,    93,    49,    47,    35,    35,    25,    25,    44, 
   42,    10,     8,    83,    15,    16,    12,   123,   123,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
  131,   131,    35,    25,   123,   123,   123,   123,   131,   131, 
  131,   131,   131,   131,   131,   131,   131,   131,   131,   131, 
   47,    42,    87,    87,    87,    87,    87,    87,    87,    87, 
   87,    87,    87,    87,    87,    87,    83,    58,   131,   131, 
  131,   131,    47,    47,    42,    42,   124,   131,   123,   123, 
   87,    87,    87,    87,    87,    47,    42,   131,   123,   123, 
  123,   123,   123,   131,   131,   131,   131,    87,   131,    87, 
  131,   131,   129,   130,   128,   128,     8,    19,   126,   126, 
    8,    10,    10,    25,    25,    35,    35,   100,   100,   102, 
  126,   126,    19,    19,   114,   113,   112,   107,   105,   104, 
  103,    79,    77,    78,    73,    75,    74,    72,    80,    71, 
   80,    70,    69,    80,    68,    67,    67,    63,    63,    61, 
   60,    59,    39,    39,    38,    38,    37,    36,    34,    30, 
   29,    29,    28,    28,    27,    26,    24,    20,    11,     4, 
    4,     4,     4,     4,     4,     4,     4,     4,     4,     4, 
    4,     4,     4,     4,     4, 
   };

static	yyStateRange	yyStartState	= STD;
static	yyStateRange	yyPreviousStart	= STD;
static	short		yySourceFile	= StdIn;
static	rbool		yyBufferIsUsed	= rfalse;
static	rbool		yyEof		= rfalse;
static	long		yyBytesRead	= 0;
static	long		yyFileOffset	= 0;
static	unsigned int	yyLineCount	= 1;
static	unsigned char *	yyLineStart	;
static	char *		yyChBufferStart2;

					/* Start State Stack: StStSt	*/

#if defined xxyyPush | defined xxyyPop
#define		yyInitStStStackSize	16

CreateArray1 (yyStStStackPtr, yyInitStStStack, yyStateRange,
   yyInitStStStackSize, {0})
static	unsigned long	yyStStStackSize	= yyInitStStStackSize;
static	unsigned int	yyStStStackIdx	= 0;
#endif

#ifdef xxyyPush
static void yyPush
#if defined __STDC__ | defined __cplusplus
   (yyStateRange yyState)
#else
   (yyState) yyStateRange yyState;
#endif
{
   if (yyStStStackIdx == yyStStStackSize) {
      ExtendArray ((char * *) & yyStStStackPtr, & yyStStStackSize,
			(unsigned long) sizeof (yyStateRange));
      if (yyStStStackPtr == NULL) yyErrorMessage (1);
   }
   yyStStStackPtr [yyStStStackIdx ++] = yyStartState;
   yyStart (yyState);
}
#endif

#ifdef xxyyPop
static void yyPop ARGS ((void))
{
   yyPreviousStart = yyStartState;
   if (yyStStStackIdx > 0)
      yyStartState = yyStStStackPtr [-- yyStStStackIdx];
   else
      yyErrorMessage (4);
}
#endif

#ifdef xxGetLower
static	unsigned char	yyToLower	[] = {
'\0', '\1', '\2', '\3', '\4', '\5', '\6', '\7',
'\10', '\11', '\12', '\13', '\14', '\15', '\16', '\17',
'\20', '\21', '\22', '\23', '\24', '\25', '\26', '\27',
'\30', '\31', '\32', '\33', '\34', '\35', '\36', '\37',
' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/',
'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
'@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_',
'`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}','~','\177',
'\200', '\201', '\202', '\203', '\204', '\205', '\206', '\207',
'\210', '\211', '\212', '\213', '\214', '\215', '\216', '\217',
'\220', '\221', '\222', '\223', '\224', '\225', '\226', '\227',
'\230', '\231', '\232', '\233', '\234', '\235', '\236', '\237',
'\240', '\241', '\242', '\243', '\244', '\245', '\246', '\247',
'\250', '\251', '\252', '\253', '\254', '\255', '\256', '\257',
'\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
'\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277',
'\300', '\301', '\302', '\303', '\304', '\305', '\306', '\307',
'\310', '\311', '\312', '\313', '\314', '\315', '\316', '\317',
'\320', '\321', '\322', '\323', '\324', '\325', '\326', '\327',
'\330', '\331', '\332', '\333', '\334', '\335', '\336', '\337',
'\340', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
'\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
'\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
'\370', '\371', '\372', '\373', '\374', '\375', '\376', '\377',
};
#endif

#ifdef xxGetUpper
static	unsigned char	yyToUpper	[] = {
'\0', '\1', '\2', '\3', '\4', '\5', '\6', '\7',
'\10', '\11', '\12', '\13', '\14', '\15', '\16', '\17',
'\20', '\21', '\22', '\23', '\24', '\25', '\26', '\27',
'\30', '\31', '\32', '\33', '\34', '\35', '\36', '\37',
' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/',
'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_',
'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}','~','\177',
'\200', '\201', '\202', '\203', '\204', '\205', '\206', '\207',
'\210', '\211', '\212', '\213', '\214', '\215', '\216', '\217',
'\220', '\221', '\222', '\223', '\224', '\225', '\226', '\227',
'\230', '\231', '\232', '\233', '\234', '\235', '\236', '\237',
'\240', '\241', '\242', '\243', '\244', '\245', '\246', '\247',
'\250', '\251', '\252', '\253', '\254', '\255', '\256', '\257',
'\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
'\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277',
'\300', '\301', '\302', '\303', '\304', '\305', '\306', '\307',
'\310', '\311', '\312', '\313', '\314', '\315', '\316', '\317',
'\320', '\321', '\322', '\323', '\324', '\325', '\326', '\327',
'\330', '\331', '\332', '\333', '\334', '\335', '\336', '\337',
'\340', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
'\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
'\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
'\370', '\371', '\372', '\373', '\374', '\375', '\376', '\377',
};
#endif

static void yyTab1	ARGS ((int yya));

#define yyTab		yyTab1 (0)
#define yyTab2(a,b)	yyTab1 (a)

/* line 73 "cobol.rex" */

#include <ctype.h>
#include <string.h>
#include "Errors.h"
#include "cobol.h"
#include "keywdef.h"
#include "keywords.h"
#include "copy_pars.h"
#include "directives.h"
#include "sn.h"

#define	MaxStringLength		4096

	rbool	ansi_copy		= rfalse;
	rbool	IsDebugging		= rfalse;
	rbool	decimal_point_is_comma	= rfalse;

extern	rbool	Copy ARGS ((tIdent ident, tPosition pos));

extern	int	error_count		;

static	char	String			[MaxStringLength + 72];
static	int	length			;
static	rbool	in_comment_entry	= rfalse;
static	tIdent	iNOTE, iSKIP1, iSKIP2, iSKIP3, iCOPY, iREPLACE;
static	unsigned long	dialect_save	;
static	tPosition	start_position	;

int Get_Token ARGS ((void));

int GetToken ARGS ((void))
{
   register int Token = Get_Token ();

   if (Token != EofToken) {
      Attribute.name.EPos.Line   = yyLineCount;
      Attribute.name.EPos.Column = (unsigned char *) TokenPtr - yyLineStart + TokenLength - 1;
   }
   return Token;
}

#define GetToken Get_Token

void ErrorAttribute
#if defined __STDC__ | defined __cplusplus
 (int Token, tScanAttribute * pAttribute)
#else
 (Token, pAttribute) int Token; tScanAttribute * pAttribute;
#endif
{
 pAttribute->Position = Attribute.Position;
 switch (Token) {
 case /* name */ 1: 
 pAttribute->name.EPos  = NoPosition	;
 ;
 pAttribute->name.Ident = NoIdent	;
 ;
 break;
 case /* paragraph_name */ 2: 
 pAttribute->paragraph_name.EPos  = NoPosition	;
 ;
 pAttribute->paragraph_name.Ident = NoIdent	;
 ;
 break;
 case /* unsigned_integer */ 3: 
 pAttribute->unsigned_integer.EPos  = NoPosition	;
 ;
 pAttribute->unsigned_integer.Value = 0		;
 ;
 break;
 case /* plus_integer */ 4: 
 pAttribute->plus_integer.EPos  = NoPosition	;
 ;
 pAttribute->plus_integer.Value = 1		;
 ;
 break;
 case /* minus_integer */ 5: 
 pAttribute->minus_integer.EPos  = NoPosition	;
 ;
 pAttribute->minus_integer.Value = -1		;
 ;
 break;
 case /* level_number */ 6: 
 pAttribute->level_number.EPos  = NoPosition	;
 ;
 pAttribute->level_number.Value = 1		;
 ;
 break;
 case /* real */ 7: 
 pAttribute->real.EPos  = NoPosition	;
 ;
 pAttribute->real.Value = PutString (String, 0);
 ;
 break;
 case /* string */ 8: 
 pAttribute->string.EPos  = NoPosition	;
 ;
 pAttribute->string.Value = PutString (String, 0);
 ;
 break;
 case /* pseudo_text */ 9: 
 pAttribute->pseudo_text.EPos  = NoPosition	;
 ;
 pAttribute->pseudo_text.Value = PutString (String, 0);
 ;
 break;
 case /* picture_string */ 10: 
 pAttribute->picture_string.EPos  = NoPosition	;
 ;
 pAttribute->picture_string.Value = PutString (String, 0);
 ;
 break;
 case /* illegal_character */ 11: 
 pAttribute->illegal_character.EPos  = NoPosition	;
 ;
 pAttribute->illegal_character.Value = ' '	;
 ;
 break;
 }
}


#define CheckLength(x, y)

/*
static void CheckLength
#if defined __STDC__ | defined __cplusplus
   (int Length, int Limit)
#else
   (Length, Limit) int Length, Limit;
#endif
{
   if (! in_comment_entry && Length > Limit)
      Message ("token too long", xxWarning, Attribute.Position);
}
*/

static void CheckAreaA ARGS ((void))
{
   if (Attribute.Position.Column < 8 || 11 < Attribute.Position.Column)
      Message ("token must begin in area A", xxWarning, Attribute.Position);
}

void begin_replacing ARGS ((void))
{
   dialect_save = dialect;
   dialect = copy_replace;
}

void end_replacing ARGS ((void))
{
   dialect = dialect_save;
}

void start_pseudo_text ARGS ((void))
{
   yyStart (Pseudo_Text);
   length = 0;
   start_position = Attribute.Position;
}

void Start_Comment_Entry ARGS ((void))
{
   if (free_format) yyStart (Skip)
   else yyStart (Comment_Entry);
}

static int Handle_Comment_Entry ARGS ((void))
{
   int Token;

   start_position = Attribute.Position;
   yyStart (STD); in_comment_entry = rtrue;
   for (;;) {
      Token = GetToken ();
      switch (Token) {
      case kCOPY		:
      case kREPLACE		:
	 if (Attribute.Position.Column <= 11) {
	    in_comment_entry = rfalse;
	    (void) copy_pars ();
	    in_comment_entry = rtrue;
	 }
	 break;

      case EofToken 		: goto exit_loop;

      case kPROGRAM_ID		:
      case kAUTHOR		: /* FOLLOW set of classical comment entries */
      case kINSTALLATION	:
      case kDATE_WRITTEN	:
      case kDATE_COMPILED	:
      case kSECURITY		:
      case kREMARKS		:
      case kEND			:
      case kIDENTIFICATION	:
      case kENVIRONMENT		:
      case kDATA		:
      case kPROCEDURE		:

				  /* FOLLOW set of SOURCE-COMPUTER */
   /* case kWITH		: optional */
      case kDEBUGGING		:
      case kOBJECT_COMPUTER	:
      case kMEMORY		: /* FOLLOW set of OBJECT-COMPUTER */
   /* case kPROGRAM		: optional */
   /* case kCOLLATING		: optional */
      case kSEQUENCE		:
      case kSEGMENT_LIMIT	:
      case kTERMINAL		:
      case kSPECIAL_NAMES	: /* FOLLOW set because of optional headings */
      case kINPUT_OUTPUT	:
      case kFILE_CONTROL	:
      case kI_O_CONTROL		:
      case kSELECT		:
      case kFILE		:
      case kWORKING_STORAGE	:
      case kLOCAL_STORAGE	:
      case kLINKAGE		:
      case kCOMMUNICATION	:
      case kREPORT		:
      case kSCREEN		:
	 if (Attribute.Position.Column <= 11) goto exit_loop;
      }
   }
exit_loop:
   yyStart (STD); in_comment_entry = rfalse;
   if (hl) (void) fprintf (hlfp, "%d rem %d.%d %d.%d\n", PAF_HIGH,
      start_position.Line, start_position.Column - 1,
      Attribute.Position.Line, Attribute.Position.Column - 1);
   return Token;
}

				/* continuation of integers and reals	*/

static int HandleContinuedNumber
#if defined __STDC__ | defined __cplusplus
   (int length)
#else
   (length) int length;
#endif
{
   register char * p = strpbrk (String, ".,");

   if (p != NULL) {
      int l;
      if (! decimal_point_is_comma && * p == '.' ||
	    decimal_point_is_comma && * p == ',') {
	 char * q;
	 Attribute.real.Value = PutString (String, length);
	 if (* String == '+' || * String == '-') CheckLength (length, 20);
	 else CheckLength (length, 19);
	 if (decimal_point_is_comma) * p = '.';
	 (void) strtod (String, & q);
	 if (decimal_point_is_comma) * p = ',';
	 if (* q != '\0') {
	    MessageI ("error in real number", xxError, Attribute.Position,
	       xxString, String);
	    error_count ++;
	 }
	 return 7;
      }
      l = p - String;
      yyLess ((TokenLength + l - length));
      switch (* String) {
      case ',': yyLess (1); return -1;
      case '.': yyLess (1); return 12;
      case '+': if (l == 1) { return 448; } break;
      case '-': if (l == 1) { return 456; } break;
      }
      length = l;
   }
   CheckLength (length, 19);
   switch (* String) {
   case '+': Attribute.plus_integer.Value = atol (String);
	     return 4;
   case '-': Attribute.minus_integer.Value = atol (String);
	     return 5;
   default : Attribute.unsigned_integer.Value = atol (String);
	     return 3;
   }
}


#ifndef yySetPosition
#define yySetPosition Attribute.Position.Line   = yyLineCount; \
Attribute.Position.Column = (int) ((unsigned char *) TokenPtr - yyLineStart);
#endif

#undef yyTab
#undef yyTab2

#ifndef yyInitBufferSize
#define yyInitBufferSize	1024 * 8 + 256
#endif
#ifndef yyInitFileStackSize
#define yyInitFileStackSize	8
#endif
#ifndef yyTabSpace
#define yyTabSpace		8
#endif

static void yyTab1
#if defined __STDC__ | defined __cplusplus
   (int yya)
#else
   (yya) int yya;
#endif
   { yyLineStart -= (yyTabSpace - 1 - ((unsigned char *) TokenPtr -
	yyLineStart + yya - 1)) & (yyTabSpace - 1); }

#define yyTab		yyLineStart -= (yyTabSpace - 1 - \
((unsigned char *) TokenPtr - yyLineStart - 1)) & (yyTabSpace - 1)
#define yyTab1(a)	yyLineStart -= (yyTabSpace - 1 - \
((unsigned char *) TokenPtr - yyLineStart + (a) - 1)) & (yyTabSpace - 1)
#define yyTab2(a,b)	yyLineStart -= (yyTabSpace - 1 - \
((unsigned char *) TokenPtr - yyLineStart + (a) - 1)) & (yyTabSpace - 1)

CreateArray1 (yyStateStack, yyInitStateStack, yyStateRange, yyInitBufferSize,
   {yyDefaultState})
static	unsigned long	yyStateStackSize= yyInitBufferSize;

CreateArray1a (yyChBufferPtr, yyInitChBuffer, unsigned char, yyInitBufferSize) =
{ 0.0, { '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0',
	 '\0', '\0', '\0', '\0', '\0', '\0', '\0', yyEolCh, yyEobCh, '\0', }};
CreateArray1b (yyChBufferPtr, yyInitChBuffer, unsigned char, yyInitBufferSize)

static	unsigned char *	yyChBufferStart	= & yyInitChBuffer.yyArray [16];
static	unsigned long	yyChBufferSize	= yyInitBufferSize;
static	unsigned char *	yyChBufferIndex	= & yyInitChBuffer.yyArray [16];

typedef	struct {
	short		yySourceFile	;
	rbool		yyEof		;
	unsigned char *	yyChBufferPtr	;
	unsigned char *	yyChBufferStart	;
	unsigned long	yyChBufferSize	;
	unsigned char *	yyChBufferIndex	;
	long		yyBytesRead	;
	long		yyFileOffset	;
	unsigned int	yyLineCount	;
	unsigned char *	yyLineStart	;
	}		yytFileStack	;

CreateArray2 (yyFileStack, yyInitFileStack, yytFileStack,
   yyInitFileStackSize, {{0}})
static	unsigned long	yyFileStackSize	= yyInitFileStackSize;
static	yytFileStack *	yyFileStackPtr	= & yyInitFileStack.yyArray [1];

int GetToken ARGS ((void))
{
   register	yyStateRange	yyState;
   register	yyStateRange *	yyStatePtr;
   register	unsigned char * yyChBufferIndexReg;
   register	yyCombType * *	yyBasePtrReg = yyBasePtr;
/* line 357 "cobol.rex" */
 int k; 

yyBegin:
   yyState		= yyStartState;		/* initialize */
   yyStatePtr		= & yyStateStack [1];
   yyChBufferIndexReg	= yyChBufferIndex;
   TokenPtr		= (char *) yyChBufferIndexReg;
   if (yyChBufferIndexReg [-1] == yyEolCh) yyState ++;

   /* ASSERT yyChBuffer [yyChBufferIndex] == first character */

yyContinue:		/* continue after sentinel or skipping blanks */
   for (;;) {		/* execute as many state transitions as possible */
			/* determine next state and get next character */
      register yyCombType * yyTablePtr =
			(yyBasePtrReg [yyState] + * yyChBufferIndexReg ++);
      if (yyTablePtr->yyCheck == yyState) {
	 yyState = yyTablePtr->yyNext;
	 * yyStatePtr ++ = yyState;		/* push state */
	 goto yyContinue;
      }
      yyChBufferIndexReg --;			/* reconsider character */
      if ((yyState = yyDefault [yyState]) == yyDNoState) break;
   }

   for (;;) {				/* search for last final state */
      TokenLength =
	    (int) (yyChBufferIndexReg - (unsigned char *) TokenPtr);
      yyChBufferIndex = yyChBufferIndexReg;
switch (yyAction [* -- yyStatePtr]) {
case 1:
/* line 419 "cobol.rex" */
{
} yyy1: goto yyBegin;
case 2:
/* line 421 "cobol.rex" */
{
} yyy2: goto yyBegin;
case 3:
/* line 423 "cobol.rex" */
{ if (IsDebugging) yyLess (1); 
} yyy3: goto yyBegin;
case 4:
yySetPosition
/* line 425 "cobol.rex" */
{ if (free_format) return 456;
			  /* else if (! in_comment_entry) {
				Message ("incorrect continuation line",
				xxError, Attribute.Position);
				error_count ++; } */
			   
} yyy4: goto yyBegin;
case 5:
/* line 433 "cobol.rex" */
{ yyPush (Directive); (void) directives ();
			     yyPop (); 
} yyy5: goto yyBegin;
case 6:
yySetPosition
/* line 437 "cobol.rex" */
{ yyEol (0);	/* skip comment line		*/
			     if (hl) (void) fprintf (hlfp, "%d rem %d.%d %d.%d\n",
				PAF_HIGH, Attribute.Position.Line, 0,
				Attribute.Position.Line, TokenLength);
			   
} yyy6: goto yyBegin;
case 7:
/* line 444 "cobol.rex" */
{ yyEol (0); 
} yyy7: goto yyBegin;
case 8:
yySetPosition
/* line 448 "cobol.rex" */
{ yyLess (0); k = Handle_Comment_Entry ();
				    if (k == kCOPY) goto lCOPY;
				    if (k == kREPLACE) goto lREPLACE;
				    return k;
				  
} yyy8: goto yyBegin;
case 9:
yySetPosition
/* line 454 "cobol.rex" */
{ /* Attribute.name.Ident = iNOTE;
				    if (! (keywords [Attribute.name.Ident].mask & dialect))
				       return 1; */
				    if (! in_comment_entry) {
				       yyStart (Note);
				       start_position = Attribute.Position;
				    }
				  
} yyy9: goto yyBegin;
case 10:
/* line 463 "cobol.rex" */
{
} yyy10: goto yyBegin;
case 11:
yySetPosition
/* line 464 "cobol.rex" */
{ yyPrevious; if (hl)
				     (void) fprintf (hlfp, "%d rem %d.%d %d.%d\n", PAF_HIGH,
				       start_position.Line, start_position.Column - 1,
				       Attribute.Position.Line, Attribute.Position.Column );
				   
} yyy11: goto yyBegin;
case 12:
yyChBufferIndex -= 1;
TokenLength -= 1;
yySetPosition
/* line 470 "cobol.rex" */
{ yyStart (Skip); 
} yyy12: goto yyBegin;
case 13:
yySetPosition
/* line 472 "cobol.rex" */
{ /* length = GetUpper (String);
				    Attribute.name.Ident = MakeIdent (String, length);
				    if (! (keywords [Attribute.name.Ident].mask & dialect))
				       return 1; */ 
} yyy13: goto yyBegin;
case 14:
yySetPosition
/* line 472 "cobol.rex" */
{ /* length = GetUpper (String);
				    Attribute.name.Ident = MakeIdent (String, length);
				    if (! (keywords [Attribute.name.Ident].mask & dialect))
				       return 1; */ 
} yyy14: goto yyBegin;
case 15:
yyChBufferIndex -= 1;
TokenLength -= 1;
yySetPosition
/* line 479 "cobol.rex" */
{ if (dialect & (os | vs)) { yyStart (Skip); }
				     else goto lName; 
} yyy15: goto yyBegin;
case 16:
yyChBufferIndex -= 1;
TokenLength -= 1;
yySetPosition
/* line 479 "cobol.rex" */
{ if (dialect & (os | vs)) { yyStart (Skip); }
				     else goto lName; 
} yyy16: goto yyBegin;
case 17:
yyChBufferIndex -= 1;
TokenLength -= 1;
yySetPosition
/* line 484 "cobol.rex" */
{ if (dialect & (os | vs)) { yyStart (Skip); }
				     else { yyLess (1); return 460; } 
} yyy17: goto yyBegin;
case 18:
yyChBufferIndex -= 1;
TokenLength -= 1;
yySetPosition
/* line 484 "cobol.rex" */
{ if (dialect & (os | vs)) { yyStart (Skip); }
				     else { yyLess (1); return 460; } 
} yyy18: goto yyBegin;
case 19:
/* line 487 "cobol.rex" */
{ yyPrevious; 
} yyy19: goto yyBegin;
case 20:
yySetPosition
/* line 491 "cobol.rex" */
{ yyStart (String1); length = 1; String [0] = '\'';
				     start_position = Attribute.Position; 
} yyy20: goto yyBegin;
case 21:
while (* yyStatePtr != 
360) {
   yyChBufferIndex --;
   TokenLength --;
   yyStatePtr --;
}
/* line 495 "cobol.rex" */
{ yyEol (0); if (free_format) goto lString1; 
} yyy21: goto yyBegin;
case 22:
/* line 496 "cobol.rex" */
{
} yyy22: goto yyBegin;
case 23:
for (;;) {
   switch (* yyStatePtr) {
case 36:;
case 130:;
case 158:;
case 194:;
case 273:;
case 318:;
case 319:;
case 364:;
case 445:;
case 492:;
case 494:;
case 504:;
goto yyL1;
   default:
      yyChBufferIndex --;
      TokenLength --;
      yyStatePtr --;
   }
}
yyL1: ;
yySetPosition
/* line 498 "cobol.rex" */
{ if (! in_comment_entry) {
				        Message ("continuation of string expected",
					xxError, Attribute.Position);
      					error_count ++;
				     }
				     Attribute.Position = start_position;
				     Attribute.string.Value = PutString (String, length);
				     yyPrevious; return 8; 
} yyy23: goto yyBegin;
case 24:
yySetPosition
/* line 498 "cobol.rex" */
{ if (! in_comment_entry) {
				        Message ("continuation of string expected",
					xxError, Attribute.Position);
      					error_count ++;
				     }
				     Attribute.Position = start_position;
				     Attribute.string.Value = PutString (String, length);
				     yyPrevious; return 8; 
} yyy24: goto yyBegin;
case 25:
/* line 507 "cobol.rex" */
{ if (length < MaxStringLength) length += GetWord (& String [length]); 
} yyy25: goto yyBegin;
case 26:
/* line 508 "cobol.rex" */
{ if (length < MaxStringLength) length += GetWord (& String [length]); 
} yyy26: goto yyBegin;
case 27:
/* line 509 "cobol.rex" */
{ if (length < MaxStringLength) String [length ++] = '\t'; 
} yyy27: goto yyBegin;
case 28:
/* line 510 "cobol.rex" */
{
} yyy28: goto yyBegin;
case 29:
/* line 511 "cobol.rex" */
{ lString1: if (length < MaxStringLength)
				     (void) strcpy (& String [length ++], "\'");
				     Attribute.string.Value = PutString (String, length);
				     yyPrevious; return 8; 
} yyy29: goto yyBegin;
case 30:
yySetPosition
/* line 516 "cobol.rex" */
{ yyStart (String2); length = 1; String [0] = '\"';
				     start_position = Attribute.Position; 
} yyy30: goto yyBegin;
case 31:
while (* yyStatePtr != 
297) {
   yyChBufferIndex --;
   TokenLength --;
   yyStatePtr --;
}
/* line 520 "cobol.rex" */
{ yyEol (0); if (free_format) goto lString2; 
} yyy31: goto yyBegin;
case 32:
/* line 521 "cobol.rex" */
{
} yyy32: goto yyBegin;
case 33:
for (;;) {
   switch (* yyStatePtr) {
case 127:;
case 131:;
case 159:;
case 189:;
case 274:;
case 316:;
case 317:;
case 363:;
case 447:;
case 484:;
case 486:;
case 505:;
goto yyL2;
   default:
      yyChBufferIndex --;
      TokenLength --;
      yyStatePtr --;
   }
}
yyL2: ;
yySetPosition
/* line 523 "cobol.rex" */
{ if (! in_comment_entry) {
					Message ("continuation of string expected",
					xxError, Attribute.Position);
      					error_count ++;
				     }
				     Attribute.Position = start_position;
				     Attribute.string.Value = PutString (String, length);
				     yyPrevious; return 8; 
} yyy33: goto yyBegin;
case 34:
yySetPosition
/* line 523 "cobol.rex" */
{ if (! in_comment_entry) {
					Message ("continuation of string expected",
					xxError, Attribute.Position);
      					error_count ++;
				     }
				     Attribute.Position = start_position;
				     Attribute.string.Value = PutString (String, length);
				     yyPrevious; return 8; 
} yyy34: goto yyBegin;
case 35:
/* line 532 "cobol.rex" */
{ if (length < MaxStringLength) length += GetWord (& String [length]); 
} yyy35: goto yyBegin;
case 36:
/* line 533 "cobol.rex" */
{ if (length < MaxStringLength) length += GetWord (& String [length]); 
} yyy36: goto yyBegin;
case 37:
/* line 534 "cobol.rex" */
{ if (length < MaxStringLength) String [length ++] = '\t'; 
} yyy37: goto yyBegin;
case 38:
/* line 535 "cobol.rex" */
{
} yyy38: goto yyBegin;
case 39:
/* line 536 "cobol.rex" */
{ lString2: if (length < MaxStringLength)
				     (void) strcpy (& String [length ++], "\"");
				     Attribute.string.Value = PutString (String, length);
				     yyPrevious; return 8; 
} yyy39: goto yyBegin;
case 40:
yySetPosition
/* line 543 "cobol.rex" */
{ length = GetUpper (String);
				    Attribute.name.Ident = MakeIdent (String, length);
				    if (! (keywords [Attribute.name.Ident].mask & dialect))
				       return 1;
				    if (hl)
				       (void) fprintf (hlfp, "%d key %d.%d %d.%d\n", PAF_HIGH,
				       Attribute.Position.Line, Attribute.Position.Column - 1,
				       Attribute.Position.Line, Attribute.Position.Column + TokenLength - 1);
				    yyStart (Picture); return 292; 
} yyy40: goto yyBegin;
case 41:
yySetPosition
/* line 553 "cobol.rex" */
{ if (hl)
				       (void) fprintf (hlfp, "%d key %d.%d %d.%d\n", PAF_HIGH,
				       Attribute.Position.Line, Attribute.Position.Column - 1,
				       Attribute.Position.Line, Attribute.Position.Column + TokenLength - 1);
				    return 221; 
} yyy41: goto yyBegin;
case 42:
yySetPosition
/* line 560 "cobol.rex" */
{ length = GetUpper (String);
				    Attribute.string.Value = PutString (String, length);
				    yyPrevious; CheckLength (TokenLength, 30); return 8; 
} yyy42: goto yyBegin;
case 43:
yyChBufferIndex -= 1;
TokenLength -= 1;
yySetPosition
/* line 560 "cobol.rex" */
{ length = GetUpper (String);
				    Attribute.string.Value = PutString (String, length);
				    yyPrevious; CheckLength (TokenLength, 30); return 8; 
} yyy43: goto yyBegin;
case 44:
yySetPosition
/* line 564 "cobol.rex" */
{ Attribute.string.Value = GetStringRef (NoIdent);
				    yyLess (0); yyPrevious; return 8; 
} yyy44: goto yyBegin;
case 45:
for (;;) {
   switch (* yyStatePtr) {
case 80:;
case 81:;
case 83:;
case 137:;
case 163:;
case 200:;
case 201:;
case 202:;
case 270:;
case 280:;
case 321:;
case 331:;
case 382:;
case 405:;
case 406:;
case 417:;
case 503:;
goto yyL3;
   default:
      yyChBufferIndex --;
      TokenLength --;
      yyStatePtr --;
   }
}
yyL3: ;
yySetPosition
/* line 570 "cobol.rex" */
{ length = GetUpper (String);
				    if (free_format) {
				       Attribute.string.Value = PutString (String, length);
				       CheckLength (TokenLength, 30);
				       yyPrevious; return 8;
				    } else
				       yyStart (Continue_Picture); 
} yyy45: goto yyBegin;
case 46:
/* line 579 "cobol.rex" */
{ yyEol ((TokenLength - 1 - (strchr (TokenPtr, '\n') - TokenPtr))); 
} yyy46: goto yyBegin;
case 47:
/* line 584 "cobol.rex" */
{ length += GetUpper (& String [length]);
				     Attribute.string.Value = PutString (String, length);
				     yyStart (STD); CheckLength (length, 30); return 8; 
} yyy47: goto yyBegin;
case 48:
yyChBufferIndex -= 1;
TokenLength -= 1;
/* line 584 "cobol.rex" */
{ length += GetUpper (& String [length]);
				     Attribute.string.Value = PutString (String, length);
				     yyStart (STD); CheckLength (length, 30); return 8; 
} yyy48: goto yyBegin;
case 49:
/* line 588 "cobol.rex" */
{ yyLess (0); yyStart (STD);
				     Attribute.string.Value = PutString (String, length);
				     CheckLength (length, 30);
				     return 8; 
} yyy49: goto yyBegin;
case 50:
yySetPosition
/* line 593 "cobol.rex" */
{ if (dialect != copy_replace) goto lCOPY;
				    Attribute.name.Ident =
				       MakeIdent (TokenPtr, TokenLength);
				    return 1; 
} yyy50: goto yyBegin;
case 51:
yySetPosition
/* line 598 "cobol.rex" */
{ lCOPY: Attribute.name.Ident = iCOPY;
				    if (! (keywords [Attribute.name.Ident].mask & dialect))
				       return 1;
				    if (hl)
				       (void) fprintf (hlfp, "%d key %d.%d %d.%d\n", PAF_HIGH,
				       Attribute.Position.Line, Attribute.Position.Column - 1,
				       Attribute.Position.Line, Attribute.Position.Column + TokenLength - 1);
				    if (ansi_copy && ! in_comment_entry) (void) copy_pars ();
				    else return 92; 
} yyy51: goto yyBegin;
case 52:
/* line 610 "cobol.rex" */
{ yyStart (Include); 
} yyy52: goto yyBegin;
case 53:
/* line 610 "cobol.rex" */
{ yyStart (Include); 
} yyy53: goto yyBegin;
case 54:
yySetPosition
/* line 613 "cobol.rex" */
{ (void) Copy (MakeIdent (TokenPtr, TokenLength), Attribute.Position);
				    yyPrevious; 
} yyy54: goto yyBegin;
case 55:
/* line 616 "cobol.rex" */
{
} yyy55: goto yyBegin;
case 56:
/* line 618 "cobol.rex" */
{ yyLess (0); yyPrevious; 
} yyy56: goto yyBegin;
case 57:
yySetPosition
/* line 620 "cobol.rex" */
{ lREPLACE: Attribute.name.Ident = iREPLACE;
				    if (! (keywords [Attribute.name.Ident].mask & dialect))
				       return 1;
				    if (hl)
				       (void) fprintf (hlfp, "%d key %d.%d %d.%d\n", PAF_HIGH,
				       Attribute.Position.Line, Attribute.Position.Column - 1,
				       Attribute.Position.Line, Attribute.Position.Column + TokenLength - 1);
				    if (ansi_copy && ! in_comment_entry) (void) copy_pars ();
				    else return 333; 
} yyy57: goto yyBegin;
case 58:
yySetPosition
/* line 631 "cobol.rex" */
{ if (hl)
				       (void) fprintf (hlfp, "%d key %d.%d %d.%d\n", PAF_HIGH,
				       Attribute.Position.Line, Attribute.Position.Column - 1,
				       Attribute.Position.Line, Attribute.Position.Column + TokenLength - 1);
				    yyStart (SQL); 
} yyy58: goto yyBegin;
case 59:
yySetPosition
/* line 639 "cobol.rex" */
{ return 458	; 
} yyy59: goto yyBegin;
case 60:
yySetPosition
/* line 640 "cobol.rex" */
{ return 446	; 
} yyy60: goto yyBegin;
case 61:
yySetPosition
/* line 641 "cobol.rex" */
{ return 447	; 
} yyy61: goto yyBegin;
case 62:
yySetPosition
/* line 642 "cobol.rex" */
{ return 460	; 
} yyy62: goto yyBegin;
case 63:
yySetPosition
/* line 643 "cobol.rex" */
{ return 459	; 
} yyy63: goto yyBegin;
case 64:
yySetPosition
/* line 644 "cobol.rex" */
{ return 448	; 
} yyy64: goto yyBegin;
case 65:
yySetPosition
/* line 645 "cobol.rex" */
{ return 456	; 
} yyy65: goto yyBegin;
case 66:
yySetPosition
/* line 646 "cobol.rex" */
{ return 12	; 
} yyy66: goto yyBegin;
case 67:
yySetPosition
/* line 647 "cobol.rex" */
{ return 461	; 
} yyy67: goto yyBegin;
case 68:
yySetPosition
/* line 648 "cobol.rex" */
{ return 452	; 
} yyy68: goto yyBegin;
case 69:
yySetPosition
/* line 649 "cobol.rex" */
{ return 453	; 
} yyy69: goto yyBegin;
case 70:
yySetPosition
/* line 650 "cobol.rex" */
{ return 454	; 
} yyy70: goto yyBegin;
case 71:
yySetPosition
/* line 651 "cobol.rex" */
{ return 455	; 
} yyy71: goto yyBegin;
case 72:
yySetPosition
/* line 652 "cobol.rex" */
{ return 457	; 
} yyy72: goto yyBegin;
case 73:
yySetPosition
/* line 653 "cobol.rex" */
{ return 444	; 
} yyy73: goto yyBegin;
case 74:
yySetPosition
/* line 654 "cobol.rex" */
{ return 451	; 
} yyy74: goto yyBegin;
case 75:
yySetPosition
/* line 655 "cobol.rex" */
{ return 449	; 
} yyy75: goto yyBegin;
case 76:
yySetPosition
/* line 656 "cobol.rex" */
{ return 443	; 
} yyy76: goto yyBegin;
case 77:
yySetPosition
/* line 657 "cobol.rex" */
{ return 445	; 
} yyy77: goto yyBegin;
case 78:
yySetPosition
/* line 658 "cobol.rex" */
{ return 450	; 
} yyy78: goto yyBegin;
case 79:
yySetPosition
/* line 659 "cobol.rex" */
{ return 462	; 
} yyy79: goto yyBegin;
case 80:
yySetPosition
/* line 663 "cobol.rex" */
{ int i = atol (TokenPtr);
				    CheckLength (TokenLength, 18);
				    if (1 <= i && i <= 49) {
				       Attribute.level_number.Value = i;
				       return 6;
				    } else {
				       Attribute.unsigned_integer.Value = i;
				       return 3;
				    }
				  
} yyy80: goto yyBegin;
case 81:
yySetPosition
/* line 674 "cobol.rex" */
{ Attribute.plus_integer.Value = atol (TokenPtr);
				    CheckLength (TokenLength, 19);
				    return 4; 
} yyy81: goto yyBegin;
case 82:
yySetPosition
/* line 678 "cobol.rex" */
{ Attribute.minus_integer.Value = atol (TokenPtr);
				    CheckLength (TokenLength, 19);
				    return 5; 
} yyy82: goto yyBegin;
case 83:
yySetPosition
/* line 683 "cobol.rex" */
{ length = GetWord (String);
				    k = HandleContinuedNumber (length);
				    if (k >= 0) return k; 
} yyy83: goto yyBegin;
case 84:
yySetPosition
/* line 688 "cobol.rex" */
{ Attribute.string.Value =
				       PutString (TokenPtr, TokenLength);
				    return 8; 
} yyy84: goto yyBegin;
case 85:
yySetPosition
/* line 688 "cobol.rex" */
{ Attribute.string.Value =
				       PutString (TokenPtr, TokenLength);
				    return 8; 
} yyy85: goto yyBegin;
case 86:
yySetPosition
/* line 693 "cobol.rex" */
{ Attribute.paragraph_name.Ident =
				       MakeIdent (TokenPtr, TokenLength);
				    CheckLength (TokenLength, 30);
				    return 2; 
} yyy86: goto yyBegin;
case 87:
yySetPosition
/* line 699 "cobol.rex" */
{ lName: length = GetUpper (String);
				    Attribute.name.Ident = MakeIdent (String, length);
				    if (Attribute.name.Ident <= max_keyword &&
				       (keywords [Attribute.name.Ident].mask & dialect)) {
				       if (hl)
					  (void) fprintf (hlfp, "%d key %d.%d %d.%d\n", PAF_HIGH,
					  Attribute.Position.Line, Attribute.Position.Column - 1,
					  Attribute.Position.Line, Attribute.Position.Column + TokenLength - 1);
				       return keywords [Attribute.name.Ident].code;
				    }
				    CheckLength (TokenLength, 30);
				    return 1; 
} yyy87: goto yyBegin;
case 88:
for (;;) {
   switch (* yyStatePtr) {
case 90:;
case 97:;
case 101:;
case 121:;
case 122:;
case 469:;
case 470:;
case 471:;
case 472:;
case 473:;
case 474:;
case 475:;
case 500:;
goto yyL4;
   default:
      yyChBufferIndex --;
      TokenLength --;
      yyStatePtr --;
   }
}
yyL4: ;
yySetPosition
/* line 715 "cobol.rex" */
{ length = GetWord (String);
				     if (free_format)
				        return HandleContinuedNumber (length);
				     else
					yyStart (Continue_Int); 
} yyy88: goto yyBegin;
case 89:
for (;;) {
   switch (* yyStatePtr) {
case 95:;
case 120:;
case 148:;
case 238:;
case 289:;
case 349:;
case 399:;
case 401:;
goto yyL5;
   default:
      yyChBufferIndex --;
      TokenLength --;
      yyStatePtr --;
   }
}
yyL5: ;
yySetPosition
/* line 722 "cobol.rex" */
{ length = GetWord (String);
				     if (decimal_point_is_comma)
				        return HandleContinuedNumber (length);
				     else if (free_format)
				        return HandleContinuedNumber (length);
				     else
					yyStart (Continue_Real); 
} yyy89: goto yyBegin;
case 90:
for (;;) {
   switch (* yyStatePtr) {
case 87:;
case 143:;
case 147:;
case 288:;
case 324:;
case 350:;
case 397:;
case 402:;
goto yyL6;
   default:
      yyChBufferIndex --;
      TokenLength --;
      yyStatePtr --;
   }
}
yyL6: ;
yySetPosition
/* line 731 "cobol.rex" */
{ length = GetWord (String);
				     if (! decimal_point_is_comma) {
				        k = HandleContinuedNumber (length);
				        if (k >= 0) return k;
				     } else if (free_format)
				        return HandleContinuedNumber (length);
				     else
					yyStart (Continue_Real); 
} yyy90: goto yyBegin;
case 91:
for (;;) {
   switch (* yyStatePtr) {
case 90:;
case 109:;
case 138:;
case 469:;
case 470:;
case 471:;
case 472:;
case 473:;
case 474:;
case 475:;
goto yyL7;
   default:
      yyChBufferIndex --;
      TokenLength --;
      yyStatePtr --;
   }
}
yyL7: ;
yySetPosition
/* line 741 "cobol.rex" */
{ length = GetWord (String);
				     if (free_format) {
					Attribute.paragraph_name.Ident = MakeIdent (String, length);
					CheckLength (length, 30);
					yyPrevious; return 2;
				     } else
					yyStart (Continue_Para); 
} yyy91: goto yyBegin;
case 92:
for (;;) {
   switch (* yyStatePtr) {
case 88:;
case 89:;
case 90:;
case 106:;
case 108:;
case 109:;
case 112:;
case 114:;
case 115:;
case 118:;
case 138:;
case 210:;
case 211:;
case 212:;
case 213:;
case 214:;
case 215:;
case 216:;
case 217:;
case 218:;
case 219:;
case 220:;
case 221:;
case 222:;
case 223:;
case 224:;
case 225:;
case 226:;
case 227:;
case 228:;
case 229:;
case 230:;
case 231:;
case 232:;
case 233:;
case 234:;
case 235:;
case 236:;
case 237:;
case 247:;
case 248:;
case 249:;
case 281:;
case 383:;
case 384:;
case 385:;
case 386:;
case 387:;
case 388:;
case 389:;
case 390:;
case 391:;
case 392:;
case 393:;
case 394:;
case 395:;
case 396:;
case 398:;
case 411:;
case 412:;
case 413:;
case 414:;
case 415:;
case 428:;
case 430:;
case 469:;
case 470:;
case 471:;
case 472:;
case 473:;
case 474:;
case 475:;
goto yyL8;
   default:
      yyChBufferIndex --;
      TokenLength --;
      yyStatePtr --;
   }
}
yyL8: ;
yySetPosition
/* line 750 "cobol.rex" */
{ if (free_format) goto lName;
				     length = GetUpper (String);
				     yyStart (Continue_Name); 
} yyy92: goto yyBegin;
case 93:
/* line 756 "cobol.rex" */
{ length += GetWord (& String [length]);
				     yyPrevious;
				     return HandleContinuedNumber (length); 
} yyy93: goto yyBegin;
case 94:
/* line 756 "cobol.rex" */
{ length += GetWord (& String [length]);
				     yyPrevious;
				     return HandleContinuedNumber (length); 
} yyy94: goto yyBegin;
case 95:
/* line 756 "cobol.rex" */
{ length += GetWord (& String [length]);
				     yyPrevious;
				     return HandleContinuedNumber (length); 
} yyy95: goto yyBegin;
case 96:
/* line 761 "cobol.rex" */
{ length += GetWord (& String [length]);
				     Attribute.paragraph_name.Ident = MakeIdent (String, length);
				     CheckLength (length, 30);
				     yyPrevious; return 2; 
} yyy96: goto yyBegin;
case 97:
/* line 767 "cobol.rex" */
{ length += GetUpper (& String [length]);
				     yyPrevious;
				     Attribute.name.Ident = MakeIdent (String, length);
				     if (Attribute.name.Ident <= max_keyword &&
				        (keywords [Attribute.name.Ident].mask & dialect)) {
				        int token = keywords [Attribute.name.Ident].code;
					if (hl) (void) fprintf (hlfp, "%d key %d.%d %d.%d\n", PAF_HIGH,
					   Attribute.Position.Line, Attribute.Position.Column - 1,
					   yyLineCount, (unsigned char *) TokenPtr - yyLineStart + TokenLength - 1);
				        if (token == kCOPY || token == kREPLACE) {
					   if (ansi_copy && ! in_comment_entry) {
					      (void) copy_pars ();
					   } else {
					      return token;
					   }
				        } else if (token == kPICTURE) {
					   yyStart (Picture);
					   return token;
					} else {
					   return token;
					}
				     } else if (Attribute.name.Ident == iNOTE) {
					yyStart (Note);
				        start_position = Attribute.Position;
				     } else if (Attribute.name.Ident == iSKIP1 ||
					Attribute.name.Ident == iSKIP2 ||
					Attribute.name.Ident == iSKIP3) {
				     } else {
					CheckLength (length, 30);
					return 1;
				     } 
} yyy97: goto yyBegin;
case 98:
/* line 800 "cobol.rex" */
{ yyLess (0); yyPrevious;
				     return HandleContinuedNumber (length); 
} yyy98: goto yyBegin;
case 99:
/* line 804 "cobol.rex" */
{ yyLess (0); yyPrevious;
				     Attribute.name.Ident = MakeIdent (String, length);
				     CheckLength (length, 30);
				     return 1; 
} yyy99: goto yyBegin;
case 100:
/* line 809 "cobol.rex" */
{
} yyy100: goto yyBegin;
case 101:
yySetPosition
/* line 810 "cobol.rex" */
{ if (hl)
				       (void) fprintf (hlfp, "%d key %d.%d %d.%d\n", PAF_HIGH,
				       Attribute.Position.Line, Attribute.Position.Column - 1,
				       Attribute.Position.Line, Attribute.Position.Column + TokenLength - 1);
				    yyPrevious; return 172; 
} yyy101: goto yyBegin;
case 102:
/* line 816 "cobol.rex" */
{ if (length < MaxStringLength)
					length += GetWord (& String [length]); 
} yyy102: goto yyBegin;
case 103:
/* line 818 "cobol.rex" */
{ if (length < MaxStringLength)
					String [length ++] = '\t'; 
} yyy103: goto yyBegin;
case 104:
/* line 820 "cobol.rex" */
{ if (length < MaxStringLength)
					String [length ++] = '\n'; yyEol (0); 
} yyy104: goto yyBegin;
case 105:
/* line 822 "cobol.rex" */
{ Attribute.pseudo_text.Value =
					PutString (String, length);
				     Attribute.Position = start_position;
				     yyLess (0); yyPrevious;
				     return 9; 
} yyy105: goto yyBegin;
case 106:
yySetPosition
/* line 828 "cobol.rex" */
{ if (! in_comment_entry) {
				       Attribute.illegal_character.Value =
					  * TokenPtr;
				       return 11;
				  } 
} yyy106: goto yyBegin;
case 107:
yySetPosition
/* line 847 "cobol.rex" */
{ yyEol (0); return EofToken; 
} yyy107: goto yyBegin;
case 108:
/* line 849 "cobol.rex" */
{
} yyy108: goto yyBegin;
case 109:
yySetPosition
/* line 851 "cobol.rex" */
{ Attribute.unsigned_integer.Value =
					atol (TokenPtr);
				    return 3; 
} yyy109: goto yyBegin;
case 110:
yySetPosition
/* line 856 "cobol.rex" */
{ Attribute.string.Value =
					PutString (TokenPtr, TokenLength);
				    return 8; 
} yyy110: goto yyBegin;
case 111:
yySetPosition
/* line 856 "cobol.rex" */
{ Attribute.string.Value =
					PutString (TokenPtr, TokenLength);
				    return 8; 
} yyy111: goto yyBegin;
case 112:
yySetPosition
/* line 860 "cobol.rex" */
{ return 10; 
} yyy112: goto yyBegin;
case 113:
yySetPosition
/* line 861 "cobol.rex" */
{ return 12; 
} yyy113: goto yyBegin;
case 114:
yySetPosition
/* line 862 "cobol.rex" */
{ return 11; 
} yyy114: goto yyBegin;
case 115:
yySetPosition
/* line 863 "cobol.rex" */
{ return 14; 
} yyy115: goto yyBegin;
case 116:
yySetPosition
/* line 864 "cobol.rex" */
{ return 5; 
} yyy116: goto yyBegin;
case 117:
yySetPosition
/* line 865 "cobol.rex" */
{ return 6; 
} yyy117: goto yyBegin;
case 118:
yySetPosition
/* line 866 "cobol.rex" */
{ return 7; 
} yyy118: goto yyBegin;
case 119:
yySetPosition
/* line 867 "cobol.rex" */
{ return 9; 
} yyy119: goto yyBegin;
case 120:
yySetPosition
/* line 868 "cobol.rex" */
{ return 13; 
} yyy120: goto yyBegin;
case 121:
yySetPosition
/* line 869 "cobol.rex" */
{ return 2; 
} yyy121: goto yyBegin;
case 122:
yySetPosition
/* line 870 "cobol.rex" */
{ return 4; 
} yyy122: goto yyBegin;
case 123:
yySetPosition
/* line 873 "cobol.rex" */
{ length = GetUpper (String);
				    Attribute.name.Ident =
					MakeIdent (String, length);
				    return 1; 
} yyy123: goto yyBegin;
case 124:
yySetPosition
/* line 880 "cobol.rex" */
{ if (! in_comment_entry) {
				       MessageI ("illegal character", xxError,
				       Attribute.Position, xxCharacter, TokenPtr);
				       error_count ++;
				  } 
} yyy124: goto yyBegin;
case 125:
/* line 886 "cobol.rex" */
{
} yyy125: goto yyBegin;
case 126:
{/* BlankAction */
while (* yyChBufferIndexReg ++ == ' ') ;
TokenPtr = (char *) -- yyChBufferIndexReg;
yyState = yyStartState;
yyStatePtr = & yyStateStack [1];
goto yyContinue;
} yyy126: goto yyBegin;
case 128:
{/* EolAction */
yyEol (0);
} yyy127: goto yyBegin;
case 131:
	 /* non final states */
	 yyChBufferIndexReg --;			/* return character */
	 break;

case 130:
	 yySetPosition
      /* TokenLength   = 1; */
	 yyChBufferIndex = ++ yyChBufferIndexReg;
	 {
/* line 369 "cobol.rex" */

if (! in_comment_entry) {
   MessageI ("illegal character", xxError, Attribute.Position, xxCharacter,
      TokenPtr);
   error_count ++;
}

	 }
	 goto yyBegin;

      case yyDNoState:
	 goto yyBegin;

case 129:
	 yyChBufferIndex = -- yyChBufferIndexReg; /* undo last state transit */
	 if (-- TokenLength == 0) {		/* get previous state */
	    yyState = yyStartState;
  	    if (yyChBufferIndexReg [-1] == yyEolCh) yyState ++;
	 } else {
	    yyState = * (yyStatePtr - 1);
	 }

	 if (yyChBufferIndex != & yyChBufferStart [yyBytesRead]) {
					/* end of buffer sentinel in buffer */
	    if ((yyState = yyEobTrans [yyState]) == yyDNoState) continue;
	    yyChBufferIndexReg ++;
	    * yyStatePtr ++ = yyState;		/* push state */
	    goto yyContinue;
	 }
						/* end of buffer reached */
	 if (! yyEof) {
	    register char * yySource = TokenPtr - 1;
	    register char * yyTarget = (char *) & yyChBufferPtr
		[(yyMaxAlign - 1 - TokenLength) & (yyMaxAlign - 1)];
	    unsigned long yyChBufferFree = Exp2 (Log2 (yyChBufferSize - 4 -
		yyMaxAlign - TokenLength));
	    if (! yyBufferIsUsed) {
		yyLineStart	= & yyChBufferPtr [16 - 1];
		yyBufferIsUsed	= rtrue;
	    }
		/* copy initial part of token in front of the input buffer */
	    if (yySource > yyTarget) {
	       TokenPtr = yyTarget + 1;
	       do * yyTarget ++ = * yySource ++;
	       while (yySource < (char *) yyChBufferIndexReg);
	       yyLineStart += (unsigned char *) yyTarget - yyChBufferStart -
				yyBytesRead;
	       yyChBufferStart = (unsigned char *) yyTarget;
	    } else {
	       yyChBufferStart = yyChBufferIndexReg;
	    }
	    yyChBufferStart2 = (char *) yyChBufferStart;
						/* extend buffer if necessary */
	    if (yyChBufferFree < yyChBufferSize >> 3 /* / 8 */ ) {
	       register unsigned long yyDelta;
	       register unsigned char * yyOldChBufferPtr = yyChBufferPtr;
	       ExtendArray ((char * *) & yyChBufferPtr, & yyChBufferSize,
				(unsigned long) sizeof (char));
	       if (yyChBufferPtr == NULL) yyErrorMessage (1);
	       yyDelta = yyChBufferPtr - yyOldChBufferPtr;
	       yyChBufferStart	+= yyDelta;
	       yyLineStart	+= yyDelta;
	       TokenPtr	+= yyDelta;
	       yyChBufferStart2	 = (char *) yyChBufferStart;
	       yyChBufferFree = Exp2 (Log2 (yyChBufferSize - 4 -
			yyMaxAlign - TokenLength));
	       if (yyStateStackSize < yyChBufferSize) {
		  yyStateRange * yyOldStateStack = yyStateStack;
		  ExtendArray ((char * *) & yyStateStack, & yyStateStackSize,
				   (unsigned long) sizeof (yyStateRange));
		  if (yyStateStack == NULL) yyErrorMessage (1);
		  yyStatePtr	+= yyStateStack - yyOldStateStack;
	       }
	    }
						/* read buffer and restart */
	    yyChBufferIndex = yyChBufferIndexReg = yyChBufferStart;
	    yyFileOffset += yyBytesRead;
	    yyBytesRead = GetLine (yySourceFile,
				(char *) yyChBufferIndex, (int) yyChBufferFree);
	    if (yyBytesRead <= 0) { yyBytesRead = 0; yyEof = rtrue; }
	    yyChBufferStart [yyBytesRead    ] = yyEobCh;
	    yyChBufferStart [yyBytesRead + 1] = '\0';
	    goto yyContinue;
	 }

	 if (TokenLength == 0) {		/* end of file reached */
	    yySetPosition
	    CloseFile ();
	    if (yyFileStackPtr == yyFileStack) {
	    }
	    if (yyFileStackPtr == yyFileStack) return EofToken;
	    goto yyBegin;
	 }
	 break;

      default:
	 yyErrorMessage (0);
      }
   }
}

static void yyInitialize ARGS ((void))
   {
      if (yyFileStackPtr >= yyFileStack + yyFileStackSize - 1) {
	 unsigned long yyyFileStackPtr = yyFileStackPtr - yyFileStack;
	 ExtendArray ((char * *) & yyFileStack, & yyFileStackSize,
			   (unsigned long) sizeof (yytFileStack));
	 if (yyFileStack == NULL) yyErrorMessage (1);
	 yyFileStackPtr = yyFileStack + yyyFileStackPtr;
      }
      yyFileStackPtr ++;			/* push file */
      yyFileStackPtr->yySourceFile	= yySourceFile		;
      yyFileStackPtr->yyEof		= yyEof			;
      yyFileStackPtr->yyChBufferPtr	= yyChBufferPtr		;
      yyFileStackPtr->yyChBufferStart	= yyChBufferStart	;
      yyFileStackPtr->yyChBufferSize	= yyChBufferSize	;
      yyFileStackPtr->yyChBufferIndex	= yyChBufferIndex	;
      yyFileStackPtr->yyBytesRead	= yyBytesRead		;
      yyFileStackPtr->yyFileOffset	= yyFileOffset		;
      yyFileStackPtr->yyLineCount	= yyLineCount		;
      yyFileStackPtr->yyLineStart	= yyLineStart		;
						/* initialize file state */
      yyChBufferSize	   = yyInitBufferSize;
      MakeArray ((char * *) & yyChBufferPtr, & yyChBufferSize,
			(unsigned long) sizeof (char));
      if (yyChBufferPtr == NULL) yyErrorMessage (1);
      yyChBufferStart	   = & yyChBufferPtr [yyMaxAlign];
      yyChBufferStart2	   = (char *) yyChBufferStart;
      yyChBufferStart [-1] = yyEolCh;		/* begin of line indicator */
      yyChBufferStart [ 0] = yyEobCh;		/* end of buffer sentinel */
      yyChBufferStart [ 1] = '\0';
      yyChBufferIndex	   = yyChBufferStart;
      TokenPtr	   = (char *) yyChBufferStart;
      yyEof		   = rfalse;
      yyBytesRead	   = 0;
      yyFileOffset	   = 0;
      yyLineCount	   = 1;
      yyLineStart	   = & yyChBufferStart [-1];
   }

void BeginFile
#if defined __STDC__ | defined __cplusplus
   (char * yyFileName)
#else
   (yyFileName) char * yyFileName;
#endif
   {
      if (! yyBufferIsUsed) {
	 ReleaseArray ((char * *) & yyChBufferPtr, & yyChBufferSize,
			   (unsigned long) sizeof (char));
	 yyFileStackPtr --;		
	 yyBufferIsUsed = rtrue;
      }
      yyInitialize ();
      yySourceFile = yyFileName == NULL ? StdIn : BeginSource (yyFileName);
      if (yySourceFile < 0) yyErrorMessage (3);
   }

void CloseFile ARGS ((void))
   {
      if (yyFileStackPtr == yyFileStack) yyErrorMessage (2);
      CloseSource (yySourceFile);
      ReleaseArray ((char * *) & yyChBufferPtr, & yyChBufferSize,
			(unsigned long) sizeof (char));
						/* pop file */
      yySourceFile	= yyFileStackPtr->yySourceFile		;
      yyEof		= yyFileStackPtr->yyEof			;
      yyChBufferPtr	= yyFileStackPtr->yyChBufferPtr		;
      yyChBufferStart	= yyFileStackPtr->yyChBufferStart	;
      yyChBufferStart2	= (char *) yyChBufferStart		;
      yyChBufferSize	= yyFileStackPtr->yyChBufferSize	;
      yyChBufferIndex	= yyFileStackPtr->yyChBufferIndex	;
      yyBytesRead	= yyFileStackPtr->yyBytesRead		;
      yyFileOffset	= yyFileStackPtr->yyFileOffset		;
      yyLineCount	= yyFileStackPtr->yyLineCount		;
      yyLineStart	= yyFileStackPtr->yyLineStart		;
      yyFileStackPtr --;		
   }

#ifdef xxGetWord
int GetWord
#if defined __STDC__ | defined __cplusplus
   (char * yyWord)
#else
   (yyWord) char * yyWord;
#endif
   {
      register char * yySource		= TokenPtr;
      register char * yyTarget			= yyWord;
      register char * yyChBufferIndexReg	= (char *) yyChBufferIndex;

      while (yySource < yyChBufferIndexReg)
	 * yyTarget ++ = * yySource ++;
      * yyTarget = '\0';
      return (int) (yyChBufferIndexReg - TokenPtr);
   }
#endif

#ifdef xxGetLower
int GetLower
#if defined __STDC__ | defined __cplusplus
   (char * yyWord)
#else
   (yyWord) char * yyWord;
#endif
   {
      register unsigned char * yySource	= (unsigned char *) TokenPtr;
      register unsigned char * yyTarget		= (unsigned char *) yyWord;
      register unsigned char * yyChBufferIndexReg = yyChBufferIndex;

      while (yySource < yyChBufferIndexReg)
	 * yyTarget ++ = yyToLower [* yySource ++];
      * yyTarget = '\0';
      return (int) (yyChBufferIndexReg - (unsigned char *) TokenPtr);
   }
#endif

#ifdef xxGetUpper
int GetUpper
#if defined __STDC__ | defined __cplusplus
   (char * yyWord)
#else
   (yyWord) char * yyWord;
#endif
   {
      register unsigned char * yySource	= (unsigned char *) TokenPtr;
      register unsigned char * yyTarget		= (unsigned char *) yyWord;
      register unsigned char * yyChBufferIndexReg = yyChBufferIndex;

      while (yySource < yyChBufferIndexReg)
	 * yyTarget ++ = yyToUpper [* yySource ++];
      * yyTarget = '\0';
      return (int) (yyChBufferIndexReg - (unsigned char *) TokenPtr);
   }
#endif

#ifdef xxinput
static char input ARGS ((void))
   {
      if (yyChBufferIndex == & yyChBufferStart [yyBytesRead]) {
	 if (! yyEof) {
	    yyLineStart -= yyBytesRead;
	    yyChBufferIndex = yyChBufferStart = yyChBufferPtr;
	    yyChBufferStart2 = (char *) yyChBufferStart;
	    yyFileOffset += yyBytesRead;
	    yyBytesRead = GetLine (yySourceFile, (char *) yyChBufferIndex,
	       (int) Exp2 (Log2 (yyChBufferSize)));
	    if (yyBytesRead <= 0) { yyBytesRead = 0; yyEof = rtrue; }
	    yyChBufferStart [yyBytesRead    ] = yyEobCh;
	    yyChBufferStart [yyBytesRead + 1] = '\0';
	 }
      }
      if (yyChBufferIndex == & yyChBufferStart [yyBytesRead]) return '\0';
      else return * yyChBufferIndex ++;
   }
#endif

static void unput
#if defined __STDC__ | defined __cplusplus
   (char yyc)
#else
   (yyc) char yyc;
#endif
   { * (-- yyChBufferIndex) = yyc; }

static void yyLess
#if defined __STDC__ | defined __cplusplus
   (int yyn)
#else
   (yyn) int yyn;
#endif
   { yyChBufferIndex -= TokenLength - yyn; TokenLength = yyn; }

void BeginScanner ARGS ((void))
   {
/* line 359 "cobol.rex" */

   iNOTE	= MakeIdent ("NOTE"	, 4);
   iSKIP1	= MakeIdent ("SKIP1"	, 5);
   iSKIP2	= MakeIdent ("SKIP2"	, 5);
   iSKIP3	= MakeIdent ("SKIP3"	, 5);
   iCOPY	= MakeIdent ("COPY"	, 4);
   iREPLACE	= MakeIdent ("REPLACE"	, 7);
   yyStart (STD);

   }

void CloseScanner ARGS ((void))
   {
   }

static void yyErrorMessage
#if defined __STDC__ | defined __cplusplus
   (int yyErrorCode)
#else
   (yyErrorCode) int yyErrorCode;
#endif
   {
      WritePosition (stderr, Attribute.Position);
      switch (yyErrorCode) {
      case 0: (void) fprintf (stderr, ": Scanner: internal error\n"); break;
      case 1: (void) fprintf (stderr, ": Scanner: out of memory\n"); break;
      case 2: (void) fprintf (stderr,
      ": Scanner: file stack underflow (too many calls of CloseFile)\n");
	      break;
      case 3: (void) fprintf (stderr,
	      ": Scanner: cannot open input file\n"); break;
      case 4: (void) fprintf (stderr,
      ": Scanner: start stack underflow (too many calls of yyPop)\n"); break;
      }
      Scanner_Exit ();
   }

