
with Odd.Histories;
with Ada.Text_IO; use Ada.Text_IO;

procedure Test_History is

   package String_History is new Odd.Histories (String);
   use String_History;

   procedure Print_Current (History : in out History_List) is
   begin
      Put_Line (Get_Current (History));
   exception
      when No_Such_Item =>
         Put_Line ("No such item");
   end Print_Current;

   procedure Move_Previous (History : in out History_List) is
   begin
      Move_To_Previous (History);
   exception
      when No_Such_Item =>
         Put_Line ("Can't move to previous");
   end Move_Previous;

   procedure Move_Next (History : in out History_List) is
   begin
      Move_To_Next (History);
   exception
      when No_Such_Item =>
         Put_Line ("Can't move to next");
   end Move_Next;

   History : String_History.History_List;
   History2 : String_History.History_List;
   History3 : String_History.History_List;

begin
   Put ("Getting from empty list (expect none)=> ");
   Print_Current (History);

   Put ("Moving to previous on empty list => ");
   Move_Previous (History);

   Put_Line ("Appending Foo");
   Append (History, "Foo");

   --  Check the list

   Put ("Get item (expect none)=> ");
   Print_Current (History);

   Put ("Move to previous, and get (expect Foo) => ");
   Move_Previous (History);
   Print_Current (History);

   Put ("Move to previous, and get (expect can't move to previous) => ");
   Move_Previous (History);
   Print_Current (History);

   --  Put items in the list

   Put_Line ("Appending Foo1 and Foo2");
   Append (History, "Foo1");
   Append (History, "Foo2");

   Put ("Get item (expect none)=> ");
   Print_Current (History);

   Put ("Move to previous, and get (expect Foo2) => ");
   Move_Previous (History);
   Print_Current (History);

   Put ("Move to previous, and get (expect Foo1) => ");
   Move_Previous (History);
   Print_Current (History);

   Put ("Move to previous, and get (expect Foo) => ");
   Move_Previous (History);
   Print_Current (History);

   Put ("Move to previous, and get (expect can't move to previous) => ");
   Move_Previous (History);
   Print_Current (History);

   New_Line;
   Put_Line ("---------------------------------------");
   Put_Line ("--  Collapsing Entries               --");
   Put_Line ("---------------------------------------");

   Put_Line ("Adding Foo, Foo1, Foo1, Foo2");
   Append (History2, "Foo");
   Append (History2, "Foo1");
   Append (History2, "Foo1");
   Append (History2, "Foo2");

   Put ("Move to previous, and get (expect Foo2) => ");
   Move_Previous (History2);
   Print_Current (History2);

   Put ("Move to previous, and get (expect Foo1) => ");
   Move_Previous (History2);
   Print_Current (History2);

   Put ("Move to previous, and get (expect Foo) => ");
   Move_Previous (History2);
   Print_Current (History2);

   Put ("Move to previous, and get (can't move) => ");
   Move_Previous (History2);
   Print_Current (History2);

   New_Line;
   Put_Line ("----------------------------------------");
   Put_Line ("--  Rewind                            --");
   Put_Line ("----------------------------------------");
   Append (History3, "Entry1");
   Append (History3, "Entry2");
   Append (History3, "Entry2");
   Append (History3, "Entry3");

   Put_Line ("Length (Should be 3) = " & Integer'Image (Length (History3)));
   Put_Line ("Contents:");
   Wind (History3, Backward);
   for J in reverse 1 .. Length (History3) loop
      Put_Line ("  - " & Get_Current (History3)
                & "  x " & Integer'Image (Get_Current_Repeat_Num (History3)));
      if J /= 1 then
         Move_To_Next (History3);
      end if;
   end loop;

end;

