/* parse_avi.c - Being able to share .mpg's or .mpeg's */

#include "gnapster.h"

#include "parse_mpg.h"
#include "parse_ext.h"

void mpg_register() {
   REGISTER_EXT("mpg", "video", parse_mpg, mpg_ext);
}

int mpg_ext(char *ext) {
   if (!strcasecmp(ext, "mpg") || !strcasecmp(ext, "mpeg"))
     return 1;
   else 
     return 0;
}

ShareData *parse_mpg(char *file, int fd) {
   ShareData *shr;
   struct stat st;
   
   shr = d_new(SHARE);
   
   fstat(fd, &st);
   
   shr->filename = d_strdup(file);
   shr->checksum = d_strdup("00000000000000000000000000000000");
   
   shr->mtime = st.st_mtime;
   shr->filesize = st.st_size;
 
   /* fix me: this should be real data */
   shr->bitrate = 0;
   shr->frequency = 0;
   shr->time = 0.0;
   
   return shr;
}
